/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import './media/gotoErrorWidget.css';
import * as nls from '../../../nls';
import * as dom from '../../../base/browser/dom';
import { dispose, DisposableStore } from '../../../base/common/lifecycle';
import { MarkerSeverity } from '../../../platform/markers/common/markers';
import { Range } from '../../common/core/range';
import { registerColor, oneOf, textLinkForeground, editorErrorForeground, editorErrorBorder, editorWarningForeground, editorWarningBorder, editorInfoForeground, editorInfoBorder } from '../../../platform/theme/common/colorRegistry';
import { IThemeService, registerThemingParticipant } from '../../../platform/theme/common/themeService';
import { Color } from '../../../base/common/color';
import { ScrollableElement } from '../../../base/browser/ui/scrollbar/scrollableElement';
import { getBaseLabel } from '../../../base/common/labels';
import { isNonEmptyArray } from '../../../base/common/arrays';
import { Emitter } from '../../../base/common/event';
import { PeekViewWidget, peekViewTitleForeground, peekViewTitleInfoForeground } from '../peekView/peekView';
import { basename } from '../../../base/common/resources';
import { SeverityIcon } from '../../../platform/severityIcon/common/severityIcon';
import { IOpenerService } from '../../../platform/opener/common/opener';
import { MenuId, IMenuService } from '../../../platform/actions/common/actions';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { createAndFillInActionBarActions } from '../../../platform/actions/browser/menuEntryActionViewItem';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { splitLines } from '../../../base/common/strings';
import { ILabelService } from '../../../platform/label/common/label';
var MessageWidget = /** @class */ (function () {
    function MessageWidget(parent, editor, onRelatedInformation, _openerService, _labelService) {
        var _this = this;
        this._openerService = _openerService;
        this._labelService = _labelService;
        this._lines = 0;
        this._longestLineLength = 0;
        this._relatedDiagnostics = new WeakMap();
        this._disposables = new DisposableStore();
        this._editor = editor;
        var domNode = document.createElement('div');
        domNode.className = 'descriptioncontainer';
        this._messageBlock = document.createElement('div');
        this._messageBlock.classList.add('message');
        this._messageBlock.setAttribute('aria-live', 'assertive');
        this._messageBlock.setAttribute('role', 'alert');
        domNode.appendChild(this._messageBlock);
        this._relatedBlock = document.createElement('div');
        domNode.appendChild(this._relatedBlock);
        this._disposables.add(dom.addStandardDisposableListener(this._relatedBlock, 'click', function (event) {
            event.preventDefault();
            var related = _this._relatedDiagnostics.get(event.target);
            if (related) {
                onRelatedInformation(related);
            }
        }));
        this._scrollable = new ScrollableElement(domNode, {
            horizontal: 1 /* Auto */,
            vertical: 1 /* Auto */,
            useShadows: false,
            horizontalScrollbarSize: 3,
            verticalScrollbarSize: 3
        });
        parent.appendChild(this._scrollable.getDomNode());
        this._disposables.add(this._scrollable.onScroll(function (e) {
            domNode.style.left = "-" + e.scrollLeft + "px";
            domNode.style.top = "-" + e.scrollTop + "px";
        }));
        this._disposables.add(this._scrollable);
    }
    MessageWidget.prototype.dispose = function () {
        dispose(this._disposables);
    };
    MessageWidget.prototype.update = function (marker) {
        var e_1, _a, e_2, _b, e_3, _c;
        var _this = this;
        var source = marker.source, message = marker.message, relatedInformation = marker.relatedInformation, code = marker.code;
        var sourceAndCodeLength = ((source === null || source === void 0 ? void 0 : source.length) || 0) + '()'.length;
        if (code) {
            if (typeof code === 'string') {
                sourceAndCodeLength += code.length;
            }
            else {
                sourceAndCodeLength += code.value.length;
            }
        }
        var lines = splitLines(message);
        this._lines = lines.length;
        this._longestLineLength = 0;
        try {
            for (var lines_1 = __values(lines), lines_1_1 = lines_1.next(); !lines_1_1.done; lines_1_1 = lines_1.next()) {
                var line = lines_1_1.value;
                this._longestLineLength = Math.max(line.length + sourceAndCodeLength, this._longestLineLength);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (lines_1_1 && !lines_1_1.done && (_a = lines_1.return)) _a.call(lines_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        dom.clearNode(this._messageBlock);
        this._messageBlock.setAttribute('aria-label', this.getAriaLabel(marker));
        this._editor.applyFontInfo(this._messageBlock);
        var lastLineElement = this._messageBlock;
        try {
            for (var lines_2 = __values(lines), lines_2_1 = lines_2.next(); !lines_2_1.done; lines_2_1 = lines_2.next()) {
                var line = lines_2_1.value;
                lastLineElement = document.createElement('div');
                lastLineElement.innerText = line;
                if (line === '') {
                    lastLineElement.style.height = this._messageBlock.style.lineHeight;
                }
                this._messageBlock.appendChild(lastLineElement);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (lines_2_1 && !lines_2_1.done && (_b = lines_2.return)) _b.call(lines_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (source || code) {
            var detailsElement = document.createElement('span');
            detailsElement.classList.add('details');
            lastLineElement.appendChild(detailsElement);
            if (source) {
                var sourceElement = document.createElement('span');
                sourceElement.innerText = source;
                sourceElement.classList.add('source');
                detailsElement.appendChild(sourceElement);
            }
            if (code) {
                if (typeof code === 'string') {
                    var codeElement = document.createElement('span');
                    codeElement.innerText = "(" + code + ")";
                    codeElement.classList.add('code');
                    detailsElement.appendChild(codeElement);
                }
                else {
                    this._codeLink = dom.$('a.code-link');
                    this._codeLink.setAttribute('href', "" + code.target.toString());
                    this._codeLink.onclick = function (e) {
                        _this._openerService.open(code.target);
                        e.preventDefault();
                        e.stopPropagation();
                    };
                    var codeElement = dom.append(this._codeLink, dom.$('span'));
                    codeElement.innerText = code.value;
                    detailsElement.appendChild(this._codeLink);
                }
            }
        }
        dom.clearNode(this._relatedBlock);
        this._editor.applyFontInfo(this._relatedBlock);
        if (isNonEmptyArray(relatedInformation)) {
            var relatedInformationNode = this._relatedBlock.appendChild(document.createElement('div'));
            relatedInformationNode.style.paddingTop = Math.floor(this._editor.getOption(53 /* lineHeight */) * 0.66) + "px";
            this._lines += 1;
            try {
                for (var relatedInformation_1 = __values(relatedInformation), relatedInformation_1_1 = relatedInformation_1.next(); !relatedInformation_1_1.done; relatedInformation_1_1 = relatedInformation_1.next()) {
                    var related = relatedInformation_1_1.value;
                    var container = document.createElement('div');
                    var relatedResource = document.createElement('a');
                    relatedResource.classList.add('filename');
                    relatedResource.innerText = getBaseLabel(related.resource) + "(" + related.startLineNumber + ", " + related.startColumn + "): ";
                    relatedResource.title = this._labelService.getUriLabel(related.resource);
                    this._relatedDiagnostics.set(relatedResource, related);
                    var relatedMessage = document.createElement('span');
                    relatedMessage.innerText = related.message;
                    container.appendChild(relatedResource);
                    container.appendChild(relatedMessage);
                    this._lines += 1;
                    relatedInformationNode.appendChild(container);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (relatedInformation_1_1 && !relatedInformation_1_1.done && (_c = relatedInformation_1.return)) _c.call(relatedInformation_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
        var fontInfo = this._editor.getOption(38 /* fontInfo */);
        var scrollWidth = Math.ceil(fontInfo.typicalFullwidthCharacterWidth * this._longestLineLength * 0.75);
        var scrollHeight = fontInfo.lineHeight * this._lines;
        this._scrollable.setScrollDimensions({ scrollWidth: scrollWidth, scrollHeight: scrollHeight });
    };
    MessageWidget.prototype.layout = function (height, width) {
        this._scrollable.getDomNode().style.height = height + "px";
        this._scrollable.getDomNode().style.width = width + "px";
        this._scrollable.setScrollDimensions({ width: width, height: height });
    };
    MessageWidget.prototype.getHeightInLines = function () {
        return Math.min(17, this._lines);
    };
    MessageWidget.prototype.getAriaLabel = function (marker) {
        var severityLabel = '';
        switch (marker.severity) {
            case MarkerSeverity.Error:
                severityLabel = nls.localize('Error', "Error");
                break;
            case MarkerSeverity.Warning:
                severityLabel = nls.localize('Warning', "Warning");
                break;
            case MarkerSeverity.Info:
                severityLabel = nls.localize('Info', "Info");
                break;
            case MarkerSeverity.Hint:
                severityLabel = nls.localize('Hint', "Hint");
                break;
        }
        var ariaLabel = nls.localize('marker aria', "{0} at {1}. ", severityLabel, marker.startLineNumber + ':' + marker.startColumn);
        var model = this._editor.getModel();
        if (model && (marker.startLineNumber <= model.getLineCount()) && (marker.startLineNumber >= 1)) {
            var lineContent = model.getLineContent(marker.startLineNumber);
            ariaLabel = lineContent + ", " + ariaLabel;
        }
        return ariaLabel;
    };
    return MessageWidget;
}());
var MarkerNavigationWidget = /** @class */ (function (_super) {
    __extends(MarkerNavigationWidget, _super);
    function MarkerNavigationWidget(editor, _themeService, _openerService, _menuService, instantiationService, _contextKeyService, _labelService) {
        var _this = _super.call(this, editor, { showArrow: true, showFrame: true, isAccessible: true }, instantiationService) || this;
        _this._themeService = _themeService;
        _this._openerService = _openerService;
        _this._menuService = _menuService;
        _this._contextKeyService = _contextKeyService;
        _this._labelService = _labelService;
        _this._callOnDispose = new DisposableStore();
        _this._onDidSelectRelatedInformation = new Emitter();
        _this.onDidSelectRelatedInformation = _this._onDidSelectRelatedInformation.event;
        _this._severity = MarkerSeverity.Warning;
        _this._backgroundColor = Color.white;
        _this._applyTheme(_themeService.getColorTheme());
        _this._callOnDispose.add(_themeService.onDidColorThemeChange(_this._applyTheme.bind(_this)));
        _this.create();
        return _this;
    }
    MarkerNavigationWidget.prototype._applyTheme = function (theme) {
        this._backgroundColor = theme.getColor(editorMarkerNavigationBackground);
        var colorId = editorMarkerNavigationError;
        if (this._severity === MarkerSeverity.Warning) {
            colorId = editorMarkerNavigationWarning;
        }
        else if (this._severity === MarkerSeverity.Info) {
            colorId = editorMarkerNavigationInfo;
        }
        var frameColor = theme.getColor(colorId);
        this.style({
            arrowColor: frameColor,
            frameColor: frameColor,
            headerBackgroundColor: this._backgroundColor,
            primaryHeadingColor: theme.getColor(peekViewTitleForeground),
            secondaryHeadingColor: theme.getColor(peekViewTitleInfoForeground)
        }); // style() will trigger _applyStyles
    };
    MarkerNavigationWidget.prototype._applyStyles = function () {
        if (this._parentContainer) {
            this._parentContainer.style.backgroundColor = this._backgroundColor ? this._backgroundColor.toString() : '';
        }
        _super.prototype._applyStyles.call(this);
    };
    MarkerNavigationWidget.prototype.dispose = function () {
        this._callOnDispose.dispose();
        _super.prototype.dispose.call(this);
    };
    MarkerNavigationWidget.prototype.focus = function () {
        this._parentContainer.focus();
    };
    MarkerNavigationWidget.prototype._fillHead = function (container) {
        var _this = this;
        _super.prototype._fillHead.call(this, container);
        this._disposables.add(this._actionbarWidget.actionRunner.onBeforeRun(function (e) { return _this.editor.focus(); }));
        var actions = [];
        var menu = this._menuService.createMenu(MarkerNavigationWidget.TitleMenu, this._contextKeyService);
        createAndFillInActionBarActions(menu, undefined, actions);
        this._actionbarWidget.push(actions, { label: false, icon: true, index: 0 });
        menu.dispose();
    };
    MarkerNavigationWidget.prototype._fillTitleIcon = function (container) {
        this._icon = dom.append(container, dom.$(''));
    };
    MarkerNavigationWidget.prototype._fillBody = function (container) {
        var _this = this;
        this._parentContainer = container;
        container.classList.add('marker-widget');
        this._parentContainer.tabIndex = 0;
        this._parentContainer.setAttribute('role', 'tooltip');
        this._container = document.createElement('div');
        container.appendChild(this._container);
        this._message = new MessageWidget(this._container, this.editor, function (related) { return _this._onDidSelectRelatedInformation.fire(related); }, this._openerService, this._labelService);
        this._disposables.add(this._message);
    };
    MarkerNavigationWidget.prototype.show = function () {
        throw new Error('call showAtMarker');
    };
    MarkerNavigationWidget.prototype.showAtMarker = function (marker, markerIdx, markerCount) {
        // update:
        // * title
        // * message
        this._container.classList.remove('stale');
        this._message.update(marker);
        // update frame color (only applied on 'show')
        this._severity = marker.severity;
        this._applyTheme(this._themeService.getColorTheme());
        // show
        var range = Range.lift(marker);
        var editorPosition = this.editor.getPosition();
        var position = editorPosition && range.containsPosition(editorPosition) ? editorPosition : range.getStartPosition();
        _super.prototype.show.call(this, position, this.computeRequiredHeight());
        var model = this.editor.getModel();
        if (model) {
            var detail = markerCount > 1
                ? nls.localize('problems', "{0} of {1} problems", markerIdx, markerCount)
                : nls.localize('change', "{0} of {1} problem", markerIdx, markerCount);
            this.setTitle(basename(model.uri), detail);
        }
        this._icon.className = "codicon " + SeverityIcon.className(MarkerSeverity.toSeverity(this._severity));
        this.editor.revealPositionNearTop(position, 0 /* Smooth */);
        this.editor.focus();
    };
    MarkerNavigationWidget.prototype.updateMarker = function (marker) {
        this._container.classList.remove('stale');
        this._message.update(marker);
    };
    MarkerNavigationWidget.prototype.showStale = function () {
        this._container.classList.add('stale');
        this._relayout();
    };
    MarkerNavigationWidget.prototype._doLayoutBody = function (heightInPixel, widthInPixel) {
        _super.prototype._doLayoutBody.call(this, heightInPixel, widthInPixel);
        this._heightInPixel = heightInPixel;
        this._message.layout(heightInPixel, widthInPixel);
        this._container.style.height = heightInPixel + "px";
    };
    MarkerNavigationWidget.prototype._onWidth = function (widthInPixel) {
        this._message.layout(this._heightInPixel, widthInPixel);
    };
    MarkerNavigationWidget.prototype._relayout = function () {
        _super.prototype._relayout.call(this, this.computeRequiredHeight());
    };
    MarkerNavigationWidget.prototype.computeRequiredHeight = function () {
        return 3 + this._message.getHeightInLines();
    };
    MarkerNavigationWidget.TitleMenu = new MenuId('gotoErrorTitleMenu');
    MarkerNavigationWidget = __decorate([
        __param(1, IThemeService),
        __param(2, IOpenerService),
        __param(3, IMenuService),
        __param(4, IInstantiationService),
        __param(5, IContextKeyService),
        __param(6, ILabelService)
    ], MarkerNavigationWidget);
    return MarkerNavigationWidget;
}(PeekViewWidget));
export { MarkerNavigationWidget };
// theming
var errorDefault = oneOf(editorErrorForeground, editorErrorBorder);
var warningDefault = oneOf(editorWarningForeground, editorWarningBorder);
var infoDefault = oneOf(editorInfoForeground, editorInfoBorder);
export var editorMarkerNavigationError = registerColor('editorMarkerNavigationError.background', { dark: errorDefault, light: errorDefault, hc: errorDefault }, nls.localize('editorMarkerNavigationError', 'Editor marker navigation widget error color.'));
export var editorMarkerNavigationWarning = registerColor('editorMarkerNavigationWarning.background', { dark: warningDefault, light: warningDefault, hc: warningDefault }, nls.localize('editorMarkerNavigationWarning', 'Editor marker navigation widget warning color.'));
export var editorMarkerNavigationInfo = registerColor('editorMarkerNavigationInfo.background', { dark: infoDefault, light: infoDefault, hc: infoDefault }, nls.localize('editorMarkerNavigationInfo', 'Editor marker navigation widget info color.'));
export var editorMarkerNavigationBackground = registerColor('editorMarkerNavigation.background', { dark: '#2D2D30', light: Color.white, hc: '#0C141F' }, nls.localize('editorMarkerNavigationBackground', 'Editor marker navigation widget background.'));
registerThemingParticipant(function (theme, collector) {
    var linkFg = theme.getColor(textLinkForeground);
    if (linkFg) {
        collector.addRule(".monaco-editor .marker-widget a { color: " + linkFg + "; }");
        collector.addRule(".monaco-editor .marker-widget a.code-link span:hover { color: " + linkFg + "; }");
    }
});
