/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { alert } from '../../../base/browser/ui/aria/aria';
import { asArray, isNonEmptyArray } from '../../../base/common/arrays';
import { CancellationToken } from '../../../base/common/cancellation';
import { illegalArgument, onUnexpectedExternalError } from '../../../base/common/errors';
import { URI } from '../../../base/common/uri';
import { EditorStateCancellationTokenSource, TextModelCancellationTokenSource } from '../../browser/core/editorState';
import { isCodeEditor } from '../../browser/editorBrowser';
import { Position } from '../../common/core/position';
import { Range } from '../../common/core/range';
import { Selection } from '../../common/core/selection';
import { DocumentFormattingEditProviderRegistry, DocumentRangeFormattingEditProviderRegistry, OnTypeFormattingEditProviderRegistry } from '../../common/modes';
import { IEditorWorkerService } from '../../common/services/editorWorkerService';
import { IModelService } from '../../common/services/modelService';
import { FormattingEdit } from './formattingEdit';
import * as nls from '../../../nls';
import { ExtensionIdentifier } from '../../../platform/extensions/common/extensions';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { LinkedList } from '../../../base/common/linkedList';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { assertType } from '../../../base/common/types';
import { Iterable } from '../../../base/common/iterator';
export function alertFormattingEdits(edits) {
    edits = edits.filter(function (edit) { return edit.range; });
    if (!edits.length) {
        return;
    }
    var range = edits[0].range;
    for (var i = 1; i < edits.length; i++) {
        range = Range.plusRange(range, edits[i].range);
    }
    var startLineNumber = range.startLineNumber, endLineNumber = range.endLineNumber;
    if (startLineNumber === endLineNumber) {
        if (edits.length === 1) {
            alert(nls.localize('hint11', "Made 1 formatting edit on line {0}", startLineNumber));
        }
        else {
            alert(nls.localize('hintn1', "Made {0} formatting edits on line {1}", edits.length, startLineNumber));
        }
    }
    else {
        if (edits.length === 1) {
            alert(nls.localize('hint1n', "Made 1 formatting edit between lines {0} and {1}", startLineNumber, endLineNumber));
        }
        else {
            alert(nls.localize('hintnn', "Made {0} formatting edits between lines {1} and {2}", edits.length, startLineNumber, endLineNumber));
        }
    }
}
export function getRealAndSyntheticDocumentFormattersOrdered(model) {
    var e_1, _a, e_2, _b;
    var result = [];
    var seen = new Set();
    // (1) add all document formatter
    var docFormatter = DocumentFormattingEditProviderRegistry.ordered(model);
    try {
        for (var docFormatter_1 = __values(docFormatter), docFormatter_1_1 = docFormatter_1.next(); !docFormatter_1_1.done; docFormatter_1_1 = docFormatter_1.next()) {
            var formatter = docFormatter_1_1.value;
            result.push(formatter);
            if (formatter.extensionId) {
                seen.add(ExtensionIdentifier.toKey(formatter.extensionId));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (docFormatter_1_1 && !docFormatter_1_1.done && (_a = docFormatter_1.return)) _a.call(docFormatter_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    // (2) add all range formatter as document formatter (unless the same extension already did that)
    var rangeFormatter = DocumentRangeFormattingEditProviderRegistry.ordered(model);
    var _loop_1 = function (formatter) {
        if (formatter.extensionId) {
            if (seen.has(ExtensionIdentifier.toKey(formatter.extensionId))) {
                return "continue";
            }
            seen.add(ExtensionIdentifier.toKey(formatter.extensionId));
        }
        result.push({
            displayName: formatter.displayName,
            extensionId: formatter.extensionId,
            provideDocumentFormattingEdits: function (model, options, token) {
                return formatter.provideDocumentRangeFormattingEdits(model, model.getFullModelRange(), options, token);
            }
        });
    };
    try {
        for (var rangeFormatter_1 = __values(rangeFormatter), rangeFormatter_1_1 = rangeFormatter_1.next(); !rangeFormatter_1_1.done; rangeFormatter_1_1 = rangeFormatter_1.next()) {
            var formatter = rangeFormatter_1_1.value;
            _loop_1(formatter);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (rangeFormatter_1_1 && !rangeFormatter_1_1.done && (_b = rangeFormatter_1.return)) _b.call(rangeFormatter_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return result;
}
var FormattingConflicts = /** @class */ (function () {
    function FormattingConflicts() {
    }
    FormattingConflicts.setFormatterSelector = function (selector) {
        var remove = FormattingConflicts._selectors.unshift(selector);
        return { dispose: remove };
    };
    FormattingConflicts.select = function (formatter, document, mode) {
        return __awaiter(this, void 0, void 0, function () {
            var selector;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (formatter.length === 0) {
                            return [2 /*return*/, undefined];
                        }
                        selector = Iterable.first(FormattingConflicts._selectors);
                        if (!selector) return [3 /*break*/, 2];
                        return [4 /*yield*/, selector(formatter, document, mode)];
                    case 1: return [2 /*return*/, _a.sent()];
                    case 2: return [2 /*return*/, undefined];
                }
            });
        });
    };
    FormattingConflicts._selectors = new LinkedList();
    return FormattingConflicts;
}());
export { FormattingConflicts };
export function formatDocumentRangesWithSelectedProvider(accessor, editorOrModel, rangeOrRanges, mode, progress, token) {
    return __awaiter(this, void 0, void 0, function () {
        var instaService, model, provider, selected;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    instaService = accessor.get(IInstantiationService);
                    model = isCodeEditor(editorOrModel) ? editorOrModel.getModel() : editorOrModel;
                    provider = DocumentRangeFormattingEditProviderRegistry.ordered(model);
                    return [4 /*yield*/, FormattingConflicts.select(provider, model, mode)];
                case 1:
                    selected = _a.sent();
                    if (!selected) return [3 /*break*/, 3];
                    progress.report(selected);
                    return [4 /*yield*/, instaService.invokeFunction(formatDocumentRangesWithProvider, selected, editorOrModel, rangeOrRanges, token)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3: return [2 /*return*/];
            }
        });
    });
}
export function formatDocumentRangesWithProvider(accessor, provider, editorOrModel, rangeOrRanges, token) {
    return __awaiter(this, void 0, void 0, function () {
        var workerService, model, cts, ranges, len, _a, _b, range, allEdits, ranges_1, ranges_1_1, range, rawEdits, minEdits, e_3_1, _c, range, initialSelection_1;
        var e_4, _d, e_3, _e;
        return __generator(this, function (_f) {
            switch (_f.label) {
                case 0:
                    workerService = accessor.get(IEditorWorkerService);
                    if (isCodeEditor(editorOrModel)) {
                        model = editorOrModel.getModel();
                        cts = new EditorStateCancellationTokenSource(editorOrModel, 1 /* Value */ | 4 /* Position */, undefined, token);
                    }
                    else {
                        model = editorOrModel;
                        cts = new TextModelCancellationTokenSource(editorOrModel, token);
                    }
                    ranges = [];
                    len = 0;
                    try {
                        for (_a = __values(asArray(rangeOrRanges).sort(Range.compareRangesUsingStarts)), _b = _a.next(); !_b.done; _b = _a.next()) {
                            range = _b.value;
                            if (len > 0 && Range.areIntersectingOrTouching(ranges[len - 1], range)) {
                                ranges[len - 1] = Range.fromPositions(ranges[len - 1].getStartPosition(), range.getEndPosition());
                            }
                            else {
                                len = ranges.push(range);
                            }
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (_b && !_b.done && (_d = _a.return)) _d.call(_a);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                    allEdits = [];
                    _f.label = 1;
                case 1:
                    _f.trys.push([1, 9, 10, 11]);
                    ranges_1 = __values(ranges), ranges_1_1 = ranges_1.next();
                    _f.label = 2;
                case 2:
                    if (!!ranges_1_1.done) return [3 /*break*/, 8];
                    range = ranges_1_1.value;
                    _f.label = 3;
                case 3:
                    _f.trys.push([3, , 6, 7]);
                    return [4 /*yield*/, provider.provideDocumentRangeFormattingEdits(model, range, model.getFormattingOptions(), cts.token)];
                case 4:
                    rawEdits = _f.sent();
                    return [4 /*yield*/, workerService.computeMoreMinimalEdits(model.uri, rawEdits)];
                case 5:
                    minEdits = _f.sent();
                    if (minEdits) {
                        allEdits.push.apply(allEdits, __spreadArray([], __read(minEdits)));
                    }
                    if (cts.token.isCancellationRequested) {
                        return [2 /*return*/, true];
                    }
                    return [3 /*break*/, 7];
                case 6:
                    cts.dispose();
                    return [7 /*endfinally*/];
                case 7:
                    ranges_1_1 = ranges_1.next();
                    return [3 /*break*/, 2];
                case 8: return [3 /*break*/, 11];
                case 9:
                    e_3_1 = _f.sent();
                    e_3 = { error: e_3_1 };
                    return [3 /*break*/, 11];
                case 10:
                    try {
                        if (ranges_1_1 && !ranges_1_1.done && (_e = ranges_1.return)) _e.call(ranges_1);
                    }
                    finally { if (e_3) throw e_3.error; }
                    return [7 /*endfinally*/];
                case 11:
                    if (allEdits.length === 0) {
                        return [2 /*return*/, false];
                    }
                    if (isCodeEditor(editorOrModel)) {
                        // use editor to apply edits
                        FormattingEdit.execute(editorOrModel, allEdits, true);
                        alertFormattingEdits(allEdits);
                        editorOrModel.revealPositionInCenterIfOutsideViewport(editorOrModel.getPosition(), 1 /* Immediate */);
                    }
                    else {
                        _c = __read(allEdits, 1), range = _c[0].range;
                        initialSelection_1 = new Selection(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
                        model.pushEditOperations([initialSelection_1], allEdits.map(function (edit) {
                            return {
                                text: edit.text,
                                range: Range.lift(edit.range),
                                forceMoveMarkers: true
                            };
                        }), function (undoEdits) {
                            var e_5, _a;
                            try {
                                for (var undoEdits_1 = __values(undoEdits), undoEdits_1_1 = undoEdits_1.next(); !undoEdits_1_1.done; undoEdits_1_1 = undoEdits_1.next()) {
                                    var range_1 = undoEdits_1_1.value.range;
                                    if (Range.areIntersectingOrTouching(range_1, initialSelection_1)) {
                                        return [new Selection(range_1.startLineNumber, range_1.startColumn, range_1.endLineNumber, range_1.endColumn)];
                                    }
                                }
                            }
                            catch (e_5_1) { e_5 = { error: e_5_1 }; }
                            finally {
                                try {
                                    if (undoEdits_1_1 && !undoEdits_1_1.done && (_a = undoEdits_1.return)) _a.call(undoEdits_1);
                                }
                                finally { if (e_5) throw e_5.error; }
                            }
                            return null;
                        });
                    }
                    return [2 /*return*/, true];
            }
        });
    });
}
export function formatDocumentWithSelectedProvider(accessor, editorOrModel, mode, progress, token) {
    return __awaiter(this, void 0, void 0, function () {
        var instaService, model, provider, selected;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    instaService = accessor.get(IInstantiationService);
                    model = isCodeEditor(editorOrModel) ? editorOrModel.getModel() : editorOrModel;
                    provider = getRealAndSyntheticDocumentFormattersOrdered(model);
                    return [4 /*yield*/, FormattingConflicts.select(provider, model, mode)];
                case 1:
                    selected = _a.sent();
                    if (!selected) return [3 /*break*/, 3];
                    progress.report(selected);
                    return [4 /*yield*/, instaService.invokeFunction(formatDocumentWithProvider, selected, editorOrModel, mode, token)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3: return [2 /*return*/];
            }
        });
    });
}
export function formatDocumentWithProvider(accessor, provider, editorOrModel, mode, token) {
    return __awaiter(this, void 0, void 0, function () {
        var workerService, model, cts, edits, rawEdits, _a, range, initialSelection_2;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    workerService = accessor.get(IEditorWorkerService);
                    if (isCodeEditor(editorOrModel)) {
                        model = editorOrModel.getModel();
                        cts = new EditorStateCancellationTokenSource(editorOrModel, 1 /* Value */ | 4 /* Position */, undefined, token);
                    }
                    else {
                        model = editorOrModel;
                        cts = new TextModelCancellationTokenSource(editorOrModel, token);
                    }
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, , 4, 5]);
                    return [4 /*yield*/, provider.provideDocumentFormattingEdits(model, model.getFormattingOptions(), cts.token)];
                case 2:
                    rawEdits = _b.sent();
                    return [4 /*yield*/, workerService.computeMoreMinimalEdits(model.uri, rawEdits)];
                case 3:
                    edits = _b.sent();
                    if (cts.token.isCancellationRequested) {
                        return [2 /*return*/, true];
                    }
                    return [3 /*break*/, 5];
                case 4:
                    cts.dispose();
                    return [7 /*endfinally*/];
                case 5:
                    if (!edits || edits.length === 0) {
                        return [2 /*return*/, false];
                    }
                    if (isCodeEditor(editorOrModel)) {
                        // use editor to apply edits
                        FormattingEdit.execute(editorOrModel, edits, mode !== 2 /* Silent */);
                        if (mode !== 2 /* Silent */) {
                            alertFormattingEdits(edits);
                            editorOrModel.revealPositionInCenterIfOutsideViewport(editorOrModel.getPosition(), 1 /* Immediate */);
                        }
                    }
                    else {
                        _a = __read(edits, 1), range = _a[0].range;
                        initialSelection_2 = new Selection(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
                        model.pushEditOperations([initialSelection_2], edits.map(function (edit) {
                            return {
                                text: edit.text,
                                range: Range.lift(edit.range),
                                forceMoveMarkers: true
                            };
                        }), function (undoEdits) {
                            var e_6, _a;
                            try {
                                for (var undoEdits_2 = __values(undoEdits), undoEdits_2_1 = undoEdits_2.next(); !undoEdits_2_1.done; undoEdits_2_1 = undoEdits_2.next()) {
                                    var range_2 = undoEdits_2_1.value.range;
                                    if (Range.areIntersectingOrTouching(range_2, initialSelection_2)) {
                                        return [new Selection(range_2.startLineNumber, range_2.startColumn, range_2.endLineNumber, range_2.endColumn)];
                                    }
                                }
                            }
                            catch (e_6_1) { e_6 = { error: e_6_1 }; }
                            finally {
                                try {
                                    if (undoEdits_2_1 && !undoEdits_2_1.done && (_a = undoEdits_2.return)) _a.call(undoEdits_2);
                                }
                                finally { if (e_6) throw e_6.error; }
                            }
                            return null;
                        });
                    }
                    return [2 /*return*/, true];
            }
        });
    });
}
export function getDocumentRangeFormattingEditsUntilResult(workerService, model, range, options, token) {
    return __awaiter(this, void 0, void 0, function () {
        var providers, providers_1, providers_1_1, provider, rawEdits, e_7_1;
        var e_7, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    providers = DocumentRangeFormattingEditProviderRegistry.ordered(model);
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 7, 8, 9]);
                    providers_1 = __values(providers), providers_1_1 = providers_1.next();
                    _b.label = 2;
                case 2:
                    if (!!providers_1_1.done) return [3 /*break*/, 6];
                    provider = providers_1_1.value;
                    return [4 /*yield*/, Promise.resolve(provider.provideDocumentRangeFormattingEdits(model, range, options, token)).catch(onUnexpectedExternalError)];
                case 3:
                    rawEdits = _b.sent();
                    if (!isNonEmptyArray(rawEdits)) return [3 /*break*/, 5];
                    return [4 /*yield*/, workerService.computeMoreMinimalEdits(model.uri, rawEdits)];
                case 4: return [2 /*return*/, _b.sent()];
                case 5:
                    providers_1_1 = providers_1.next();
                    return [3 /*break*/, 2];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_7_1 = _b.sent();
                    e_7 = { error: e_7_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (providers_1_1 && !providers_1_1.done && (_a = providers_1.return)) _a.call(providers_1);
                    }
                    finally { if (e_7) throw e_7.error; }
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/, undefined];
            }
        });
    });
}
export function getDocumentFormattingEditsUntilResult(workerService, model, options, token) {
    return __awaiter(this, void 0, void 0, function () {
        var providers, providers_2, providers_2_1, provider, rawEdits, e_8_1;
        var e_8, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    providers = getRealAndSyntheticDocumentFormattersOrdered(model);
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 7, 8, 9]);
                    providers_2 = __values(providers), providers_2_1 = providers_2.next();
                    _b.label = 2;
                case 2:
                    if (!!providers_2_1.done) return [3 /*break*/, 6];
                    provider = providers_2_1.value;
                    return [4 /*yield*/, Promise.resolve(provider.provideDocumentFormattingEdits(model, options, token)).catch(onUnexpectedExternalError)];
                case 3:
                    rawEdits = _b.sent();
                    if (!isNonEmptyArray(rawEdits)) return [3 /*break*/, 5];
                    return [4 /*yield*/, workerService.computeMoreMinimalEdits(model.uri, rawEdits)];
                case 4: return [2 /*return*/, _b.sent()];
                case 5:
                    providers_2_1 = providers_2.next();
                    return [3 /*break*/, 2];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_8_1 = _b.sent();
                    e_8 = { error: e_8_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (providers_2_1 && !providers_2_1.done && (_a = providers_2.return)) _a.call(providers_2);
                    }
                    finally { if (e_8) throw e_8.error; }
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/, undefined];
            }
        });
    });
}
export function getOnTypeFormattingEdits(workerService, model, position, ch, options) {
    var providers = OnTypeFormattingEditProviderRegistry.ordered(model);
    if (providers.length === 0) {
        return Promise.resolve(undefined);
    }
    if (providers[0].autoFormatTriggerCharacters.indexOf(ch) < 0) {
        return Promise.resolve(undefined);
    }
    return Promise.resolve(providers[0].provideOnTypeFormattingEdits(model, position, ch, options, CancellationToken.None)).catch(onUnexpectedExternalError).then(function (edits) {
        return workerService.computeMoreMinimalEdits(model.uri, edits);
    });
}
CommandsRegistry.registerCommand('_executeFormatRangeProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 3), resource = _a[0], range = _a[1], options = _a[2];
    assertType(URI.isUri(resource));
    assertType(Range.isIRange(range));
    var model = accessor.get(IModelService).getModel(resource);
    if (!model) {
        throw illegalArgument('resource');
    }
    return getDocumentRangeFormattingEditsUntilResult(accessor.get(IEditorWorkerService), model, Range.lift(range), options, CancellationToken.None);
});
CommandsRegistry.registerCommand('_executeFormatDocumentProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 2), resource = _a[0], options = _a[1];
    assertType(URI.isUri(resource));
    var model = accessor.get(IModelService).getModel(resource);
    if (!model) {
        throw illegalArgument('resource');
    }
    return getDocumentFormattingEditsUntilResult(accessor.get(IEditorWorkerService), model, options, CancellationToken.None);
});
CommandsRegistry.registerCommand('_executeFormatOnTypeProvider', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a = __read(args, 4), resource = _a[0], position = _a[1], ch = _a[2], options = _a[3];
    assertType(URI.isUri(resource));
    assertType(Position.isIPosition(position));
    assertType(typeof ch === 'string');
    var model = accessor.get(IModelService).getModel(resource);
    if (!model) {
        throw illegalArgument('resource');
    }
    return getOnTypeFormattingEdits(accessor.get(IEditorWorkerService), model, Position.lift(position), ch, options);
});
