/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { RunOnceScheduler, createCancelablePromise, disposableTimeout } from '../../../base/common/async';
import { onUnexpectedError, onUnexpectedExternalError } from '../../../base/common/errors';
import { toDisposable, DisposableStore } from '../../../base/common/lifecycle';
import { StableEditorScrollState } from '../../browser/core/editorState';
import { registerEditorContribution, registerEditorAction, EditorAction } from '../../browser/editorExtensions';
import { CodeLensProviderRegistry } from '../../common/modes';
import { getCodeLensModel } from './codelens';
import { CodeLensWidget, CodeLensHelper } from './codelensWidget';
import { ICommandService } from '../../../platform/commands/common/commands';
import { INotificationService } from '../../../platform/notification/common/notification';
import { ICodeLensCache } from './codeLensCache';
import * as dom from '../../../base/browser/dom';
import { hash } from '../../../base/common/hash';
import { IQuickInputService } from '../../../platform/quickinput/common/quickInput';
import { localize } from '../../../nls';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { LanguageFeatureRequestDelays } from '../../common/modes/languageFeatureRegistry';
var CodeLensContribution = /** @class */ (function () {
    function CodeLensContribution(_editor, _commandService, _notificationService, _codeLensCache) {
        var _this = this;
        this._editor = _editor;
        this._commandService = _commandService;
        this._notificationService = _notificationService;
        this._codeLensCache = _codeLensCache;
        this._disposables = new DisposableStore();
        this._localToDispose = new DisposableStore();
        this._lenses = [];
        this._getCodeLensModelDelays = new LanguageFeatureRequestDelays(CodeLensProviderRegistry, 250, 2500);
        this._oldCodeLensModels = new DisposableStore();
        this._resolveCodeLensesDelays = new LanguageFeatureRequestDelays(CodeLensProviderRegistry, 250, 2500);
        this._resolveCodeLensesScheduler = new RunOnceScheduler(function () { return _this._resolveCodeLensesInViewport(); }, this._resolveCodeLensesDelays.min);
        this._disposables.add(this._editor.onDidChangeModel(function () { return _this._onModelChange(); }));
        this._disposables.add(this._editor.onDidChangeModelLanguage(function () { return _this._onModelChange(); }));
        this._disposables.add(this._editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(38 /* fontInfo */) || e.hasChanged(13 /* codeLensFontSize */) || e.hasChanged(12 /* codeLensFontFamily */)) {
                _this._updateLensStyle();
            }
            if (e.hasChanged(11 /* codeLens */)) {
                _this._onModelChange();
            }
        }));
        this._disposables.add(CodeLensProviderRegistry.onDidChange(this._onModelChange, this));
        this._onModelChange();
        this._styleClassName = '_' + hash(this._editor.getId()).toString(16);
        this._styleElement = dom.createStyleSheet(dom.isInShadowDOM(this._editor.getContainerDomNode())
            ? this._editor.getContainerDomNode()
            : undefined);
        this._updateLensStyle();
    }
    CodeLensContribution.prototype.dispose = function () {
        var _a;
        this._localDispose();
        this._disposables.dispose();
        this._oldCodeLensModels.dispose();
        (_a = this._currentCodeLensModel) === null || _a === void 0 ? void 0 : _a.dispose();
        this._styleElement.remove();
    };
    CodeLensContribution.prototype._getLayoutInfo = function () {
        var fontSize = this._editor.getOption(13 /* codeLensFontSize */);
        var codeLensHeight;
        if (!fontSize || fontSize < 5) {
            fontSize = (this._editor.getOption(40 /* fontSize */) * .9) | 0;
            codeLensHeight = this._editor.getOption(53 /* lineHeight */);
        }
        else {
            codeLensHeight = (fontSize * Math.max(1.3, this._editor.getOption(53 /* lineHeight */) / this._editor.getOption(40 /* fontSize */))) | 0;
        }
        return { codeLensHeight: codeLensHeight, fontSize: fontSize };
    };
    CodeLensContribution.prototype._updateLensStyle = function () {
        var _this = this;
        var _a = this._getLayoutInfo(), codeLensHeight = _a.codeLensHeight, fontSize = _a.fontSize;
        var fontFamily = this._editor.getOption(12 /* codeLensFontFamily */);
        var editorFontInfo = this._editor.getOption(38 /* fontInfo */);
        var fontFamilyVar = "--codelens-font-family" + this._styleClassName;
        var newStyle = "\n\t\t.monaco-editor .codelens-decoration." + this._styleClassName + " { line-height: " + codeLensHeight + "px; font-size: " + fontSize + "px; padding-right: " + Math.round(fontSize * 0.5) + "px; font-feature-settings: " + editorFontInfo.fontFeatureSettings + " }\n\t\t.monaco-editor .codelens-decoration." + this._styleClassName + " span.codicon { line-height: " + codeLensHeight + "px; font-size: " + fontSize + "px; }\n\t\t";
        if (fontFamily) {
            newStyle += ".monaco-editor .codelens-decoration." + this._styleClassName + " { font-family: var(" + fontFamilyVar + ")}";
        }
        this._styleElement.textContent = newStyle;
        this._editor.getContainerDomNode().style.setProperty(fontFamilyVar, fontFamily !== null && fontFamily !== void 0 ? fontFamily : 'inherit');
        //
        this._editor.changeViewZones(function (accessor) {
            var e_1, _a;
            try {
                for (var _b = __values(_this._lenses), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var lens = _c.value;
                    lens.updateHeight(codeLensHeight, accessor);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
    };
    CodeLensContribution.prototype._localDispose = function () {
        var _a, _b, _c;
        (_a = this._getCodeLensModelPromise) === null || _a === void 0 ? void 0 : _a.cancel();
        this._getCodeLensModelPromise = undefined;
        (_b = this._resolveCodeLensesPromise) === null || _b === void 0 ? void 0 : _b.cancel();
        this._resolveCodeLensesPromise = undefined;
        this._localToDispose.clear();
        this._oldCodeLensModels.clear();
        (_c = this._currentCodeLensModel) === null || _c === void 0 ? void 0 : _c.dispose();
    };
    CodeLensContribution.prototype._onModelChange = function () {
        var e_2, _a;
        var _this = this;
        this._localDispose();
        var model = this._editor.getModel();
        if (!model) {
            return;
        }
        if (!this._editor.getOption(11 /* codeLens */)) {
            return;
        }
        var cachedLenses = this._codeLensCache.get(model);
        if (cachedLenses) {
            this._renderCodeLensSymbols(cachedLenses);
        }
        if (!CodeLensProviderRegistry.has(model)) {
            // no provider -> return but check with
            // cached lenses. they expire after 30 seconds
            if (cachedLenses) {
                this._localToDispose.add(disposableTimeout(function () {
                    var cachedLensesNow = _this._codeLensCache.get(model);
                    if (cachedLenses === cachedLensesNow) {
                        _this._codeLensCache.delete(model);
                        _this._onModelChange();
                    }
                }, 30 * 1000));
            }
            return;
        }
        try {
            for (var _b = __values(CodeLensProviderRegistry.all(model)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var provider = _c.value;
                if (typeof provider.onDidChange === 'function') {
                    var registration = provider.onDidChange(function () { return scheduler.schedule(); });
                    this._localToDispose.add(registration);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        var scheduler = new RunOnceScheduler(function () {
            var _a;
            var t1 = Date.now();
            (_a = _this._getCodeLensModelPromise) === null || _a === void 0 ? void 0 : _a.cancel();
            _this._getCodeLensModelPromise = createCancelablePromise(function (token) { return getCodeLensModel(model, token); });
            _this._getCodeLensModelPromise.then(function (result) {
                if (_this._currentCodeLensModel) {
                    _this._oldCodeLensModels.add(_this._currentCodeLensModel);
                }
                _this._currentCodeLensModel = result;
                // cache model to reduce flicker
                _this._codeLensCache.put(model, result);
                // update moving average
                var newDelay = _this._getCodeLensModelDelays.update(model, Date.now() - t1);
                scheduler.delay = newDelay;
                // render lenses
                _this._renderCodeLensSymbols(result);
                _this._resolveCodeLensesInViewport();
            }, onUnexpectedError);
        }, this._getCodeLensModelDelays.get(model));
        this._localToDispose.add(scheduler);
        this._localToDispose.add(toDisposable(function () { return _this._resolveCodeLensesScheduler.cancel(); }));
        this._localToDispose.add(this._editor.onDidChangeModelContent(function () {
            _this._editor.changeDecorations(function (decorationsAccessor) {
                _this._editor.changeViewZones(function (viewZonesAccessor) {
                    var toDispose = [];
                    var lastLensLineNumber = -1;
                    _this._lenses.forEach(function (lens) {
                        if (!lens.isValid() || lastLensLineNumber === lens.getLineNumber()) {
                            // invalid -> lens collapsed, attach range doesn't exist anymore
                            // line_number -> lenses should never be on the same line
                            toDispose.push(lens);
                        }
                        else {
                            lens.update(viewZonesAccessor);
                            lastLensLineNumber = lens.getLineNumber();
                        }
                    });
                    var helper = new CodeLensHelper();
                    toDispose.forEach(function (l) {
                        l.dispose(helper, viewZonesAccessor);
                        _this._lenses.splice(_this._lenses.indexOf(l), 1);
                    });
                    helper.commit(decorationsAccessor);
                });
            });
            // Ask for all references again
            scheduler.schedule();
        }));
        this._localToDispose.add(this._editor.onDidFocusEditorWidget(function () {
            scheduler.schedule();
        }));
        this._localToDispose.add(this._editor.onDidScrollChange(function (e) {
            if (e.scrollTopChanged && _this._lenses.length > 0) {
                _this._resolveCodeLensesInViewportSoon();
            }
        }));
        this._localToDispose.add(this._editor.onDidLayoutChange(function () {
            _this._resolveCodeLensesInViewportSoon();
        }));
        this._localToDispose.add(toDisposable(function () {
            if (_this._editor.getModel()) {
                var scrollState = StableEditorScrollState.capture(_this._editor);
                _this._editor.changeDecorations(function (decorationsAccessor) {
                    _this._editor.changeViewZones(function (viewZonesAccessor) {
                        _this._disposeAllLenses(decorationsAccessor, viewZonesAccessor);
                    });
                });
                scrollState.restore(_this._editor);
            }
            else {
                // No accessors available
                _this._disposeAllLenses(undefined, undefined);
            }
        }));
        this._localToDispose.add(this._editor.onMouseDown(function (e) {
            var e_3, _a, _b;
            if (e.target.type !== 9 /* CONTENT_WIDGET */) {
                return;
            }
            var target = e.target.element;
            if ((target === null || target === void 0 ? void 0 : target.tagName) === 'SPAN') {
                target = target.parentElement;
            }
            if ((target === null || target === void 0 ? void 0 : target.tagName) === 'A') {
                try {
                    for (var _c = __values(_this._lenses), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var lens = _d.value;
                        var command = lens.getCommand(target);
                        if (command) {
                            (_b = _this._commandService).executeCommand.apply(_b, __spreadArray([command.id], __read((command.arguments || [])))).catch(function (err) { return _this._notificationService.error(err); });
                            break;
                        }
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
        }));
        scheduler.schedule();
    };
    CodeLensContribution.prototype._disposeAllLenses = function (decChangeAccessor, viewZoneChangeAccessor) {
        var e_4, _a;
        var helper = new CodeLensHelper();
        try {
            for (var _b = __values(this._lenses), _c = _b.next(); !_c.done; _c = _b.next()) {
                var lens = _c.value;
                lens.dispose(helper, viewZoneChangeAccessor);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        if (decChangeAccessor) {
            helper.commit(decChangeAccessor);
        }
        this._lenses.length = 0;
    };
    CodeLensContribution.prototype._renderCodeLensSymbols = function (symbols) {
        var e_5, _a;
        var _this = this;
        if (!this._editor.hasModel()) {
            return;
        }
        var maxLineNumber = this._editor.getModel().getLineCount();
        var groups = [];
        var lastGroup;
        try {
            for (var _b = __values(symbols.lenses), _c = _b.next(); !_c.done; _c = _b.next()) {
                var symbol = _c.value;
                var line = symbol.symbol.range.startLineNumber;
                if (line < 1 || line > maxLineNumber) {
                    // invalid code lens
                    continue;
                }
                else if (lastGroup && lastGroup[lastGroup.length - 1].symbol.range.startLineNumber === line) {
                    // on same line as previous
                    lastGroup.push(symbol);
                }
                else {
                    // on later line as previous
                    lastGroup = [symbol];
                    groups.push(lastGroup);
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
        var scrollState = StableEditorScrollState.capture(this._editor);
        var layoutInfo = this._getLayoutInfo();
        this._editor.changeDecorations(function (decorationsAccessor) {
            _this._editor.changeViewZones(function (viewZoneAccessor) {
                var helper = new CodeLensHelper();
                var codeLensIndex = 0;
                var groupsIndex = 0;
                while (groupsIndex < groups.length && codeLensIndex < _this._lenses.length) {
                    var symbolsLineNumber = groups[groupsIndex][0].symbol.range.startLineNumber;
                    var codeLensLineNumber = _this._lenses[codeLensIndex].getLineNumber();
                    if (codeLensLineNumber < symbolsLineNumber) {
                        _this._lenses[codeLensIndex].dispose(helper, viewZoneAccessor);
                        _this._lenses.splice(codeLensIndex, 1);
                    }
                    else if (codeLensLineNumber === symbolsLineNumber) {
                        _this._lenses[codeLensIndex].updateCodeLensSymbols(groups[groupsIndex], helper);
                        groupsIndex++;
                        codeLensIndex++;
                    }
                    else {
                        _this._lenses.splice(codeLensIndex, 0, new CodeLensWidget(groups[groupsIndex], _this._editor, _this._styleClassName, helper, viewZoneAccessor, layoutInfo.codeLensHeight, function () { return _this._resolveCodeLensesInViewportSoon(); }));
                        codeLensIndex++;
                        groupsIndex++;
                    }
                }
                // Delete extra code lenses
                while (codeLensIndex < _this._lenses.length) {
                    _this._lenses[codeLensIndex].dispose(helper, viewZoneAccessor);
                    _this._lenses.splice(codeLensIndex, 1);
                }
                // Create extra symbols
                while (groupsIndex < groups.length) {
                    _this._lenses.push(new CodeLensWidget(groups[groupsIndex], _this._editor, _this._styleClassName, helper, viewZoneAccessor, layoutInfo.codeLensHeight, function () { return _this._resolveCodeLensesInViewportSoon(); }));
                    groupsIndex++;
                }
                helper.commit(decorationsAccessor);
            });
        });
        scrollState.restore(this._editor);
    };
    CodeLensContribution.prototype._resolveCodeLensesInViewportSoon = function () {
        var model = this._editor.getModel();
        if (model) {
            this._resolveCodeLensesScheduler.schedule();
        }
    };
    CodeLensContribution.prototype._resolveCodeLensesInViewport = function () {
        var _this = this;
        var _a;
        (_a = this._resolveCodeLensesPromise) === null || _a === void 0 ? void 0 : _a.cancel();
        this._resolveCodeLensesPromise = undefined;
        var model = this._editor.getModel();
        if (!model) {
            return;
        }
        var toResolve = [];
        var lenses = [];
        this._lenses.forEach(function (lens) {
            var request = lens.computeIfNecessary(model);
            if (request) {
                toResolve.push(request);
                lenses.push(lens);
            }
        });
        if (toResolve.length === 0) {
            return;
        }
        var t1 = Date.now();
        var resolvePromise = createCancelablePromise(function (token) {
            var promises = toResolve.map(function (request, i) {
                var resolvedSymbols = new Array(request.length);
                var promises = request.map(function (request, i) {
                    if (!request.symbol.command && typeof request.provider.resolveCodeLens === 'function') {
                        return Promise.resolve(request.provider.resolveCodeLens(model, request.symbol, token)).then(function (symbol) {
                            resolvedSymbols[i] = symbol;
                        }, onUnexpectedExternalError);
                    }
                    else {
                        resolvedSymbols[i] = request.symbol;
                        return Promise.resolve(undefined);
                    }
                });
                return Promise.all(promises).then(function () {
                    if (!token.isCancellationRequested && !lenses[i].isDisposed()) {
                        lenses[i].updateCommands(resolvedSymbols);
                    }
                });
            });
            return Promise.all(promises);
        });
        this._resolveCodeLensesPromise = resolvePromise;
        this._resolveCodeLensesPromise.then(function () {
            // update moving average
            var newDelay = _this._resolveCodeLensesDelays.update(model, Date.now() - t1);
            _this._resolveCodeLensesScheduler.delay = newDelay;
            if (_this._currentCodeLensModel) { // update the cached state with new resolved items
                _this._codeLensCache.put(model, _this._currentCodeLensModel);
            }
            _this._oldCodeLensModels.clear(); // dispose old models once we have updated the UI with the current model
            if (resolvePromise === _this._resolveCodeLensesPromise) {
                _this._resolveCodeLensesPromise = undefined;
            }
        }, function (err) {
            onUnexpectedError(err); // can also be cancellation!
            if (resolvePromise === _this._resolveCodeLensesPromise) {
                _this._resolveCodeLensesPromise = undefined;
            }
        });
    };
    CodeLensContribution.prototype.getLenses = function () {
        return this._lenses;
    };
    CodeLensContribution.ID = 'css.editor.codeLens';
    CodeLensContribution = __decorate([
        __param(1, ICommandService),
        __param(2, INotificationService),
        __param(3, ICodeLensCache)
    ], CodeLensContribution);
    return CodeLensContribution;
}());
export { CodeLensContribution };
registerEditorContribution(CodeLensContribution.ID, CodeLensContribution);
registerEditorAction(/** @class */ (function (_super) {
    __extends(ShowLensesInCurrentLine, _super);
    function ShowLensesInCurrentLine() {
        return _super.call(this, {
            id: 'codelens.showLensesInCurrentLine',
            precondition: EditorContextKeys.hasCodeLensProvider,
            label: localize('showLensOnLine', "Show CodeLens Commands For Current Line"),
            alias: 'Show CodeLens Commands For Current Line',
        }) || this;
    }
    ShowLensesInCurrentLine.prototype.run = function (accessor, editor) {
        return __awaiter(this, void 0, void 0, function () {
            var quickInputService, commandService, notificationService, lineNumber, codelensController, items, _a, _b, lens, _c, _d, item_1, command, item, err_1;
            var e_6, _e, e_7, _f;
            return __generator(this, function (_g) {
                switch (_g.label) {
                    case 0:
                        if (!editor.hasModel()) {
                            return [2 /*return*/];
                        }
                        quickInputService = accessor.get(IQuickInputService);
                        commandService = accessor.get(ICommandService);
                        notificationService = accessor.get(INotificationService);
                        lineNumber = editor.getSelection().positionLineNumber;
                        codelensController = editor.getContribution(CodeLensContribution.ID);
                        items = [];
                        try {
                            for (_a = __values(codelensController.getLenses()), _b = _a.next(); !_b.done; _b = _a.next()) {
                                lens = _b.value;
                                if (lens.getLineNumber() === lineNumber) {
                                    try {
                                        for (_c = (e_7 = void 0, __values(lens.getItems())), _d = _c.next(); !_d.done; _d = _c.next()) {
                                            item_1 = _d.value;
                                            command = item_1.symbol.command;
                                            if (command) {
                                                items.push({
                                                    label: command.title,
                                                    command: command
                                                });
                                            }
                                        }
                                    }
                                    catch (e_7_1) { e_7 = { error: e_7_1 }; }
                                    finally {
                                        try {
                                            if (_d && !_d.done && (_f = _c.return)) _f.call(_c);
                                        }
                                        finally { if (e_7) throw e_7.error; }
                                    }
                                }
                            }
                        }
                        catch (e_6_1) { e_6 = { error: e_6_1 }; }
                        finally {
                            try {
                                if (_b && !_b.done && (_e = _a.return)) _e.call(_a);
                            }
                            finally { if (e_6) throw e_6.error; }
                        }
                        if (items.length === 0) {
                            // We dont want an empty picker
                            return [2 /*return*/];
                        }
                        return [4 /*yield*/, quickInputService.pick(items, { canPickMany: false })];
                    case 1:
                        item = _g.sent();
                        if (!item) {
                            // Nothing picked
                            return [2 /*return*/];
                        }
                        _g.label = 2;
                    case 2:
                        _g.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, commandService.executeCommand.apply(commandService, __spreadArray([item.command.id], __read((item.command.arguments || []))))];
                    case 3:
                        _g.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        err_1 = _g.sent();
                        notificationService.error(err_1);
                        return [3 /*break*/, 5];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    return ShowLensesInCurrentLine;
}(EditorAction)));
