/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { createDecorator } from '../../../platform/instantiation/common/instantiation';
import { registerSingleton } from '../../../platform/instantiation/common/extensions';
import { CodeLensModel } from './codelens';
import { LRUCache } from '../../../base/common/map';
import { IStorageService, WillSaveStateReason } from '../../../platform/storage/common/storage';
import { Range } from '../../common/core/range';
import { runWhenIdle } from '../../../base/common/async';
import { once } from '../../../base/common/functional';
export var ICodeLensCache = createDecorator('ICodeLensCache');
var CacheItem = /** @class */ (function () {
    function CacheItem(lineCount, data) {
        this.lineCount = lineCount;
        this.data = data;
    }
    return CacheItem;
}());
var CodeLensCache = /** @class */ (function () {
    function CodeLensCache(storageService) {
        var _this = this;
        this._fakeProvider = new /** @class */ (function () {
            function class_1() {
            }
            class_1.prototype.provideCodeLenses = function () {
                throw new Error('not supported');
            };
            return class_1;
        }());
        this._cache = new LRUCache(20, 0.75);
        // remove old data
        var oldkey = 'codelens/cache';
        runWhenIdle(function () { return storageService.remove(oldkey, 1 /* WORKSPACE */); });
        // restore lens data on start
        var key = 'codelens/cache2';
        var raw = storageService.get(key, 1 /* WORKSPACE */, '{}');
        this._deserialize(raw);
        // store lens data on shutdown
        once(storageService.onWillSaveState)(function (e) {
            if (e.reason === WillSaveStateReason.SHUTDOWN) {
                storageService.store(key, _this._serialize(), 1 /* WORKSPACE */, 1 /* MACHINE */);
            }
        });
    }
    CodeLensCache.prototype.put = function (model, data) {
        // create a copy of the model that is without command-ids
        // but with comand-labels
        var copyItems = data.lenses.map(function (item) {
            var _a;
            return {
                range: item.symbol.range,
                command: item.symbol.command && { id: '', title: (_a = item.symbol.command) === null || _a === void 0 ? void 0 : _a.title },
            };
        });
        var copyModel = new CodeLensModel();
        copyModel.add({ lenses: copyItems, dispose: function () { } }, this._fakeProvider);
        var item = new CacheItem(model.getLineCount(), copyModel);
        this._cache.set(model.uri.toString(), item);
    };
    CodeLensCache.prototype.get = function (model) {
        var item = this._cache.get(model.uri.toString());
        return item && item.lineCount === model.getLineCount() ? item.data : undefined;
    };
    CodeLensCache.prototype.delete = function (model) {
        this._cache.delete(model.uri.toString());
    };
    // --- persistence
    CodeLensCache.prototype._serialize = function () {
        var e_1, _a, e_2, _b;
        var data = Object.create(null);
        try {
            for (var _c = __values(this._cache), _d = _c.next(); !_d.done; _d = _c.next()) {
                var _e = __read(_d.value, 2), key = _e[0], value = _e[1];
                var lines = new Set();
                try {
                    for (var _f = (e_2 = void 0, __values(value.data.lenses)), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var d = _g.value;
                        lines.add(d.symbol.range.startLineNumber);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                data[key] = {
                    lineCount: value.lineCount,
                    lines: __spreadArray([], __read(lines.values()))
                };
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return JSON.stringify(data);
    };
    CodeLensCache.prototype._deserialize = function (raw) {
        var e_3, _a;
        try {
            var data = JSON.parse(raw);
            for (var key in data) {
                var element = data[key];
                var lenses = [];
                try {
                    for (var _b = (e_3 = void 0, __values(element.lines)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var line = _c.value;
                        lenses.push({ range: new Range(line, 1, line, 11) });
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                var model = new CodeLensModel();
                model.add({ lenses: lenses, dispose: function () { } }, this._fakeProvider);
                this._cache.set(key, new CacheItem(element.lineCount, model));
            }
        }
        catch (_d) {
            // ignore...
        }
    };
    CodeLensCache = __decorate([
        __param(0, IStorageService)
    ], CodeLensCache);
    return CodeLensCache;
}());
export { CodeLensCache };
registerSingleton(ICodeLensCache, CodeLensCache);
