/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { CancellationToken } from '../../../base/common/cancellation';
import { onUnexpectedExternalError } from '../../../base/common/errors';
import { URI } from '../../../base/common/uri';
import { DocumentSemanticTokensProviderRegistry, DocumentRangeSemanticTokensProviderRegistry } from '../modes';
import { IModelService } from './modelService';
import { CommandsRegistry, ICommandService } from '../../../platform/commands/common/commands';
import { assertType } from '../../../base/common/types';
import { encodeSemanticTokensDto } from './semanticTokensDto';
import { Range } from '../core/range';
export function isSemanticTokens(v) {
    return v && !!(v.data);
}
export function isSemanticTokensEdits(v) {
    return v && Array.isArray(v.edits);
}
export function getDocumentSemanticTokens(model, lastResultId, token) {
    var provider = _getDocumentSemanticTokensProvider(model);
    if (!provider) {
        return null;
    }
    return {
        provider: provider,
        request: Promise.resolve(provider.provideDocumentSemanticTokens(model, lastResultId, token))
    };
}
function _getDocumentSemanticTokensProvider(model) {
    var result = DocumentSemanticTokensProviderRegistry.ordered(model);
    return (result.length > 0 ? result[0] : null);
}
export function getDocumentRangeSemanticTokensProvider(model) {
    var result = DocumentRangeSemanticTokensProviderRegistry.ordered(model);
    return (result.length > 0 ? result[0] : null);
}
CommandsRegistry.registerCommand('_provideDocumentSemanticTokensLegend', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, model, provider;
        return __generator(this, function (_b) {
            _a = __read(args, 1), uri = _a[0];
            assertType(uri instanceof URI);
            model = accessor.get(IModelService).getModel(uri);
            if (!model) {
                return [2 /*return*/, undefined];
            }
            provider = _getDocumentSemanticTokensProvider(model);
            if (!provider) {
                // there is no provider => fall back to a document range semantic tokens provider
                return [2 /*return*/, accessor.get(ICommandService).executeCommand('_provideDocumentRangeSemanticTokensLegend', uri)];
            }
            return [2 /*return*/, provider.getLegend()];
        });
    });
});
CommandsRegistry.registerCommand('_provideDocumentSemanticTokens', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, model, r, provider, request, result, err_1, buff;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = __read(args, 1), uri = _a[0];
                    assertType(uri instanceof URI);
                    model = accessor.get(IModelService).getModel(uri);
                    if (!model) {
                        return [2 /*return*/, undefined];
                    }
                    r = getDocumentSemanticTokens(model, null, CancellationToken.None);
                    if (!r) {
                        // there is no provider => fall back to a document range semantic tokens provider
                        return [2 /*return*/, accessor.get(ICommandService).executeCommand('_provideDocumentRangeSemanticTokens', uri, model.getFullModelRange())];
                    }
                    provider = r.provider, request = r.request;
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, request];
                case 2:
                    result = _b.sent();
                    return [3 /*break*/, 4];
                case 3:
                    err_1 = _b.sent();
                    onUnexpectedExternalError(err_1);
                    return [2 /*return*/, undefined];
                case 4:
                    if (!result || !isSemanticTokens(result)) {
                        return [2 /*return*/, undefined];
                    }
                    buff = encodeSemanticTokensDto({
                        id: 0,
                        type: 'full',
                        data: result.data
                    });
                    if (result.resultId) {
                        provider.releaseDocumentSemanticTokens(result.resultId);
                    }
                    return [2 /*return*/, buff];
            }
        });
    });
});
CommandsRegistry.registerCommand('_provideDocumentRangeSemanticTokensLegend', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, model, provider;
        return __generator(this, function (_b) {
            _a = __read(args, 1), uri = _a[0];
            assertType(uri instanceof URI);
            model = accessor.get(IModelService).getModel(uri);
            if (!model) {
                return [2 /*return*/, undefined];
            }
            provider = getDocumentRangeSemanticTokensProvider(model);
            if (!provider) {
                return [2 /*return*/, undefined];
            }
            return [2 /*return*/, provider.getLegend()];
        });
    });
});
CommandsRegistry.registerCommand('_provideDocumentRangeSemanticTokens', function (accessor) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return __awaiter(void 0, void 0, void 0, function () {
        var _a, uri, range, model, provider, result, err_2;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = __read(args, 2), uri = _a[0], range = _a[1];
                    assertType(uri instanceof URI);
                    assertType(Range.isIRange(range));
                    model = accessor.get(IModelService).getModel(uri);
                    if (!model) {
                        return [2 /*return*/, undefined];
                    }
                    provider = getDocumentRangeSemanticTokensProvider(model);
                    if (!provider) {
                        // there is no provider
                        return [2 /*return*/, undefined];
                    }
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, provider.provideDocumentRangeSemanticTokens(model, Range.lift(range), CancellationToken.None)];
                case 2:
                    result = _b.sent();
                    return [3 /*break*/, 4];
                case 3:
                    err_2 = _b.sent();
                    onUnexpectedExternalError(err_2);
                    return [2 /*return*/, undefined];
                case 4:
                    if (!result || !isSemanticTokens(result)) {
                        return [2 /*return*/, undefined];
                    }
                    return [2 /*return*/, encodeSemanticTokensDto({
                            id: 0,
                            type: 'full',
                            data: result.data
                        })];
            }
        });
    });
});
