/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import * as platform from '../../../base/common/platform';
import { EditorOptions } from './editorOptions';
import { EditorZoom } from './editorZoom';
/**
 * Determined from empirical observations.
 * @internal
 */
var GOLDEN_LINE_HEIGHT_RATIO = platform.isMacintosh ? 1.5 : 1.35;
/**
 * @internal
 */
var MINIMUM_LINE_HEIGHT = 8;
var BareFontInfo = /** @class */ (function () {
    /**
     * @internal
     */
    function BareFontInfo(opts) {
        this.zoomLevel = opts.zoomLevel;
        this.pixelRatio = opts.pixelRatio;
        this.fontFamily = String(opts.fontFamily);
        this.fontWeight = String(opts.fontWeight);
        this.fontSize = opts.fontSize;
        this.fontFeatureSettings = opts.fontFeatureSettings;
        this.lineHeight = opts.lineHeight | 0;
        this.letterSpacing = opts.letterSpacing;
    }
    /**
     * @internal
     */
    BareFontInfo.createFromValidatedSettings = function (options, zoomLevel, pixelRatio, ignoreEditorZoom) {
        var fontFamily = options.get(37 /* fontFamily */);
        var fontWeight = options.get(41 /* fontWeight */);
        var fontSize = options.get(40 /* fontSize */);
        var fontFeatureSettings = options.get(39 /* fontLigatures */);
        var lineHeight = options.get(53 /* lineHeight */);
        var letterSpacing = options.get(50 /* letterSpacing */);
        return BareFontInfo._create(fontFamily, fontWeight, fontSize, fontFeatureSettings, lineHeight, letterSpacing, zoomLevel, pixelRatio, ignoreEditorZoom);
    };
    /**
     * @internal
     */
    BareFontInfo.createFromRawSettings = function (opts, zoomLevel, pixelRatio, ignoreEditorZoom) {
        if (ignoreEditorZoom === void 0) { ignoreEditorZoom = false; }
        var fontFamily = EditorOptions.fontFamily.validate(opts.fontFamily);
        var fontWeight = EditorOptions.fontWeight.validate(opts.fontWeight);
        var fontSize = EditorOptions.fontSize.validate(opts.fontSize);
        var fontFeatureSettings = EditorOptions.fontLigatures2.validate(opts.fontLigatures);
        var lineHeight = EditorOptions.lineHeight.validate(opts.lineHeight);
        var letterSpacing = EditorOptions.letterSpacing.validate(opts.letterSpacing);
        return BareFontInfo._create(fontFamily, fontWeight, fontSize, fontFeatureSettings, lineHeight, letterSpacing, zoomLevel, pixelRatio, ignoreEditorZoom);
    };
    /**
     * @internal
     */
    BareFontInfo._create = function (fontFamily, fontWeight, fontSize, fontFeatureSettings, lineHeight, letterSpacing, zoomLevel, pixelRatio, ignoreEditorZoom) {
        if (lineHeight === 0) {
            lineHeight = Math.round(GOLDEN_LINE_HEIGHT_RATIO * fontSize);
        }
        else if (lineHeight < MINIMUM_LINE_HEIGHT) {
            lineHeight = MINIMUM_LINE_HEIGHT;
        }
        var editorZoomLevelMultiplier = 1 + (ignoreEditorZoom ? 0 : EditorZoom.getZoomLevel() * 0.1);
        fontSize *= editorZoomLevelMultiplier;
        lineHeight *= editorZoomLevelMultiplier;
        return new BareFontInfo({
            zoomLevel: zoomLevel,
            pixelRatio: pixelRatio,
            fontFamily: fontFamily,
            fontWeight: fontWeight,
            fontSize: fontSize,
            fontFeatureSettings: fontFeatureSettings,
            lineHeight: lineHeight,
            letterSpacing: letterSpacing
        });
    };
    /**
     * @internal
     */
    BareFontInfo.prototype.getId = function () {
        return this.zoomLevel + '-' + this.pixelRatio + '-' + this.fontFamily + '-' + this.fontWeight + '-' + this.fontSize + '-' + this.fontFeatureSettings + '-' + this.lineHeight + '-' + this.letterSpacing;
    };
    /**
     * @internal
     */
    BareFontInfo.prototype.getMassagedFontFamily = function () {
        if (/[,"']/.test(this.fontFamily)) {
            // Looks like the font family might be already escaped
            return this.fontFamily;
        }
        if (/[+ ]/.test(this.fontFamily)) {
            // Wrap a font family using + or <space> with quotes
            return "\"" + this.fontFamily + "\"";
        }
        return this.fontFamily;
    };
    return BareFontInfo;
}());
export { BareFontInfo };
// change this whenever `FontInfo` members are changed
export var SERIALIZED_FONT_INFO_VERSION = 1;
var FontInfo = /** @class */ (function (_super) {
    __extends(FontInfo, _super);
    /**
     * @internal
     */
    function FontInfo(opts, isTrusted) {
        var _this = _super.call(this, opts) || this;
        _this.version = SERIALIZED_FONT_INFO_VERSION;
        _this.isTrusted = isTrusted;
        _this.isMonospace = opts.isMonospace;
        _this.typicalHalfwidthCharacterWidth = opts.typicalHalfwidthCharacterWidth;
        _this.typicalFullwidthCharacterWidth = opts.typicalFullwidthCharacterWidth;
        _this.canUseHalfwidthRightwardsArrow = opts.canUseHalfwidthRightwardsArrow;
        _this.spaceWidth = opts.spaceWidth;
        _this.middotWidth = opts.middotWidth;
        _this.wsmiddotWidth = opts.wsmiddotWidth;
        _this.maxDigitWidth = opts.maxDigitWidth;
        return _this;
    }
    /**
     * @internal
     */
    FontInfo.prototype.equals = function (other) {
        return (this.fontFamily === other.fontFamily
            && this.fontWeight === other.fontWeight
            && this.fontSize === other.fontSize
            && this.fontFeatureSettings === other.fontFeatureSettings
            && this.lineHeight === other.lineHeight
            && this.letterSpacing === other.letterSpacing
            && this.typicalHalfwidthCharacterWidth === other.typicalHalfwidthCharacterWidth
            && this.typicalFullwidthCharacterWidth === other.typicalFullwidthCharacterWidth
            && this.canUseHalfwidthRightwardsArrow === other.canUseHalfwidthRightwardsArrow
            && this.spaceWidth === other.spaceWidth
            && this.middotWidth === other.middotWidth
            && this.wsmiddotWidth === other.wsmiddotWidth
            && this.maxDigitWidth === other.maxDigitWidth);
    };
    return FontInfo;
}(BareFontInfo));
export { FontInfo };
