/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { MouseTarget } from '../controller/mouseTarget';
var ViewUserInputEvents = /** @class */ (function () {
    function ViewUserInputEvents(coordinatesConverter) {
        this.onKeyDown = null;
        this.onKeyUp = null;
        this.onContextMenu = null;
        this.onMouseMove = null;
        this.onMouseLeave = null;
        this.onMouseDown = null;
        this.onMouseUp = null;
        this.onMouseDrag = null;
        this.onMouseDrop = null;
        this.onMouseDropCanceled = null;
        this.onMouseWheel = null;
        this._coordinatesConverter = coordinatesConverter;
    }
    ViewUserInputEvents.prototype.emitKeyDown = function (e) {
        if (this.onKeyDown) {
            this.onKeyDown(e);
        }
    };
    ViewUserInputEvents.prototype.emitKeyUp = function (e) {
        if (this.onKeyUp) {
            this.onKeyUp(e);
        }
    };
    ViewUserInputEvents.prototype.emitContextMenu = function (e) {
        if (this.onContextMenu) {
            this.onContextMenu(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseMove = function (e) {
        if (this.onMouseMove) {
            this.onMouseMove(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseLeave = function (e) {
        if (this.onMouseLeave) {
            this.onMouseLeave(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseDown = function (e) {
        if (this.onMouseDown) {
            this.onMouseDown(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseUp = function (e) {
        if (this.onMouseUp) {
            this.onMouseUp(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseDrag = function (e) {
        if (this.onMouseDrag) {
            this.onMouseDrag(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseDrop = function (e) {
        if (this.onMouseDrop) {
            this.onMouseDrop(this._convertViewToModelMouseEvent(e));
        }
    };
    ViewUserInputEvents.prototype.emitMouseDropCanceled = function () {
        if (this.onMouseDropCanceled) {
            this.onMouseDropCanceled();
        }
    };
    ViewUserInputEvents.prototype.emitMouseWheel = function (e) {
        if (this.onMouseWheel) {
            this.onMouseWheel(e);
        }
    };
    ViewUserInputEvents.prototype._convertViewToModelMouseEvent = function (e) {
        if (e.target) {
            return {
                event: e.event,
                target: this._convertViewToModelMouseTarget(e.target)
            };
        }
        return e;
    };
    ViewUserInputEvents.prototype._convertViewToModelMouseTarget = function (target) {
        return ViewUserInputEvents.convertViewToModelMouseTarget(target, this._coordinatesConverter);
    };
    ViewUserInputEvents.convertViewToModelMouseTarget = function (target, coordinatesConverter) {
        return new ExternalMouseTarget(target.element, target.type, target.mouseColumn, target.position ? coordinatesConverter.convertViewPositionToModelPosition(target.position) : null, target.range ? coordinatesConverter.convertViewRangeToModelRange(target.range) : null, target.detail);
    };
    return ViewUserInputEvents;
}());
export { ViewUserInputEvents };
var ExternalMouseTarget = /** @class */ (function () {
    function ExternalMouseTarget(element, type, mouseColumn, position, range, detail) {
        this.element = element;
        this.type = type;
        this.mouseColumn = mouseColumn;
        this.position = position;
        this.range = range;
        this.detail = detail;
    }
    ExternalMouseTarget.prototype.toString = function () {
        return MouseTarget.toString(this);
    };
    return ExternalMouseTarget;
}());
