/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import './media/quickInput.css';
import * as dom from '../../../browser/dom';
import { dispose } from '../../../common/lifecycle';
import { matchesFuzzyIconAware, parseLabelWithIcons } from '../../../common/iconLabels';
import { compareAnything } from '../../../common/comparers';
import { Emitter, Event } from '../../../common/event';
import { StandardKeyboardEvent } from '../../../browser/keyboardEvent';
import { IconLabel } from '../../../browser/ui/iconLabel/iconLabel';
import { HighlightedLabel } from '../../../browser/ui/highlightedlabel/highlightedLabel';
import { memoize } from '../../../common/decorators';
import { range } from '../../../common/arrays';
import * as platform from '../../../common/platform';
import { ActionBar } from '../../../browser/ui/actionbar/actionbar';
import { Action } from '../../../common/actions';
import { getIconClass } from './quickInputUtils';
import { withNullAsUndefined } from '../../../common/types';
import { KeybindingLabel } from '../../../browser/ui/keybindingLabel/keybindingLabel';
import { localize } from '../../../../nls';
var $ = dom.$;
var ListElement = /** @class */ (function () {
    function ListElement(init) {
        this.hidden = false;
        this._onChecked = new Emitter();
        this.onChecked = this._onChecked.event;
        Object.assign(this, init);
    }
    Object.defineProperty(ListElement.prototype, "checked", {
        get: function () {
            return !!this._checked;
        },
        set: function (value) {
            if (value !== this._checked) {
                this._checked = value;
                this._onChecked.fire(value);
            }
        },
        enumerable: false,
        configurable: true
    });
    ListElement.prototype.dispose = function () {
        this._onChecked.dispose();
    };
    return ListElement;
}());
var ListElementRenderer = /** @class */ (function () {
    function ListElementRenderer() {
    }
    Object.defineProperty(ListElementRenderer.prototype, "templateId", {
        get: function () {
            return ListElementRenderer.ID;
        },
        enumerable: false,
        configurable: true
    });
    ListElementRenderer.prototype.renderTemplate = function (container) {
        var data = Object.create(null);
        data.toDisposeElement = [];
        data.toDisposeTemplate = [];
        data.entry = dom.append(container, $('.quick-input-list-entry'));
        // Checkbox
        var label = dom.append(data.entry, $('label.quick-input-list-label'));
        data.toDisposeTemplate.push(dom.addStandardDisposableListener(label, dom.EventType.CLICK, function (e) {
            if (!data.checkbox.offsetParent) { // If checkbox not visible:
                e.preventDefault(); // Prevent toggle of checkbox when it is immediately shown afterwards. #91740
            }
        }));
        data.checkbox = dom.append(label, $('input.quick-input-list-checkbox'));
        data.checkbox.type = 'checkbox';
        data.toDisposeTemplate.push(dom.addStandardDisposableListener(data.checkbox, dom.EventType.CHANGE, function (e) {
            data.element.checked = data.checkbox.checked;
        }));
        // Rows
        var rows = dom.append(label, $('.quick-input-list-rows'));
        var row1 = dom.append(rows, $('.quick-input-list-row'));
        var row2 = dom.append(rows, $('.quick-input-list-row'));
        // Label
        data.label = new IconLabel(row1, { supportHighlights: true, supportDescriptionHighlights: true, supportIcons: true });
        // Keybinding
        var keybindingContainer = dom.append(row1, $('.quick-input-list-entry-keybinding'));
        data.keybinding = new KeybindingLabel(keybindingContainer, platform.OS);
        // Detail
        var detailContainer = dom.append(row2, $('.quick-input-list-label-meta'));
        data.detail = new HighlightedLabel(detailContainer, true);
        // Separator
        data.separator = dom.append(data.entry, $('.quick-input-list-separator'));
        // Actions
        data.actionBar = new ActionBar(data.entry);
        data.actionBar.domNode.classList.add('quick-input-list-entry-action-bar');
        data.toDisposeTemplate.push(data.actionBar);
        return data;
    };
    ListElementRenderer.prototype.renderElement = function (element, index, data) {
        var _this = this;
        data.toDisposeElement = dispose(data.toDisposeElement);
        data.element = element;
        data.checkbox.checked = element.checked;
        data.toDisposeElement.push(element.onChecked(function (checked) { return data.checkbox.checked = checked; }));
        var labelHighlights = element.labelHighlights, descriptionHighlights = element.descriptionHighlights, detailHighlights = element.detailHighlights;
        // Label
        var options = Object.create(null);
        options.matches = labelHighlights || [];
        options.descriptionTitle = element.saneDescription;
        options.descriptionMatches = descriptionHighlights || [];
        options.extraClasses = element.item.iconClasses;
        options.italic = element.item.italic;
        options.strikethrough = element.item.strikethrough;
        data.label.setLabel(element.saneLabel, element.saneDescription, options);
        // Keybinding
        data.keybinding.set(element.item.keybinding);
        // Meta
        data.detail.set(element.saneDetail, detailHighlights);
        // Separator
        if (element.separator && element.separator.label) {
            data.separator.textContent = element.separator.label;
            data.separator.style.display = '';
        }
        else {
            data.separator.style.display = 'none';
        }
        data.entry.classList.toggle('quick-input-list-separator-border', !!element.separator);
        // Actions
        data.actionBar.clear();
        var buttons = element.item.buttons;
        if (buttons && buttons.length) {
            data.actionBar.push(buttons.map(function (button, index) {
                var cssClasses = button.iconClass || (button.iconPath ? getIconClass(button.iconPath) : undefined);
                if (button.alwaysVisible) {
                    cssClasses = cssClasses ? cssClasses + " always-visible" : 'always-visible';
                }
                var action = new Action("id-" + index, '', cssClasses, true, function () { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        element.fireButtonTriggered({
                            button: button,
                            item: element.item
                        });
                        return [2 /*return*/];
                    });
                }); });
                action.tooltip = button.tooltip || '';
                return action;
            }), { icon: true, label: false });
            data.entry.classList.add('has-actions');
        }
        else {
            data.entry.classList.remove('has-actions');
        }
    };
    ListElementRenderer.prototype.disposeElement = function (element, index, data) {
        data.toDisposeElement = dispose(data.toDisposeElement);
    };
    ListElementRenderer.prototype.disposeTemplate = function (data) {
        data.toDisposeElement = dispose(data.toDisposeElement);
        data.toDisposeTemplate = dispose(data.toDisposeTemplate);
    };
    ListElementRenderer.ID = 'listelement';
    return ListElementRenderer;
}());
var ListElementDelegate = /** @class */ (function () {
    function ListElementDelegate() {
    }
    ListElementDelegate.prototype.getHeight = function (element) {
        return element.saneDetail ? 44 : 22;
    };
    ListElementDelegate.prototype.getTemplateId = function (element) {
        return ListElementRenderer.ID;
    };
    return ListElementDelegate;
}());
export var QuickInputListFocus;
(function (QuickInputListFocus) {
    QuickInputListFocus[QuickInputListFocus["First"] = 1] = "First";
    QuickInputListFocus[QuickInputListFocus["Second"] = 2] = "Second";
    QuickInputListFocus[QuickInputListFocus["Last"] = 3] = "Last";
    QuickInputListFocus[QuickInputListFocus["Next"] = 4] = "Next";
    QuickInputListFocus[QuickInputListFocus["Previous"] = 5] = "Previous";
    QuickInputListFocus[QuickInputListFocus["NextPage"] = 6] = "NextPage";
    QuickInputListFocus[QuickInputListFocus["PreviousPage"] = 7] = "PreviousPage";
})(QuickInputListFocus || (QuickInputListFocus = {}));
var QuickInputList = /** @class */ (function () {
    function QuickInputList(parent, id, options) {
        var _this = this;
        this.parent = parent;
        this.inputElements = [];
        this.elements = [];
        this.elementsToIndexes = new Map();
        this.matchOnDescription = false;
        this.matchOnDetail = false;
        this.matchOnLabel = true;
        this.matchOnMeta = true;
        this.sortByLabel = true;
        this._onChangedAllVisibleChecked = new Emitter();
        this.onChangedAllVisibleChecked = this._onChangedAllVisibleChecked.event;
        this._onChangedCheckedCount = new Emitter();
        this.onChangedCheckedCount = this._onChangedCheckedCount.event;
        this._onChangedVisibleCount = new Emitter();
        this.onChangedVisibleCount = this._onChangedVisibleCount.event;
        this._onChangedCheckedElements = new Emitter();
        this.onChangedCheckedElements = this._onChangedCheckedElements.event;
        this._onButtonTriggered = new Emitter();
        this.onButtonTriggered = this._onButtonTriggered.event;
        this._onKeyDown = new Emitter();
        this.onKeyDown = this._onKeyDown.event;
        this._onLeave = new Emitter();
        this.onLeave = this._onLeave.event;
        this._fireCheckedEvents = true;
        this.elementDisposables = [];
        this.disposables = [];
        this.id = id;
        this.container = dom.append(this.parent, $('.quick-input-list'));
        var delegate = new ListElementDelegate();
        var accessibilityProvider = new QuickInputAccessibilityProvider();
        this.list = options.createList('QuickInput', this.container, delegate, [new ListElementRenderer()], {
            identityProvider: { getId: function (element) { return element.saneLabel; } },
            setRowLineHeight: false,
            multipleSelectionSupport: false,
            horizontalScrolling: false,
            accessibilityProvider: accessibilityProvider
        });
        this.list.getHTMLElement().id = id;
        this.disposables.push(this.list);
        this.disposables.push(this.list.onKeyDown(function (e) {
            var event = new StandardKeyboardEvent(e);
            switch (event.keyCode) {
                case 10 /* Space */:
                    _this.toggleCheckbox();
                    break;
                case 31 /* KEY_A */:
                    if (platform.isMacintosh ? e.metaKey : e.ctrlKey) {
                        _this.list.setFocus(range(_this.list.length));
                    }
                    break;
                case 16 /* UpArrow */:
                    var focus1 = _this.list.getFocus();
                    if (focus1.length === 1 && focus1[0] === 0) {
                        _this._onLeave.fire();
                    }
                    break;
                case 18 /* DownArrow */:
                    var focus2 = _this.list.getFocus();
                    if (focus2.length === 1 && focus2[0] === _this.list.length - 1) {
                        _this._onLeave.fire();
                    }
                    break;
            }
            _this._onKeyDown.fire(event);
        }));
        this.disposables.push(this.list.onMouseDown(function (e) {
            if (e.browserEvent.button !== 2) {
                // Works around / fixes #64350.
                e.browserEvent.preventDefault();
            }
        }));
        this.disposables.push(dom.addDisposableListener(this.container, dom.EventType.CLICK, function (e) {
            if (e.x || e.y) { // Avoid 'click' triggered by 'space' on checkbox.
                _this._onLeave.fire();
            }
        }));
        this.disposables.push(this.list.onMouseMiddleClick(function (e) {
            _this._onLeave.fire();
        }));
        this.disposables.push(this.list.onContextMenu(function (e) {
            if (typeof e.index === 'number') {
                e.browserEvent.preventDefault();
                // we want to treat a context menu event as
                // a gesture to open the item at the index
                // since we do not have any context menu
                // this enables for example macOS to Ctrl-
                // click on an item to open it.
                _this.list.setSelection([e.index]);
            }
        }));
        this.disposables.push(this._onChangedAllVisibleChecked, this._onChangedCheckedCount, this._onChangedVisibleCount, this._onChangedCheckedElements, this._onButtonTriggered, this._onLeave, this._onKeyDown);
    }
    Object.defineProperty(QuickInputList.prototype, "onDidChangeFocus", {
        get: function () {
            return Event.map(this.list.onDidChangeFocus, function (e) { return e.elements.map(function (e) { return e.item; }); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputList.prototype, "onDidChangeSelection", {
        get: function () {
            return Event.map(this.list.onDidChangeSelection, function (e) { return ({ items: e.elements.map(function (e) { return e.item; }), event: e.browserEvent }); });
        },
        enumerable: false,
        configurable: true
    });
    QuickInputList.prototype.getAllVisibleChecked = function () {
        return this.allVisibleChecked(this.elements, false);
    };
    QuickInputList.prototype.allVisibleChecked = function (elements, whenNoneVisible) {
        if (whenNoneVisible === void 0) { whenNoneVisible = true; }
        for (var i = 0, n = elements.length; i < n; i++) {
            var element = elements[i];
            if (!element.hidden) {
                if (!element.checked) {
                    return false;
                }
                else {
                    whenNoneVisible = true;
                }
            }
        }
        return whenNoneVisible;
    };
    QuickInputList.prototype.getCheckedCount = function () {
        var count = 0;
        var elements = this.elements;
        for (var i = 0, n = elements.length; i < n; i++) {
            if (elements[i].checked) {
                count++;
            }
        }
        return count;
    };
    QuickInputList.prototype.getVisibleCount = function () {
        var count = 0;
        var elements = this.elements;
        for (var i = 0, n = elements.length; i < n; i++) {
            if (!elements[i].hidden) {
                count++;
            }
        }
        return count;
    };
    QuickInputList.prototype.setAllVisibleChecked = function (checked) {
        try {
            this._fireCheckedEvents = false;
            this.elements.forEach(function (element) {
                if (!element.hidden) {
                    element.checked = checked;
                }
            });
        }
        finally {
            this._fireCheckedEvents = true;
            this.fireCheckedEvents();
        }
    };
    QuickInputList.prototype.setElements = function (inputElements) {
        var _a, _b;
        var _this = this;
        this.elementDisposables = dispose(this.elementDisposables);
        var fireButtonTriggered = function (event) { return _this.fireButtonTriggered(event); };
        this.inputElements = inputElements;
        this.elements = inputElements.reduce(function (result, item, index) {
            var _a, _b, _c;
            if (item.type !== 'separator') {
                var previous = index && inputElements[index - 1];
                var saneLabel = item.label && item.label.replace(/\r?\n/g, ' ');
                var saneMeta = item.meta && item.meta.replace(/\r?\n/g, ' ');
                var saneDescription = item.description && item.description.replace(/\r?\n/g, ' ');
                var saneDetail = item.detail && item.detail.replace(/\r?\n/g, ' ');
                var saneAriaLabel = item.ariaLabel || [saneLabel, saneDescription, saneDetail]
                    .map(function (s) { return s && parseLabelWithIcons(s).text; })
                    .filter(function (s) { return !!s; })
                    .join(', ');
                result.push(new ListElement({
                    index: index,
                    item: item,
                    saneLabel: saneLabel,
                    saneMeta: saneMeta,
                    saneAriaLabel: saneAriaLabel,
                    saneDescription: saneDescription,
                    saneDetail: saneDetail,
                    labelHighlights: (_a = item.highlights) === null || _a === void 0 ? void 0 : _a.label,
                    descriptionHighlights: (_b = item.highlights) === null || _b === void 0 ? void 0 : _b.description,
                    detailHighlights: (_c = item.highlights) === null || _c === void 0 ? void 0 : _c.detail,
                    checked: false,
                    separator: previous && previous.type === 'separator' ? previous : undefined,
                    fireButtonTriggered: fireButtonTriggered
                }));
            }
            return result;
        }, []);
        (_a = this.elementDisposables).push.apply(_a, __spreadArray([], __read(this.elements)));
        (_b = this.elementDisposables).push.apply(_b, __spreadArray([], __read(this.elements.map(function (element) { return element.onChecked(function () { return _this.fireCheckedEvents(); }); }))));
        this.elementsToIndexes = this.elements.reduce(function (map, element, index) {
            map.set(element.item, index);
            return map;
        }, new Map());
        this.list.splice(0, this.list.length); // Clear focus and selection first, sending the events when the list is empty.
        this.list.splice(0, this.list.length, this.elements);
        this._onChangedVisibleCount.fire(this.elements.length);
    };
    QuickInputList.prototype.getElementsCount = function () {
        return this.inputElements.length;
    };
    QuickInputList.prototype.getFocusedElements = function () {
        return this.list.getFocusedElements()
            .map(function (e) { return e.item; });
    };
    QuickInputList.prototype.setFocusedElements = function (items) {
        var _this = this;
        this.list.setFocus(items
            .filter(function (item) { return _this.elementsToIndexes.has(item); })
            .map(function (item) { return _this.elementsToIndexes.get(item); }));
        if (items.length > 0) {
            var focused = this.list.getFocus()[0];
            if (typeof focused === 'number') {
                this.list.reveal(focused);
            }
        }
    };
    QuickInputList.prototype.getActiveDescendant = function () {
        return this.list.getHTMLElement().getAttribute('aria-activedescendant');
    };
    QuickInputList.prototype.getSelectedElements = function () {
        return this.list.getSelectedElements()
            .map(function (e) { return e.item; });
    };
    QuickInputList.prototype.setSelectedElements = function (items) {
        var _this = this;
        this.list.setSelection(items
            .filter(function (item) { return _this.elementsToIndexes.has(item); })
            .map(function (item) { return _this.elementsToIndexes.get(item); }));
    };
    QuickInputList.prototype.getCheckedElements = function () {
        return this.elements.filter(function (e) { return e.checked; })
            .map(function (e) { return e.item; });
    };
    QuickInputList.prototype.setCheckedElements = function (items) {
        var e_1, _a, e_2, _b;
        try {
            this._fireCheckedEvents = false;
            var checked = new Set();
            try {
                for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                    var item = items_1_1.value;
                    checked.add(item);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            try {
                for (var _c = __values(this.elements), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var element = _d.value;
                    element.checked = checked.has(element.item);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        finally {
            this._fireCheckedEvents = true;
            this.fireCheckedEvents();
        }
    };
    Object.defineProperty(QuickInputList.prototype, "enabled", {
        set: function (value) {
            this.list.getHTMLElement().style.pointerEvents = value ? '' : 'none';
        },
        enumerable: false,
        configurable: true
    });
    QuickInputList.prototype.focus = function (what) {
        if (!this.list.length) {
            return;
        }
        if (what === QuickInputListFocus.Next && this.list.getFocus()[0] === this.list.length - 1) {
            what = QuickInputListFocus.First;
        }
        if (what === QuickInputListFocus.Previous && this.list.getFocus()[0] === 0) {
            what = QuickInputListFocus.Last;
        }
        if (what === QuickInputListFocus.Second && this.list.length < 2) {
            what = QuickInputListFocus.First;
        }
        switch (what) {
            case QuickInputListFocus.First:
                this.list.focusFirst();
                break;
            case QuickInputListFocus.Second:
                this.list.focusNth(1);
                break;
            case QuickInputListFocus.Last:
                this.list.focusLast();
                break;
            case QuickInputListFocus.Next:
                this.list.focusNext();
                break;
            case QuickInputListFocus.Previous:
                this.list.focusPrevious();
                break;
            case QuickInputListFocus.NextPage:
                this.list.focusNextPage();
                break;
            case QuickInputListFocus.PreviousPage:
                this.list.focusPreviousPage();
                break;
        }
        var focused = this.list.getFocus()[0];
        if (typeof focused === 'number') {
            this.list.reveal(focused);
        }
    };
    QuickInputList.prototype.clearFocus = function () {
        this.list.setFocus([]);
    };
    QuickInputList.prototype.domFocus = function () {
        this.list.domFocus();
    };
    QuickInputList.prototype.layout = function (maxHeight) {
        this.list.getHTMLElement().style.maxHeight = maxHeight ? "calc(" + Math.floor(maxHeight / 44) * 44 + "px)" : '';
        this.list.layout();
    };
    QuickInputList.prototype.filter = function (query) {
        var _this = this;
        if (!(this.sortByLabel || this.matchOnLabel || this.matchOnDescription || this.matchOnDetail)) {
            this.list.layout();
            return false;
        }
        query = query.trim();
        // Reset filtering
        if (!query || !(this.matchOnLabel || this.matchOnDescription || this.matchOnDetail)) {
            this.elements.forEach(function (element) {
                element.labelHighlights = undefined;
                element.descriptionHighlights = undefined;
                element.detailHighlights = undefined;
                element.hidden = false;
                var previous = element.index && _this.inputElements[element.index - 1];
                element.separator = previous && previous.type === 'separator' ? previous : undefined;
            });
        }
        // Filter by value (since we support icons in labels, use $(..) aware fuzzy matching)
        else {
            this.elements.forEach(function (element) {
                var labelHighlights = _this.matchOnLabel ? withNullAsUndefined(matchesFuzzyIconAware(query, parseLabelWithIcons(element.saneLabel))) : undefined;
                var descriptionHighlights = _this.matchOnDescription ? withNullAsUndefined(matchesFuzzyIconAware(query, parseLabelWithIcons(element.saneDescription || ''))) : undefined;
                var detailHighlights = _this.matchOnDetail ? withNullAsUndefined(matchesFuzzyIconAware(query, parseLabelWithIcons(element.saneDetail || ''))) : undefined;
                var metaHighlights = _this.matchOnMeta ? withNullAsUndefined(matchesFuzzyIconAware(query, parseLabelWithIcons(element.saneMeta || ''))) : undefined;
                if (labelHighlights || descriptionHighlights || detailHighlights || metaHighlights) {
                    element.labelHighlights = labelHighlights;
                    element.descriptionHighlights = descriptionHighlights;
                    element.detailHighlights = detailHighlights;
                    element.hidden = false;
                }
                else {
                    element.labelHighlights = undefined;
                    element.descriptionHighlights = undefined;
                    element.detailHighlights = undefined;
                    element.hidden = !element.item.alwaysShow;
                }
                element.separator = undefined;
            });
        }
        var shownElements = this.elements.filter(function (element) { return !element.hidden; });
        // Sort by value
        if (this.sortByLabel && query) {
            var normalizedSearchValue_1 = query.toLowerCase();
            shownElements.sort(function (a, b) {
                return compareEntries(a, b, normalizedSearchValue_1);
            });
        }
        this.elementsToIndexes = shownElements.reduce(function (map, element, index) {
            map.set(element.item, index);
            return map;
        }, new Map());
        this.list.splice(0, this.list.length, shownElements);
        this.list.setFocus([]);
        this.list.layout();
        this._onChangedAllVisibleChecked.fire(this.getAllVisibleChecked());
        this._onChangedVisibleCount.fire(shownElements.length);
        return true;
    };
    QuickInputList.prototype.toggleCheckbox = function () {
        var e_3, _a;
        try {
            this._fireCheckedEvents = false;
            var elements = this.list.getFocusedElements();
            var allChecked = this.allVisibleChecked(elements);
            try {
                for (var elements_1 = __values(elements), elements_1_1 = elements_1.next(); !elements_1_1.done; elements_1_1 = elements_1.next()) {
                    var element = elements_1_1.value;
                    element.checked = !allChecked;
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (elements_1_1 && !elements_1_1.done && (_a = elements_1.return)) _a.call(elements_1);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
        finally {
            this._fireCheckedEvents = true;
            this.fireCheckedEvents();
        }
    };
    QuickInputList.prototype.display = function (display) {
        this.container.style.display = display ? '' : 'none';
    };
    QuickInputList.prototype.isDisplayed = function () {
        return this.container.style.display !== 'none';
    };
    QuickInputList.prototype.dispose = function () {
        this.elementDisposables = dispose(this.elementDisposables);
        this.disposables = dispose(this.disposables);
    };
    QuickInputList.prototype.fireCheckedEvents = function () {
        if (this._fireCheckedEvents) {
            this._onChangedAllVisibleChecked.fire(this.getAllVisibleChecked());
            this._onChangedCheckedCount.fire(this.getCheckedCount());
            this._onChangedCheckedElements.fire(this.getCheckedElements());
        }
    };
    QuickInputList.prototype.fireButtonTriggered = function (event) {
        this._onButtonTriggered.fire(event);
    };
    QuickInputList.prototype.style = function (styles) {
        this.list.style(styles);
    };
    __decorate([
        memoize
    ], QuickInputList.prototype, "onDidChangeFocus", null);
    __decorate([
        memoize
    ], QuickInputList.prototype, "onDidChangeSelection", null);
    return QuickInputList;
}());
export { QuickInputList };
function compareEntries(elementA, elementB, lookFor) {
    var labelHighlightsA = elementA.labelHighlights || [];
    var labelHighlightsB = elementB.labelHighlights || [];
    if (labelHighlightsA.length && !labelHighlightsB.length) {
        return -1;
    }
    if (!labelHighlightsA.length && labelHighlightsB.length) {
        return 1;
    }
    if (labelHighlightsA.length === 0 && labelHighlightsB.length === 0) {
        return 0;
    }
    return compareAnything(elementA.saneLabel, elementB.saneLabel, lookFor);
}
var QuickInputAccessibilityProvider = /** @class */ (function () {
    function QuickInputAccessibilityProvider() {
    }
    QuickInputAccessibilityProvider.prototype.getWidgetAriaLabel = function () {
        return localize('quickInput', "Quick Input");
    };
    QuickInputAccessibilityProvider.prototype.getAriaLabel = function (element) {
        return element.saneAriaLabel;
    };
    QuickInputAccessibilityProvider.prototype.getWidgetRole = function () {
        return 'listbox';
    };
    QuickInputAccessibilityProvider.prototype.getRole = function () {
        return 'option';
    };
    return QuickInputAccessibilityProvider;
}());
