/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var hasOwnProperty = Object.prototype.hasOwnProperty;
/**
 * Returns an array which contains all values that reside
 * in the given dictionary.
 */
export function values(from) {
    var result = [];
    for (var key in from) {
        if (hasOwnProperty.call(from, key)) {
            result.push(from[key]);
        }
    }
    return result;
}
/**
 * Iterates over each entry in the provided dictionary. The iterator allows
 * to remove elements and will stop when the callback returns {{false}}.
 */
export function forEach(from, callback) {
    var _loop_1 = function (key) {
        if (hasOwnProperty.call(from, key)) {
            var result = callback({ key: key, value: from[key] }, function () {
                delete from[key];
            });
            if (result === false) {
                return { value: void 0 };
            }
        }
    };
    for (var key in from) {
        var state_1 = _loop_1(key);
        if (typeof state_1 === "object")
            return state_1.value;
    }
}
/**
 * Groups the collection into a dictionary based on the provided
 * group function.
 */
export function groupBy(data, groupFn) {
    var e_1, _a;
    var result = Object.create(null);
    try {
        for (var data_1 = __values(data), data_1_1 = data_1.next(); !data_1_1.done; data_1_1 = data_1.next()) {
            var element = data_1_1.value;
            var key = groupFn(element);
            var target = result[key];
            if (!target) {
                target = result[key] = [];
            }
            target.push(element);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (data_1_1 && !data_1_1.done && (_a = data_1.return)) _a.call(data_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}
export function fromMap(original) {
    var result = Object.create(null);
    if (original) {
        original.forEach(function (value, key) {
            result[key] = value;
        });
    }
    return result;
}
export function diffSets(before, after) {
    var e_2, _a, e_3, _b;
    var removed = [];
    var added = [];
    try {
        for (var before_1 = __values(before), before_1_1 = before_1.next(); !before_1_1.done; before_1_1 = before_1.next()) {
            var element = before_1_1.value;
            if (!after.has(element)) {
                removed.push(element);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (before_1_1 && !before_1_1.done && (_a = before_1.return)) _a.call(before_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    try {
        for (var after_1 = __values(after), after_1_1 = after_1.next(); !after_1_1.done; after_1_1 = after_1.next()) {
            var element = after_1_1.value;
            if (!before.has(element)) {
                added.push(element);
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (after_1_1 && !after_1_1.done && (_b = after_1.return)) _b.call(after_1);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return { removed: removed, added: added };
}
export function diffMaps(before, after) {
    var e_4, _a, e_5, _b;
    var removed = [];
    var added = [];
    try {
        for (var before_2 = __values(before), before_2_1 = before_2.next(); !before_2_1.done; before_2_1 = before_2.next()) {
            var _c = __read(before_2_1.value, 2), index = _c[0], value = _c[1];
            if (!after.has(index)) {
                removed.push(value);
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (before_2_1 && !before_2_1.done && (_a = before_2.return)) _a.call(before_2);
        }
        finally { if (e_4) throw e_4.error; }
    }
    try {
        for (var after_2 = __values(after), after_2_1 = after_2.next(); !after_2_1.done; after_2_1 = after_2.next()) {
            var _d = __read(after_2_1.value, 2), index = _d[0], value = _d[1];
            if (!before.has(index)) {
                added.push(value);
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (after_2_1 && !after_2_1.done && (_b = after_2.return)) _b.call(after_2);
        }
        finally { if (e_5) throw e_5.error; }
    }
    return { removed: removed, added: added };
}
var SetMap = /** @class */ (function () {
    function SetMap() {
        this.map = new Map();
    }
    SetMap.prototype.add = function (key, value) {
        var values = this.map.get(key);
        if (!values) {
            values = new Set();
            this.map.set(key, values);
        }
        values.add(value);
    };
    SetMap.prototype.delete = function (key, value) {
        var values = this.map.get(key);
        if (!values) {
            return;
        }
        values.delete(value);
        if (values.size === 0) {
            this.map.delete(key);
        }
    };
    SetMap.prototype.forEach = function (key, fn) {
        var values = this.map.get(key);
        if (!values) {
            return;
        }
        values.forEach(fn);
    };
    return SetMap;
}());
export { SetMap };
