/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { CancellationTokenSource } from './cancellation';
import { canceled, onUnexpectedError } from './errors';
import { Emitter } from './event';
import { toDisposable } from './lifecycle';
import { LinkedList } from './linkedList';
export function isThenable(obj) {
    return !!obj && typeof obj.then === 'function';
}
export function createCancelablePromise(callback) {
    var source = new CancellationTokenSource();
    var thenable = callback(source.token);
    var promise = new Promise(function (resolve, reject) {
        source.token.onCancellationRequested(function () {
            reject(canceled());
        });
        Promise.resolve(thenable).then(function (value) {
            source.dispose();
            resolve(value);
        }, function (err) {
            source.dispose();
            reject(err);
        });
    });
    return new /** @class */ (function () {
        function class_1() {
        }
        class_1.prototype.cancel = function () {
            source.cancel();
        };
        class_1.prototype.then = function (resolve, reject) {
            return promise.then(resolve, reject);
        };
        class_1.prototype.catch = function (reject) {
            return this.then(undefined, reject);
        };
        class_1.prototype.finally = function (onfinally) {
            return promise.finally(onfinally);
        };
        return class_1;
    }());
}
export function raceCancellation(promise, token, defaultValue) {
    return Promise.race([promise, new Promise(function (resolve) { return token.onCancellationRequested(function () { return resolve(defaultValue); }); })]);
}
/**
 * Returns as soon as one of the promises is resolved and cancels remaining promises
 */
export function raceCancellablePromises(cancellablePromises) {
    return __awaiter(this, void 0, void 0, function () {
        var resolvedPromiseIndex, promises, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    resolvedPromiseIndex = -1;
                    promises = cancellablePromises.map(function (promise, index) { return promise.then(function (result) { resolvedPromiseIndex = index; return result; }); });
                    return [4 /*yield*/, Promise.race(promises)];
                case 1:
                    result = _a.sent();
                    cancellablePromises.forEach(function (cancellablePromise, index) {
                        if (index !== resolvedPromiseIndex) {
                            cancellablePromise.cancel();
                        }
                    });
                    return [2 /*return*/, result];
            }
        });
    });
}
export function raceTimeout(promise, timeout, onTimeout) {
    var promiseResolve = undefined;
    var timer = setTimeout(function () {
        promiseResolve === null || promiseResolve === void 0 ? void 0 : promiseResolve(undefined);
        onTimeout === null || onTimeout === void 0 ? void 0 : onTimeout();
    }, timeout);
    return Promise.race([
        promise.finally(function () { return clearTimeout(timer); }),
        new Promise(function (resolve) { return promiseResolve = resolve; })
    ]);
}
export function asPromise(callback) {
    return new Promise(function (resolve, reject) {
        var item = callback();
        if (isThenable(item)) {
            item.then(resolve, reject);
        }
        else {
            resolve(item);
        }
    });
}
/**
 * A helper to prevent accumulation of sequential async tasks.
 *
 * Imagine a mail man with the sole task of delivering letters. As soon as
 * a letter submitted for delivery, he drives to the destination, delivers it
 * and returns to his base. Imagine that during the trip, N more letters were submitted.
 * When the mail man returns, he picks those N letters and delivers them all in a
 * single trip. Even though N+1 submissions occurred, only 2 deliveries were made.
 *
 * The throttler implements this via the queue() method, by providing it a task
 * factory. Following the example:
 *
 * 		const throttler = new Throttler();
 * 		const letters = [];
 *
 * 		function deliver() {
 * 			const lettersToDeliver = letters;
 * 			letters = [];
 * 			return makeTheTrip(lettersToDeliver);
 * 		}
 *
 * 		function onLetterReceived(l) {
 * 			letters.push(l);
 * 			throttler.queue(deliver);
 * 		}
 */
var Throttler = /** @class */ (function () {
    function Throttler() {
        this.activePromise = null;
        this.queuedPromise = null;
        this.queuedPromiseFactory = null;
    }
    Throttler.prototype.queue = function (promiseFactory) {
        var _this = this;
        if (this.activePromise) {
            this.queuedPromiseFactory = promiseFactory;
            if (!this.queuedPromise) {
                var onComplete_1 = function () {
                    _this.queuedPromise = null;
                    var result = _this.queue(_this.queuedPromiseFactory);
                    _this.queuedPromiseFactory = null;
                    return result;
                };
                this.queuedPromise = new Promise(function (resolve) {
                    _this.activePromise.then(onComplete_1, onComplete_1).then(resolve);
                });
            }
            return new Promise(function (resolve, reject) {
                _this.queuedPromise.then(resolve, reject);
            });
        }
        this.activePromise = promiseFactory();
        return new Promise(function (resolve, reject) {
            _this.activePromise.then(function (result) {
                _this.activePromise = null;
                resolve(result);
            }, function (err) {
                _this.activePromise = null;
                reject(err);
            });
        });
    };
    return Throttler;
}());
export { Throttler };
var Sequencer = /** @class */ (function () {
    function Sequencer() {
        this.current = Promise.resolve(null);
    }
    Sequencer.prototype.queue = function (promiseTask) {
        return this.current = this.current.then(function () { return promiseTask(); }, function () { return promiseTask(); });
    };
    return Sequencer;
}());
export { Sequencer };
var SequencerByKey = /** @class */ (function () {
    function SequencerByKey() {
        this.promiseMap = new Map();
    }
    SequencerByKey.prototype.queue = function (key, promiseTask) {
        var _this = this;
        var _a;
        var runningPromise = (_a = this.promiseMap.get(key)) !== null && _a !== void 0 ? _a : Promise.resolve();
        var newPromise = runningPromise
            .catch(function () { })
            .then(promiseTask)
            .finally(function () {
            if (_this.promiseMap.get(key) === newPromise) {
                _this.promiseMap.delete(key);
            }
        });
        this.promiseMap.set(key, newPromise);
        return newPromise;
    };
    return SequencerByKey;
}());
export { SequencerByKey };
/**
 * A helper to delay (debounce) execution of a task that is being requested often.
 *
 * Following the throttler, now imagine the mail man wants to optimize the number of
 * trips proactively. The trip itself can be long, so he decides not to make the trip
 * as soon as a letter is submitted. Instead he waits a while, in case more
 * letters are submitted. After said waiting period, if no letters were submitted, he
 * decides to make the trip. Imagine that N more letters were submitted after the first
 * one, all within a short period of time between each other. Even though N+1
 * submissions occurred, only 1 delivery was made.
 *
 * The delayer offers this behavior via the trigger() method, into which both the task
 * to be executed and the waiting period (delay) must be passed in as arguments. Following
 * the example:
 *
 * 		const delayer = new Delayer(WAITING_PERIOD);
 * 		const letters = [];
 *
 * 		function letterReceived(l) {
 * 			letters.push(l);
 * 			delayer.trigger(() => { return makeTheTrip(); });
 * 		}
 */
var Delayer = /** @class */ (function () {
    function Delayer(defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.timeout = null;
        this.completionPromise = null;
        this.doResolve = null;
        this.doReject = null;
        this.task = null;
    }
    Delayer.prototype.trigger = function (task, delay) {
        var _this = this;
        if (delay === void 0) { delay = this.defaultDelay; }
        this.task = task;
        this.cancelTimeout();
        if (!this.completionPromise) {
            this.completionPromise = new Promise(function (resolve, reject) {
                _this.doResolve = resolve;
                _this.doReject = reject;
            }).then(function () {
                _this.completionPromise = null;
                _this.doResolve = null;
                if (_this.task) {
                    var task_1 = _this.task;
                    _this.task = null;
                    return task_1();
                }
                return undefined;
            });
        }
        this.timeout = setTimeout(function () {
            _this.timeout = null;
            if (_this.doResolve) {
                _this.doResolve(null);
            }
        }, delay);
        return this.completionPromise;
    };
    Delayer.prototype.isTriggered = function () {
        return this.timeout !== null;
    };
    Delayer.prototype.cancel = function () {
        this.cancelTimeout();
        if (this.completionPromise) {
            if (this.doReject) {
                this.doReject(canceled());
            }
            this.completionPromise = null;
        }
    };
    Delayer.prototype.cancelTimeout = function () {
        if (this.timeout !== null) {
            clearTimeout(this.timeout);
            this.timeout = null;
        }
    };
    Delayer.prototype.dispose = function () {
        this.cancelTimeout();
    };
    return Delayer;
}());
export { Delayer };
/**
 * A helper to delay execution of a task that is being requested often, while
 * preventing accumulation of consecutive executions, while the task runs.
 *
 * The mail man is clever and waits for a certain amount of time, before going
 * out to deliver letters. While the mail man is going out, more letters arrive
 * and can only be delivered once he is back. Once he is back the mail man will
 * do one more trip to deliver the letters that have accumulated while he was out.
 */
var ThrottledDelayer = /** @class */ (function () {
    function ThrottledDelayer(defaultDelay) {
        this.delayer = new Delayer(defaultDelay);
        this.throttler = new Throttler();
    }
    ThrottledDelayer.prototype.trigger = function (promiseFactory, delay) {
        var _this = this;
        return this.delayer.trigger(function () { return _this.throttler.queue(promiseFactory); }, delay);
    };
    ThrottledDelayer.prototype.isTriggered = function () {
        return this.delayer.isTriggered();
    };
    ThrottledDelayer.prototype.cancel = function () {
        this.delayer.cancel();
    };
    ThrottledDelayer.prototype.dispose = function () {
        this.delayer.dispose();
    };
    return ThrottledDelayer;
}());
export { ThrottledDelayer };
/**
 * A barrier that is initially closed and then becomes opened permanently.
 */
var Barrier = /** @class */ (function () {
    function Barrier() {
        var _this = this;
        this._isOpen = false;
        this._promise = new Promise(function (c, e) {
            _this._completePromise = c;
        });
    }
    Barrier.prototype.isOpen = function () {
        return this._isOpen;
    };
    Barrier.prototype.open = function () {
        this._isOpen = true;
        this._completePromise(true);
    };
    Barrier.prototype.wait = function () {
        return this._promise;
    };
    return Barrier;
}());
export { Barrier };
/**
 * A barrier that is initially closed and then becomes opened permanently after a certain period of
 * time or when open is called explicitly
 */
var AutoOpenBarrier = /** @class */ (function (_super) {
    __extends(AutoOpenBarrier, _super);
    function AutoOpenBarrier(autoOpenTimeMs) {
        var _this = _super.call(this) || this;
        _this._timeout = setTimeout(function () { return _this.open(); }, autoOpenTimeMs);
        return _this;
    }
    AutoOpenBarrier.prototype.open = function () {
        clearTimeout(this._timeout);
        _super.prototype.open.call(this);
    };
    return AutoOpenBarrier;
}(Barrier));
export { AutoOpenBarrier };
export function timeout(millis, token) {
    if (!token) {
        return createCancelablePromise(function (token) { return timeout(millis, token); });
    }
    return new Promise(function (resolve, reject) {
        var handle = setTimeout(resolve, millis);
        token.onCancellationRequested(function () {
            clearTimeout(handle);
            reject(canceled());
        });
    });
}
export function disposableTimeout(handler, timeout) {
    if (timeout === void 0) { timeout = 0; }
    var timer = setTimeout(handler, timeout);
    return toDisposable(function () { return clearTimeout(timer); });
}
export function ignoreErrors(promise) {
    return promise.then(undefined, function (_) { return undefined; });
}
/**
 * Runs the provided list of promise factories in sequential order. The returned
 * promise will complete to an array of results from each promise.
 */
export function sequence(promiseFactories) {
    var results = [];
    var index = 0;
    var len = promiseFactories.length;
    function next() {
        return index < len ? promiseFactories[index++]() : null;
    }
    function thenHandler(result) {
        if (result !== undefined && result !== null) {
            results.push(result);
        }
        var n = next();
        if (n) {
            return n.then(thenHandler);
        }
        return Promise.resolve(results);
    }
    return Promise.resolve(null).then(thenHandler);
}
export function first(promiseFactories, shouldStop, defaultValue) {
    if (shouldStop === void 0) { shouldStop = function (t) { return !!t; }; }
    if (defaultValue === void 0) { defaultValue = null; }
    var index = 0;
    var len = promiseFactories.length;
    var loop = function () {
        if (index >= len) {
            return Promise.resolve(defaultValue);
        }
        var factory = promiseFactories[index++];
        var promise = Promise.resolve(factory());
        return promise.then(function (result) {
            if (shouldStop(result)) {
                return Promise.resolve(result);
            }
            return loop();
        });
    };
    return loop();
}
export function firstParallel(promiseList, shouldStop, defaultValue) {
    if (shouldStop === void 0) { shouldStop = function (t) { return !!t; }; }
    if (defaultValue === void 0) { defaultValue = null; }
    if (promiseList.length === 0) {
        return Promise.resolve(defaultValue);
    }
    var todo = promiseList.length;
    var finish = function () {
        var e_1, _a;
        var _b, _c;
        todo = -1;
        try {
            for (var promiseList_1 = __values(promiseList), promiseList_1_1 = promiseList_1.next(); !promiseList_1_1.done; promiseList_1_1 = promiseList_1.next()) {
                var promise = promiseList_1_1.value;
                (_c = (_b = promise).cancel) === null || _c === void 0 ? void 0 : _c.call(_b);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (promiseList_1_1 && !promiseList_1_1.done && (_a = promiseList_1.return)) _a.call(promiseList_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    return new Promise(function (resolve, reject) {
        var e_2, _a;
        try {
            for (var promiseList_2 = __values(promiseList), promiseList_2_1 = promiseList_2.next(); !promiseList_2_1.done; promiseList_2_1 = promiseList_2.next()) {
                var promise = promiseList_2_1.value;
                promise.then(function (result) {
                    if (--todo >= 0 && shouldStop(result)) {
                        finish();
                        resolve(result);
                    }
                    else if (todo === 0) {
                        resolve(defaultValue);
                    }
                })
                    .catch(function (err) {
                    if (--todo >= 0) {
                        finish();
                        reject(err);
                    }
                });
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (promiseList_2_1 && !promiseList_2_1.done && (_a = promiseList_2.return)) _a.call(promiseList_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
    });
}
/**
 * A helper to queue N promises and run them all with a max degree of parallelism. The helper
 * ensures that at any time no more than M promises are running at the same time.
 */
var Limiter = /** @class */ (function () {
    function Limiter(maxDegreeOfParalellism) {
        this._size = 0;
        this.maxDegreeOfParalellism = maxDegreeOfParalellism;
        this.outstandingPromises = [];
        this.runningPromises = 0;
        this._onFinished = new Emitter();
    }
    Object.defineProperty(Limiter.prototype, "onFinished", {
        get: function () {
            return this._onFinished.event;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Limiter.prototype, "size", {
        get: function () {
            return this._size;
            // return this.runningPromises + this.outstandingPromises.length;
        },
        enumerable: false,
        configurable: true
    });
    Limiter.prototype.queue = function (factory) {
        var _this = this;
        this._size++;
        return new Promise(function (c, e) {
            _this.outstandingPromises.push({ factory: factory, c: c, e: e });
            _this.consume();
        });
    };
    Limiter.prototype.consume = function () {
        var _this = this;
        while (this.outstandingPromises.length && this.runningPromises < this.maxDegreeOfParalellism) {
            var iLimitedTask = this.outstandingPromises.shift();
            this.runningPromises++;
            var promise = iLimitedTask.factory();
            promise.then(iLimitedTask.c, iLimitedTask.e);
            promise.then(function () { return _this.consumed(); }, function () { return _this.consumed(); });
        }
    };
    Limiter.prototype.consumed = function () {
        this._size--;
        this.runningPromises--;
        if (this.outstandingPromises.length > 0) {
            this.consume();
        }
        else {
            this._onFinished.fire();
        }
    };
    Limiter.prototype.dispose = function () {
        this._onFinished.dispose();
    };
    return Limiter;
}());
export { Limiter };
/**
 * A queue is handles one promise at a time and guarantees that at any time only one promise is executing.
 */
var Queue = /** @class */ (function (_super) {
    __extends(Queue, _super);
    function Queue() {
        return _super.call(this, 1) || this;
    }
    return Queue;
}(Limiter));
export { Queue };
/**
 * A helper to organize queues per resource. The ResourceQueue makes sure to manage queues per resource
 * by disposing them once the queue is empty.
 */
var ResourceQueue = /** @class */ (function () {
    function ResourceQueue() {
        this.queues = new Map();
    }
    ResourceQueue.prototype.queueFor = function (resource) {
        var _this = this;
        var key = resource.toString();
        if (!this.queues.has(key)) {
            var queue_1 = new Queue();
            queue_1.onFinished(function () {
                queue_1.dispose();
                _this.queues.delete(key);
            });
            this.queues.set(key, queue_1);
        }
        return this.queues.get(key);
    };
    ResourceQueue.prototype.dispose = function () {
        this.queues.forEach(function (queue) { return queue.dispose(); });
        this.queues.clear();
    };
    return ResourceQueue;
}());
export { ResourceQueue };
var TimeoutTimer = /** @class */ (function () {
    function TimeoutTimer(runner, timeout) {
        this._token = -1;
        if (typeof runner === 'function' && typeof timeout === 'number') {
            this.setIfNotSet(runner, timeout);
        }
    }
    TimeoutTimer.prototype.dispose = function () {
        this.cancel();
    };
    TimeoutTimer.prototype.cancel = function () {
        if (this._token !== -1) {
            clearTimeout(this._token);
            this._token = -1;
        }
    };
    TimeoutTimer.prototype.cancelAndSet = function (runner, timeout) {
        var _this = this;
        this.cancel();
        this._token = setTimeout(function () {
            _this._token = -1;
            runner();
        }, timeout);
    };
    TimeoutTimer.prototype.setIfNotSet = function (runner, timeout) {
        var _this = this;
        if (this._token !== -1) {
            // timer is already set
            return;
        }
        this._token = setTimeout(function () {
            _this._token = -1;
            runner();
        }, timeout);
    };
    return TimeoutTimer;
}());
export { TimeoutTimer };
var IntervalTimer = /** @class */ (function () {
    function IntervalTimer() {
        this._token = -1;
    }
    IntervalTimer.prototype.dispose = function () {
        this.cancel();
    };
    IntervalTimer.prototype.cancel = function () {
        if (this._token !== -1) {
            clearInterval(this._token);
            this._token = -1;
        }
    };
    IntervalTimer.prototype.cancelAndSet = function (runner, interval) {
        this.cancel();
        this._token = setInterval(function () {
            runner();
        }, interval);
    };
    return IntervalTimer;
}());
export { IntervalTimer };
var RunOnceScheduler = /** @class */ (function () {
    function RunOnceScheduler(runner, delay) {
        this.timeoutToken = -1;
        this.runner = runner;
        this.timeout = delay;
        this.timeoutHandler = this.onTimeout.bind(this);
    }
    /**
     * Dispose RunOnceScheduler
     */
    RunOnceScheduler.prototype.dispose = function () {
        this.cancel();
        this.runner = null;
    };
    /**
     * Cancel current scheduled runner (if any).
     */
    RunOnceScheduler.prototype.cancel = function () {
        if (this.isScheduled()) {
            clearTimeout(this.timeoutToken);
            this.timeoutToken = -1;
        }
    };
    /**
     * Cancel previous runner (if any) & schedule a new runner.
     */
    RunOnceScheduler.prototype.schedule = function (delay) {
        if (delay === void 0) { delay = this.timeout; }
        this.cancel();
        this.timeoutToken = setTimeout(this.timeoutHandler, delay);
    };
    Object.defineProperty(RunOnceScheduler.prototype, "delay", {
        get: function () {
            return this.timeout;
        },
        set: function (value) {
            this.timeout = value;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns true if scheduled.
     */
    RunOnceScheduler.prototype.isScheduled = function () {
        return this.timeoutToken !== -1;
    };
    RunOnceScheduler.prototype.onTimeout = function () {
        this.timeoutToken = -1;
        if (this.runner) {
            this.doRun();
        }
    };
    RunOnceScheduler.prototype.doRun = function () {
        if (this.runner) {
            this.runner();
        }
    };
    return RunOnceScheduler;
}());
export { RunOnceScheduler };
var RunOnceWorker = /** @class */ (function (_super) {
    __extends(RunOnceWorker, _super);
    function RunOnceWorker(runner, timeout) {
        var _this = _super.call(this, runner, timeout) || this;
        _this.units = [];
        return _this;
    }
    RunOnceWorker.prototype.work = function (unit) {
        this.units.push(unit);
        if (!this.isScheduled()) {
            this.schedule();
        }
    };
    RunOnceWorker.prototype.doRun = function () {
        var units = this.units;
        this.units = [];
        if (this.runner) {
            this.runner(units);
        }
    };
    RunOnceWorker.prototype.dispose = function () {
        this.units = [];
        _super.prototype.dispose.call(this);
    };
    return RunOnceWorker;
}(RunOnceScheduler));
export { RunOnceWorker };
/**
 * Execute the callback the next time the browser is idle
 */
export var runWhenIdle;
(function () {
    if (typeof requestIdleCallback !== 'function' || typeof cancelIdleCallback !== 'function') {
        var dummyIdle_1 = Object.freeze({
            didTimeout: true,
            timeRemaining: function () { return 15; }
        });
        runWhenIdle = function (runner) {
            var handle = setTimeout(function () { return runner(dummyIdle_1); });
            var disposed = false;
            return {
                dispose: function () {
                    if (disposed) {
                        return;
                    }
                    disposed = true;
                    clearTimeout(handle);
                }
            };
        };
    }
    else {
        runWhenIdle = function (runner, timeout) {
            var handle = requestIdleCallback(runner, typeof timeout === 'number' ? { timeout: timeout } : undefined);
            var disposed = false;
            return {
                dispose: function () {
                    if (disposed) {
                        return;
                    }
                    disposed = true;
                    cancelIdleCallback(handle);
                }
            };
        };
    }
})();
/**
 * An implementation of the "idle-until-urgent"-strategy as introduced
 * here: https://philipwalton.com/articles/idle-until-urgent/
 */
var IdleValue = /** @class */ (function () {
    function IdleValue(executor) {
        var _this = this;
        this._didRun = false;
        this._executor = function () {
            try {
                _this._value = executor();
            }
            catch (err) {
                _this._error = err;
            }
            finally {
                _this._didRun = true;
            }
        };
        this._handle = runWhenIdle(function () { return _this._executor(); });
    }
    IdleValue.prototype.dispose = function () {
        this._handle.dispose();
    };
    Object.defineProperty(IdleValue.prototype, "value", {
        get: function () {
            if (!this._didRun) {
                this._handle.dispose();
                this._executor();
            }
            if (this._error) {
                throw this._error;
            }
            return this._value;
        },
        enumerable: false,
        configurable: true
    });
    return IdleValue;
}());
export { IdleValue };
//#endregion
export function retry(task, delay, retries) {
    return __awaiter(this, void 0, void 0, function () {
        var lastError, i, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < retries)) return [3 /*break*/, 7];
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 4, , 6]);
                    return [4 /*yield*/, task()];
                case 3: return [2 /*return*/, _a.sent()];
                case 4:
                    error_1 = _a.sent();
                    lastError = error_1;
                    return [4 /*yield*/, timeout(delay)];
                case 5:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 6:
                    i++;
                    return [3 /*break*/, 1];
                case 7: throw lastError;
            }
        });
    });
}
var TaskSequentializer = /** @class */ (function () {
    function TaskSequentializer() {
    }
    TaskSequentializer.prototype.hasPending = function (taskId) {
        if (!this._pending) {
            return false;
        }
        if (typeof taskId === 'number') {
            return this._pending.taskId === taskId;
        }
        return !!this._pending;
    };
    Object.defineProperty(TaskSequentializer.prototype, "pending", {
        get: function () {
            return this._pending ? this._pending.promise : undefined;
        },
        enumerable: false,
        configurable: true
    });
    TaskSequentializer.prototype.cancelPending = function () {
        var _a;
        (_a = this._pending) === null || _a === void 0 ? void 0 : _a.cancel();
    };
    TaskSequentializer.prototype.setPending = function (taskId, promise, onCancel) {
        var _this = this;
        this._pending = { taskId: taskId, cancel: function () { return onCancel === null || onCancel === void 0 ? void 0 : onCancel(); }, promise: promise };
        promise.then(function () { return _this.donePending(taskId); }, function () { return _this.donePending(taskId); });
        return promise;
    };
    TaskSequentializer.prototype.donePending = function (taskId) {
        if (this._pending && taskId === this._pending.taskId) {
            // only set pending to done if the promise finished that is associated with that taskId
            this._pending = undefined;
            // schedule the next task now that we are free if we have any
            this.triggerNext();
        }
    };
    TaskSequentializer.prototype.triggerNext = function () {
        if (this._next) {
            var next = this._next;
            this._next = undefined;
            // Run next task and complete on the associated promise
            next.run().then(next.promiseResolve, next.promiseReject);
        }
    };
    TaskSequentializer.prototype.setNext = function (run) {
        // this is our first next task, so we create associated promise with it
        // so that we can return a promise that completes when the task has
        // completed.
        if (!this._next) {
            var promiseResolve_1;
            var promiseReject_1;
            var promise = new Promise(function (resolve, reject) {
                promiseResolve_1 = resolve;
                promiseReject_1 = reject;
            });
            this._next = {
                run: run,
                promise: promise,
                promiseResolve: promiseResolve_1,
                promiseReject: promiseReject_1
            };
        }
        // we have a previous next task, just overwrite it
        else {
            this._next.run = run;
        }
        return this._next.promise;
    };
    return TaskSequentializer;
}());
export { TaskSequentializer };
//#endregion
//#region
/**
 * The `IntervalCounter` allows to count the number
 * of calls to `increment()` over a duration of
 * `interval`. This utility can be used to conditionally
 * throttle a frequent task when a certain threshold
 * is reached.
 */
var IntervalCounter = /** @class */ (function () {
    function IntervalCounter(interval) {
        this.interval = interval;
        this.lastIncrementTime = 0;
        this.value = 0;
    }
    IntervalCounter.prototype.increment = function () {
        var now = Date.now();
        // We are outside of the range of `interval` and as such
        // start counting from 0 and remember the time
        if (now - this.lastIncrementTime > this.interval) {
            this.lastIncrementTime = now;
            this.value = 0;
        }
        this.value++;
        return this.value;
    };
    return IntervalCounter;
}());
export { IntervalCounter };
/**
 * Creates a promise whose resolution or rejection can be controlled imperatively.
 */
var DeferredPromise = /** @class */ (function () {
    function DeferredPromise() {
        var _this = this;
        this.rejected = false;
        this.resolved = false;
        this.p = new Promise(function (c, e) {
            _this.completeCallback = c;
            _this.errorCallback = e;
        });
    }
    Object.defineProperty(DeferredPromise.prototype, "isRejected", {
        get: function () {
            return this.rejected;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DeferredPromise.prototype, "isResolved", {
        get: function () {
            return this.resolved;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DeferredPromise.prototype, "isSettled", {
        get: function () {
            return this.rejected || this.resolved;
        },
        enumerable: false,
        configurable: true
    });
    DeferredPromise.prototype.complete = function (value) {
        var _this = this;
        return new Promise(function (resolve) {
            _this.completeCallback(value);
            _this.resolved = true;
            resolve();
        });
    };
    DeferredPromise.prototype.error = function (err) {
        var _this = this;
        return new Promise(function (resolve) {
            _this.errorCallback(err);
            _this.rejected = true;
            resolve();
        });
    };
    DeferredPromise.prototype.cancel = function () {
        var _this = this;
        new Promise(function (resolve) {
            _this.errorCallback(canceled());
            _this.rejected = true;
            resolve();
        });
    };
    return DeferredPromise;
}());
export { DeferredPromise };
var AsyncEmitter = /** @class */ (function (_super) {
    __extends(AsyncEmitter, _super);
    function AsyncEmitter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AsyncEmitter.prototype.fireAsync = function (data, token, promiseJoin) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, listener, _loop_1, this_1;
            var e_3, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        if (!this._listeners) {
                            return [2 /*return*/];
                        }
                        if (!this._asyncDeliveryQueue) {
                            this._asyncDeliveryQueue = new LinkedList();
                        }
                        try {
                            for (_a = __values(this._listeners), _b = _a.next(); !_b.done; _b = _a.next()) {
                                listener = _b.value;
                                this._asyncDeliveryQueue.push([listener, data]);
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                        _loop_1 = function () {
                            var _e, listener, data_1, thenables, event_1;
                            return __generator(this, function (_f) {
                                switch (_f.label) {
                                    case 0:
                                        _e = __read(this_1._asyncDeliveryQueue.shift(), 2), listener = _e[0], data_1 = _e[1];
                                        thenables = [];
                                        event_1 = __assign(__assign({}, data_1), { waitUntil: function (p) {
                                                if (Object.isFrozen(thenables)) {
                                                    throw new Error('waitUntil can NOT be called asynchronous');
                                                }
                                                if (promiseJoin) {
                                                    p = promiseJoin(p, typeof listener === 'function' ? listener : listener[0]);
                                                }
                                                thenables.push(p);
                                            } });
                                        try {
                                            if (typeof listener === 'function') {
                                                listener.call(undefined, event_1);
                                            }
                                            else {
                                                listener[0].call(listener[1], event_1);
                                            }
                                        }
                                        catch (e) {
                                            onUnexpectedError(e);
                                            return [2 /*return*/, "continue"];
                                        }
                                        // freeze thenables-collection to enforce sync-calls to
                                        // wait until and then wait for all thenables to resolve
                                        Object.freeze(thenables);
                                        return [4 /*yield*/, Promises.settled(thenables).catch(function (e) { return onUnexpectedError(e); })];
                                    case 1:
                                        _f.sent();
                                        return [2 /*return*/];
                                }
                            });
                        };
                        this_1 = this;
                        _d.label = 1;
                    case 1:
                        if (!(this._asyncDeliveryQueue.size > 0 && !token.isCancellationRequested)) return [3 /*break*/, 3];
                        return [5 /*yield**/, _loop_1()];
                    case 2:
                        _d.sent();
                        return [3 /*break*/, 1];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    return AsyncEmitter;
}(Emitter));
export { AsyncEmitter };
//#endregion
//#region Promises
export var Promises;
(function (Promises) {
    /**
     * A polyfill of `Promise.allSettled`: returns after all promises have
     * resolved or rejected and provides access to each result or error
     * in the order of the original passed in promises array.
     * See: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/allSettled
     */
    function allSettled(promises) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (typeof Promise.allSettled === 'function') {
                    return [2 /*return*/, allSettledNative(promises)]; // in some environments we can benefit from native implementation
                }
                return [2 /*return*/, allSettledShim(promises)];
            });
        });
    }
    Promises.allSettled = allSettled;
    function allSettledNative(promises) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, Promise.allSettled(promises)];
            });
        });
    }
    function allSettledShim(promises) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, Promise.all(promises.map(function (promise) { return (promise.then(function (value) {
                        var fulfilled = { status: 'fulfilled', value: value };
                        return fulfilled;
                    }, function (error) {
                        var rejected = { status: 'rejected', reason: error };
                        return rejected;
                    })); }))];
            });
        });
    }
    /**
     * A drop-in replacement for `Promise.all` with the only difference
     * that the method awaits every promise to either fulfill or reject.
     *
     * Similar to `Promise.all`, only the first error will be returned
     * if any.
     */
    function settled(promises) {
        return __awaiter(this, void 0, void 0, function () {
            var firstError, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        firstError = undefined;
                        return [4 /*yield*/, Promise.all(promises.map(function (promise) { return promise.then(function (value) { return value; }, function (error) {
                                if (!firstError) {
                                    firstError = error;
                                }
                                return undefined; // do not rethrow so that other promises can settle
                            }); }))];
                    case 1:
                        result = _a.sent();
                        if (typeof firstError !== 'undefined') {
                            throw firstError;
                        }
                        return [2 /*return*/, result]; // cast is needed and protected by the `throw` above
                }
            });
        });
    }
    Promises.settled = settled;
})(Promises || (Promises = {}));
//#endregion
