/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { getOrDefault } from '../../../common/objects';
import { dispose, Disposable, toDisposable, DisposableStore } from '../../../common/lifecycle';
import { Gesture, EventType as TouchEventType } from '../../touch';
import { Event, Emitter } from '../../../common/event';
import { domEvent } from '../../event';
import { SmoothScrollableElement } from '../scrollbar/scrollableElement';
import { Scrollable } from '../../../common/scrollable';
import { RangeMap, shift } from './rangeMap';
import { RowCache } from './rowCache';
import { memoize } from '../../../common/decorators';
import { Range } from '../../../common/range';
import { equals, distinct } from '../../../common/arrays';
import { DataTransfers, StaticDND } from '../../dnd';
import { disposableTimeout, Delayer } from '../../../common/async';
import { isFirefox } from '../../browser';
import { $, animate, getContentHeight, getContentWidth, getTopLeftOffset, scheduleAtNextAnimationFrame } from '../../dom';
var DefaultOptions = {
    useShadows: true,
    verticalScrollMode: 1 /* Auto */,
    setRowLineHeight: true,
    setRowHeight: true,
    supportDynamicHeights: false,
    dnd: {
        getDragElements: function (e) { return [e]; },
        getDragURI: function () { return null; },
        onDragStart: function () { },
        onDragOver: function () { return false; },
        drop: function () { }
    },
    horizontalScrolling: false,
    transformOptimization: true,
    alwaysConsumeMouseWheel: true,
};
var ElementsDragAndDropData = /** @class */ (function () {
    function ElementsDragAndDropData(elements) {
        this.elements = elements;
    }
    Object.defineProperty(ElementsDragAndDropData.prototype, "context", {
        get: function () {
            return this._context;
        },
        set: function (value) {
            this._context = value;
        },
        enumerable: false,
        configurable: true
    });
    ElementsDragAndDropData.prototype.update = function () { };
    ElementsDragAndDropData.prototype.getData = function () {
        return this.elements;
    };
    return ElementsDragAndDropData;
}());
export { ElementsDragAndDropData };
var ExternalElementsDragAndDropData = /** @class */ (function () {
    function ExternalElementsDragAndDropData(elements) {
        this.elements = elements;
    }
    ExternalElementsDragAndDropData.prototype.update = function () { };
    ExternalElementsDragAndDropData.prototype.getData = function () {
        return this.elements;
    };
    return ExternalElementsDragAndDropData;
}());
export { ExternalElementsDragAndDropData };
var NativeDragAndDropData = /** @class */ (function () {
    function NativeDragAndDropData() {
        this.types = [];
        this.files = [];
    }
    NativeDragAndDropData.prototype.update = function (dataTransfer) {
        var _a;
        if (dataTransfer.types) {
            (_a = this.types).splice.apply(_a, __spreadArray([0, this.types.length], __read(dataTransfer.types)));
        }
        if (dataTransfer.files) {
            this.files.splice(0, this.files.length);
            for (var i = 0; i < dataTransfer.files.length; i++) {
                var file = dataTransfer.files.item(i);
                if (file && (file.size || file.type)) {
                    this.files.push(file);
                }
            }
        }
    };
    NativeDragAndDropData.prototype.getData = function () {
        return {
            types: this.types,
            files: this.files
        };
    };
    return NativeDragAndDropData;
}());
export { NativeDragAndDropData };
function equalsDragFeedback(f1, f2) {
    if (Array.isArray(f1) && Array.isArray(f2)) {
        return equals(f1, f2);
    }
    return f1 === f2;
}
var ListViewAccessibilityProvider = /** @class */ (function () {
    function ListViewAccessibilityProvider(accessibilityProvider) {
        if (accessibilityProvider === null || accessibilityProvider === void 0 ? void 0 : accessibilityProvider.getSetSize) {
            this.getSetSize = accessibilityProvider.getSetSize.bind(accessibilityProvider);
        }
        else {
            this.getSetSize = function (e, i, l) { return l; };
        }
        if (accessibilityProvider === null || accessibilityProvider === void 0 ? void 0 : accessibilityProvider.getPosInSet) {
            this.getPosInSet = accessibilityProvider.getPosInSet.bind(accessibilityProvider);
        }
        else {
            this.getPosInSet = function (e, i) { return i + 1; };
        }
        if (accessibilityProvider === null || accessibilityProvider === void 0 ? void 0 : accessibilityProvider.getRole) {
            this.getRole = accessibilityProvider.getRole.bind(accessibilityProvider);
        }
        else {
            this.getRole = function (_) { return 'listitem'; };
        }
        if (accessibilityProvider === null || accessibilityProvider === void 0 ? void 0 : accessibilityProvider.isChecked) {
            this.isChecked = accessibilityProvider.isChecked.bind(accessibilityProvider);
        }
        else {
            this.isChecked = function (_) { return undefined; };
        }
    }
    return ListViewAccessibilityProvider;
}());
var ListView = /** @class */ (function () {
    function ListView(container, virtualDelegate, renderers, options) {
        var e_1, _a;
        var _this = this;
        if (options === void 0) { options = DefaultOptions; }
        this.virtualDelegate = virtualDelegate;
        this.domId = "list_id_" + ++ListView.InstanceCount;
        this.renderers = new Map();
        this.renderWidth = 0;
        this._scrollHeight = 0;
        this.scrollableElementUpdateDisposable = null;
        this.scrollableElementWidthDelayer = new Delayer(50);
        this.splicing = false;
        this.dragOverAnimationStopDisposable = Disposable.None;
        this.dragOverMouseY = 0;
        this.canDrop = false;
        this.currentDragFeedbackDisposable = Disposable.None;
        this.onDragLeaveTimeout = Disposable.None;
        this.disposables = new DisposableStore();
        this._onDidChangeContentHeight = new Emitter();
        this.onDidChangeContentHeight = Event.latch(this._onDidChangeContentHeight.event);
        this._horizontalScrolling = false;
        if (options.horizontalScrolling && options.supportDynamicHeights) {
            throw new Error('Horizontal scrolling and dynamic heights not supported simultaneously');
        }
        this.items = [];
        this.itemId = 0;
        this.rangeMap = new RangeMap();
        try {
            for (var renderers_1 = __values(renderers), renderers_1_1 = renderers_1.next(); !renderers_1_1.done; renderers_1_1 = renderers_1.next()) {
                var renderer = renderers_1_1.value;
                this.renderers.set(renderer.templateId, renderer);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (renderers_1_1 && !renderers_1_1.done && (_a = renderers_1.return)) _a.call(renderers_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this.cache = this.disposables.add(new RowCache(this.renderers));
        this.lastRenderTop = 0;
        this.lastRenderHeight = 0;
        this.domNode = document.createElement('div');
        this.domNode.className = 'monaco-list';
        this.domNode.classList.add(this.domId);
        this.domNode.tabIndex = 0;
        this.domNode.classList.toggle('mouse-support', typeof options.mouseSupport === 'boolean' ? options.mouseSupport : true);
        this._horizontalScrolling = getOrDefault(options, function (o) { return o.horizontalScrolling; }, DefaultOptions.horizontalScrolling);
        this.domNode.classList.toggle('horizontal-scrolling', this._horizontalScrolling);
        this.additionalScrollHeight = typeof options.additionalScrollHeight === 'undefined' ? 0 : options.additionalScrollHeight;
        this.accessibilityProvider = new ListViewAccessibilityProvider(options.accessibilityProvider);
        this.rowsContainer = document.createElement('div');
        this.rowsContainer.className = 'monaco-list-rows';
        var transformOptimization = getOrDefault(options, function (o) { return o.transformOptimization; }, DefaultOptions.transformOptimization);
        if (transformOptimization) {
            this.rowsContainer.style.transform = 'translate3d(0px, 0px, 0px)';
        }
        this.disposables.add(Gesture.addTarget(this.rowsContainer));
        this.scrollable = new Scrollable(getOrDefault(options, function (o) { return o.smoothScrolling; }, false) ? 125 : 0, function (cb) { return scheduleAtNextAnimationFrame(cb); });
        this.scrollableElement = this.disposables.add(new SmoothScrollableElement(this.rowsContainer, {
            alwaysConsumeMouseWheel: getOrDefault(options, function (o) { return o.alwaysConsumeMouseWheel; }, DefaultOptions.alwaysConsumeMouseWheel),
            horizontal: 1 /* Auto */,
            vertical: getOrDefault(options, function (o) { return o.verticalScrollMode; }, DefaultOptions.verticalScrollMode),
            useShadows: getOrDefault(options, function (o) { return o.useShadows; }, DefaultOptions.useShadows),
        }, this.scrollable));
        this.domNode.appendChild(this.scrollableElement.getDomNode());
        container.appendChild(this.domNode);
        this.scrollableElement.onScroll(this.onScroll, this, this.disposables);
        domEvent(this.rowsContainer, TouchEventType.Change)(this.onTouchChange, this, this.disposables);
        // Prevent the monaco-scrollable-element from scrolling
        // https://github.com/microsoft/vscode/issues/44181
        domEvent(this.scrollableElement.getDomNode(), 'scroll')(function (e) { return e.target.scrollTop = 0; }, null, this.disposables);
        Event.map(domEvent(this.domNode, 'dragover'), function (e) { return _this.toDragEvent(e); })(this.onDragOver, this, this.disposables);
        Event.map(domEvent(this.domNode, 'drop'), function (e) { return _this.toDragEvent(e); })(this.onDrop, this, this.disposables);
        domEvent(this.domNode, 'dragleave')(this.onDragLeave, this, this.disposables);
        domEvent(window, 'dragend')(this.onDragEnd, this, this.disposables);
        this.setRowLineHeight = getOrDefault(options, function (o) { return o.setRowLineHeight; }, DefaultOptions.setRowLineHeight);
        this.setRowHeight = getOrDefault(options, function (o) { return o.setRowHeight; }, DefaultOptions.setRowHeight);
        this.supportDynamicHeights = getOrDefault(options, function (o) { return o.supportDynamicHeights; }, DefaultOptions.supportDynamicHeights);
        this.dnd = getOrDefault(options, function (o) { return o.dnd; }, DefaultOptions.dnd);
        this.layout();
    }
    Object.defineProperty(ListView.prototype, "contentHeight", {
        get: function () { return this.rangeMap.size; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onDidScroll", {
        get: function () { return this.scrollableElement.onScroll; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onWillScroll", {
        get: function () { return this.scrollableElement.onWillScroll; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "containerDomNode", {
        get: function () { return this.rowsContainer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "horizontalScrolling", {
        get: function () { return this._horizontalScrolling; },
        set: function (value) {
            var e_2, _a;
            if (value === this._horizontalScrolling) {
                return;
            }
            if (value && this.supportDynamicHeights) {
                throw new Error('Horizontal scrolling and dynamic heights not supported simultaneously');
            }
            this._horizontalScrolling = value;
            this.domNode.classList.toggle('horizontal-scrolling', this._horizontalScrolling);
            if (this._horizontalScrolling) {
                try {
                    for (var _b = __values(this.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var item = _c.value;
                        this.measureItemWidth(item);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                this.updateScrollWidth();
                this.scrollableElement.setScrollDimensions({ width: getContentWidth(this.domNode) });
                this.rowsContainer.style.width = Math.max(this.scrollWidth || 0, this.renderWidth) + "px";
            }
            else {
                this.scrollableElementWidthDelayer.cancel();
                this.scrollableElement.setScrollDimensions({ width: this.renderWidth, scrollWidth: this.renderWidth });
                this.rowsContainer.style.width = '';
            }
        },
        enumerable: false,
        configurable: true
    });
    ListView.prototype.updateOptions = function (options) {
        if (options.additionalScrollHeight !== undefined) {
            this.additionalScrollHeight = options.additionalScrollHeight;
        }
        if (options.smoothScrolling !== undefined) {
            this.scrollable.setSmoothScrollDuration(options.smoothScrolling ? 125 : 0);
        }
        if (options.horizontalScrolling !== undefined) {
            this.horizontalScrolling = options.horizontalScrolling;
        }
    };
    ListView.prototype.triggerScrollFromMouseWheelEvent = function (browserEvent) {
        this.scrollableElement.triggerScrollFromMouseWheelEvent(browserEvent);
    };
    ListView.prototype.updateElementHeight = function (index, size, anchorIndex) {
        if (index < 0 || index >= this.items.length) {
            return;
        }
        if (this.items[index].size === size) {
            return;
        }
        var lastRenderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
        var heightDiff = 0;
        if (index < lastRenderRange.start) {
            // do not scroll the viewport if resized element is out of viewport
            heightDiff = size - this.items[index].size;
        }
        else {
            if (anchorIndex !== null && anchorIndex > index && anchorIndex <= lastRenderRange.end) {
                // anchor in viewport
                // resized elemnet in viewport and above the anchor
                heightDiff = size - this.items[index].size;
            }
            else {
                heightDiff = 0;
            }
        }
        this.rangeMap.splice(index, 1, [{ size: size }]);
        this.items[index].size = size;
        this.render(lastRenderRange, Math.max(0, this.lastRenderTop + heightDiff), this.lastRenderHeight, undefined, undefined, true);
        this.eventuallyUpdateScrollDimensions();
        if (this.supportDynamicHeights) {
            this._rerender(this.lastRenderTop, this.lastRenderHeight);
        }
    };
    ListView.prototype.splice = function (start, deleteCount, elements) {
        if (elements === void 0) { elements = []; }
        if (this.splicing) {
            throw new Error('Can\'t run recursive splices.');
        }
        this.splicing = true;
        try {
            return this._splice(start, deleteCount, elements);
        }
        finally {
            this.splicing = false;
            this._onDidChangeContentHeight.fire(this.contentHeight);
        }
    };
    ListView.prototype._splice = function (start, deleteCount, elements) {
        var _a, e_3, _b, e_4, _c, e_5, _d, e_6, _e;
        var _this = this;
        if (elements === void 0) { elements = []; }
        var previousRenderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
        var deleteRange = { start: start, end: start + deleteCount };
        var removeRange = Range.intersect(previousRenderRange, deleteRange);
        // try to reuse rows, avoid removing them from DOM
        var rowsToDispose = new Map();
        for (var i = removeRange.start; i < removeRange.end; i++) {
            var item = this.items[i];
            item.dragStartDisposable.dispose();
            if (item.row) {
                var rows = rowsToDispose.get(item.templateId);
                if (!rows) {
                    rows = [];
                    rowsToDispose.set(item.templateId, rows);
                }
                var renderer = this.renderers.get(item.templateId);
                if (renderer && renderer.disposeElement) {
                    renderer.disposeElement(item.element, i, item.row.templateData, item.size);
                }
                rows.push(item.row);
            }
            item.row = null;
        }
        var previousRestRange = { start: start + deleteCount, end: this.items.length };
        var previousRenderedRestRange = Range.intersect(previousRestRange, previousRenderRange);
        var previousUnrenderedRestRanges = Range.relativeComplement(previousRestRange, previousRenderRange);
        var inserted = elements.map(function (element) { return ({
            id: String(_this.itemId++),
            element: element,
            templateId: _this.virtualDelegate.getTemplateId(element),
            size: _this.virtualDelegate.getHeight(element),
            width: undefined,
            hasDynamicHeight: !!_this.virtualDelegate.hasDynamicHeight && _this.virtualDelegate.hasDynamicHeight(element),
            lastDynamicHeightWidth: undefined,
            row: null,
            uri: undefined,
            dropTarget: false,
            dragStartDisposable: Disposable.None
        }); });
        var deleted;
        // TODO@joao: improve this optimization to catch even more cases
        if (start === 0 && deleteCount >= this.items.length) {
            this.rangeMap = new RangeMap();
            this.rangeMap.splice(0, 0, inserted);
            deleted = this.items;
            this.items = inserted;
        }
        else {
            this.rangeMap.splice(start, deleteCount, inserted);
            deleted = (_a = this.items).splice.apply(_a, __spreadArray([start, deleteCount], __read(inserted)));
        }
        var delta = elements.length - deleteCount;
        var renderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
        var renderedRestRange = shift(previousRenderedRestRange, delta);
        var updateRange = Range.intersect(renderRange, renderedRestRange);
        for (var i = updateRange.start; i < updateRange.end; i++) {
            this.updateItemInDOM(this.items[i], i);
        }
        var removeRanges = Range.relativeComplement(renderedRestRange, renderRange);
        try {
            for (var removeRanges_1 = __values(removeRanges), removeRanges_1_1 = removeRanges_1.next(); !removeRanges_1_1.done; removeRanges_1_1 = removeRanges_1.next()) {
                var range = removeRanges_1_1.value;
                for (var i = range.start; i < range.end; i++) {
                    this.removeItemFromDOM(i);
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (removeRanges_1_1 && !removeRanges_1_1.done && (_b = removeRanges_1.return)) _b.call(removeRanges_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        var unrenderedRestRanges = previousUnrenderedRestRanges.map(function (r) { return shift(r, delta); });
        var elementsRange = { start: start, end: start + elements.length };
        var insertRanges = __spreadArray([elementsRange], __read(unrenderedRestRanges)).map(function (r) { return Range.intersect(renderRange, r); });
        var beforeElement = this.getNextToLastElement(insertRanges);
        try {
            for (var insertRanges_1 = __values(insertRanges), insertRanges_1_1 = insertRanges_1.next(); !insertRanges_1_1.done; insertRanges_1_1 = insertRanges_1.next()) {
                var range = insertRanges_1_1.value;
                for (var i = range.start; i < range.end; i++) {
                    var item = this.items[i];
                    var rows = rowsToDispose.get(item.templateId);
                    var row = rows === null || rows === void 0 ? void 0 : rows.pop();
                    this.insertItemInDOM(i, beforeElement, row);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (insertRanges_1_1 && !insertRanges_1_1.done && (_c = insertRanges_1.return)) _c.call(insertRanges_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
        try {
            for (var _f = __values(rowsToDispose.values()), _g = _f.next(); !_g.done; _g = _f.next()) {
                var rows = _g.value;
                try {
                    for (var rows_1 = (e_6 = void 0, __values(rows)), rows_1_1 = rows_1.next(); !rows_1_1.done; rows_1_1 = rows_1.next()) {
                        var row = rows_1_1.value;
                        this.cache.release(row);
                    }
                }
                catch (e_6_1) { e_6 = { error: e_6_1 }; }
                finally {
                    try {
                        if (rows_1_1 && !rows_1_1.done && (_e = rows_1.return)) _e.call(rows_1);
                    }
                    finally { if (e_6) throw e_6.error; }
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_g && !_g.done && (_d = _f.return)) _d.call(_f);
            }
            finally { if (e_5) throw e_5.error; }
        }
        this.eventuallyUpdateScrollDimensions();
        if (this.supportDynamicHeights) {
            this._rerender(this.scrollTop, this.renderHeight);
        }
        return deleted.map(function (i) { return i.element; });
    };
    ListView.prototype.eventuallyUpdateScrollDimensions = function () {
        var _this = this;
        this._scrollHeight = this.contentHeight;
        this.rowsContainer.style.height = this._scrollHeight + "px";
        if (!this.scrollableElementUpdateDisposable) {
            this.scrollableElementUpdateDisposable = scheduleAtNextAnimationFrame(function () {
                _this.scrollableElement.setScrollDimensions({ scrollHeight: _this.scrollHeight });
                _this.updateScrollWidth();
                _this.scrollableElementUpdateDisposable = null;
            });
        }
    };
    ListView.prototype.eventuallyUpdateScrollWidth = function () {
        var _this = this;
        if (!this.horizontalScrolling) {
            this.scrollableElementWidthDelayer.cancel();
            return;
        }
        this.scrollableElementWidthDelayer.trigger(function () { return _this.updateScrollWidth(); });
    };
    ListView.prototype.updateScrollWidth = function () {
        var e_7, _a;
        if (!this.horizontalScrolling) {
            return;
        }
        var scrollWidth = 0;
        try {
            for (var _b = __values(this.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                if (typeof item.width !== 'undefined') {
                    scrollWidth = Math.max(scrollWidth, item.width);
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_7) throw e_7.error; }
        }
        this.scrollWidth = scrollWidth;
        this.scrollableElement.setScrollDimensions({ scrollWidth: scrollWidth === 0 ? 0 : (scrollWidth + 10) });
    };
    ListView.prototype.updateWidth = function (index) {
        if (!this.horizontalScrolling || typeof this.scrollWidth === 'undefined') {
            return;
        }
        var item = this.items[index];
        this.measureItemWidth(item);
        if (typeof item.width !== 'undefined' && item.width > this.scrollWidth) {
            this.scrollWidth = item.width;
            this.scrollableElement.setScrollDimensions({ scrollWidth: this.scrollWidth + 10 });
        }
    };
    ListView.prototype.rerender = function () {
        var e_8, _a;
        if (!this.supportDynamicHeights) {
            return;
        }
        try {
            for (var _b = __values(this.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                item.lastDynamicHeightWidth = undefined;
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_8) throw e_8.error; }
        }
        this._rerender(this.lastRenderTop, this.lastRenderHeight);
    };
    Object.defineProperty(ListView.prototype, "length", {
        get: function () {
            return this.items.length;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "renderHeight", {
        get: function () {
            var scrollDimensions = this.scrollableElement.getScrollDimensions();
            return scrollDimensions.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "firstVisibleIndex", {
        get: function () {
            var range = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
            var firstElTop = this.rangeMap.positionAt(range.start);
            var nextElTop = this.rangeMap.positionAt(range.start + 1);
            if (nextElTop !== -1) {
                var firstElMidpoint = (nextElTop - firstElTop) / 2 + firstElTop;
                if (firstElMidpoint < this.scrollTop) {
                    return range.start + 1;
                }
            }
            return range.start;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "lastVisibleIndex", {
        get: function () {
            var range = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
            return range.end - 1;
        },
        enumerable: false,
        configurable: true
    });
    ListView.prototype.element = function (index) {
        return this.items[index].element;
    };
    ListView.prototype.indexOf = function (element) {
        return this.items.findIndex(function (item) { return item.element === element; });
    };
    ListView.prototype.domElement = function (index) {
        var row = this.items[index].row;
        return row && row.domNode;
    };
    ListView.prototype.elementHeight = function (index) {
        return this.items[index].size;
    };
    ListView.prototype.elementTop = function (index) {
        return this.rangeMap.positionAt(index);
    };
    ListView.prototype.indexAt = function (position) {
        return this.rangeMap.indexAt(position);
    };
    ListView.prototype.indexAfter = function (position) {
        return this.rangeMap.indexAfter(position);
    };
    ListView.prototype.layout = function (height, width) {
        var scrollDimensions = {
            height: typeof height === 'number' ? height : getContentHeight(this.domNode)
        };
        if (this.scrollableElementUpdateDisposable) {
            this.scrollableElementUpdateDisposable.dispose();
            this.scrollableElementUpdateDisposable = null;
            scrollDimensions.scrollHeight = this.scrollHeight;
        }
        this.scrollableElement.setScrollDimensions(scrollDimensions);
        if (typeof width !== 'undefined') {
            this.renderWidth = width;
            if (this.supportDynamicHeights) {
                this._rerender(this.scrollTop, this.renderHeight);
            }
            if (this.horizontalScrolling) {
                this.scrollableElement.setScrollDimensions({
                    width: typeof width === 'number' ? width : getContentWidth(this.domNode)
                });
            }
        }
    };
    // Render
    ListView.prototype.render = function (previousRenderRange, renderTop, renderHeight, renderLeft, scrollWidth, updateItemsInDOM) {
        var e_9, _a, e_10, _b;
        if (updateItemsInDOM === void 0) { updateItemsInDOM = false; }
        var renderRange = this.getRenderRange(renderTop, renderHeight);
        var rangesToInsert = Range.relativeComplement(renderRange, previousRenderRange);
        var rangesToRemove = Range.relativeComplement(previousRenderRange, renderRange);
        var beforeElement = this.getNextToLastElement(rangesToInsert);
        if (updateItemsInDOM) {
            var rangesToUpdate = Range.intersect(previousRenderRange, renderRange);
            for (var i = rangesToUpdate.start; i < rangesToUpdate.end; i++) {
                this.updateItemInDOM(this.items[i], i);
            }
        }
        try {
            for (var rangesToInsert_1 = __values(rangesToInsert), rangesToInsert_1_1 = rangesToInsert_1.next(); !rangesToInsert_1_1.done; rangesToInsert_1_1 = rangesToInsert_1.next()) {
                var range = rangesToInsert_1_1.value;
                for (var i = range.start; i < range.end; i++) {
                    this.insertItemInDOM(i, beforeElement);
                }
            }
        }
        catch (e_9_1) { e_9 = { error: e_9_1 }; }
        finally {
            try {
                if (rangesToInsert_1_1 && !rangesToInsert_1_1.done && (_a = rangesToInsert_1.return)) _a.call(rangesToInsert_1);
            }
            finally { if (e_9) throw e_9.error; }
        }
        try {
            for (var rangesToRemove_1 = __values(rangesToRemove), rangesToRemove_1_1 = rangesToRemove_1.next(); !rangesToRemove_1_1.done; rangesToRemove_1_1 = rangesToRemove_1.next()) {
                var range = rangesToRemove_1_1.value;
                for (var i = range.start; i < range.end; i++) {
                    this.removeItemFromDOM(i);
                }
            }
        }
        catch (e_10_1) { e_10 = { error: e_10_1 }; }
        finally {
            try {
                if (rangesToRemove_1_1 && !rangesToRemove_1_1.done && (_b = rangesToRemove_1.return)) _b.call(rangesToRemove_1);
            }
            finally { if (e_10) throw e_10.error; }
        }
        if (renderLeft !== undefined) {
            this.rowsContainer.style.left = "-" + renderLeft + "px";
        }
        this.rowsContainer.style.top = "-" + renderTop + "px";
        if (this.horizontalScrolling && scrollWidth !== undefined) {
            this.rowsContainer.style.width = Math.max(scrollWidth, this.renderWidth) + "px";
        }
        this.lastRenderTop = renderTop;
        this.lastRenderHeight = renderHeight;
    };
    // DOM operations
    ListView.prototype.insertItemInDOM = function (index, beforeElement, row) {
        var _this = this;
        var item = this.items[index];
        if (!item.row) {
            item.row = row !== null && row !== void 0 ? row : this.cache.alloc(item.templateId);
        }
        var role = this.accessibilityProvider.getRole(item.element) || 'listitem';
        item.row.domNode.setAttribute('role', role);
        var checked = this.accessibilityProvider.isChecked(item.element);
        if (typeof checked !== 'undefined') {
            item.row.domNode.setAttribute('aria-checked', String(!!checked));
        }
        if (!item.row.domNode.parentElement) {
            if (beforeElement) {
                this.rowsContainer.insertBefore(item.row.domNode, beforeElement);
            }
            else {
                this.rowsContainer.appendChild(item.row.domNode);
            }
        }
        this.updateItemInDOM(item, index);
        var renderer = this.renderers.get(item.templateId);
        if (!renderer) {
            throw new Error("No renderer found for template id " + item.templateId);
        }
        if (renderer) {
            renderer.renderElement(item.element, index, item.row.templateData, item.size);
        }
        var uri = this.dnd.getDragURI(item.element);
        item.dragStartDisposable.dispose();
        item.row.domNode.draggable = !!uri;
        if (uri) {
            var onDragStart = domEvent(item.row.domNode, 'dragstart');
            item.dragStartDisposable = onDragStart(function (event) { return _this.onDragStart(item.element, uri, event); });
        }
        if (this.horizontalScrolling) {
            this.measureItemWidth(item);
            this.eventuallyUpdateScrollWidth();
        }
    };
    ListView.prototype.measureItemWidth = function (item) {
        if (!item.row || !item.row.domNode) {
            return;
        }
        item.row.domNode.style.width = isFirefox ? '-moz-fit-content' : 'fit-content';
        item.width = getContentWidth(item.row.domNode);
        var style = window.getComputedStyle(item.row.domNode);
        if (style.paddingLeft) {
            item.width += parseFloat(style.paddingLeft);
        }
        if (style.paddingRight) {
            item.width += parseFloat(style.paddingRight);
        }
        item.row.domNode.style.width = '';
    };
    ListView.prototype.updateItemInDOM = function (item, index) {
        item.row.domNode.style.top = this.elementTop(index) + "px";
        if (this.setRowHeight) {
            item.row.domNode.style.height = item.size + "px";
        }
        if (this.setRowLineHeight) {
            item.row.domNode.style.lineHeight = item.size + "px";
        }
        item.row.domNode.setAttribute('data-index', "" + index);
        item.row.domNode.setAttribute('data-last-element', index === this.length - 1 ? 'true' : 'false');
        item.row.domNode.setAttribute('aria-setsize', String(this.accessibilityProvider.getSetSize(item.element, index, this.length)));
        item.row.domNode.setAttribute('aria-posinset', String(this.accessibilityProvider.getPosInSet(item.element, index)));
        item.row.domNode.setAttribute('id', this.getElementDomId(index));
        item.row.domNode.classList.toggle('drop-target', item.dropTarget);
    };
    ListView.prototype.removeItemFromDOM = function (index) {
        var item = this.items[index];
        item.dragStartDisposable.dispose();
        if (item.row) {
            var renderer = this.renderers.get(item.templateId);
            if (renderer && renderer.disposeElement) {
                renderer.disposeElement(item.element, index, item.row.templateData, item.size);
            }
            this.cache.release(item.row);
            item.row = null;
        }
        if (this.horizontalScrolling) {
            this.eventuallyUpdateScrollWidth();
        }
    };
    ListView.prototype.getScrollTop = function () {
        var scrollPosition = this.scrollableElement.getScrollPosition();
        return scrollPosition.scrollTop;
    };
    ListView.prototype.setScrollTop = function (scrollTop, reuseAnimation) {
        if (this.scrollableElementUpdateDisposable) {
            this.scrollableElementUpdateDisposable.dispose();
            this.scrollableElementUpdateDisposable = null;
            this.scrollableElement.setScrollDimensions({ scrollHeight: this.scrollHeight });
        }
        this.scrollableElement.setScrollPosition({ scrollTop: scrollTop, reuseAnimation: reuseAnimation });
    };
    ListView.prototype.getScrollLeft = function () {
        var scrollPosition = this.scrollableElement.getScrollPosition();
        return scrollPosition.scrollLeft;
    };
    ListView.prototype.setScrollLeft = function (scrollLeft) {
        if (this.scrollableElementUpdateDisposable) {
            this.scrollableElementUpdateDisposable.dispose();
            this.scrollableElementUpdateDisposable = null;
            this.scrollableElement.setScrollDimensions({ scrollWidth: this.scrollWidth });
        }
        this.scrollableElement.setScrollPosition({ scrollLeft: scrollLeft });
    };
    Object.defineProperty(ListView.prototype, "scrollTop", {
        get: function () {
            return this.getScrollTop();
        },
        set: function (scrollTop) {
            this.setScrollTop(scrollTop);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "scrollHeight", {
        get: function () {
            return this._scrollHeight + (this.horizontalScrolling ? 10 : 0) + this.additionalScrollHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseClick", {
        // Events
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'click'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseDblClick", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'dblclick'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseMiddleClick", {
        get: function () {
            var _this = this;
            return Event.filter(Event.map(domEvent(this.domNode, 'auxclick'), function (e) { return _this.toMouseEvent(e); }), function (e) { return e.browserEvent.button === 1; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseUp", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'mouseup'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseDown", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'mousedown'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseOver", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'mouseover'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseMove", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'mousemove'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onMouseOut", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'mouseout'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onContextMenu", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'contextmenu'), function (e) { return _this.toMouseEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onTouchStart", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.domNode, 'touchstart'), function (e) { return _this.toTouchEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListView.prototype, "onTap", {
        get: function () {
            var _this = this;
            return Event.map(domEvent(this.rowsContainer, TouchEventType.Tap), function (e) { return _this.toGestureEvent(e); });
        },
        enumerable: false,
        configurable: true
    });
    ListView.prototype.toMouseEvent = function (browserEvent) {
        var index = this.getItemIndexFromEventTarget(browserEvent.target || null);
        var item = typeof index === 'undefined' ? undefined : this.items[index];
        var element = item && item.element;
        return { browserEvent: browserEvent, index: index, element: element };
    };
    ListView.prototype.toTouchEvent = function (browserEvent) {
        var index = this.getItemIndexFromEventTarget(browserEvent.target || null);
        var item = typeof index === 'undefined' ? undefined : this.items[index];
        var element = item && item.element;
        return { browserEvent: browserEvent, index: index, element: element };
    };
    ListView.prototype.toGestureEvent = function (browserEvent) {
        var index = this.getItemIndexFromEventTarget(browserEvent.initialTarget || null);
        var item = typeof index === 'undefined' ? undefined : this.items[index];
        var element = item && item.element;
        return { browserEvent: browserEvent, index: index, element: element };
    };
    ListView.prototype.toDragEvent = function (browserEvent) {
        var index = this.getItemIndexFromEventTarget(browserEvent.target || null);
        var item = typeof index === 'undefined' ? undefined : this.items[index];
        var element = item && item.element;
        return { browserEvent: browserEvent, index: index, element: element };
    };
    ListView.prototype.onScroll = function (e) {
        try {
            var previousRenderRange = this.getRenderRange(this.lastRenderTop, this.lastRenderHeight);
            this.render(previousRenderRange, e.scrollTop, e.height, e.scrollLeft, e.scrollWidth);
            if (this.supportDynamicHeights) {
                this._rerender(e.scrollTop, e.height, e.inSmoothScrolling);
            }
        }
        catch (err) {
            console.error('Got bad scroll event:', e);
            throw err;
        }
    };
    ListView.prototype.onTouchChange = function (event) {
        event.preventDefault();
        event.stopPropagation();
        this.scrollTop -= event.translationY;
    };
    // DND
    ListView.prototype.onDragStart = function (element, uri, event) {
        if (!event.dataTransfer) {
            return;
        }
        var elements = this.dnd.getDragElements(element);
        event.dataTransfer.effectAllowed = 'copyMove';
        event.dataTransfer.setData(DataTransfers.RESOURCES, JSON.stringify([uri]));
        if (event.dataTransfer.setDragImage) {
            var label = void 0;
            if (this.dnd.getDragLabel) {
                label = this.dnd.getDragLabel(elements, event);
            }
            if (typeof label === 'undefined') {
                label = String(elements.length);
            }
            var dragImage_1 = $('.monaco-drag-image');
            dragImage_1.textContent = label;
            document.body.appendChild(dragImage_1);
            event.dataTransfer.setDragImage(dragImage_1, -10, -10);
            setTimeout(function () { return document.body.removeChild(dragImage_1); }, 0);
        }
        this.currentDragData = new ElementsDragAndDropData(elements);
        StaticDND.CurrentDragAndDropData = new ExternalElementsDragAndDropData(elements);
        if (this.dnd.onDragStart) {
            this.dnd.onDragStart(this.currentDragData, event);
        }
    };
    ListView.prototype.onDragOver = function (event) {
        var e_11, _a;
        var _this = this;
        event.browserEvent.preventDefault(); // needed so that the drop event fires (https://stackoverflow.com/questions/21339924/drop-event-not-firing-in-chrome)
        this.onDragLeaveTimeout.dispose();
        if (StaticDND.CurrentDragAndDropData && StaticDND.CurrentDragAndDropData.getData() === 'vscode-ui') {
            return false;
        }
        this.setupDragAndDropScrollTopAnimation(event.browserEvent);
        if (!event.browserEvent.dataTransfer) {
            return false;
        }
        // Drag over from outside
        if (!this.currentDragData) {
            if (StaticDND.CurrentDragAndDropData) {
                // Drag over from another list
                this.currentDragData = StaticDND.CurrentDragAndDropData;
            }
            else {
                // Drag over from the desktop
                if (!event.browserEvent.dataTransfer.types) {
                    return false;
                }
                this.currentDragData = new NativeDragAndDropData();
            }
        }
        var result = this.dnd.onDragOver(this.currentDragData, event.element, event.index, event.browserEvent);
        this.canDrop = typeof result === 'boolean' ? result : result.accept;
        if (!this.canDrop) {
            this.currentDragFeedback = undefined;
            this.currentDragFeedbackDisposable.dispose();
            return false;
        }
        event.browserEvent.dataTransfer.dropEffect = (typeof result !== 'boolean' && result.effect === 0 /* Copy */) ? 'copy' : 'move';
        var feedback;
        if (typeof result !== 'boolean' && result.feedback) {
            feedback = result.feedback;
        }
        else {
            if (typeof event.index === 'undefined') {
                feedback = [-1];
            }
            else {
                feedback = [event.index];
            }
        }
        // sanitize feedback list
        feedback = distinct(feedback).filter(function (i) { return i >= -1 && i < _this.length; }).sort(function (a, b) { return a - b; });
        feedback = feedback[0] === -1 ? [-1] : feedback;
        if (equalsDragFeedback(this.currentDragFeedback, feedback)) {
            return true;
        }
        this.currentDragFeedback = feedback;
        this.currentDragFeedbackDisposable.dispose();
        if (feedback[0] === -1) { // entire list feedback
            this.domNode.classList.add('drop-target');
            this.rowsContainer.classList.add('drop-target');
            this.currentDragFeedbackDisposable = toDisposable(function () {
                _this.domNode.classList.remove('drop-target');
                _this.rowsContainer.classList.remove('drop-target');
            });
        }
        else {
            try {
                for (var feedback_1 = __values(feedback), feedback_1_1 = feedback_1.next(); !feedback_1_1.done; feedback_1_1 = feedback_1.next()) {
                    var index = feedback_1_1.value;
                    var item = this.items[index];
                    item.dropTarget = true;
                    if (item.row) {
                        item.row.domNode.classList.add('drop-target');
                    }
                }
            }
            catch (e_11_1) { e_11 = { error: e_11_1 }; }
            finally {
                try {
                    if (feedback_1_1 && !feedback_1_1.done && (_a = feedback_1.return)) _a.call(feedback_1);
                }
                finally { if (e_11) throw e_11.error; }
            }
            this.currentDragFeedbackDisposable = toDisposable(function () {
                var e_12, _a;
                try {
                    for (var feedback_2 = __values(feedback), feedback_2_1 = feedback_2.next(); !feedback_2_1.done; feedback_2_1 = feedback_2.next()) {
                        var index = feedback_2_1.value;
                        var item = _this.items[index];
                        item.dropTarget = false;
                        if (item.row) {
                            item.row.domNode.classList.remove('drop-target');
                        }
                    }
                }
                catch (e_12_1) { e_12 = { error: e_12_1 }; }
                finally {
                    try {
                        if (feedback_2_1 && !feedback_2_1.done && (_a = feedback_2.return)) _a.call(feedback_2);
                    }
                    finally { if (e_12) throw e_12.error; }
                }
            });
        }
        return true;
    };
    ListView.prototype.onDragLeave = function () {
        var _this = this;
        this.onDragLeaveTimeout.dispose();
        this.onDragLeaveTimeout = disposableTimeout(function () { return _this.clearDragOverFeedback(); }, 100);
    };
    ListView.prototype.onDrop = function (event) {
        if (!this.canDrop) {
            return;
        }
        var dragData = this.currentDragData;
        this.teardownDragAndDropScrollTopAnimation();
        this.clearDragOverFeedback();
        this.currentDragData = undefined;
        StaticDND.CurrentDragAndDropData = undefined;
        if (!dragData || !event.browserEvent.dataTransfer) {
            return;
        }
        event.browserEvent.preventDefault();
        dragData.update(event.browserEvent.dataTransfer);
        this.dnd.drop(dragData, event.element, event.index, event.browserEvent);
    };
    ListView.prototype.onDragEnd = function (event) {
        this.canDrop = false;
        this.teardownDragAndDropScrollTopAnimation();
        this.clearDragOverFeedback();
        this.currentDragData = undefined;
        StaticDND.CurrentDragAndDropData = undefined;
        if (this.dnd.onDragEnd) {
            this.dnd.onDragEnd(event);
        }
    };
    ListView.prototype.clearDragOverFeedback = function () {
        this.currentDragFeedback = undefined;
        this.currentDragFeedbackDisposable.dispose();
        this.currentDragFeedbackDisposable = Disposable.None;
    };
    // DND scroll top animation
    ListView.prototype.setupDragAndDropScrollTopAnimation = function (event) {
        var _this = this;
        if (!this.dragOverAnimationDisposable) {
            var viewTop = getTopLeftOffset(this.domNode).top;
            this.dragOverAnimationDisposable = animate(this.animateDragAndDropScrollTop.bind(this, viewTop));
        }
        this.dragOverAnimationStopDisposable.dispose();
        this.dragOverAnimationStopDisposable = disposableTimeout(function () {
            if (_this.dragOverAnimationDisposable) {
                _this.dragOverAnimationDisposable.dispose();
                _this.dragOverAnimationDisposable = undefined;
            }
        }, 1000);
        this.dragOverMouseY = event.pageY;
    };
    ListView.prototype.animateDragAndDropScrollTop = function (viewTop) {
        if (this.dragOverMouseY === undefined) {
            return;
        }
        var diff = this.dragOverMouseY - viewTop;
        var upperLimit = this.renderHeight - 35;
        if (diff < 35) {
            this.scrollTop += Math.max(-14, Math.floor(0.3 * (diff - 35)));
        }
        else if (diff > upperLimit) {
            this.scrollTop += Math.min(14, Math.floor(0.3 * (diff - upperLimit)));
        }
    };
    ListView.prototype.teardownDragAndDropScrollTopAnimation = function () {
        this.dragOverAnimationStopDisposable.dispose();
        if (this.dragOverAnimationDisposable) {
            this.dragOverAnimationDisposable.dispose();
            this.dragOverAnimationDisposable = undefined;
        }
    };
    // Util
    ListView.prototype.getItemIndexFromEventTarget = function (target) {
        var scrollableElement = this.scrollableElement.getDomNode();
        var element = target;
        while (element instanceof HTMLElement && element !== this.rowsContainer && scrollableElement.contains(element)) {
            var rawIndex = element.getAttribute('data-index');
            if (rawIndex) {
                var index = Number(rawIndex);
                if (!isNaN(index)) {
                    return index;
                }
            }
            element = element.parentElement;
        }
        return undefined;
    };
    ListView.prototype.getRenderRange = function (renderTop, renderHeight) {
        return {
            start: this.rangeMap.indexAt(renderTop),
            end: this.rangeMap.indexAfter(renderTop + renderHeight - 1)
        };
    };
    /**
     * Given a stable rendered state, checks every rendered element whether it needs
     * to be probed for dynamic height. Adjusts scroll height and top if necessary.
     */
    ListView.prototype._rerender = function (renderTop, renderHeight, inSmoothScrolling) {
        var e_13, _a, e_14, _b;
        var previousRenderRange = this.getRenderRange(renderTop, renderHeight);
        // Let's remember the second element's position, this helps in scrolling up
        // and preserving a linear upwards scroll movement
        var anchorElementIndex;
        var anchorElementTopDelta;
        if (renderTop === this.elementTop(previousRenderRange.start)) {
            anchorElementIndex = previousRenderRange.start;
            anchorElementTopDelta = 0;
        }
        else if (previousRenderRange.end - previousRenderRange.start > 1) {
            anchorElementIndex = previousRenderRange.start + 1;
            anchorElementTopDelta = this.elementTop(anchorElementIndex) - renderTop;
        }
        var heightDiff = 0;
        while (true) {
            var renderRange = this.getRenderRange(renderTop, renderHeight);
            var didChange = false;
            for (var i = renderRange.start; i < renderRange.end; i++) {
                var diff = this.probeDynamicHeight(i);
                if (diff !== 0) {
                    this.rangeMap.splice(i, 1, [this.items[i]]);
                }
                heightDiff += diff;
                didChange = didChange || diff !== 0;
            }
            if (!didChange) {
                if (heightDiff !== 0) {
                    this.eventuallyUpdateScrollDimensions();
                }
                var unrenderRanges = Range.relativeComplement(previousRenderRange, renderRange);
                try {
                    for (var unrenderRanges_1 = (e_13 = void 0, __values(unrenderRanges)), unrenderRanges_1_1 = unrenderRanges_1.next(); !unrenderRanges_1_1.done; unrenderRanges_1_1 = unrenderRanges_1.next()) {
                        var range = unrenderRanges_1_1.value;
                        for (var i = range.start; i < range.end; i++) {
                            if (this.items[i].row) {
                                this.removeItemFromDOM(i);
                            }
                        }
                    }
                }
                catch (e_13_1) { e_13 = { error: e_13_1 }; }
                finally {
                    try {
                        if (unrenderRanges_1_1 && !unrenderRanges_1_1.done && (_a = unrenderRanges_1.return)) _a.call(unrenderRanges_1);
                    }
                    finally { if (e_13) throw e_13.error; }
                }
                var renderRanges = Range.relativeComplement(renderRange, previousRenderRange);
                try {
                    for (var renderRanges_1 = (e_14 = void 0, __values(renderRanges)), renderRanges_1_1 = renderRanges_1.next(); !renderRanges_1_1.done; renderRanges_1_1 = renderRanges_1.next()) {
                        var range = renderRanges_1_1.value;
                        for (var i = range.start; i < range.end; i++) {
                            var afterIndex = i + 1;
                            var beforeRow = afterIndex < this.items.length ? this.items[afterIndex].row : null;
                            var beforeElement = beforeRow ? beforeRow.domNode : null;
                            this.insertItemInDOM(i, beforeElement);
                        }
                    }
                }
                catch (e_14_1) { e_14 = { error: e_14_1 }; }
                finally {
                    try {
                        if (renderRanges_1_1 && !renderRanges_1_1.done && (_b = renderRanges_1.return)) _b.call(renderRanges_1);
                    }
                    finally { if (e_14) throw e_14.error; }
                }
                for (var i = renderRange.start; i < renderRange.end; i++) {
                    if (this.items[i].row) {
                        this.updateItemInDOM(this.items[i], i);
                    }
                }
                if (typeof anchorElementIndex === 'number') {
                    // To compute a destination scroll top, we need to take into account the current smooth scrolling
                    // animation, and then reuse it with a new target (to avoid prolonging the scroll)
                    // See https://github.com/microsoft/vscode/issues/104144
                    // See https://github.com/microsoft/vscode/pull/104284
                    // See https://github.com/microsoft/vscode/issues/107704
                    var deltaScrollTop = this.scrollable.getFutureScrollPosition().scrollTop - renderTop;
                    var newScrollTop = this.elementTop(anchorElementIndex) - anchorElementTopDelta + deltaScrollTop;
                    this.setScrollTop(newScrollTop, inSmoothScrolling);
                }
                this._onDidChangeContentHeight.fire(this.contentHeight);
                return;
            }
        }
    };
    ListView.prototype.probeDynamicHeight = function (index) {
        var item = this.items[index];
        if (!item.hasDynamicHeight || item.lastDynamicHeightWidth === this.renderWidth) {
            return 0;
        }
        if (!!this.virtualDelegate.hasDynamicHeight && !this.virtualDelegate.hasDynamicHeight(item.element)) {
            return 0;
        }
        var size = item.size;
        if (!this.setRowHeight && item.row) {
            var newSize = item.row.domNode.offsetHeight;
            item.size = newSize;
            item.lastDynamicHeightWidth = this.renderWidth;
            return newSize - size;
        }
        var row = this.cache.alloc(item.templateId);
        row.domNode.style.height = '';
        this.rowsContainer.appendChild(row.domNode);
        var renderer = this.renderers.get(item.templateId);
        if (renderer) {
            renderer.renderElement(item.element, index, row.templateData, undefined);
            if (renderer.disposeElement) {
                renderer.disposeElement(item.element, index, row.templateData, undefined);
            }
        }
        item.size = row.domNode.offsetHeight;
        if (this.virtualDelegate.setDynamicHeight) {
            this.virtualDelegate.setDynamicHeight(item.element, item.size);
        }
        item.lastDynamicHeightWidth = this.renderWidth;
        this.rowsContainer.removeChild(row.domNode);
        this.cache.release(row);
        return item.size - size;
    };
    ListView.prototype.getNextToLastElement = function (ranges) {
        var lastRange = ranges[ranges.length - 1];
        if (!lastRange) {
            return null;
        }
        var nextToLastItem = this.items[lastRange.end];
        if (!nextToLastItem) {
            return null;
        }
        if (!nextToLastItem.row) {
            return null;
        }
        return nextToLastItem.row.domNode;
    };
    ListView.prototype.getElementDomId = function (index) {
        return this.domId + "_" + index;
    };
    // Dispose
    ListView.prototype.dispose = function () {
        var e_15, _a;
        if (this.items) {
            try {
                for (var _b = __values(this.items), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    if (item.row) {
                        var renderer = this.renderers.get(item.row.templateId);
                        if (renderer) {
                            if (renderer.disposeElement) {
                                renderer.disposeElement(item.element, -1, item.row.templateData, undefined);
                            }
                            renderer.disposeTemplate(item.row.templateData);
                        }
                    }
                }
            }
            catch (e_15_1) { e_15 = { error: e_15_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_15) throw e_15.error; }
            }
            this.items = [];
        }
        if (this.domNode && this.domNode.parentNode) {
            this.domNode.parentNode.removeChild(this.domNode);
        }
        dispose(this.disposables);
    };
    ListView.InstanceCount = 0;
    __decorate([
        memoize
    ], ListView.prototype, "onMouseClick", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseDblClick", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseMiddleClick", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseUp", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseDown", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseOver", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseMove", null);
    __decorate([
        memoize
    ], ListView.prototype, "onMouseOut", null);
    __decorate([
        memoize
    ], ListView.prototype, "onContextMenu", null);
    __decorate([
        memoize
    ], ListView.prototype, "onTouchStart", null);
    __decorate([
        memoize
    ], ListView.prototype, "onTap", null);
    return ListView;
}());
export { ListView };
