"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var DebugSessionWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugSessionWidget = exports.DebugSessionWidgetFactory = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const debug_threads_widget_1 = require("./debug-threads-widget");
const debug_stack_frames_widget_1 = require("./debug-stack-frames-widget");
const debug_breakpoints_widget_1 = require("./debug-breakpoints-widget");
const debug_variables_widget_1 = require("./debug-variables-widget");
const debug_toolbar_widget_1 = require("./debug-toolbar-widget");
const debug_view_model_1 = require("./debug-view-model");
const debug_watch_widget_1 = require("./debug-watch-widget");
exports.DebugSessionWidgetFactory = Symbol('DebugSessionWidgetFactory');
let DebugSessionWidget = DebugSessionWidget_1 = class DebugSessionWidget extends browser_1.BaseWidget {
    static createContainer(parent, options) {
        const child = new inversify_1.Container({ defaultScope: 'Singleton' });
        child.parent = parent;
        child.bind(debug_view_model_1.DebugViewOptions).toConstantValue(options);
        child.bind(debug_view_model_1.DebugViewModel).toSelf();
        child.bind(debug_toolbar_widget_1.DebugToolBar).toSelf();
        child.bind(debug_threads_widget_1.DebugThreadsWidget).toDynamicValue(({ container }) => debug_threads_widget_1.DebugThreadsWidget.createWidget(container));
        child.bind(debug_stack_frames_widget_1.DebugStackFramesWidget).toDynamicValue(({ container }) => debug_stack_frames_widget_1.DebugStackFramesWidget.createWidget(container));
        child.bind(debug_variables_widget_1.DebugVariablesWidget).toDynamicValue(({ container }) => debug_variables_widget_1.DebugVariablesWidget.createWidget(container));
        child.bind(debug_watch_widget_1.DebugWatchWidget).toDynamicValue(({ container }) => debug_watch_widget_1.DebugWatchWidget.createWidget(container));
        child.bind(debug_breakpoints_widget_1.DebugBreakpointsWidget).toDynamicValue(({ container }) => debug_breakpoints_widget_1.DebugBreakpointsWidget.createWidget(container));
        child.bind(DebugSessionWidget_1).toSelf();
        return child;
    }
    static createWidget(parent, options) {
        return DebugSessionWidget_1.createContainer(parent, options).get(DebugSessionWidget_1);
    }
    init() {
        this.id = 'debug:session:' + this.model.id;
        this.title.label = this.model.label;
        this.title.caption = this.model.label;
        this.title.closable = true;
        this.title.iconClass = 'debug-tab-icon';
        this.addClass('theia-session-container');
        this.viewContainer = this.viewContainerFactory({
            id: 'debug:view-container:' + this.model.id
        });
        this.viewContainer.addWidget(this.threads, { weight: 30 });
        this.viewContainer.addWidget(this.stackFrames, { weight: 20 });
        this.viewContainer.addWidget(this.variables, { weight: 10 });
        this.viewContainer.addWidget(this.watch, { weight: 10 });
        this.viewContainer.addWidget(this.breakpoints, { weight: 10 });
        this.toDispose.pushAll([
            this.toolbar,
            this.viewContainer
        ]);
        const layout = this.layout = new browser_1.PanelLayout();
        layout.addWidget(this.toolbar);
        layout.addWidget(this.viewContainer);
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.toolbar.focus();
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.getTrackableWidgets().forEach(w => w.update());
    }
    getTrackableWidgets() {
        return this.viewContainer.getTrackableWidgets();
    }
    storeState() {
        return this.viewContainer.storeState();
    }
    restoreState(oldState) {
        this.viewContainer.restoreState(oldState);
    }
};
__decorate([
    inversify_1.inject(browser_1.ViewContainer.Factory),
    __metadata("design:type", Function)
], DebugSessionWidget.prototype, "viewContainerFactory", void 0);
__decorate([
    inversify_1.inject(debug_view_model_1.DebugViewModel),
    __metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugSessionWidget.prototype, "model", void 0);
__decorate([
    inversify_1.inject(debug_toolbar_widget_1.DebugToolBar),
    __metadata("design:type", debug_toolbar_widget_1.DebugToolBar)
], DebugSessionWidget.prototype, "toolbar", void 0);
__decorate([
    inversify_1.inject(debug_threads_widget_1.DebugThreadsWidget),
    __metadata("design:type", debug_threads_widget_1.DebugThreadsWidget)
], DebugSessionWidget.prototype, "threads", void 0);
__decorate([
    inversify_1.inject(debug_stack_frames_widget_1.DebugStackFramesWidget),
    __metadata("design:type", debug_stack_frames_widget_1.DebugStackFramesWidget)
], DebugSessionWidget.prototype, "stackFrames", void 0);
__decorate([
    inversify_1.inject(debug_variables_widget_1.DebugVariablesWidget),
    __metadata("design:type", debug_variables_widget_1.DebugVariablesWidget)
], DebugSessionWidget.prototype, "variables", void 0);
__decorate([
    inversify_1.inject(debug_watch_widget_1.DebugWatchWidget),
    __metadata("design:type", debug_watch_widget_1.DebugWatchWidget)
], DebugSessionWidget.prototype, "watch", void 0);
__decorate([
    inversify_1.inject(debug_breakpoints_widget_1.DebugBreakpointsWidget),
    __metadata("design:type", debug_breakpoints_widget_1.DebugBreakpointsWidget)
], DebugSessionWidget.prototype, "breakpoints", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], DebugSessionWidget.prototype, "init", null);
DebugSessionWidget = DebugSessionWidget_1 = __decorate([
    inversify_1.injectable()
], DebugSessionWidget);
exports.DebugSessionWidget = DebugSessionWidget;
//# sourceMappingURL=debug-session-widget.js.map