"use strict";
/********************************************************************************
 * Copyright (C) 2018 Google and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindCorePreferences = exports.createCorePreferences = exports.CorePreferences = exports.CorePreferenceContribution = exports.corePreferenceSchema = void 0;
const preferences_1 = require("./preferences");
const supported_encodings_1 = require("./supported-encodings");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
const os_1 = require("../common/os");
exports.corePreferenceSchema = {
    'type': 'object',
    properties: {
        'workbench.list.openMode': {
            type: 'string',
            enum: [
                'singleClick',
                'doubleClick'
            ],
            default: 'singleClick',
            description: 'Controls how to open items in trees using the mouse.'
        },
        'workbench.editor.highlightModifiedTabs': {
            'type': 'boolean',
            'description': 'Controls whether a top border is drawn on modified (dirty) editor tabs or not.',
            'default': false
        },
        'workbench.editor.closeOnFileDelete': {
            'type': 'boolean',
            // eslint-disable-next-line max-len
            'description': 'Controls whether editors showing a file that was opened during the session should close automatically when getting deleted or renamed by some other process. Disabling this will keep the editor open  on such an event. Note that deleting from within the application will always close the editor and that dirty files will never close to preserve your data.',
            'default': false
        },
        'application.confirmExit': {
            type: 'string',
            enum: [
                'never',
                'ifRequired',
                'always',
            ],
            default: 'ifRequired',
            description: 'When to confirm before closing the application window.',
        },
        'workbench.commandPalette.history': {
            type: 'number',
            default: 50,
            minimum: 0,
            description: 'Controls the number of recently used commands to keep in history for the command palette. Set to 0 to disable command history.'
        },
        'workbench.colorTheme': {
            type: 'string',
            default: frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().defaultTheme,
            description: 'Specifies the color theme used in the workbench.'
        },
        'workbench.iconTheme': {
            type: ['string', 'null'],
            default: frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().defaultIconTheme,
            description: "Specifies the icon theme used in the workbench or 'null' to not show any file icons."
        },
        'workbench.silentNotifications': {
            type: 'boolean',
            default: false,
            description: 'Controls whether to suppress notification popups.'
        },
        'files.encoding': {
            'type': 'string',
            'enum': Object.keys(supported_encodings_1.SUPPORTED_ENCODINGS),
            'default': 'utf8',
            'description': 'The default character set encoding to use when reading and writing files. This setting can also be configured per language.',
            'scope': 'language-overridable',
            'enumDescriptions': Object.keys(supported_encodings_1.SUPPORTED_ENCODINGS).map(key => supported_encodings_1.SUPPORTED_ENCODINGS[key].labelLong),
            'included': Object.keys(supported_encodings_1.SUPPORTED_ENCODINGS).length > 1
        },
        'workbench.tree.renderIndentGuides': {
            type: 'string',
            enum: ['onHover', 'none', 'always'],
            default: 'onHover',
            description: 'Controls whether the tree should render indent guides.'
        },
        'keyboard.dispatch': {
            type: 'string',
            enum: [
                'code',
                'keyCode',
            ],
            default: 'code',
            description: 'Whether to interpret keypresses by the `code` of the physical key, or by the `keyCode` provided by the OS.'
        },
        'window.menuBarVisibility': {
            type: 'string',
            enum: ['classic', 'visible', 'hidden', 'compact'],
            markdownEnumDescriptions: [
                'Menu is displayed at the top of the window and only hidden in full screen mode.',
                'Menu is always visible at the top of the window even in full screen mode.',
                'Menu is always hidden.',
                'Menu is displayed as a compact button in the sidebar.'
            ],
            default: 'classic',
            scope: 'application',
            markdownDescription: `Control the visibility of the menu bar. 
            A setting of 'compact' will move the menu into the sidebar.`,
            included: !os_1.isOSX
        },
    }
};
exports.CorePreferenceContribution = Symbol('CorePreferenceContribution');
exports.CorePreferences = Symbol('CorePreferences');
function createCorePreferences(preferences, schema = exports.corePreferenceSchema) {
    return preferences_1.createPreferenceProxy(preferences, schema);
}
exports.createCorePreferences = createCorePreferences;
function bindCorePreferences(bind) {
    bind(exports.CorePreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.CorePreferenceContribution);
        return createCorePreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.CorePreferenceContribution).toConstantValue({ schema: exports.corePreferenceSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.CorePreferenceContribution);
}
exports.bindCorePreferences = bindCorePreferences;
//# sourceMappingURL=core-preferences.js.map