/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DocumentSymbolHandler {
    private static Range DEFAULT_RANGE = new Range(new Position(0, 0), new Position(0, 0));
    private boolean hierarchicalDocumentSymbolSupported;

    public DocumentSymbolHandler(boolean hierarchicalDocumentSymbolSupported) {
        this.hierarchicalDocumentSymbolSupported = hierarchicalDocumentSymbolSupported;
    }

    public List<Either<SymbolInformation, DocumentSymbol>> documentSymbol(DocumentSymbolParams params, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null) {
            return Collections.emptyList();
        }
        if (this.hierarchicalDocumentSymbolSupported) {
            List<DocumentSymbol> symbols = this.getHierarchicalOutline(unit, monitor);
            return symbols.stream().map(Either::forRight).collect(Collectors.toList());
        }
        SymbolInformation[] elements = this.getOutline(unit, monitor);
        return Arrays.asList(elements).stream().map(Either::forLeft).collect(Collectors.toList());
    }

    private SymbolInformation[] getOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            IJavaElement[] elements = unit.getChildren();
            ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>(elements.length);
            this.collectChildren(unit, elements, symbols, monitor);
            return symbols.toArray(new SymbolInformation[symbols.size()]);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem getting outline for" + unit.getElementName(), e);
            return new SymbolInformation[0];
        }
    }

    private void collectChildren(ITypeRoot unit, IJavaElement[] elements, ArrayList<SymbolInformation> symbols, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Location location;
            int type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (element instanceof IParent) {
                this.collectChildren(unit, this.filter(((IParent)element).getChildren()), symbols, monitor);
            }
            if (((type = element.getElementType()) == 7 || type == 8 || type == 9) && (location = JDTUtils.toLocation(element)) != null) {
                SymbolInformation si = new SymbolInformation();
                String name = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                si.setName(name == null ? element.getElementName() : name);
                si.setKind(DocumentSymbolHandler.mapKind(element));
                if (element.getParent() != null) {
                    si.setContainerName(element.getParent().getElementName());
                }
                location.setUri(ResourceUtils.toClientUri(location.getUri()));
                si.setLocation(location);
                if (!symbols.contains(si)) {
                    symbols.add(si);
                }
            }
            ++n2;
        }
    }

    private List<DocumentSymbol> getHierarchicalOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            return Stream.of(this.filter(unit.getChildren())).map(child -> this.toDocumentSymbol((IJavaElement)child, monitor)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (OperationCanceledException e) {
            JavaLanguageServerPlugin.logInfo("User abort while collecting the document symbols.");
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem getting outline for" + unit.getElementName(), e);
        }
        return Collections.emptyList();
    }

    private DocumentSymbol toDocumentSymbol(IJavaElement unit, IProgressMonitor monitor) {
        int type = unit.getElementType();
        if (type != 7 && type != 8 && type != 9 && type != 11 && type != 5) {
            return null;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("User abort");
        }
        DocumentSymbol symbol = new DocumentSymbol();
        try {
            String name = this.getName(unit);
            symbol.setName(name);
            symbol.setRange(this.getRange(unit));
            symbol.setSelectionRange(this.getSelectionRange(unit));
            symbol.setKind(DocumentSymbolHandler.mapKind(unit));
            symbol.setDeprecated(Boolean.valueOf(this.isDeprecated(unit)));
            symbol.setDetail(this.getDetail(unit, name));
            if (unit instanceof IParent) {
                IJavaElement[] children = this.filter(((IParent)unit).getChildren());
                symbol.setChildren(Stream.of(children).map(child -> this.toDocumentSymbol((IJavaElement)child, monitor)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        catch (JavaModelException e) {
            Exceptions.sneakyThrow((Throwable)e);
        }
        return symbol;
    }

    private String getName(IJavaElement element) {
        String name = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
        return name == null ? element.getElementName() : name;
    }

    private Range getRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element, JDTUtils.LocationType.FULL_RANGE);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    private Range getSelectionRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    private boolean isDeprecated(IJavaElement element) throws JavaModelException {
        if (element instanceof ITypeRoot) {
            return Flags.isDeprecated((int)((ITypeRoot)element).findPrimaryType().getFlags());
        }
        return false;
    }

    private String getDetail(IJavaElement element, String name) {
        String nameWithDetails = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT | 0x20L | 0x10000000000L);
        if (nameWithDetails != null && nameWithDetails.startsWith(name)) {
            return nameWithDetails.substring(name.length());
        }
        return "";
    }

    private IJavaElement[] filter(IJavaElement[] elements) {
        return (IJavaElement[])Stream.of(elements).filter(e -> !this.isInitializer((IJavaElement)e) && !this.isSyntheticElement((IJavaElement)e)).toArray(IJavaElement[]::new);
    }

    private boolean isInitializer(IJavaElement element) {
        String name;
        return element.getElementType() == 9 && (name = element.getElementName()) != null && name.indexOf(60) >= 0;
    }

    private boolean isSyntheticElement(IJavaElement element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)element;
        if (!member.isBinary()) {
            return false;
        }
        try {
            return Flags.isSynthetic((int)member.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public static SymbolKind mapKind(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                try {
                    IType type = (IType)element;
                    if (type.isInterface()) {
                        return SymbolKind.Interface;
                    }
                    if (type.isEnum()) {
                        return SymbolKind.Enum;
                    }
                }
                catch (JavaModelException type) {
                    // empty catch block
                }
                return SymbolKind.Class;
            }
            case 16: {
                return SymbolKind.Property;
            }
            case 5: 
            case 6: {
                return SymbolKind.File;
            }
            case 8: {
                IField field = (IField)element;
                try {
                    if (field.isEnumConstant()) {
                        return SymbolKind.EnumMember;
                    }
                    int flags = field.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                        return SymbolKind.Constant;
                    }
                }
                catch (JavaModelException flags) {
                    // empty catch block
                }
                return SymbolKind.Field;
            }
            case 12: 
            case 13: 
            case 17: {
                return SymbolKind.Module;
            }
            case 10: {
                return SymbolKind.Constructor;
            }
            case 14: {
                return SymbolKind.Variable;
            }
            case 15: {
                return SymbolKind.TypeParameter;
            }
            case 9: {
                try {
                    if (element instanceof IMethod && ((IMethod)element).isConstructor()) {
                        return SymbolKind.Constructor;
                    }
                    return SymbolKind.Method;
                }
                catch (JavaModelException e) {
                    return SymbolKind.Method;
                }
            }
            case 11: {
                return SymbolKind.Package;
            }
        }
        return SymbolKind.String;
    }
}

