/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import org.eclipse.jface.text.templates.Template;

public enum CodeSnippetTemplate {
    SYSOUT("org.eclipse.jdt.ls.templates.sysout", "java-statements", "System.out.println($${0});", "print to standard out"),
    SYSERR("org.eclipse.jdt.ls.templates.syserr", "java-statements", "System.err.println($${0});", "print to standard err"),
    SYSTRACE("org.eclipse.jdt.ls.templates.systrace", "java-statements", "System.out.println(\"${enclosing_type}.${enclosing_method}()\");", "print current method to standard out"),
    FOREACH("org.eclipse.jdt.ls.templates.for_array", "java-statements", "for ($${1:${iterable_type}} $${2:${iterable_element}} : $${3:${iterable}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "iterate over an array or Iterable"),
    FORI("org.eclipse.jdt.ls.templates.for_iterable", "java-statements", "for ($${1:int} $${2:${index}} = $${3:0}; $${2:${index}} < $${4:${array}.length}; $${2:${index}}++) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "iterate over array"),
    WHILE("org.eclipse.jdt.ls.templates.while_condition", "java-statements", "while ($${1:${condition:var(boolean)}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "while statement"),
    DOWHILE("org.eclipse.jdt.ls.templates.do", "java-statements", "do {\n\t$$TM_SELECTED_TEXT$${0}\n} while ($${1:${condition:var(boolean)}});", "do-while statement"),
    IF("org.eclipse.jdt.ls.templates.if", "java-statements", "if ($${1:${condition:var(boolean)}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "if statement"),
    IFELSE("org.eclipse.jdt.ls.templates.ifelse", "java-statements", "if ($${1:${condition:var(boolean)}}) {\n\t$${2}\n} else {\n\t$${0}\n}", "if-else statement"),
    IFNULL("org.eclipse.jdt.ls.templates.ifnull", "java-statements", "if ($${1:${name:var}} == null) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "if statement checking for null"),
    IFNOTNULL("org.eclipse.jdt.ls.templates.ifnotnull", "java-statements", "if ($${1:${name:var}} != null) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "if statement checking for not null");

    private final String templateId;
    private final String contextType;
    private final String defaultContent;
    private final String description;

    private CodeSnippetTemplate(String templatesId, String contextType, String defaultContent, String description) {
        this.templateId = templatesId;
        this.contextType = contextType;
        this.defaultContent = defaultContent;
        this.description = description;
    }

    public Template createTemplate() {
        return new Template(this.name().toLowerCase(), this.description, this.contextType, this.defaultContent, false);
    }

    public String getId() {
        return this.templateId;
    }
}

