/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.reflect.misc.ReflectUtil;

public final class FieldFinder {
    public static Field findField(Class<?> clazz, String string) throws NoSuchFieldException {
        if (string == null) {
            throw new IllegalArgumentException("Field name is not set");
        }
        Field field = clazz.getField(string);
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new NoSuchFieldException("Field '" + string + "' is not public");
        }
        clazz = field.getDeclaringClass();
        if (!Modifier.isPublic(clazz.getModifiers()) || !ReflectUtil.isPackageAccessible(clazz)) {
            throw new NoSuchFieldException("Field '" + string + "' is not accessible");
        }
        return field;
    }

    public static Field findInstanceField(Class<?> clazz, String string) throws NoSuchFieldException {
        Field field = FieldFinder.findField(clazz, string);
        if (Modifier.isStatic(field.getModifiers())) {
            throw new NoSuchFieldException("Field '" + string + "' is static");
        }
        return field;
    }

    public static Field findStaticField(Class<?> clazz, String string) throws NoSuchFieldException {
        Field field = FieldFinder.findField(clazz, string);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new NoSuchFieldException("Field '" + string + "' is not static");
        }
        return field;
    }

    private FieldFinder() {
    }
}

