/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.LogStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.runtime.Log;
import sun.rmi.transport.Connection;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;
import sun.rmi.transport.tcp.MultiplexInputStream;
import sun.rmi.transport.tcp.MultiplexOutputStream;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.security.action.GetPropertyAction;

final class ConnectionMultiplexer {
    static int logLevel = LogStream.parseLevel(ConnectionMultiplexer.getLogLevel());
    static final Log multiplexLog = Log.getLog("sun.rmi.transport.tcp.multiplex", "multiplex", logLevel);
    private static final int OPEN = 225;
    private static final int CLOSE = 226;
    private static final int CLOSEACK = 227;
    private static final int REQUEST = 228;
    private static final int TRANSMIT = 229;
    private TCPChannel channel;
    private InputStream in;
    private OutputStream out;
    private boolean orig;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    private Hashtable<Integer, MultiplexConnectionInfo> connectionTable = new Hashtable(7);
    private int numConnections = 0;
    private static final int maxConnections = 256;
    private int lastID = 4097;
    private boolean alive = true;

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.multiplex.logLevel"));
    }

    public ConnectionMultiplexer(TCPChannel tCPChannel, InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.channel = tCPChannel;
        this.in = inputStream;
        this.out = outputStream;
        this.orig = bl;
        this.dataIn = new DataInputStream(inputStream);
        this.dataOut = new DataOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            int n;
            block18: while (true) {
                n = this.dataIn.readUnsignedByte();
                switch (n) {
                    case 225: {
                        MultiplexConnectionInfo multiplexConnectionInfo;
                        int n2 = this.dataIn.readUnsignedShort();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  OPEN " + n2);
                        }
                        if ((multiplexConnectionInfo = this.connectionTable.get(n2)) != null) {
                            throw new IOException("OPEN: Connection ID already exists");
                        }
                        multiplexConnectionInfo = new MultiplexConnectionInfo(n2);
                        multiplexConnectionInfo.in = new MultiplexInputStream(this, multiplexConnectionInfo, 2048);
                        multiplexConnectionInfo.out = new MultiplexOutputStream(this, multiplexConnectionInfo, 2048);
                        Object object = this.connectionTable;
                        synchronized (object) {
                            this.connectionTable.put(n2, multiplexConnectionInfo);
                            ++this.numConnections;
                        }
                        object = new TCPConnection(this.channel, multiplexConnectionInfo.in, multiplexConnectionInfo.out);
                        this.channel.acceptMultiplexConnection((Connection)object);
                        continue block18;
                    }
                    case 226: {
                        MultiplexConnectionInfo multiplexConnectionInfo;
                        int n2 = this.dataIn.readUnsignedShort();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  CLOSE " + n2);
                        }
                        if ((multiplexConnectionInfo = this.connectionTable.get(n2)) == null) {
                            throw new IOException("CLOSE: Invalid connection ID");
                        }
                        multiplexConnectionInfo.in.disconnect();
                        multiplexConnectionInfo.out.disconnect();
                        if (!multiplexConnectionInfo.closed) {
                            this.sendCloseAck(multiplexConnectionInfo);
                        }
                        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.remove(n2);
                            --this.numConnections;
                            continue block18;
                        }
                    }
                    case 227: {
                        MultiplexConnectionInfo multiplexConnectionInfo;
                        int n2 = this.dataIn.readUnsignedShort();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  CLOSEACK " + n2);
                        }
                        if ((multiplexConnectionInfo = this.connectionTable.get(n2)) == null) {
                            throw new IOException("CLOSEACK: Invalid connection ID");
                        }
                        if (!multiplexConnectionInfo.closed) {
                            throw new IOException("CLOSEACK: Connection not closed");
                        }
                        multiplexConnectionInfo.in.disconnect();
                        multiplexConnectionInfo.out.disconnect();
                        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.remove(n2);
                            --this.numConnections;
                            continue block18;
                        }
                    }
                    case 228: {
                        int n2 = this.dataIn.readUnsignedShort();
                        MultiplexConnectionInfo multiplexConnectionInfo = this.connectionTable.get(n2);
                        if (multiplexConnectionInfo == null) {
                            throw new IOException("REQUEST: Invalid connection ID");
                        }
                        int n3 = this.dataIn.readInt();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  REQUEST " + n2 + ": " + n3);
                        }
                        multiplexConnectionInfo.out.request(n3);
                        continue block18;
                    }
                    case 229: {
                        int n2 = this.dataIn.readUnsignedShort();
                        MultiplexConnectionInfo multiplexConnectionInfo = this.connectionTable.get(n2);
                        if (multiplexConnectionInfo == null) {
                            throw new IOException("SEND: Invalid connection ID");
                        }
                        int n3 = this.dataIn.readInt();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  TRANSMIT " + n2 + ": " + n3);
                        }
                        multiplexConnectionInfo.in.receive(n3, this.dataIn);
                        continue block18;
                    }
                }
                break;
            }
            throw new IOException("Invalid operation: " + Integer.toHexString(n));
        }
        catch (Throwable throwable) {
            this.shutDown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TCPConnection openConnection() throws IOException {
        int n;
        do {
            ++this.lastID;
            this.lastID &= Short.MAX_VALUE;
            n = this.lastID;
            if (!this.orig) continue;
            n |= 0x8000;
        } while (this.connectionTable.get(n) != null);
        MultiplexConnectionInfo multiplexConnectionInfo = new MultiplexConnectionInfo(n);
        multiplexConnectionInfo.in = new MultiplexInputStream(this, multiplexConnectionInfo, 2048);
        multiplexConnectionInfo.out = new MultiplexOutputStream(this, multiplexConnectionInfo, 2048);
        Object object = this.connectionTable;
        synchronized (object) {
            if (!this.alive) {
                throw new IOException("Multiplexer connection dead");
            }
            if (this.numConnections >= 256) {
                throw new IOException("Cannot exceed 256 simultaneous multiplexed connections");
            }
            this.connectionTable.put(n, multiplexConnectionInfo);
            ++this.numConnections;
        }
        object = this.dataOut;
        synchronized (object) {
            try {
                this.dataOut.writeByte(225);
                this.dataOut.writeShort(n);
                this.dataOut.flush();
            }
            catch (IOException iOException) {
                multiplexLog.log(Log.BRIEF, "exception: ", iOException);
                this.shutDown();
                throw iOException;
            }
        }
        return new TCPConnection(this.channel, multiplexConnectionInfo.in, multiplexConnectionInfo.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
        synchronized (hashtable) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            Enumeration<MultiplexConnectionInfo> enumeration = this.connectionTable.elements();
            while (enumeration.hasMoreElements()) {
                MultiplexConnectionInfo multiplexConnectionInfo = enumeration.nextElement();
                multiplexConnectionInfo.in.disconnect();
                multiplexConnectionInfo.out.disconnect();
            }
            this.connectionTable.clear();
            this.numConnections = 0;
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequest(MultiplexConnectionInfo multiplexConnectionInfo, int n) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(228);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.writeInt(n);
                    this.dataOut.flush();
                }
                catch (IOException iOException) {
                    multiplexLog.log(Log.BRIEF, "exception: ", iOException);
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendTransmit(MultiplexConnectionInfo multiplexConnectionInfo, byte[] byArray, int n, int n2) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(229);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.writeInt(n2);
                    this.dataOut.write(byArray, n, n2);
                    this.dataOut.flush();
                }
                catch (IOException iOException) {
                    multiplexLog.log(Log.BRIEF, "exception: ", iOException);
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendClose(MultiplexConnectionInfo multiplexConnectionInfo) throws IOException {
        multiplexConnectionInfo.out.disconnect();
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(226);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.flush();
                    multiplexConnectionInfo.closed = true;
                }
                catch (IOException iOException) {
                    multiplexLog.log(Log.BRIEF, "exception: ", iOException);
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCloseAck(MultiplexConnectionInfo multiplexConnectionInfo) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !multiplexConnectionInfo.closed) {
                try {
                    this.dataOut.writeByte(227);
                    this.dataOut.writeShort(multiplexConnectionInfo.id);
                    this.dataOut.flush();
                    multiplexConnectionInfo.closed = true;
                }
                catch (IOException iOException) {
                    multiplexLog.log(Log.BRIEF, "exception: ", iOException);
                    this.shutDown();
                    throw iOException;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutDown();
    }
}

