/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.DEREncodedKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class DEREncodedKeyValueResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(DEREncodedKeyValueResolver.class);

    @Override
    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignature11Space(element, "DEREncodedKeyValue");
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.debug("Can I resolve {}", element.getTagName());
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        try {
            DEREncodedKeyValue dEREncodedKeyValue = new DEREncodedKeyValue(element, string);
            return dEREncodedKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
            return null;
        }
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }
}

