/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

class Comparators {
    private Comparators() {
        throw new AssertionError((Object)"no instances");
    }

    static final class NullComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -7569533591570686392L;
        private final boolean nullFirst;
        private final Comparator<T> real;

        NullComparator(boolean bl, Comparator<? super T> comparator) {
            this.nullFirst = bl;
            this.real = comparator;
        }

        @Override
        public int compare(T t, T t2) {
            if (t == null) {
                return t2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (t2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real == null ? 0 : this.real.compare(t, t2);
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator);
            return new NullComparator<T>(this.nullFirst, this.real == null ? comparator : this.real.thenComparing(comparator));
        }

        @Override
        public Comparator<T> reversed() {
            return new NullComparator<T>(!this.nullFirst, this.real == null ? null : this.real.reversed());
        }
    }

    static enum NaturalOrderComparator implements Comparator<Comparable<Object>>
    {
        INSTANCE;


        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            return comparable.compareTo(comparable2);
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return Comparator.reverseOrder();
        }
    }
}

