/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.PCDesc;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.MethodData;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.JByteField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class NMethod
extends CodeBlob {
    private static long pcDescSize;
    private static AddressField methodField;
    private static CIntegerField entryBCIField;
    private static AddressField osrLinkField;
    private static AddressField scavengeRootLinkField;
    private static JByteField scavengeRootStateField;
    private static CIntegerField exceptionOffsetField;
    private static CIntegerField deoptOffsetField;
    private static CIntegerField deoptMhOffsetField;
    private static CIntegerField origPCOffsetField;
    private static CIntegerField stubOffsetField;
    private static CIntegerField oopsOffsetField;
    private static CIntegerField metadataOffsetField;
    private static CIntegerField scopesDataOffsetField;
    private static CIntegerField scopesPCsOffsetField;
    private static CIntegerField dependenciesOffsetField;
    private static CIntegerField handlerTableOffsetField;
    private static CIntegerField nulChkTableOffsetField;
    private static CIntegerField nmethodEndOffsetField;
    private static AddressField entryPointField;
    private static AddressField verifiedEntryPointField;
    private static AddressField osrEntryPointField;
    private static JIntField lockCountField;
    private static CIntegerField stackTraversalMarkField;
    private static CIntegerField compLevelField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("nmethod");
        methodField = type.getAddressField("_method");
        entryBCIField = type.getCIntegerField("_entry_bci");
        osrLinkField = type.getAddressField("_osr_link");
        scavengeRootLinkField = type.getAddressField("_scavenge_root_link");
        scavengeRootStateField = type.getJByteField("_scavenge_root_state");
        exceptionOffsetField = type.getCIntegerField("_exception_offset");
        deoptOffsetField = type.getCIntegerField("_deoptimize_offset");
        deoptMhOffsetField = type.getCIntegerField("_deoptimize_mh_offset");
        origPCOffsetField = type.getCIntegerField("_orig_pc_offset");
        stubOffsetField = type.getCIntegerField("_stub_offset");
        oopsOffsetField = type.getCIntegerField("_oops_offset");
        metadataOffsetField = type.getCIntegerField("_metadata_offset");
        scopesDataOffsetField = type.getCIntegerField("_scopes_data_offset");
        scopesPCsOffsetField = type.getCIntegerField("_scopes_pcs_offset");
        dependenciesOffsetField = type.getCIntegerField("_dependencies_offset");
        handlerTableOffsetField = type.getCIntegerField("_handler_table_offset");
        nulChkTableOffsetField = type.getCIntegerField("_nul_chk_table_offset");
        nmethodEndOffsetField = type.getCIntegerField("_nmethod_end_offset");
        entryPointField = type.getAddressField("_entry_point");
        verifiedEntryPointField = type.getAddressField("_verified_entry_point");
        osrEntryPointField = type.getAddressField("_osr_entry_point");
        lockCountField = type.getJIntField("_lock_count");
        stackTraversalMarkField = type.getCIntegerField("_stack_traversal_mark");
        compLevelField = type.getCIntegerField("_comp_level");
        pcDescSize = db.lookupType("PcDesc").getSize();
    }

    public NMethod(Address addr) {
        super(addr);
    }

    @Override
    public Address getAddress() {
        return this.addr;
    }

    public Method getMethod() {
        return (Method)Metadata.instantiateWrapperFor(methodField.getValue(this.addr));
    }

    @Override
    public boolean isNMethod() {
        return true;
    }

    @Override
    public boolean isJavaMethod() {
        return !this.getMethod().isNative();
    }

    @Override
    public boolean isNativeMethod() {
        return this.getMethod().isNative();
    }

    @Override
    public boolean isOSRMethod() {
        return this.getEntryBCI() != VM.getVM().getInvocationEntryBCI();
    }

    public Address constantsBegin() {
        return this.contentBegin();
    }

    public Address constantsEnd() {
        return this.getEntryPoint();
    }

    public Address instsBegin() {
        return this.codeBegin();
    }

    public Address instsEnd() {
        return this.headerBegin().addOffsetTo(this.getStubOffset());
    }

    public Address exceptionBegin() {
        return this.headerBegin().addOffsetTo(this.getExceptionOffset());
    }

    public Address deoptHandlerBegin() {
        return this.headerBegin().addOffsetTo(this.getDeoptOffset());
    }

    public Address deoptMhHandlerBegin() {
        return this.headerBegin().addOffsetTo(this.getDeoptMhOffset());
    }

    public Address stubBegin() {
        return this.headerBegin().addOffsetTo(this.getStubOffset());
    }

    public Address stubEnd() {
        return this.headerBegin().addOffsetTo(this.getOopsOffset());
    }

    public Address oopsBegin() {
        return this.headerBegin().addOffsetTo(this.getOopsOffset());
    }

    public Address oopsEnd() {
        return this.headerBegin().addOffsetTo(this.getMetadataOffset());
    }

    public Address metadataBegin() {
        return this.headerBegin().addOffsetTo(this.getMetadataOffset());
    }

    public Address metadataEnd() {
        return this.headerBegin().addOffsetTo(this.getScopesDataOffset());
    }

    public Address scopesDataBegin() {
        return this.headerBegin().addOffsetTo(this.getScopesDataOffset());
    }

    public Address scopesDataEnd() {
        return this.headerBegin().addOffsetTo(this.getScopesPCsOffset());
    }

    public Address scopesPCsBegin() {
        return this.headerBegin().addOffsetTo(this.getScopesPCsOffset());
    }

    public Address scopesPCsEnd() {
        return this.headerBegin().addOffsetTo(this.getDependenciesOffset());
    }

    public Address dependenciesBegin() {
        return this.headerBegin().addOffsetTo(this.getDependenciesOffset());
    }

    public Address dependenciesEnd() {
        return this.headerBegin().addOffsetTo(this.getHandlerTableOffset());
    }

    public Address handlerTableBegin() {
        return this.headerBegin().addOffsetTo(this.getHandlerTableOffset());
    }

    public Address handlerTableEnd() {
        return this.headerBegin().addOffsetTo(this.getNulChkTableOffset());
    }

    public Address nulChkTableBegin() {
        return this.headerBegin().addOffsetTo(this.getNulChkTableOffset());
    }

    public Address nulChkTableEnd() {
        return this.headerBegin().addOffsetTo(this.getNMethodEndOffset());
    }

    public int constantsSize() {
        return (int)this.constantsEnd().minus(this.constantsBegin());
    }

    public int instsSize() {
        return (int)this.instsEnd().minus(this.instsBegin());
    }

    public int stubSize() {
        return (int)this.stubEnd().minus(this.stubBegin());
    }

    public int oopsSize() {
        return (int)this.oopsEnd().minus(this.oopsBegin());
    }

    public int metadataSize() {
        return (int)this.metadataEnd().minus(this.metadataBegin());
    }

    public int scopesDataSize() {
        return (int)this.scopesDataEnd().minus(this.scopesDataBegin());
    }

    public int scopesPCsSize() {
        return (int)this.scopesPCsEnd().minus(this.scopesPCsBegin());
    }

    public int dependenciesSize() {
        return (int)this.dependenciesEnd().minus(this.dependenciesBegin());
    }

    public int handlerTableSize() {
        return (int)this.handlerTableEnd().minus(this.handlerTableBegin());
    }

    public int nulChkTableSize() {
        return (int)this.nulChkTableEnd().minus(this.nulChkTableBegin());
    }

    public int origPCOffset() {
        return (int)origPCOffsetField.getValue(this.addr);
    }

    public int totalSize() {
        return this.constantsSize() + this.instsSize() + this.stubSize() + this.scopesDataSize() + this.scopesPCsSize() + this.dependenciesSize() + this.handlerTableSize() + this.nulChkTableSize();
    }

    public boolean constantsContains(Address addr) {
        return this.constantsBegin().lessThanOrEqual(addr) && this.constantsEnd().greaterThan(addr);
    }

    public boolean instsContains(Address addr) {
        return this.instsBegin().lessThanOrEqual(addr) && this.instsEnd().greaterThan(addr);
    }

    public boolean stubContains(Address addr) {
        return this.stubBegin().lessThanOrEqual(addr) && this.stubEnd().greaterThan(addr);
    }

    public boolean oopsContains(Address addr) {
        return this.oopsBegin().lessThanOrEqual(addr) && this.oopsEnd().greaterThan(addr);
    }

    public boolean metadataContains(Address addr) {
        return this.metadataBegin().lessThanOrEqual(addr) && this.metadataEnd().greaterThan(addr);
    }

    public boolean scopesDataContains(Address addr) {
        return this.scopesDataBegin().lessThanOrEqual(addr) && this.scopesDataEnd().greaterThan(addr);
    }

    public boolean scopesPCsContains(Address addr) {
        return this.scopesPCsBegin().lessThanOrEqual(addr) && this.scopesPCsEnd().greaterThan(addr);
    }

    public boolean handlerTableContains(Address addr) {
        return this.handlerTableBegin().lessThanOrEqual(addr) && this.handlerTableEnd().greaterThan(addr);
    }

    public boolean nulChkTableContains(Address addr) {
        return this.nulChkTableBegin().lessThanOrEqual(addr) && this.nulChkTableEnd().greaterThan(addr);
    }

    public int getOopsLength() {
        return (int)((long)this.oopsSize() / VM.getVM().getOopSize());
    }

    public int getMetadataLength() {
        return (int)((long)this.metadataSize() / VM.getVM().getOopSize());
    }

    public Address getEntryPoint() {
        return entryPointField.getValue(this.addr);
    }

    public Address getVerifiedEntryPoint() {
        return verifiedEntryPointField.getValue(this.addr);
    }

    public OopHandle getOopAt(int index) {
        if (index == 0) {
            return null;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index > 0 && index <= this.getOopsLength(), "must be a valid non-zero index");
        }
        return this.oopsBegin().getOopHandleAt((long)(index - 1) * VM.getVM().getOopSize());
    }

    public Address getMetadataAt(int index) {
        if (index == 0) {
            return null;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index > 0 && index <= this.getMetadataLength(), "must be a valid non-zero index");
        }
        return this.metadataBegin().getAddressAt((long)(index - 1) * VM.getVM().getOopSize());
    }

    public Method getMethodAt(int index) {
        return (Method)Metadata.instantiateWrapperFor(this.getMetadataAt(index));
    }

    @Override
    public boolean isZombie() {
        return false;
    }

    public int getOSREntryBCI() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getEntryBCI() != VM.getVM().getInvocationEntryBCI(), "wrong kind of nmethod");
        }
        return this.getEntryBCI();
    }

    public NMethod getOSRLink() {
        return (NMethod)VMObjectFactory.newObject(NMethod.class, osrLinkField.getValue(this.addr));
    }

    public NMethod getScavengeRootLink() {
        return (NMethod)VMObjectFactory.newObject(NMethod.class, scavengeRootLinkField.getValue(this.addr));
    }

    public int getScavengeRootState() {
        return scavengeRootStateField.getValue(this.addr);
    }

    public boolean isMethodHandleReturn(Address returnPc) {
        PCDesc pd = this.getPCDescAt(returnPc);
        if (pd == null) {
            return false;
        }
        return pd.isMethodHandleInvoke();
    }

    public boolean isDeoptPc(Address pc) {
        return this.isDeoptEntry(pc) || this.isDeoptMhEntry(pc);
    }

    public boolean isDeoptEntry(Address pc) {
        return pc == this.deoptHandlerBegin();
    }

    public boolean isDeoptMhEntry(Address pc) {
        return pc == this.deoptMhHandlerBegin();
    }

    public boolean canBeDeoptimized() {
        return this.isJavaMethod();
    }

    @Override
    public boolean isLockedByVM() {
        return lockCountField.getValue(this.addr) > 0;
    }

    public PCDesc getPCDescAt(Address pc) {
        Address p = this.scopesPCsBegin();
        while (p.lessThan(this.scopesPCsEnd())) {
            PCDesc pcDesc = new PCDesc(p);
            if (pcDesc.getRealPC(this).equals(pc)) {
                return pcDesc;
            }
            p = p.addOffsetTo(pcDescSize);
        }
        return null;
    }

    public ScopeDesc getScopeDescAt(Address pc) {
        PCDesc pd = this.getPCDescAt(pc);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(pd != null, "scope must be present");
        }
        return new ScopeDesc(this, pd.getScopeDecodeOffset(), pd.getObjDecodeOffset(), pd.getReexecute());
    }

    public PCDesc getPCDescNearDbg(Address pc) {
        PCDesc bestGuessPCDesc = null;
        long bestDistance = 0L;
        Address p = this.scopesPCsBegin();
        while (p.lessThan(this.scopesPCsEnd())) {
            PCDesc pcDesc = new PCDesc(p);
            if (pcDesc.getScopeDecodeOffset() != 0) {
                long distance = -pcDesc.getRealPC(this).minus(pc);
                if (bestGuessPCDesc == null || distance >= 0L && distance < bestDistance) {
                    bestGuessPCDesc = pcDesc;
                    bestDistance = distance;
                }
            }
            p = p.addOffsetTo(pcDescSize);
        }
        return bestGuessPCDesc;
    }

    PCDesc find_pc_desc(long pc, boolean approximate) {
        return this.find_pc_desc_internal(pc, approximate);
    }

    PCDesc find_pc_desc_internal(long pc, boolean approximate) {
        PCDesc m;
        Address mid;
        long base_address = VM.getAddressValue(this.codeBegin());
        int pc_offset = (int)(pc - base_address);
        Address lower = this.scopesPCsBegin();
        Address upper = this.scopesPCsEnd();
        if (lower.greaterThan(upper = upper.addOffsetTo(-pcDescSize))) {
            return null;
        }
        int LOG2_RADIX = 4;
        int RADIX = 1 << LOG2_RADIX;
        block0: for (int step = 1 << LOG2_RADIX * 3; step > 1; step >>= LOG2_RADIX) {
            while ((mid = lower.addOffsetTo((long)step * pcDescSize)).lessThan(upper)) {
                PCDesc m2 = new PCDesc(mid);
                if (m2.getPCOffset() < pc_offset) {
                    lower = mid;
                    continue;
                }
                upper = mid;
                continue block0;
            }
        }
        while ((m = new PCDesc(mid = lower.addOffsetTo(pcDescSize))).getPCOffset() < pc_offset) {
            lower = mid;
        }
        upper = mid;
        PCDesc u = new PCDesc(upper);
        if (NMethod.match_desc(u, pc_offset, approximate)) {
            return u;
        }
        return null;
    }

    PCDesc pc_desc_at(long pc) {
        return this.find_pc_desc(pc, false);
    }

    PCDesc pc_desc_near(long pc) {
        return this.find_pc_desc(pc, true);
    }

    public ScopeDesc scope_desc_in(long begin, long end) {
        PCDesc p = this.pc_desc_near(begin + 1L);
        if (p != null && VM.getAddressValue(p.getRealPC(this)) <= end) {
            return new ScopeDesc(this, p.getScopeDecodeOffset(), p.getObjDecodeOffset(), p.getReexecute());
        }
        return null;
    }

    static boolean match_desc(PCDesc pc, int pc_offset, boolean approximate) {
        if (!approximate) {
            return pc.getPCOffset() == pc_offset;
        }
        PCDesc prev = new PCDesc(pc.getAddress().addOffsetTo(-pcDescSize));
        return prev.getPCOffset() < pc_offset && pc_offset <= pc.getPCOffset();
    }

    public ScopeDesc getScopeDescNearDbg(Address pc) {
        PCDesc pd = this.getPCDescNearDbg(pc);
        if (pd == null) {
            return null;
        }
        return new ScopeDesc(this, pd.getScopeDecodeOffset(), pd.getObjDecodeOffset(), pd.getReexecute());
    }

    public Map getSafepoints() {
        HashMap<Address, PCDesc> safepoints = new HashMap<Address, PCDesc>();
        Address p = null;
        p = this.scopesPCsBegin();
        while (p.lessThan(this.scopesPCsEnd())) {
            PCDesc pcDesc = new PCDesc(p);
            Address pc = pcDesc.getRealPC(this);
            safepoints.put(pc, pcDesc);
            p = p.addOffsetTo(pcDescSize);
        }
        return safepoints;
    }

    public static int getEntryPointOffset() {
        return (int)entryPointField.getOffset();
    }

    public static int getVerifiedEntryPointOffset() {
        return (int)verifiedEntryPointField.getOffset();
    }

    public static int getOSREntryPointOffset() {
        return (int)osrEntryPointField.getOffset();
    }

    public static int getEntryBCIOffset() {
        return (int)entryBCIField.getOffset();
    }

    public static int getMethodOffset() {
        return (int)methodField.getOffset();
    }

    @Override
    public void print() {
        this.printOn(System.out);
    }

    @Override
    protected void printComponentsOn(PrintStream tty) {
        tty.println(" content: [" + this.contentBegin() + ", " + this.contentEnd() + "), " + " code: [" + this.codeBegin() + ", " + this.codeEnd() + "), " + " data: [" + this.dataBegin() + ", " + this.dataEnd() + "), " + " oops: [" + this.oopsBegin() + ", " + this.oopsEnd() + "), " + " frame size: " + this.getFrameSize());
    }

    @Override
    public String toString() {
        Method method = this.getMethod();
        return "NMethod for " + method.getMethodHolder().getName().asString() + "." + method.getName().asString() + method.getSignature().asString() + "==>n" + super.toString();
    }

    public String flagsToString() {
        return "";
    }

    @Override
    public String getName() {
        Method method = this.getMethod();
        return "NMethod for " + method.getMethodHolder().getName().asString() + "." + method.getName().asString() + method.getSignature().asString();
    }

    public void dumpReplayData(PrintStream out) {
        HashMap<Metadata, Metadata> h = new HashMap<Metadata, Metadata>();
        for (int i = 1; i < this.getMetadataLength(); ++i) {
            Metadata meta = Metadata.instantiateWrapperFor(this.getMetadataAt(i));
            System.err.println(meta);
            if (h.get(meta) != null) continue;
            h.put(meta, meta);
            if (meta instanceof InstanceKlass) {
                ((InstanceKlass)meta).dumpReplayData(out);
                continue;
            }
            if (!(meta instanceof Method)) continue;
            ((Method)meta).dumpReplayData(out);
            MethodData mdo = ((Method)meta).getMethodData();
            if (mdo == null) continue;
            mdo.dumpReplayData(out);
        }
        Method method = this.getMethod();
        if (h.get(method) == null) {
            method.dumpReplayData(out);
            MethodData mdo = method.getMethodData();
            if (mdo != null) {
                mdo.dumpReplayData(out);
            }
        }
        if (h.get(method.getMethodHolder()) == null) {
            method.getMethodHolder().dumpReplayData(out);
        }
        InstanceKlass holder = method.getMethodHolder();
        out.println("compile " + holder.getName().asString() + " " + OopUtilities.escapeString(method.getName().asString()) + " " + method.getSignature().asString() + " " + this.getEntryBCI() + " " + this.getCompLevel());
    }

    private int getEntryBCI() {
        return (int)entryBCIField.getValue(this.addr);
    }

    private int getExceptionOffset() {
        return (int)exceptionOffsetField.getValue(this.addr);
    }

    private int getDeoptOffset() {
        return (int)deoptOffsetField.getValue(this.addr);
    }

    private int getDeoptMhOffset() {
        return (int)deoptMhOffsetField.getValue(this.addr);
    }

    private int getStubOffset() {
        return (int)stubOffsetField.getValue(this.addr);
    }

    private int getOopsOffset() {
        return (int)oopsOffsetField.getValue(this.addr);
    }

    private int getMetadataOffset() {
        return (int)metadataOffsetField.getValue(this.addr);
    }

    private int getScopesDataOffset() {
        return (int)scopesDataOffsetField.getValue(this.addr);
    }

    private int getScopesPCsOffset() {
        return (int)scopesPCsOffsetField.getValue(this.addr);
    }

    private int getDependenciesOffset() {
        return (int)dependenciesOffsetField.getValue(this.addr);
    }

    private int getHandlerTableOffset() {
        return (int)handlerTableOffsetField.getValue(this.addr);
    }

    private int getNulChkTableOffset() {
        return (int)nulChkTableOffsetField.getValue(this.addr);
    }

    private int getNMethodEndOffset() {
        return (int)nmethodEndOffsetField.getValue(this.addr);
    }

    private int getCompLevel() {
        return (int)compLevelField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                NMethod.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

