/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.AudioSynthesizer;
import com.sun.media.sound.AudioSynthesizerPropertyInfo;
import com.sun.media.sound.EmergencySoundbank;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelByteBufferWavetable;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelInstrumentComparator;
import com.sun.media.sound.ModelMappedInstrument;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ReferenceCountingDevice;
import com.sun.media.sound.SF2Soundbank;
import com.sun.media.sound.SoftAudioPusher;
import com.sun.media.sound.SoftChannel;
import com.sun.media.sound.SoftChannelProxy;
import com.sun.media.sound.SoftCubicResampler;
import com.sun.media.sound.SoftInstrument;
import com.sun.media.sound.SoftJitterCorrector;
import com.sun.media.sound.SoftLanczosResampler;
import com.sun.media.sound.SoftLinearResampler;
import com.sun.media.sound.SoftLinearResampler2;
import com.sun.media.sound.SoftMainMixer;
import com.sun.media.sound.SoftPointResampler;
import com.sun.media.sound.SoftReceiver;
import com.sun.media.sound.SoftResampler;
import com.sun.media.sound.SoftSincResampler;
import com.sun.media.sound.SoftTuning;
import com.sun.media.sound.SoftVoice;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class SoftSynthesizer
implements AudioSynthesizer,
ReferenceCountingDevice {
    static final String INFO_NAME = "Gervill";
    static final String INFO_VENDOR = "OpenJDK";
    static final String INFO_DESCRIPTION = "Software MIDI Synthesizer";
    static final String INFO_VERSION = "1.0";
    static final MidiDevice.Info info = new Info();
    private static SourceDataLine testline = null;
    private static Soundbank defaultSoundBank = null;
    WeakAudioStream weakstream = null;
    final Object control_mutex = this;
    int voiceIDCounter = 0;
    int voice_allocation_mode = 0;
    boolean load_default_soundbank = false;
    boolean reverb_light = true;
    boolean reverb_on = true;
    boolean chorus_on = true;
    boolean agc_on = true;
    SoftChannel[] channels;
    SoftChannelProxy[] external_channels = null;
    private boolean largemode = false;
    private int gmmode = 0;
    private int deviceid = 0;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private SourceDataLine sourceDataLine = null;
    private SoftAudioPusher pusher = null;
    private AudioInputStream pusher_stream = null;
    private float controlrate = 147.0f;
    private boolean open = false;
    private boolean implicitOpen = false;
    private String resamplerType = "linear";
    private SoftResampler resampler = new SoftLinearResampler();
    private int number_of_midi_channels = 16;
    private int maxpoly = 64;
    private long latency = 200000L;
    private boolean jitter_correction = false;
    private SoftMainMixer mainmixer;
    private SoftVoice[] voices;
    private Map<String, SoftTuning> tunings = new HashMap<String, SoftTuning>();
    private Map<String, SoftInstrument> inslist = new HashMap<String, SoftInstrument>();
    private Map<String, ModelInstrument> loadedlist = new HashMap<String, ModelInstrument>();
    private ArrayList<Receiver> recvslist = new ArrayList();

    private void getBuffers(ModelInstrument modelInstrument, List<ModelByteBuffer> list) {
        for (ModelPerformer modelPerformer : modelInstrument.getPerformers()) {
            if (modelPerformer.getOscillators() == null) continue;
            for (ModelOscillator modelOscillator : modelPerformer.getOscillators()) {
                if (!(modelOscillator instanceof ModelByteBufferWavetable)) continue;
                ModelByteBufferWavetable modelByteBufferWavetable = (ModelByteBufferWavetable)modelOscillator;
                ModelByteBuffer modelByteBuffer = modelByteBufferWavetable.getBuffer();
                if (modelByteBuffer != null) {
                    list.add(modelByteBuffer);
                }
                if ((modelByteBuffer = modelByteBufferWavetable.get8BitExtensionBuffer()) == null) continue;
                list.add(modelByteBuffer);
            }
        }
    }

    private boolean loadSamples(List<ModelInstrument> list) {
        if (this.largemode) {
            return true;
        }
        ArrayList<ModelByteBuffer> arrayList = new ArrayList<ModelByteBuffer>();
        for (ModelInstrument modelInstrument : list) {
            this.getBuffers(modelInstrument, arrayList);
        }
        try {
            ModelByteBuffer.loadAll(arrayList);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadInstruments(List<ModelInstrument> list) {
        if (!this.isOpen()) {
            return false;
        }
        if (!this.loadSamples(list)) {
            return false;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.channels != null) {
                for (SoftChannel object2 : this.channels) {
                    object2.current_instrument = null;
                    object2.current_director = null;
                }
            }
            for (Instrument instrument : list) {
                String string = this.patchToString(instrument.getPatch());
                SoftInstrument softInstrument = new SoftInstrument((ModelInstrument)instrument);
                this.inslist.put(string, softInstrument);
                this.loadedlist.put(string, (ModelInstrument)instrument);
            }
        }
        return true;
    }

    private void processPropertyInfo(Map<String, Object> map) {
        AudioSynthesizerPropertyInfo[] audioSynthesizerPropertyInfoArray = this.getPropertyInfo(map);
        String string = (String)audioSynthesizerPropertyInfoArray[0].value;
        if (string.equalsIgnoreCase("point")) {
            this.resampler = new SoftPointResampler();
            this.resamplerType = "point";
        } else if (string.equalsIgnoreCase("linear")) {
            this.resampler = new SoftLinearResampler2();
            this.resamplerType = "linear";
        } else if (string.equalsIgnoreCase("linear1")) {
            this.resampler = new SoftLinearResampler();
            this.resamplerType = "linear1";
        } else if (string.equalsIgnoreCase("linear2")) {
            this.resampler = new SoftLinearResampler2();
            this.resamplerType = "linear2";
        } else if (string.equalsIgnoreCase("cubic")) {
            this.resampler = new SoftCubicResampler();
            this.resamplerType = "cubic";
        } else if (string.equalsIgnoreCase("lanczos")) {
            this.resampler = new SoftLanczosResampler();
            this.resamplerType = "lanczos";
        } else if (string.equalsIgnoreCase("sinc")) {
            this.resampler = new SoftSincResampler();
            this.resamplerType = "sinc";
        }
        this.setFormat((AudioFormat)audioSynthesizerPropertyInfoArray[2].value);
        this.controlrate = ((Float)audioSynthesizerPropertyInfoArray[1].value).floatValue();
        this.latency = (Long)audioSynthesizerPropertyInfoArray[3].value;
        this.deviceid = (Integer)audioSynthesizerPropertyInfoArray[4].value;
        this.maxpoly = (Integer)audioSynthesizerPropertyInfoArray[5].value;
        this.reverb_on = (Boolean)audioSynthesizerPropertyInfoArray[6].value;
        this.chorus_on = (Boolean)audioSynthesizerPropertyInfoArray[7].value;
        this.agc_on = (Boolean)audioSynthesizerPropertyInfoArray[8].value;
        this.largemode = (Boolean)audioSynthesizerPropertyInfoArray[9].value;
        this.number_of_midi_channels = (Integer)audioSynthesizerPropertyInfoArray[10].value;
        this.jitter_correction = (Boolean)audioSynthesizerPropertyInfoArray[11].value;
        this.reverb_light = (Boolean)audioSynthesizerPropertyInfoArray[12].value;
        this.load_default_soundbank = (Boolean)audioSynthesizerPropertyInfoArray[13].value;
    }

    private String patchToString(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            return "p." + patch.getProgram() + "." + patch.getBank();
        }
        return patch.getProgram() + "." + patch.getBank();
    }

    private void setFormat(AudioFormat audioFormat) {
        if (audioFormat.getChannels() > 2) {
            throw new IllegalArgumentException("Only mono and stereo audio supported.");
        }
        if (AudioFloatConverter.getConverter(audioFormat) == null) {
            throw new IllegalArgumentException("Audio format not supported.");
        }
        this.format = audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReceiver(Receiver receiver) {
        boolean bl = false;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.recvslist.remove(receiver) && this.implicitOpen && this.recvslist.isEmpty()) {
                bl = true;
            }
        }
        if (bl) {
            this.close();
        }
    }

    SoftMainMixer getMainMixer() {
        if (!this.isOpen()) {
            return null;
        }
        return this.mainmixer;
    }

    SoftInstrument findInstrument(int n, int n2, int n3) {
        if (n2 >> 7 == 120 || n2 >> 7 == 121) {
            SoftInstrument softInstrument = this.inslist.get(n + "." + n2);
            if (softInstrument != null) {
                return softInstrument;
            }
            String string = n2 >> 7 == 120 ? "p." : "";
            softInstrument = this.inslist.get(string + n + "." + ((n2 & 0x80) << 7));
            if (softInstrument != null) {
                return softInstrument;
            }
            softInstrument = this.inslist.get(string + n + "." + (n2 & 0x80));
            if (softInstrument != null) {
                return softInstrument;
            }
            softInstrument = this.inslist.get(string + n + ".0");
            if (softInstrument != null) {
                return softInstrument;
            }
            softInstrument = this.inslist.get(string + n + "0.0");
            if (softInstrument != null) {
                return softInstrument;
            }
            return null;
        }
        String string = n3 == 9 ? "p." : "";
        SoftInstrument softInstrument = this.inslist.get(string + n + "." + n2);
        if (softInstrument != null) {
            return softInstrument;
        }
        softInstrument = this.inslist.get(string + n + ".0");
        if (softInstrument != null) {
            return softInstrument;
        }
        softInstrument = this.inslist.get(string + "0.0");
        if (softInstrument != null) {
            return softInstrument;
        }
        return null;
    }

    int getVoiceAllocationMode() {
        return this.voice_allocation_mode;
    }

    int getGeneralMidiMode() {
        return this.gmmode;
    }

    void setGeneralMidiMode(int n) {
        this.gmmode = n;
    }

    int getDeviceID() {
        return this.deviceid;
    }

    float getControlRate() {
        return this.controlrate;
    }

    SoftVoice[] getVoices() {
        return this.voices;
    }

    SoftTuning getTuning(Patch patch) {
        String string = this.patchToString(patch);
        SoftTuning softTuning = this.tunings.get(string);
        if (softTuning == null) {
            softTuning = new SoftTuning(patch);
            this.tunings.put(string, softTuning);
        }
        return softTuning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatency() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.latency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPolyphony() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.maxpoly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MidiChannel[] getChannels() {
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.external_channels == null) {
                this.external_channels = new SoftChannelProxy[16];
                for (int i = 0; i < this.external_channels.length; ++i) {
                    this.external_channels[i] = new SoftChannelProxy();
                }
            }
            MidiChannel[] midiChannelArray = this.isOpen() ? new MidiChannel[this.channels.length] : new MidiChannel[16];
            for (int i = 0; i < midiChannelArray.length; ++i) {
                midiChannelArray[i] = this.external_channels[i];
            }
            return midiChannelArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoiceStatus[] getVoiceStatus() {
        if (!this.isOpen()) {
            VoiceStatus[] voiceStatusArray = new VoiceStatus[this.getMaxPolyphony()];
            for (int i = 0; i < voiceStatusArray.length; ++i) {
                VoiceStatus voiceStatus = new VoiceStatus();
                voiceStatus.active = false;
                voiceStatus.bank = 0;
                voiceStatus.channel = 0;
                voiceStatus.note = 0;
                voiceStatus.program = 0;
                voiceStatus.volume = 0;
                voiceStatusArray[i] = voiceStatus;
            }
            return voiceStatusArray;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            VoiceStatus[] voiceStatusArray = new VoiceStatus[this.voices.length];
            for (int i = 0; i < this.voices.length; ++i) {
                SoftVoice softVoice = this.voices[i];
                VoiceStatus voiceStatus = new VoiceStatus();
                voiceStatus.active = softVoice.active;
                voiceStatus.bank = softVoice.bank;
                voiceStatus.channel = softVoice.channel;
                voiceStatus.note = softVoice.note;
                voiceStatus.program = softVoice.program;
                voiceStatus.volume = softVoice.volume;
                voiceStatusArray[i] = voiceStatus;
            }
            return voiceStatusArray;
        }
    }

    @Override
    public boolean isSoundbankSupported(Soundbank soundbank) {
        for (Instrument instrument : soundbank.getInstruments()) {
            if (instrument instanceof ModelInstrument) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean loadInstrument(Instrument instrument) {
        if (instrument == null || !(instrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + instrument);
        }
        ArrayList<ModelInstrument> arrayList = new ArrayList<ModelInstrument>();
        arrayList.add((ModelInstrument)instrument);
        return this.loadInstruments(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadInstrument(Instrument instrument) {
        if (instrument == null || !(instrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + instrument);
        }
        if (!this.isOpen()) {
            return;
        }
        String string = this.patchToString(instrument.getPatch());
        Object object = this.control_mutex;
        synchronized (object) {
            for (SoftChannel softChannel : this.channels) {
                softChannel.current_instrument = null;
            }
            this.inslist.remove(string);
            this.loadedlist.remove(string);
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].allSoundOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        if (instrument == null) {
            throw new NullPointerException();
        }
        if (instrument2 == null) {
            throw new NullPointerException();
        }
        if (!(instrument instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + instrument.toString());
        }
        if (!(instrument2 instanceof ModelInstrument)) {
            throw new IllegalArgumentException("Unsupported instrument: " + instrument2.toString());
        }
        if (!this.isOpen()) {
            return false;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.loadedlist.containsValue(instrument2)) {
                throw new IllegalArgumentException("Instrument to is not loaded.");
            }
            this.unloadInstrument(instrument);
            ModelMappedInstrument modelMappedInstrument = new ModelMappedInstrument((ModelInstrument)instrument2, instrument.getPatch());
            return this.loadInstrument(modelMappedInstrument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Soundbank getDefaultSoundbank() {
        Class<SoftSynthesizer> clazz = SoftSynthesizer.class;
        synchronized (SoftSynthesizer.class) {
            if (defaultSoundBank != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultSoundBank;
            }
            ArrayList<PrivilegedAction<InputStream>> arrayList = new ArrayList<PrivilegedAction<InputStream>>();
            arrayList.add(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    File file = new File(System.getProperties().getProperty("java.home"));
                    File file2 = new File(new File(file, "lib"), "audio");
                    if (file2.exists()) {
                        File file3 = null;
                        File[] fileArray = file2.listFiles();
                        if (fileArray != null) {
                            for (int i = 0; i < fileArray.length; ++i) {
                                String string;
                                File file4 = fileArray[i];
                                if (!file4.isFile() || !(string = file4.getName().toLowerCase()).endsWith(".sf2") && !string.endsWith(".dls") || file3 != null && file4.length() <= file3.length()) continue;
                                file3 = file4;
                            }
                        }
                        if (file3 != null) {
                            try {
                                return new FileInputStream(file3);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    return null;
                }
            });
            arrayList.add(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    if (System.getProperties().getProperty("os.name").startsWith("Linux")) {
                        File[] fileArray;
                        for (File file : fileArray = new File[]{new File("/usr/share/soundfonts/"), new File("/usr/local/share/soundfonts/"), new File("/usr/share/sounds/sf2/"), new File("/usr/local/share/sounds/sf2/")}) {
                            File file2;
                            if (!file.exists() || !(file2 = new File(file, "default.sf2")).exists()) continue;
                            try {
                                return new FileInputStream(file2);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    return null;
                }
            });
            arrayList.add(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    File file;
                    if (System.getProperties().getProperty("os.name").startsWith("Windows") && (file = new File(System.getenv("SystemRoot") + "\\system32\\drivers\\gm.dls")).exists()) {
                        try {
                            return new FileInputStream(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
            arrayList.add(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    File file = new File(System.getProperty("user.home"), ".gervill");
                    File file2 = new File(file, "soundbank-emg.sf2");
                    if (file2.exists()) {
                        try {
                            return new FileInputStream(file2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                PrivilegedAction privilegedAction = (PrivilegedAction)object.next();
                try {
                    Soundbank soundbank;
                    InputStream inputStream = (InputStream)AccessController.doPrivileged(privilegedAction);
                    if (inputStream == null) continue;
                    try {
                        soundbank = MidiSystem.getSoundbank(new BufferedInputStream(inputStream));
                    }
                    finally {
                        inputStream.close();
                    }
                    if (soundbank == null) continue;
                    defaultSoundBank = soundbank;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return defaultSoundBank;
                }
                catch (Exception exception) {
                }
            }
            try {
                defaultSoundBank = EmergencySoundbank.createSoundbank();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (defaultSoundBank != null && (object = AccessController.doPrivileged(() -> {
                try {
                    File file;
                    File file2 = new File(System.getProperty("user.home"), ".gervill");
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    if ((file = new File(file2, "soundbank-emg.sf2")).exists()) {
                        return null;
                    }
                    return new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            })) != null) {
                try {
                    ((SF2Soundbank)defaultSoundBank).save((OutputStream)object);
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultSoundBank;
        }
    }

    @Override
    public Instrument[] getAvailableInstruments() {
        Soundbank soundbank = this.getDefaultSoundbank();
        if (soundbank == null) {
            return new Instrument[0];
        }
        Instrument[] instrumentArray = soundbank.getInstruments();
        Arrays.sort(instrumentArray, new ModelInstrumentComparator());
        return instrumentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instrument[] getLoadedInstruments() {
        if (!this.isOpen()) {
            return new Instrument[0];
        }
        Object object = this.control_mutex;
        synchronized (object) {
            Instrument[] instrumentArray = new ModelInstrument[this.loadedlist.values().size()];
            this.loadedlist.values().toArray(instrumentArray);
            Arrays.sort(instrumentArray, new ModelInstrumentComparator());
            return instrumentArray;
        }
    }

    @Override
    public boolean loadAllInstruments(Soundbank soundbank) {
        ArrayList<ModelInstrument> arrayList = new ArrayList<ModelInstrument>();
        for (Instrument instrument : soundbank.getInstruments()) {
            if (instrument == null || !(instrument instanceof ModelInstrument)) {
                throw new IllegalArgumentException("Unsupported instrument: " + instrument);
            }
            arrayList.add((ModelInstrument)instrument);
        }
        return this.loadInstruments(arrayList);
    }

    @Override
    public void unloadAllInstruments(Soundbank soundbank) {
        if (soundbank == null || !this.isSoundbankSupported(soundbank)) {
            throw new IllegalArgumentException("Unsupported soundbank: " + soundbank);
        }
        if (!this.isOpen()) {
            return;
        }
        for (Instrument instrument : soundbank.getInstruments()) {
            if (!(instrument instanceof ModelInstrument)) continue;
            this.unloadInstrument(instrument);
        }
    }

    @Override
    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        ArrayList<ModelInstrument> arrayList = new ArrayList<ModelInstrument>();
        for (Patch patch : patchArray) {
            Instrument instrument = soundbank.getInstrument(patch);
            if (instrument == null || !(instrument instanceof ModelInstrument)) {
                throw new IllegalArgumentException("Unsupported instrument: " + instrument);
            }
            arrayList.add((ModelInstrument)instrument);
        }
        return this.loadInstruments(arrayList);
    }

    @Override
    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
        if (soundbank == null || !this.isSoundbankSupported(soundbank)) {
            throw new IllegalArgumentException("Unsupported soundbank: " + soundbank);
        }
        if (!this.isOpen()) {
            return;
        }
        for (Patch patch : patchArray) {
            Instrument instrument = soundbank.getInstrument(patch);
            if (!(instrument instanceof ModelInstrument)) continue;
            this.unloadInstrument(instrument);
        }
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return info;
    }

    private Properties getStoredProperties() {
        return AccessController.doPrivileged(() -> {
            Properties properties = new Properties();
            String string = "/com/sun/media/sound/softsynthesizer";
            try {
                Preferences preferences = Preferences.userRoot();
                if (preferences.nodeExists(string)) {
                    String[] stringArray;
                    Preferences preferences2 = preferences.node(string);
                    for (String string2 : stringArray = preferences2.keys()) {
                        String string3 = preferences2.get(string2, null);
                        if (string3 == null) continue;
                        properties.setProperty(string2, string3);
                    }
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            return properties;
        });
    }

    @Override
    public AudioSynthesizerPropertyInfo[] getPropertyInfo(Map<String, Object> map) {
        ArrayList<AudioSynthesizerPropertyInfo> arrayList = new ArrayList<AudioSynthesizerPropertyInfo>();
        boolean bl = map == null && this.open;
        AudioSynthesizerPropertyInfo audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("interpolation", bl ? this.resamplerType : "linear");
        audioSynthesizerPropertyInfo.choices = new String[]{"linear", "linear1", "linear2", "cubic", "lanczos", "sinc", "point"};
        audioSynthesizerPropertyInfo.description = "Interpolation method";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("control rate", Float.valueOf(bl ? this.controlrate : 147.0f));
        audioSynthesizerPropertyInfo.description = "Control rate";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("format", bl ? this.format : new AudioFormat(44100.0f, 16, 2, true, false));
        audioSynthesizerPropertyInfo.description = "Default audio format";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("latency", bl ? this.latency : 120000L);
        audioSynthesizerPropertyInfo.description = "Default latency";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("device id", bl ? this.deviceid : 0);
        audioSynthesizerPropertyInfo.description = "Device ID for SysEx Messages";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("max polyphony", bl ? this.maxpoly : 64);
        audioSynthesizerPropertyInfo.description = "Maximum polyphony";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("reverb", bl ? this.reverb_on : true);
        audioSynthesizerPropertyInfo.description = "Turn reverb effect on or off";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("chorus", bl ? this.chorus_on : true);
        audioSynthesizerPropertyInfo.description = "Turn chorus effect on or off";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("auto gain control", bl ? this.agc_on : true);
        audioSynthesizerPropertyInfo.description = "Turn auto gain control on or off";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("large mode", bl ? this.largemode : false);
        audioSynthesizerPropertyInfo.description = "Turn large mode on or off.";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("midi channels", bl ? this.channels.length : 16);
        audioSynthesizerPropertyInfo.description = "Number of midi channels.";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("jitter correction", bl ? this.jitter_correction : true);
        audioSynthesizerPropertyInfo.description = "Turn jitter correction on or off.";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("light reverb", bl ? this.reverb_light : true);
        audioSynthesizerPropertyInfo.description = "Turn light reverb mode on or off";
        arrayList.add(audioSynthesizerPropertyInfo);
        audioSynthesizerPropertyInfo = new AudioSynthesizerPropertyInfo("load default soundbank", bl ? this.load_default_soundbank : true);
        audioSynthesizerPropertyInfo.description = "Enabled/disable loading default soundbank";
        arrayList.add(audioSynthesizerPropertyInfo);
        AudioSynthesizerPropertyInfo[] audioSynthesizerPropertyInfoArray = arrayList.toArray(new AudioSynthesizerPropertyInfo[arrayList.size()]);
        Properties properties = this.getStoredProperties();
        for (AudioSynthesizerPropertyInfo audioSynthesizerPropertyInfo2 : audioSynthesizerPropertyInfoArray) {
            Object object;
            Object object2 = map == null ? null : map.get(audioSynthesizerPropertyInfo2.name);
            Object object3 = object2 = object2 != null ? object2 : properties.getProperty(audioSynthesizerPropertyInfo2.name);
            if (object2 == null) continue;
            Class clazz = audioSynthesizerPropertyInfo2.valueClass;
            if (clazz.isInstance(object2)) {
                audioSynthesizerPropertyInfo2.value = object2;
                continue;
            }
            if (object2 instanceof String) {
                object = (String)object2;
                if (clazz == Boolean.class) {
                    if (((String)object).equalsIgnoreCase("true")) {
                        audioSynthesizerPropertyInfo2.value = Boolean.TRUE;
                    }
                    if (!((String)object).equalsIgnoreCase("false")) continue;
                    audioSynthesizerPropertyInfo2.value = Boolean.FALSE;
                    continue;
                }
                if (clazz == AudioFormat.class) {
                    int n = 2;
                    boolean bl2 = true;
                    boolean bl3 = false;
                    int n2 = 16;
                    float f = 44100.0f;
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, ", ");
                        String string = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken().toLowerCase();
                            if (string2.equals("mono")) {
                                n = 1;
                            }
                            if (string2.startsWith("channel")) {
                                n = Integer.parseInt(string);
                            }
                            if (string2.contains("unsigned")) {
                                bl2 = false;
                            }
                            if (string2.equals("big-endian")) {
                                bl3 = true;
                            }
                            if (string2.equals("bit")) {
                                n2 = Integer.parseInt(string);
                            }
                            if (string2.equals("hz")) {
                                f = Float.parseFloat(string);
                            }
                            string = string2;
                        }
                        audioSynthesizerPropertyInfo2.value = new AudioFormat(f, n2, n, bl2, bl3);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                try {
                    if (clazz == Byte.class) {
                        audioSynthesizerPropertyInfo2.value = Byte.valueOf((String)object);
                        continue;
                    }
                    if (clazz == Short.class) {
                        audioSynthesizerPropertyInfo2.value = Short.valueOf((String)object);
                        continue;
                    }
                    if (clazz == Integer.class) {
                        audioSynthesizerPropertyInfo2.value = Integer.valueOf((String)object);
                        continue;
                    }
                    if (clazz == Long.class) {
                        audioSynthesizerPropertyInfo2.value = Long.valueOf((String)object);
                        continue;
                    }
                    if (clazz == Float.class) {
                        audioSynthesizerPropertyInfo2.value = Float.valueOf((String)object);
                        continue;
                    }
                    if (clazz != Double.class) continue;
                    audioSynthesizerPropertyInfo2.value = Double.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!(object2 instanceof Number)) continue;
            object = (Number)object2;
            if (clazz == Byte.class) {
                audioSynthesizerPropertyInfo2.value = ((Number)object).byteValue();
            }
            if (clazz == Short.class) {
                audioSynthesizerPropertyInfo2.value = ((Number)object).shortValue();
            }
            if (clazz == Integer.class) {
                audioSynthesizerPropertyInfo2.value = ((Number)object).intValue();
            }
            if (clazz == Long.class) {
                audioSynthesizerPropertyInfo2.value = ((Number)object).longValue();
            }
            if (clazz == Float.class) {
                audioSynthesizerPropertyInfo2.value = Float.valueOf(((Number)object).floatValue());
            }
            if (clazz != Double.class) continue;
            audioSynthesizerPropertyInfo2.value = ((Number)object).doubleValue();
        }
        return audioSynthesizerPropertyInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws MidiUnavailableException {
        if (this.isOpen()) {
            Object object = this.control_mutex;
            synchronized (object) {
                this.implicitOpen = false;
            }
            return;
        }
        this.open(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(SourceDataLine sourceDataLine, Map<String, Object> map) throws MidiUnavailableException {
        if (this.isOpen()) {
            Object object = this.control_mutex;
            synchronized (object) {
                this.implicitOpen = false;
            }
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            try {
                int n;
                if (sourceDataLine != null) {
                    this.setFormat(sourceDataLine.getFormat());
                }
                AudioInputStream audioInputStream = this.openStream(this.getFormat(), map);
                this.weakstream = new WeakAudioStream(audioInputStream);
                audioInputStream = this.weakstream.getAudioInputStream();
                if (sourceDataLine == null) {
                    sourceDataLine = testline != null ? testline : AudioSystem.getSourceDataLine(this.getFormat());
                }
                double d = this.latency;
                if (!sourceDataLine.isOpen()) {
                    n = this.getFormat().getFrameSize() * (int)((double)this.getFormat().getFrameRate() * (d / 1000000.0));
                    sourceDataLine.open(this.getFormat(), n);
                    this.sourceDataLine = sourceDataLine;
                }
                if (!sourceDataLine.isActive()) {
                    sourceDataLine.start();
                }
                n = 512;
                try {
                    n = audioInputStream.available();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int n2 = sourceDataLine.getBufferSize();
                n2 -= n2 % n;
                if (n2 < 3 * n) {
                    n2 = 3 * n;
                }
                if (this.jitter_correction) {
                    audioInputStream = new SoftJitterCorrector(audioInputStream, n2, n);
                    if (this.weakstream != null) {
                        this.weakstream.jitter_stream = audioInputStream;
                    }
                }
                this.pusher = new SoftAudioPusher(sourceDataLine, audioInputStream, n);
                this.pusher_stream = audioInputStream;
                this.pusher.start();
                if (this.weakstream != null) {
                    this.weakstream.pusher = this.pusher;
                    this.weakstream.sourceDataLine = this.sourceDataLine;
                }
            }
            catch (IllegalArgumentException | SecurityException | LineUnavailableException exception) {
                if (this.isOpen()) {
                    this.close();
                }
                MidiUnavailableException midiUnavailableException = new MidiUnavailableException("Can not open line");
                midiUnavailableException.initCause(exception);
                throw midiUnavailableException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream openStream(AudioFormat audioFormat, Map<String, Object> map) throws MidiUnavailableException {
        if (this.isOpen()) {
            throw new MidiUnavailableException("Synthesizer is already open");
        }
        Object object = this.control_mutex;
        synchronized (object) {
            int n;
            Soundbank soundbank;
            this.gmmode = 0;
            this.voice_allocation_mode = 0;
            this.processPropertyInfo(map);
            this.open = true;
            this.implicitOpen = false;
            if (audioFormat != null) {
                this.setFormat(audioFormat);
            }
            if (this.load_default_soundbank && (soundbank = this.getDefaultSoundbank()) != null) {
                this.loadAllInstruments(soundbank);
            }
            this.voices = new SoftVoice[this.maxpoly];
            for (n = 0; n < this.maxpoly; ++n) {
                this.voices[n] = new SoftVoice(this);
            }
            this.mainmixer = new SoftMainMixer(this);
            this.channels = new SoftChannel[this.number_of_midi_channels];
            for (n = 0; n < this.channels.length; ++n) {
                this.channels[n] = new SoftChannel(this, n);
            }
            if (this.external_channels == null) {
                this.external_channels = this.channels.length < 16 ? new SoftChannelProxy[16] : new SoftChannelProxy[this.channels.length];
                for (n = 0; n < this.external_channels.length; ++n) {
                    this.external_channels[n] = new SoftChannelProxy();
                }
            } else if (this.channels.length > this.external_channels.length) {
                int n2;
                SoftChannelProxy[] softChannelProxyArray = new SoftChannelProxy[this.channels.length];
                for (n2 = 0; n2 < this.external_channels.length; ++n2) {
                    softChannelProxyArray[n2] = this.external_channels[n2];
                }
                for (n2 = this.external_channels.length; n2 < softChannelProxyArray.length; ++n2) {
                    softChannelProxyArray[n2] = new SoftChannelProxy();
                }
            }
            for (int i = 0; i < this.channels.length; ++i) {
                this.external_channels[i].setChannel(this.channels[i]);
            }
            for (SoftVoice softVoice : this.getVoices()) {
                softVoice.resampler = this.resampler.openStreamer();
            }
            for (Receiver receiver : this.getReceivers()) {
                SoftReceiver softReceiver = (SoftReceiver)receiver;
                softReceiver.open = this.open;
                softReceiver.mainmixer = this.mainmixer;
                softReceiver.midimessages = this.mainmixer.midimessages;
            }
            return this.mainmixer.getInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        SoftAudioPusher softAudioPusher = null;
        AudioInputStream audioInputStream = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.pusher != null) {
                softAudioPusher = this.pusher;
                audioInputStream = this.pusher_stream;
                this.pusher = null;
                this.pusher_stream = null;
            }
        }
        if (softAudioPusher != null) {
            softAudioPusher.stop();
            try {
                audioInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = this.control_mutex;
        synchronized (object) {
            if (this.mainmixer != null) {
                this.mainmixer.close();
            }
            this.open = false;
            this.implicitOpen = false;
            this.mainmixer = null;
            this.voices = null;
            this.channels = null;
            if (this.external_channels != null) {
                for (int i = 0; i < this.external_channels.length; ++i) {
                    this.external_channels[i].setChannel(null);
                }
            }
            if (this.sourceDataLine != null) {
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
            this.inslist.clear();
            this.loadedlist.clear();
            this.tunings.clear();
            while (this.recvslist.size() != 0) {
                this.recvslist.get(this.recvslist.size() - 1).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMicrosecondPosition() {
        if (!this.isOpen()) {
            return 0L;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            return this.mainmixer.getMicrosecondPosition();
        }
    }

    @Override
    public int getMaxReceivers() {
        return -1;
    }

    @Override
    public int getMaxTransmitters() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        Object object = this.control_mutex;
        synchronized (object) {
            SoftReceiver softReceiver = new SoftReceiver(this);
            softReceiver.open = this.open;
            this.recvslist.add(softReceiver);
            return softReceiver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Receiver> getReceivers() {
        Object object = this.control_mutex;
        synchronized (object) {
            ArrayList<Receiver> arrayList = new ArrayList<Receiver>();
            arrayList.addAll(this.recvslist);
            return arrayList;
        }
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException("No transmitter available");
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return new ArrayList<Transmitter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver getReceiverReferenceCounting() throws MidiUnavailableException {
        if (!this.isOpen()) {
            this.open();
            Object object = this.control_mutex;
            synchronized (object) {
                this.implicitOpen = true;
            }
        }
        return this.getReceiver();
    }

    @Override
    public Transmitter getTransmitterReferenceCounting() throws MidiUnavailableException {
        throw new MidiUnavailableException("No transmitter available");
    }

    private static class Info
    extends MidiDevice.Info {
        Info() {
            super(SoftSynthesizer.INFO_NAME, SoftSynthesizer.INFO_VENDOR, SoftSynthesizer.INFO_DESCRIPTION, SoftSynthesizer.INFO_VERSION);
        }
    }

    protected static final class WeakAudioStream
    extends InputStream {
        private volatile AudioInputStream stream;
        public SoftAudioPusher pusher = null;
        public AudioInputStream jitter_stream = null;
        public SourceDataLine sourceDataLine = null;
        public volatile long silent_samples = 0L;
        private int framesize = 0;
        private WeakReference<AudioInputStream> weak_stream_link;
        private AudioFloatConverter converter;
        private float[] silentbuffer = null;
        private int samplesize;

        public void setInputStream(AudioInputStream audioInputStream) {
            this.stream = audioInputStream;
        }

        @Override
        public int available() throws IOException {
            AudioInputStream audioInputStream = this.stream;
            if (audioInputStream != null) {
                return audioInputStream.available();
            }
            return 0;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray) == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            AudioInputStream audioInputStream = this.stream;
            if (audioInputStream != null) {
                return audioInputStream.read(byArray, n, n2);
            }
            int n3 = n2 / this.samplesize;
            if (this.silentbuffer == null || this.silentbuffer.length < n3) {
                this.silentbuffer = new float[n3];
            }
            this.converter.toByteArray(this.silentbuffer, n3, byArray, n);
            this.silent_samples += (long)(n2 / this.framesize);
            if (this.pusher != null && this.weak_stream_link.get() == null) {
                Runnable runnable = new Runnable(){
                    SoftAudioPusher _pusher;
                    AudioInputStream _jitter_stream;
                    SourceDataLine _sourceDataLine;
                    {
                        this._pusher = pusher;
                        this._jitter_stream = jitter_stream;
                        this._sourceDataLine = sourceDataLine;
                    }

                    @Override
                    public void run() {
                        this._pusher.stop();
                        if (this._jitter_stream != null) {
                            try {
                                this._jitter_stream.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        if (this._sourceDataLine != null) {
                            this._sourceDataLine.close();
                        }
                    }
                };
                this.pusher = null;
                this.jitter_stream = null;
                this.sourceDataLine = null;
                new Thread(runnable).start();
            }
            return n2;
        }

        public WeakAudioStream(AudioInputStream audioInputStream) {
            this.stream = audioInputStream;
            this.weak_stream_link = new WeakReference<AudioInputStream>(audioInputStream);
            this.converter = AudioFloatConverter.getConverter(audioInputStream.getFormat());
            this.samplesize = audioInputStream.getFormat().getFrameSize() / audioInputStream.getFormat().getChannels();
            this.framesize = audioInputStream.getFormat().getFrameSize();
        }

        public AudioInputStream getAudioInputStream() {
            return new AudioInputStream(this, this.stream.getFormat(), -1L);
        }

        @Override
        public void close() throws IOException {
            AudioInputStream audioInputStream = (AudioInputStream)this.weak_stream_link.get();
            if (audioInputStream != null) {
                audioInputStream.close();
            }
        }
    }
}

