/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import java.security.Permission;
import sun.tracing.dtrace.DTraceProvider;
import sun.tracing.dtrace.JVM;
import sun.tracing.dtrace.SystemResource;

class Activation {
    private SystemResource resource;
    private int referenceCount;

    Activation(String string, DTraceProvider[] dTraceProviderArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DTraceProvider[] dTraceProviderArray2 = new RuntimePermission("com.sun.tracing.dtrace.createProvider");
            securityManager.checkPermission((Permission)dTraceProviderArray2);
        }
        this.referenceCount = dTraceProviderArray.length;
        for (DTraceProvider dTraceProvider : dTraceProviderArray) {
            dTraceProvider.setActivation(this);
        }
        this.resource = new SystemResource(this, JVM.activate(string, dTraceProviderArray));
    }

    void disposeProvider(DTraceProvider dTraceProvider) {
        if (--this.referenceCount == 0) {
            this.resource.dispose();
        }
    }
}

