/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.CCacheInputStream;
import sun.security.krb5.internal.ccache.FileCredentialsCache;

class KinitOptions {
    public int action = 1;
    public short forwardable = 0;
    public short proxiable = 0;
    public KerberosTime lifetime;
    public KerberosTime renewable_lifetime;
    public String target_service;
    public String keytab_file;
    public String cachename;
    private PrincipalName principal;
    public String realm;
    char[] password = null;
    public boolean keytab;
    private boolean DEBUG = Krb5.DEBUG;
    private boolean includeAddresses = true;
    private boolean useKeytab = false;
    private String ktabName;

    public KinitOptions() throws RuntimeException, RealmException {
        this.cachename = FileCredentialsCache.getDefaultCacheName();
        if (this.cachename == null) {
            throw new RuntimeException("default cache name error");
        }
        this.principal = this.getDefaultPrincipal();
    }

    public void setKDCRealm(String string) throws RealmException {
        this.realm = string;
    }

    public String getKDCRealm() {
        if (this.realm == null && this.principal != null) {
            return this.principal.getRealmString();
        }
        return null;
    }

    public KinitOptions(String[] stringArray) throws KrbException, RuntimeException, IOException {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-f")) {
                this.forwardable = 1;
                continue;
            }
            if (stringArray[i].equals("-p")) {
                this.proxiable = 1;
                continue;
            }
            if (stringArray[i].equals("-c")) {
                if (stringArray[i + 1].startsWith("-")) {
                    throw new IllegalArgumentException("input format  not correct:  -c  option must be followed by the cache name");
                }
                this.cachename = stringArray[++i];
                if (this.cachename.length() < 5 || !this.cachename.substring(0, 5).equalsIgnoreCase("FILE:")) continue;
                this.cachename = this.cachename.substring(5);
                continue;
            }
            if (stringArray[i].equals("-A")) {
                this.includeAddresses = false;
                continue;
            }
            if (stringArray[i].equals("-k")) {
                this.useKeytab = true;
                continue;
            }
            if (stringArray[i].equals("-t")) {
                if (this.ktabName != null) {
                    throw new IllegalArgumentException("-t option/keytab file name repeated");
                }
                if (i + 1 >= stringArray.length) {
                    throw new IllegalArgumentException("-t option requires keytab file name");
                }
                this.ktabName = stringArray[++i];
                this.useKeytab = true;
                continue;
            }
            if (stringArray[i].equals("-R")) {
                this.action = 2;
                continue;
            }
            if (stringArray[i].equals("-l")) {
                this.lifetime = this.getTime(Config.duration(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("-r")) {
                this.renewable_lifetime = this.getTime(Config.duration(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-help")) {
                this.printHelp();
                System.exit(0);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                try {
                    this.principal = new PrincipalName(string);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid Principal name: " + string + exception.getMessage());
                }
            }
            if (this.password == null) {
                this.password = stringArray[i].toCharArray();
                continue;
            }
            throw new IllegalArgumentException("too many parameters");
        }
        if (this.cachename == null) {
            this.cachename = FileCredentialsCache.getDefaultCacheName();
            if (this.cachename == null) {
                throw new RuntimeException("default cache name error");
            }
        }
        if (this.principal == null) {
            this.principal = this.getDefaultPrincipal();
        }
    }

    PrincipalName getDefaultPrincipal() {
        block12: {
            try {
                CCacheInputStream cCacheInputStream = new CCacheInputStream(new FileInputStream(this.cachename));
                int n = cCacheInputStream.readVersion();
                if (n == 1284) {
                    cCacheInputStream.readTag();
                } else if (n == 1281 || n == 1282) {
                    cCacheInputStream.setNativeByteOrder();
                }
                PrincipalName principalName = cCacheInputStream.readPrincipal(n);
                cCacheInputStream.close();
                if (this.DEBUG) {
                    System.out.println(">>>KinitOptions principal name from the cache is :" + principalName);
                }
                return principalName;
            }
            catch (IOException iOException) {
                if (this.DEBUG) {
                    iOException.printStackTrace();
                }
            }
            catch (RealmException realmException) {
                if (!this.DEBUG) break block12;
                realmException.printStackTrace();
            }
        }
        String string = System.getProperty("user.name");
        if (this.DEBUG) {
            System.out.println(">>>KinitOptions default username is :" + string);
        }
        try {
            PrincipalName principalName = new PrincipalName(string);
            return principalName;
        }
        catch (RealmException realmException) {
            if (this.DEBUG) {
                System.out.println("Exception in getting principal name " + realmException.getMessage());
                realmException.printStackTrace();
            }
            return null;
        }
    }

    void printHelp() {
        System.out.println("Usage:\n\n1. Initial ticket request:\n    kinit [-A] [-f] [-p] [-c cachename] [-l lifetime] [-r renewable_time]\n          [[-k [-t keytab_file_name]] [principal] [password]");
        System.out.println("2. Renew a ticket:\n    kinit -R [-c cachename] [principal]");
        System.out.println("\nAvailable options to Kerberos 5 ticket request:");
        System.out.println("\t-A   do not include addresses");
        System.out.println("\t-f   forwardable");
        System.out.println("\t-p   proxiable");
        System.out.println("\t-c   cache name (i.e., FILE:\\d:\\myProfiles\\mykrb5cache)");
        System.out.println("\t-l   lifetime");
        System.out.println("\t-r   renewable time (total lifetime a ticket can be renewed)");
        System.out.println("\t-k   use keytab");
        System.out.println("\t-t   keytab file name");
        System.out.println("\tprincipal   the principal name (i.e., qweadf@ATHENA.MIT.EDU qweadf)");
        System.out.println("\tpassword    the principal's Kerberos password");
    }

    public boolean getAddressOption() {
        return this.includeAddresses;
    }

    public boolean useKeytabFile() {
        return this.useKeytab;
    }

    public String keytabFileName() {
        return this.ktabName;
    }

    public PrincipalName getPrincipal() {
        return this.principal;
    }

    private KerberosTime getTime(int n) {
        return new KerberosTime(Instant.now().plusSeconds(n));
    }
}

