/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.apps;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.Utils;
import jdk.test.lib.process.OutputBuffer;
import jdk.test.lib.process.StreamPumper;
import jdk.test.lib.util.CoreUtils;

public class LingeredApp {
    private static final long spinDelay = 1000L;
    private long lockCreationTime;
    private ByteArrayOutputStream stderrBuffer;
    private ByteArrayOutputStream stdoutBuffer;
    private Thread outPumperThread;
    private Thread errPumperThread;
    private boolean finishAppCalled = false;
    private boolean useDefaultClasspath = true;
    protected Process appProcess;
    protected OutputBuffer output;
    protected static final int appWaitTime = 100;
    protected static final int appCoreWaitTime = 480;
    protected final String lockFileName;
    protected String logFileName;
    protected boolean forceCrash = false;
    private static volatile boolean steadyStateReached = false;

    public LingeredApp(String lockFileName) {
        this.lockFileName = lockFileName;
    }

    public LingeredApp() {
        String lockName = UUID.randomUUID().toString() + ".lck";
        this.lockFileName = lockName;
    }

    public void setForceCrash(boolean forceCrash) {
        this.forceCrash = forceCrash;
    }

    private static native int crash();

    public String getLockFileName() {
        return this.lockFileName;
    }

    public void setLogFileName(String name) {
        this.logFileName = name;
    }

    public long getPid() {
        if (this.appProcess == null) {
            throw new RuntimeException("Process is not alive");
        }
        return this.appProcess.pid();
    }

    public Process getProcess() {
        return this.appProcess;
    }

    public String getProcessStdout() {
        return this.stdoutBuffer.toString();
    }

    public OutputBuffer getOutput() {
        if (this.appProcess.isAlive()) {
            throw new RuntimeException("Process is still alive. Can't get its output.");
        }
        if (this.output == null) {
            this.output = OutputBuffer.of(this.stdoutBuffer.toString(), this.stderrBuffer.toString(), this.appProcess.exitValue());
        }
        return this.output;
    }

    private void startOutputPumpers() {
        this.stderrBuffer = new ByteArrayOutputStream();
        this.stdoutBuffer = new ByteArrayOutputStream();
        StreamPumper outPumper = new StreamPumper(this.appProcess.getInputStream(), this.stdoutBuffer);
        StreamPumper errPumper = new StreamPumper(this.appProcess.getErrorStream(), this.stderrBuffer);
        this.outPumperThread = new Thread(outPumper);
        this.errPumperThread = new Thread(errPumper);
        this.outPumperThread.setDaemon(true);
        this.errPumperThread.setDaemon(true);
        this.outPumperThread.start();
        this.errPumperThread.start();
    }

    private static long epoch() {
        return new Date().getTime();
    }

    private static long lastModified(String fileName) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        return attr.lastModifiedTime().toMillis();
    }

    private static void setLastModified(String fileName, long newTime) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        FileTime fileTime = FileTime.fromMillis(newTime);
        Files.setLastModifiedTime(path, fileTime);
    }

    public void createLock() throws IOException {
        Path path = Paths.get(this.lockFileName, new String[0]);
        Files.createFile(path, new FileAttribute[0]);
        this.lockCreationTime = LingeredApp.lastModified(this.lockFileName);
    }

    public void deleteLock() throws IOException {
        try {
            Path path = Paths.get(this.lockFileName, new String[0]);
            Files.delete(path);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public void waitAppTerminate() {
        try {
            if (!this.appProcess.waitFor(Utils.adjustTimeout(100L), TimeUnit.SECONDS)) {
                this.appProcess.destroy();
                this.appProcess.waitFor();
            }
            this.outPumperThread.join();
            this.errPumperThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void waitAppReadyOrCrashed(long timeout) throws IOException {
        timeout = Utils.adjustTimeout(timeout) * 1000L;
        long here = LingeredApp.epoch();
        while (true) {
            if (!this.appProcess.isAlive()) {
                if (this.forceCrash) {
                    return;
                }
                throw new IOException("App exited unexpectedly with " + this.appProcess.exitValue());
            }
            long lm = LingeredApp.lastModified(this.lockFileName);
            if (lm > this.lockCreationTime) break;
            long timeTaken = LingeredApp.epoch() - here;
            if (timeTaken > timeout) {
                throw new IOException("Timeout: app not started or crashed in " + timeTaken + "ms");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitAppReadyOrCrashed() throws IOException {
        this.waitAppReadyOrCrashed(this.forceCrash ? 480L : 100L);
    }

    private List<String> runAppPrepare(String[] vmArguments) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JDKToolFinder.getTestJDKTool("java"));
        Collections.addAll(cmd, vmArguments);
        if (this.forceCrash) {
            cmd.add("-XX:+CreateCoredumpOnCrash");
            cmd.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        }
        if (this.useDefaultClasspath()) {
            cmd.add("-cp");
            String classpath = System.getProperty("test.class.path");
            cmd.add(classpath == null ? "." : classpath);
        }
        return cmd;
    }

    protected void runAddAppName(List<String> cmd) {
        cmd.add(this.getClass().getName());
    }

    public void printCommandLine(List<String> cmd) {
        System.out.println(cmd.stream().map(s -> "'" + s + "'").collect(Collectors.joining(" ", "Command line: [", "]")));
    }

    public boolean useDefaultClasspath() {
        return this.useDefaultClasspath;
    }

    public void setUseDefaultClasspath(boolean value) {
        this.useDefaultClasspath = value;
    }

    public void runAppExactJvmOpts(String[] vmOpts) throws IOException {
        List<String> cmd = this.runAppPrepare(vmOpts);
        this.runAddAppName(cmd);
        cmd.add(this.lockFileName);
        if (this.forceCrash) {
            cmd.add("forceCrash");
        }
        this.printCommandLine(cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (this.forceCrash) {
            pb = CoreUtils.addCoreUlimitCommand(pb);
        }
        this.appProcess = pb.start();
        this.startOutputPumpers();
    }

    private void finishApp() {
        block15: {
            if (this.appProcess != null) {
                if (this.finishAppCalled) {
                    return;
                }
                this.finishAppCalled = true;
                OutputBuffer output = this.getOutput();
                String msg = " LingeredApp stdout: [" + output.getStdout() + "];\n LingeredApp stderr: [" + output.getStderr() + "]\n LingeredApp exitValue = " + this.appProcess.exitValue();
                if (this.logFileName != null) {
                    System.out.println(" LingeredApp exitValue = " + this.appProcess.exitValue());
                    System.out.println(" LingeredApp output: " + this.logFileName + " (" + msg.length() + " chars)");
                    try (FileOutputStream fos = new FileOutputStream(this.logFileName);
                         PrintStream ps = new PrintStream(fos);){
                        ps.print(msg);
                        break block15;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                System.out.println(msg);
            }
        }
    }

    public void stopApp() throws IOException {
        this.deleteLock();
        if (this.appProcess != null) {
            this.waitAppTerminate();
            this.finishApp();
            int exitcode = this.appProcess.exitValue();
            if (exitcode != 0) {
                throw new IOException("LingeredApp terminated with non-zero exit code " + exitcode);
            }
        }
    }

    public static void startAppExactJvmOpts(LingeredApp theApp, String ... jvmOpts) throws IOException {
        long t1 = System.currentTimeMillis();
        theApp.createLock();
        try {
            theApp.runAppExactJvmOpts(jvmOpts);
            theApp.waitAppReadyOrCrashed();
        }
        catch (Exception ex) {
            boolean alive = theApp.getProcess() != null && theApp.getProcess().isAlive();
            System.out.println("LingeredApp failed to start or failed to crash. isAlive=" + alive + ": " + String.valueOf(ex));
            if (alive) {
                theApp.stopApp();
            }
            boolean bl = alive = theApp.getProcess() != null && theApp.getProcess().isAlive();
            if (!alive) {
                theApp.finishApp();
            }
            theApp.deleteLock();
            throw ex;
        }
        finally {
            long t2 = System.currentTimeMillis();
            System.out.println("LingeredApp startup took " + (t2 - t1) + "ms");
            LingeredApp.checkForDumps();
        }
    }

    public static void checkForDumps() {
        System.out.println("Check for hs_err_pid/core/mdmp files:");
        int count = 0;
        FilenameFilter filter = (dir, file) -> file.startsWith("hs_err_pid") || file.startsWith("core") || file.endsWith("mdmp");
        for (File f : new File(".").listFiles(filter)) {
            long fileSize = f.length();
            System.out.println(String.valueOf(f) + " " + fileSize / 1024L / 1024L + "mb (" + fileSize + " bytes)");
            ++count;
        }
        if (count == 0) {
            System.out.println("None.");
        }
    }

    public static void startApp(LingeredApp theApp, String ... additionalJvmOpts) throws IOException {
        LingeredApp.startAppExactJvmOpts(theApp, Utils.prependTestJavaOpts(additionalJvmOpts));
    }

    public static LingeredApp startApp(String ... additionalJvmOpts) throws IOException {
        LingeredApp a = new LingeredApp();
        LingeredApp.startApp(a, additionalJvmOpts);
        return a;
    }

    public static void stopApp(LingeredApp app) throws IOException {
        if (app != null) {
            app.stopApp();
        }
    }

    public static boolean isLastModifiedWorking() {
        boolean sane = true;
        try {
            long now;
            long lm = LingeredApp.lastModified(".");
            if (lm == 0L) {
                System.err.println("SANITY Warning! The lastModifiedTime() doesn't work on this system, it returns 0");
                sane = false;
            }
            if (lm > (now = LingeredApp.epoch())) {
                System.err.println("SANITY Warning! The Clock is wrong on this system lastModifiedTime() > getTime()");
                sane = false;
            }
            LingeredApp.setLastModified(".", LingeredApp.epoch());
            long lm1 = LingeredApp.lastModified(".");
            if (lm1 <= lm) {
                System.err.println("SANITY Warning! The setLastModified doesn't work on this system");
                sane = false;
            }
        }
        catch (IOException e) {
            System.err.println("SANITY Warning! IOException during sanity check " + String.valueOf(e));
            sane = false;
        }
        return sane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void steadyState(Object steadyStateObj) {
        steadyStateReached = true;
        Object object = steadyStateObj;
        synchronized (object) {
        }
    }

    private static void startSteadyStateThread(final Object steadyStateObj) {
        Thread steadyStateThread = new Thread(){

            @Override
            public void run() {
                LingeredApp.steadyState(steadyStateObj);
            }
        };
        steadyStateThread.setName("SteadyStateThread");
        steadyStateThread.start();
        while (!steadyStateReached) {
            Thread.onSpinWait();
        }
        while (steadyStateThread.getState() != Thread.State.BLOCKED) {
            Thread.onSpinWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean forceCrash = false;
        if (args.length == 0) {
            System.err.println("Lock file name is not specified");
            System.exit(7);
        } else if (args.length > 2) {
            System.err.println("Too many arguments specified: " + args.length);
            System.exit(7);
        }
        if (args.length == 2) {
            if (args[1].equals("forceCrash")) {
                forceCrash = true;
            } else {
                System.err.println("Invalid 1st argment: " + args[1]);
                System.exit(7);
            }
        }
        String theLockFileName = args[0];
        Path path = Paths.get(theLockFileName, new String[0]);
        try {
            SteadyStateLock steadyStateObj;
            SteadyStateLock steadyStateLock = steadyStateObj = new SteadyStateLock();
            synchronized (steadyStateLock) {
                LingeredApp.startSteadyStateThread(steadyStateObj);
                if (forceCrash) {
                    System.loadLibrary("LingeredApp");
                    LingeredApp.crash();
                }
                while (Files.exists(path, new LinkOption[0])) {
                    LingeredApp.setLastModified(theLockFileName, LingeredApp.epoch());
                    Thread.sleep(1000L);
                }
            }
        }
        catch (IOException ex) {
            if (Files.exists(path, new LinkOption[0])) {
                System.err.println("LingeredApp IOException: lock file still exists");
                System.exit(4);
            }
        }
        catch (Exception ex) {
            System.err.println("LingeredApp ERROR: " + String.valueOf(ex));
            System.exit(3);
        }
        System.exit(0);
    }

    static class SteadyStateLock {
        SteadyStateLock() {
        }
    }
}

