/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java2d.DemoGroup;
import java2d.DemoInstVarsAccessor;
import java2d.DemoPanel;
import java2d.J2Ddemo;
import java2d.TextureChooser;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlobalControls
extends JPanel
implements ItemListener,
ChangeListener {
    private final DemoInstVarsAccessor demoInstVars;
    public static final String[] screenNames = new String[]{"Auto Screen", "On Screen", "Off Screen", "INT_xRGB", "INT_ARGB", "INT_ARGB_PRE", "INT_BGR", "3BYTE_BGR", "4BYTE_ABGR", "4BYTE_ABGR_PRE", "USHORT_565_RGB", "USHORT_x555_RGB", "BYTE_GRAY", "USHORT_GRAY", "BYTE_BINARY", "BYTE_INDEXED", "BYTE_BINARY 2 bit", "BYTE_BINARY 4 bit", "INT_RGBx", "USHORT_555x_RGB"};
    public final JComboBox<String> screenCombo;
    public TextureChooser texturechooser;
    public JCheckBox aliasCB;
    public JCheckBox renderCB;
    public JCheckBox toolBarCB;
    public JCheckBox compositeCB;
    public JCheckBox textureCB;
    public JSlider slider;
    public Object obj;
    private Font font = new Font("Serif", 0, 12);

    public GlobalControls(DemoInstVarsAccessor demoInstVars) {
        this.demoInstVars = demoInstVars;
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Global Controls"));
        this.aliasCB = this.createCheckBox("Anti-Aliasing", true, 0);
        this.renderCB = this.createCheckBox("Rendering Quality", false, 1);
        this.textureCB = this.createCheckBox("Texture", false, 2);
        this.compositeCB = this.createCheckBox("AlphaComposite", false, 3);
        this.screenCombo = new JComboBox();
        this.screenCombo.setPreferredSize(new Dimension(120, 18));
        this.screenCombo.setLightWeightPopupEnabled(true);
        this.screenCombo.setFont(this.font);
        for (int i = 0; i < screenNames.length; ++i) {
            this.screenCombo.addItem(screenNames[i]);
        }
        this.screenCombo.addItemListener(this);
        J2Ddemo.addToGridBag(this, this.screenCombo, 0, 4, 1, 1, 0.0, 0.0);
        this.toolBarCB = this.createCheckBox("Tools", false, 5);
        this.slider = new JSlider(0, 0, 200, 30);
        this.slider.addChangeListener(this);
        TitledBorder tb = new TitledBorder(new EtchedBorder());
        tb.setTitleFont(this.font);
        tb.setTitle("Anim delay = 30 ms");
        this.slider.setBorder(tb);
        this.slider.setMinimumSize(new Dimension(80, 46));
        J2Ddemo.addToGridBag(this, this.slider, 0, 6, 1, 1, 1.0, 1.0);
        this.texturechooser = new TextureChooser(0, demoInstVars);
        J2Ddemo.addToGridBag(this, this.texturechooser, 0, 7, 1, 1, 1.0, 1.0);
    }

    private JCheckBox createCheckBox(String s, boolean b, int y) {
        JCheckBox cb = new JCheckBox(s, b);
        cb.setFont(this.font);
        cb.setHorizontalAlignment(2);
        cb.addItemListener(this);
        J2Ddemo.addToGridBag(this, cb, 0, y, 1, 1, 1.0, 1.0);
        return cb;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = this.slider.getValue();
        TitledBorder tb = (TitledBorder)this.slider.getBorder();
        tb.setTitle("Anim delay = " + String.valueOf(value) + " ms");
        int index = this.demoInstVars.getTabbedPane().getSelectedIndex() - 1;
        DemoGroup dg = this.demoInstVars.getGroup()[index];
        JPanel p = dg.getPanel();
        for (int i = 0; i < p.getComponentCount(); ++i) {
            DemoPanel dp = (DemoPanel)p.getComponent(i);
            if (dp.tools == null || dp.tools.slider == null) continue;
            dp.tools.slider.setValue(value);
        }
        this.slider.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.demoInstVars.getTabbedPane().getSelectedIndex() != 0) {
            this.obj = e.getSource();
            int index = this.demoInstVars.getTabbedPane().getSelectedIndex() - 1;
            this.demoInstVars.getGroup()[index].setup(true);
            this.obj = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(135, 260);
    }
}

