/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ckb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_MM = "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631";
        final String metaValue_ar = "\u0639\u06d5\u0631\u06d5\u0628\u06cc";
        final String metaValue_el = "\u06cc\u06c6\u0646\u0627\u0646\u06cc";
        final String metaValue_he = "\u0647\u06cc\u0628\u0631\u06ce";
        final String metaValue_hy = "\u0626\u06d5\u0631\u0645\u06d5\u0646\u06cc";
        final String metaValue_ja = "\u0698\u0627\u067e\u06c6\u0646\u06cc";
        final String metaValue_la = "\u0644\u0627\u062a\u06cc\u0646\u06cc";
        final String metaValue_mn = "\u0645\u06d5\u0646\u06af\u06c6\u0644\u06cc";
        final String metaValue_ta = "\u062a\u0627\u0645\u06cc\u0644\u06cc";
        final String metaValue_th = "\u062a\u0627\u06cc\u0644\u06d5\u0646\u062f\u06cc";
        final Object[][] data = new Object[][] {
            { "ps", "\u067e\u06d5\u0634\u062a\u0648\u0648" },
            { "PT", "\u067e\u0648\u0631\u062a\u0648\u06af\u0627\u0644" },
            { "pt", "\u067e\u0648\u0631\u062a\u0648\u06af\u0627\u0644\u06cc" },
            { "PW", "\u067e\u0627\u0644\u0627\u0648" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u0648\u0627\u06cc" },
            { "Hebr", metaValue_he },
            { "QA", "\u0642\u06d5\u062a\u06d5\u0631" },
            { "Laoo", "\u0644\u0627\u0648" },
            { "AD", "\u0626\u0627\u0646\u062f\u06c6\u0631\u0627" },
            { "AE", "\u0645\u06cc\u0631\u0646\u0634\u06cc\u0646\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5 \u0639\u06d5\u0631\u06d5\u0628\u06cc\u06cc\u06d5\u06a9\u0627\u0646" },
            { "AF", "\u0626\u06d5\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0626\u0627\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "AL", "\u0626\u06d5\u06b5\u0628\u0627\u0646\u06cc\u0627" },
            { "AM", "\u0626\u06d5\u0631\u0645\u06d5\u0646\u0633\u062a\u0627\u0646" },
            { "am", "\u0626\u06d5\u0645\u0647\u06d5\u0631\u06cc\u0646\u062c\u06cc" },
            { "Arab", metaValue_ar },
            { "AO", "\u0626\u06d5\u0646\u06af\u06c6\u0644\u0627" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0626\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627" },
            { "ar", metaValue_ar },
            { "AR", "\u0626\u06d5\u0631\u0698\u06d5\u0646\u062a\u06cc\u0646" },
            { "Ethi", "\u0626\u06d5\u062a\u06cc\u06c6\u067e\u06cc\u06a9" },
            { "AS", "\u0633\u0627\u0645\u0648\u0627\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "as", "\u0626\u0627\u0633\u0627\u0645\u06cc" },
            { "AT", "\u0646\u06d5\u0645\u0633\u0627" },
            { "AU", "\u0626\u0648\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0626\u0627\u0631\u0648\u0648\u0628\u0627" },
            { "sdh", "\u06a9\u0648\u0631\u062f\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "en_US", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "AZ", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646" },
            { "az", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc" },
            { "RO", "\u0695\u06c6\u0645\u0627\u0646\u06cc\u0627" },
            { "ro", "\u0695\u06c6\u0645\u0627\u0646\u06cc" },
            { "BA", "\u0628\u06c6\u0633\u0646\u06cc\u0627 \u0648 \u06be\u06d5\u0631\u0632\u06d5\u06af\u06c6\u06a4\u06cc\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u06c6\u0633" },
            { "RS", "\u0633\u0631\u0628\u06cc\u0627" },
            { "BD", "\u0628\u06d5\u0646\u06af\u0644\u0627\u062f\u06cc\u0634" },
            { "BE", "\u0628\u06d5\u0644\u0698\u06cc\u06a9" },
            { "RU", "\u0695\u0648\u0648\u0633\u06cc\u0627" },
            { "be", "\u0628\u06cc\u0644\u0627\u0695\u0648\u0648\u0633\u06cc" },
            { "ru", "\u0695\u0648\u0648\u0633\u06cc" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627\u0641\u0627\u0633\u06c6" },
            { "BG", "\u0628\u0648\u0644\u06af\u0627\u0631\u06cc\u0627" },
            { "RW", "\u0695\u0648\u0627\u0646\u062f\u0627" },
            { "bg", "\u0628\u06c6\u0644\u06af\u0627\u0631\u06cc" },
            { "BH", "\u0628\u06d5\u062d\u0631\u06d5\u06cc\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u06cc" },
            { "BJ", "\u0628\u06ce\u0646\u06cc\u0646" },
            { "en_AU", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0626\u06c6\u0633\u062a\u0631\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "bn", "\u0628\u06d5\u0646\u06af\u0644\u0627\u062f\u06ce\u0634\u06cc" },
            { "BO", "\u0628\u06c6\u0644\u06cc\u06a4\u06cc\u0627" },
            { "SA", "\u0639\u06d5\u0631\u06d5\u0628\u0633\u062a\u0627\u0646\u06cc \u0633\u06d5\u0639\u0648\u0648\u062f\u06cc" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0631\u064a\u062a" },
            { "SB", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0633\u0644\u06ce\u0645\u0627\u0646" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "SC", "\u0633\u06cc\u0634\u06ce\u0644" },
            { "br", "\u0628\u0631\u06ce\u062a\u0648\u0646\u06cc" },
            { "BS", "\u0628\u06d5\u06be\u0627\u0645\u0627" },
            { "SD", "\u0633\u0648\u0648\u062f\u0627\u0646" },
            { "bs", "\u0628\u06c6\u0633\u0646\u06cc" },
            { "sd", "\u0633\u064a\u0646\u062f\u06cc" },
            { "BT", "\u0628\u0648\u0648\u062a\u0627\u0646" },
            { "SE", "\u0633\u0648\u06cc\u062f" },
            { "SG", "\u0633\u06cc\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "Mymr", metaValue_MM },
            { "BW", "\u0628\u06c6\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "SI", "\u0633\u0644\u06c6\u06a4\u06ce\u0646\u06cc\u0627" },
            { "si", "\u0633\u06cc\u0646\u0647\u06d5\u0644\u06cc" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0695\u0648\u0648\u0633" },
            { "BZ", "\u0628\u06d5\u0644\u06cc\u0632" },
            { "SK", "\u0633\u0644\u06c6\u06a4\u0627\u06a9\u06cc\u0627" },
            { "sk", "\u0633\u0644\u06c6\u06a4\u0627\u0643\u06cc" },
            { "SL", "\u0633\u06cc\u06d5\u0631\u0627\u0644\u06cc\u06c6\u0646" },
            { "sl", "\u0633\u0644\u06c6\u06a4\u06ce\u0646\u06cc" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u06c6" },
            { "SN", "\u0633\u06cc\u0646\u06cc\u06af\u0627\u0644" },
            { "SO", "\u0633\u06c6\u0645\u0627\u0644\u06cc\u0627" },
            { "so", "\u0633\u06c6\u0645\u0627\u0644\u06cc" },
            { "CA", "\u06a9\u0627\u0646\u06d5\u062f\u0627" },
            { "ca", "\u0643\u0627\u062a\u0627\u0644\u06c6\u0646\u06cc" },
            { "sq", "\u0626\u06d5\u06b5\u0628\u0627\u0646\u06cc" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "sr", "\u0633\u06d5\u0631\u0628\u06cc" },
            { "mzn", "\u0645\u0627\u0632\u06d5\u0646\u062f\u06d5\u0631\u0627\u0646\u06cc" },
            { "CD", "\u06a9\u06c6\u0646\u06af\u06c6 \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "ST", "\u0633\u0627\u0648\u062a\u06c6\u0645\u06ce \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e\u06cc" },
            { "st", "\u0633\u06ce\u0633\u06c6\u062a\u06c6" },
            { "su", "\u0633\u0648\u062f\u0627\u0646\u06cc" },
            { "CF", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "SV", "\u0626\u06ce\u0644\u0633\u0627\u0644\u06a4\u0627\u062f\u06c6\u0631" },
            { "sv", "\u0633\u0648\u06cc\u062f\u06cc" },
            { "CH", "\u0633\u0648\u06cc\u0633\u0631\u0627" },
            { "CI", "\u06a9\u06c6\u062a\u062f\u06cc\u06a4\u0648\u0627\u0631" },
            { "SY", "\u0633\u0648\u0648\u0631\u06cc\u0627" },
            { "SZ", "\u0633\u0648\u0627\u0632\u06cc\u0644\u0627\u0646\u062f" },
            { "CL", "\u0686\u06cc\u0644\u06cc" },
            { "CM", "\u06a9\u0627\u0645\u06cc\u0631\u06c6\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u06c6\u0644\u06c6\u0645\u0628\u06cc\u0627" },
            { "ta", metaValue_ta },
            { "Orya", "\u0626\u06c6\u0631\u06cc\u0627" },
            { "CR", "\u06a9\u06c6\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "143", "\u0626\u0627\u0633\u06cc\u0627\u06cc \u0646\u0627\u0648\u06d5\u0646\u062f\u06cc" },
            { "TD", "\u0686\u0627\u062f" },
            { "cs", "\u0686\u06d5\u0643\u06cc" },
            { "te", "\u062a\u06d5\u0644\u06c6\u06af\u0648\u06cc" },
            { "145", "\u0626\u0627\u0633\u06cc\u0627\u06cc \u0695\u06c6\u0698\u0627\u0648\u0627" },
            { "CU", "\u06a9\u0648\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06d5\u06cc\u067e\u06a4\u06d5\u0631\u062f" },
            { "TG", "\u062a\u06c6\u06af\u06c6" },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "th", metaValue_th },
            { "TH", "\u062a\u0627\u06cc\u0644\u06d5\u0646\u062f" },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627\u06cc" },
            { "CY", "\u0642\u06cc\u0628\u0631\u0633" },
            { "TJ", "\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0627\u0646" },
            { "cy", "\u0648\u06ce\u0644\u0632\u06cc" },
            { "en_CA", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u06a9\u06d5\u0646\u06d5\u062f\u0627\u06cc\u06cc" },
            { "CZ", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0686\u06cc\u06a9" },
            { "tk", "\u062a\u0648\u0631\u06a9\u0645\u0627\u0646\u06cc" },
            { "TM", "\u062a\u0648\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0648\u0646\u0633" },
            { "TO", "\u062a\u06c6\u0646\u06af\u0627" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u0643\u06cc" },
            { "TR", "\u062a\u0648\u0631\u06a9\u06cc\u0627" },
            { "tr", "\u062a\u0648\u0631\u06a9\u06cc" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0648 \u062a\u06c6\u0628\u0627\u06af\u0648" },
            { "DE", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc\u0627" },
            { "de", "\u0626\u0627\u06b5\u0645\u0627\u0646\u06cc" },
            { "TV", "\u062a\u0648\u0648\u06a4\u0627\u0644\u0648\u0648" },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "DJ", "\u062c\u06cc\u0628\u0648\u0648\u062a\u06cc" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "DK", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9" },
            { "Brai", "\u0628\u0631\u06d5\u06cc\u0644" },
            { "DM", "\u062f\u06c6\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "UA", "\u0626\u06c6\u06a9\u0631\u0627\u0646\u06cc\u0627" },
            { "UG", "\u0626\u0648\u06af\u0627\u0646\u062f\u0627" },
            { "ug", "\u0626\u0648\u064a\u062e\u0648\u0648\u0631\u06cc" },
            { "Kore", "\u06a9\u06c6\u0631\u06cc\u0627\u06cc\u06cc" },
            { "039", "\u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "DZ", "\u062c\u06d5\u0632\u0627\u06cc\u0631" },
            { "uk", "\u0626\u06c6\u0643\u0631\u0627\u06cc\u0646\u06cc" },
            { "Sinh", "\u0633\u06cc\u0646\u06be\u0627\u0644\u0627" },
            { "ur", "\u0626\u06c6\u0631\u062f\u0648\u0648" },
            { "EC", "\u0626\u06cc\u06a9\u0648\u0627\u062f\u06c6\u0631" },
            { "US", "\u0648\u06cc\u0644\u0627\u06cc\u06d5\u062a\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5\u06a9\u0627\u0646" },
            { "EG", "\u0645\u06cc\u0633\u0631" },
            { "UY", "\u0626\u0648\u0631\u0648\u06af\u0648\u0627\u06cc" },
            { "UZ", "\u0626\u0648\u0632\u0628\u06d5\u06a9\u0633\u062a\u0627\u0646" },
            { "uz", "\u0626\u0648\u0632\u0628\u06d5\u06a9\u06cc" },
            { "el", metaValue_el },
            { "en", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc" },
            { "eo", "\u0626\u06ce\u0633\u067e\u06cc\u0631\u0627\u0646\u062a\u06c6" },
            { "VA", "\u06a4\u0627\u062a\u06cc\u06a9\u0627\u0646" },
            { "ER", "\u0626\u06d5\u0631\u06cc\u062a\u0631\u06cc\u0627" },
            { "VC", "\u0633\u06d5\u06cc\u0646\u062a \u06a4\u06cc\u0646\u0633\u06d5\u0646\u062a \u0648 \u06af\u0631\u06cc\u0646\u0627\u062f\u06cc\u0646\u0632" },
            { "ES", "\u0626\u06cc\u0633\u067e\u0627\u0646\u06cc\u0627" },
            { "es", "\u0626\u06cc\u0633\u067e\u0627\u0646\u06cc" },
            { "ET", "\u0626\u06d5\u062a\u06cc\u06c6\u067e\u06cc\u0627" },
            { "et", "\u0626\u06cc\u0633\u062a\u06c6\u0646\u06cc" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "Hang", "\u06be\u0627\u0646\u06af\u0648\u0644" },
            { "vi", "\u06a4\u06cc\u06d5\u062a\u0646\u0627\u0645\u06cc" },
            { "VN", "\u06a4\u06cc\u06d5\u062a\u0646\u0627\u0645" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "az_Arab", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "VU", "\u06a4\u0627\u0646\u0648\u0648\u0627\u062a\u0648\u0648" },
            { "FI", "\u0641\u06cc\u0646\u0644\u0627\u0646\u062f" },
            { "fi", "\u0641\u06cc\u0646\u0644\u06d5\u0646\u062f\u06cc" },
            { "FJ", "\u0641\u06cc\u062c\u06cc" },
            { "FM", "\u0645\u0627\u06cc\u06a9\u0631\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u06d5\u0695\u06d5\u0646\u0633\u0627" },
            { "fr", "\u0641\u06d5\u0631\u0627\u0646\u0633\u06cc" },
            { "Grek", metaValue_el },
            { "fy", "\u0641\u0631\u06cc\u0633\u06cc\u06cc \u0695\u06c6\u0698\u0627\u0648\u0627" },
            { "GA", "\u06af\u0627\u0628\u06c6\u0646" },
            { "ga", "\u0626\u06cc\u0631\u0644\u06d5\u0646\u062f\u06cc" },
            { "GB", "\u0634\u0627\u0646\u0634\u06cc\u0646\u06cc \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "GD", "\u06af\u0631\u06cc\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "Mong", metaValue_mn },
            { "GH", "\u063a\u06d5\u0646\u0627" },
            { "GL", "\u06af\u0631\u06cc\u0646\u0644\u0627\u0646\u062f" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0633\u06cc" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u06cc\u0646\u06ce" },
            { "gn", "\u06af\u0648\u0648\u0627\u0631\u0627\u0646\u06cc" },
            { "und", "\u0632\u0645\u0627\u0646\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "Latn", metaValue_la },
            { "GR", "\u06cc\u06c6\u0646\u0627\u0646" },
            { "GT", "\u06af\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0627\u0645" },
            { "gu", "\u06af\u0648\u062c\u0627\u0631\u0627\u062a\u06cc" },
            { "GW", "\u06af\u06cc\u0646\u06ce \u0628\u06cc\u0633\u0627\u0648" },
            { "GY", "\u06af\u0648\u06cc\u0627\u0646\u0627" },
            { "Gujr", "\u06af\u0648\u062c\u06d5\u0631\u0627\u062a\u06cc" },
            { "ckb", "\u06a9\u0648\u0631\u062f\u06cc\u06cc \u0646\u0627\u0648\u06d5\u0646\u062f\u06cc" },
            { "he", metaValue_he },
            { "hi", "\u0647\u06cc\u0646\u062f\u06cc" },
            { "HN", "\u06be\u06c6\u0646\u062f\u0648\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u06c6\u0648\u0627\u062a\u06cc\u0627" },
            { "hr", "\u0643\u0631\u0648\u0627\u062a\u06cc" },
            { "HT", "\u06be\u0627\u06cc\u062a\u06cc" },
            { "YE", "\u06cc\u06d5\u0645\u06d5\u0646" },
            { "HU", "\u0645\u06d5\u062c\u0627\u0631\u0633\u062a\u0627\u0646" },
            { "hu", "\u0647\u06d5\u0646\u06af\u0627\u0631\u06cc (\u0645\u06d5\u062c\u0627\u0631\u06cc)" },
            { "hy", metaValue_hy },
            { "ID", "\u0626\u06cc\u0646\u062f\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "id", "\u0626\u06ce\u06d5\u0646\u062f\u0648\u0646\u06cc\u0632\u06cc" },
            { "IE", "\u0626\u06cc\u0631\u0644\u06d5\u0646\u062f" },
            { "IL", "\u0626\u06cc\u0633\u0631\u0627\u0626\u06cc\u0644" },
            { "IN", "\u06be\u06cc\u0646\u062f\u0633\u062a\u0627\u0646" },
            { "ZA", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "IQ", "\u0639\u06ce\u0631\u0627\u0642" },
            { "IR", "\u0626\u06ce\u0631\u0627\u0646" },
            { "IS", "\u0626\u0627\u06cc\u0633\u0644\u06d5\u0646\u062f" },
            { "is", "\u0626\u06cc\u0633\u0644\u06d5\u0646\u062f\u06cc" },
            { "IT", "\u0626\u06cc\u062a\u0627\u06b5\u06cc" },
            { "it", "\u0626\u06cc\u062a\u0627\u0644\u06cc" },
            { "Deva", "\u062f\u06d5\u06a4\u06d5\u0646\u0627\u06af\u06d5\u0631\u06cc" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "Hira", "\u06be\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "Bopo", "\u0628\u06c6\u067e\u06c6\u0645\u06c6\u0641\u06c6" },
            { "ja", metaValue_ja },
            { "Mlym", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u06cc" },
            { "Geor", "\u06af\u0648\u0631\u062c\u06cc" },
            { "JM", "\u062c\u0627\u0645\u0627\u06cc\u06a9\u0627" },
            { "Beng", "\u0628\u06d5\u0646\u06af\u0627\u0644\u06cc" },
            { "JO", "\u0626\u0648\u0631\u062f\u0646" },
            { "JP", "\u0698\u0627\u067e\u06c6\u0646" },
            { "sma", "\u0633\u0627\u0645\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "jv", "\u062c\u0627\u06a4\u0627\u0646\u06cc" },
            { "ka", "\u06af\u06c6\u0631\u062c\u0633\u062a\u0627\u0646\u06cc" },
            { "KG", "\u0642\u0631\u063a\u06cc\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u06d5\u0645\u0628\u06c6\u062f\u06cc\u0627" },
            { "KI", "\u06a9\u06cc\u0631\u06cc\u0628\u0627\u0633" },
            { "kk", "\u06a9\u0627\u0632\u0627\u062e\u06cc" },
            { "KM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06c6\u0645\u06c6\u0631" },
            { "KN", "\u0633\u06d5\u06cc\u0646\u062a \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u06cc\u06a4\u06cc\u0633" },
            { "Knda", "\u06a9\u06d5\u0646\u06d5\u062f\u0627" },
            { "KP", "\u06a9\u06c6\u0631\u06cc\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "ku", "\u06a9\u0648\u0631\u062f\u06cc" },
            { "KW", "\u06a9\u0648\u06d5\u06cc\u062a" },
            { "ky", "\u0643\u0631\u06af\u06cc\u0632\u06cc" },
            { "KZ", "\u06a9\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u0631\u06cc\u0644\u06cc\u06a9" },
            { "la", metaValue_la },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0648\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06d5\u06cc\u0646\u062a \u0644\u0648\u0648\u0633\u06cc\u0627" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u06cc\u0644\u0627\u0646\u06a9\u0627" },
            { "ln", "\u0644\u064a\u0646\u06af\u0627\u0644\u0627" },
            { "lo", "\u0644\u0627\u0648\u06cc" },
            { "LR", "\u0644\u06cc\u0628\u06d5\u0631\u06cc\u0627" },
            { "LS", "\u0644\u06d5\u0633\u06c6\u062a\u06c6" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u0627\u06cc\u0627" },
            { "lt", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc" },
            { "LU", "\u0644\u0648\u06a9\u0633\u06d5\u0645\u0628\u0648\u0631\u06af" },
            { "LV", "\u0644\u0627\u062a\u06a4\u06cc\u0627" },
            { "lv", "\u0644\u06ce\u062a\u06c6\u0646\u06cc" },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "Thaa", "\u062a\u0627\u0646\u06d5" },
            { "MA", "\u0645\u06d5\u063a\u0631\u06cc\u0628" },
            { "MC", "\u0645\u06c6\u0646\u0627\u06a9\u06c6" },
            { "MD", "\u0645\u06c6\u0644\u062f\u06c6\u06a4\u0627" },
            { "ME", "\u0645\u06c6\u0646\u062a\u06cc\u0646\u06cc\u06af\u0631\u06c6" },
            { "MG", "\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "Thai", metaValue_th },
            { "MH", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0631\u0634\u0627\u06b5" },
            { "mk", "\u0645\u0627\u0643\u06ce\u062f\u06c6\u0646\u06cc" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", metaValue_MM },
            { "mn", metaValue_mn },
            { "MN", "\u0645\u06d5\u0646\u06af\u06c6\u0644\u06cc\u0627" },
            { "MR", "\u0645\u06c6\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "mr", "\u0645\u0627\u0631\u0627\u062a\u06cc" },
            { "MT", "\u0645\u0627\u06b5\u062a\u0627" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u06a4" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06d5\u06a9\u0633\u06cc\u06a9" },
            { "MY", "\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627" },
            { "Armn", metaValue_hy },
            { "MZ", "\u0645\u06c6\u0632\u0627\u0645\u0628\u06cc\u06a9" },
            { "NA", "\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627" },
            { "NE", "\u0646\u06cc\u062c\u06d5\u0631" },
            { "ne", "\u0646\u06cc\u067e\u0627\u0644\u06cc" },
            { "NI", "\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0627" },
            { "NL", "\u06be\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "nl", "\u0647\u06c6\u06b5\u06d5\u0646\u062f\u06cc" },
            { "NO", "\u0646\u06c6\u0631\u0648\u06cc\u0698" },
            { "no", "\u0646\u06c6\u0631\u0648\u06ce\u0698\u06cc" },
            { "Khmr", "\u062e\u0645\u06ce\u0631\u06cc" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0626\u0648\u0631\u0648\u0648" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0627\u0646\u062f" },
            { "OM", "\u0639\u0648\u0645\u0627\u0646" },
            { "or", "\u0626\u06c6\u0631\u06cc\u06cc\u0627" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "pa", "\u067e\u06d5\u0646\u062c\u0627\u0628\u06cc" },
            { "Guru", "\u06af\u0648\u0631\u0645\u0648\u06a9\u06be\u06cc" },
            { "en_GB", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "PE", "\u067e\u06cc\u0631\u0648\u0648" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u06af\u06cc\u0646\u06ce\u06cc \u0646\u0648\u06ce" },
            { "PH", "\u0641\u0644\u06cc\u067e\u06cc\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "pl", "\u067e\u06c6\u06b5\u06c6\u0646\u06cc\u0627\u06cc\u06cc (\u0644\u06d5\u0647\u0633\u062a\u0627\u0646\u06cc)" },
            { "Telu", "\u062a\u06cc\u0644\u0648\u06af\u0648" },
        };
        return data;
    }
}
