/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;

class ImageBufferCache {
    private static final int MAX_CACHED_BUFFERS = 3;
    private static final int LARGE_BUFFER = 65536;
    private static final ThreadLocal<BufferReference[]> CACHE = new ThreadLocal<BufferReference[]>(){

        @Override
        protected BufferReference[] initialValue() {
            return new BufferReference[4];
        }
    };
    private static Comparator<BufferReference> DECREASING_CAPACITY_NULLS_LAST = new Comparator<BufferReference>(){

        @Override
        public int compare(BufferReference br1, BufferReference br2) {
            return Integer.compare(br2 == null ? 0 : br2.capacity, br1 == null ? 0 : br1.capacity);
        }
    };

    ImageBufferCache() {
    }

    private static ByteBuffer allocateBuffer(long size) {
        return ByteBuffer.allocateDirect((int)(size + 4095L & 0xFFFFFFFFFFFFF000L));
    }

    static ByteBuffer getBuffer(long size) {
        if (size < 0L || Integer.MAX_VALUE < size) {
            throw new IndexOutOfBoundsException("size");
        }
        ByteBuffer result = null;
        if (size > 65536L) {
            result = ImageBufferCache.allocateBuffer(size);
        } else {
            BufferReference[] cache = CACHE.get();
            for (int i = 2; i >= 0; --i) {
                ByteBuffer buffer;
                BufferReference reference = cache[i];
                if (reference == null || (buffer = (ByteBuffer)reference.get()) == null || size > (long)buffer.capacity()) continue;
                cache[i] = null;
                result = buffer;
                result.rewind();
                break;
            }
            if (result == null) {
                result = ImageBufferCache.allocateBuffer(size);
            }
        }
        result.limit((int)size);
        return result;
    }

    static void releaseBuffer(ByteBuffer buffer) {
        if (buffer.capacity() > 65536) {
            return;
        }
        BufferReference[] cache = CACHE.get();
        for (int i = 0; i < 3; ++i) {
            BufferReference reference = cache[i];
            if (reference == null || reference.get() != null) continue;
            cache[i] = null;
        }
        cache[3] = new BufferReference(buffer);
        Arrays.sort(cache, DECREASING_CAPACITY_NULLS_LAST);
        cache[3] = null;
    }

    private static class BufferReference
    extends WeakReference<ByteBuffer> {
        final int capacity;

        BufferReference(ByteBuffer buffer) {
            super(buffer);
            this.capacity = buffer.capacity();
        }
    }
}

