/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_shi extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u2d49\u2d4f\u2d4f\u2d30\u2d62\u2d54",
               "\u2d31\u2d55\u2d30\u2d62\u2d55",
               "\u2d4e\u2d30\u2d55\u2d5a",
               "\u2d49\u2d31\u2d54\u2d49\u2d54",
               "\u2d4e\u2d30\u2d62\u2d62\u2d53",
               "\u2d62\u2d53\u2d4f\u2d62\u2d53",
               "\u2d62\u2d53\u2d4d\u2d62\u2d53\u2d63",
               "\u2d56\u2d53\u2d5b\u2d5c",
               "\u2d5b\u2d53\u2d5c\u2d30\u2d4f\u2d31\u2d49\u2d54",
               "\u2d3d\u2d5c\u2d53\u2d31\u2d54",
               "\u2d4f\u2d53\u2d61\u2d30\u2d4f\u2d31\u2d49\u2d54",
               "\u2d37\u2d53\u2d4a\u2d30\u2d4f\u2d31\u2d49\u2d54",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u2d49\u2d4f\u2d4f",
               "\u2d31\u2d55\u2d30",
               "\u2d4e\u2d30\u2d55",
               "\u2d49\u2d31\u2d54",
               "\u2d4e\u2d30\u2d62",
               "\u2d62\u2d53\u2d4f",
               "\u2d62\u2d53\u2d4d",
               "\u2d56\u2d53\u2d5b",
               "\u2d5b\u2d53\u2d5c",
               "\u2d3d\u2d5c\u2d53",
               "\u2d4f\u2d53\u2d61",
               "\u2d37\u2d53\u2d4a",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u2d49",
               "\u2d31",
               "\u2d4e",
               "\u2d49",
               "\u2d4e",
               "\u2d62",
               "\u2d62",
               "\u2d56",
               "\u2d5b",
               "\u2d3d",
               "\u2d4f",
               "\u2d37",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u2d30\u2d59\u2d30\u2d4e\u2d30\u2d59",
               "\u2d30\u2d62\u2d4f\u2d30\u2d59",
               "\u2d30\u2d59\u2d49\u2d4f\u2d30\u2d59",
               "\u2d30\u2d3d\u2d55\u2d30\u2d59",
               "\u2d30\u2d3d\u2d61\u2d30\u2d59",
               "\u2d59\u2d49\u2d4e\u2d61\u2d30\u2d59",
               "\u2d30\u2d59\u2d49\u2d39\u2d62\u2d30\u2d59",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u2d30\u2d59\u2d30",
               "\u2d30\u2d62\u2d4f",
               "\u2d30\u2d59\u2d49",
               "\u2d30\u2d3d\u2d55",
               "\u2d30\u2d3d\u2d61",
               "\u2d30\u2d59\u2d49\u2d4e",
               "\u2d30\u2d59\u2d49\u2d39",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u2d30\u2d3d\u2d55\u2d30\u2d39\u2d62\u2d53\u2d54 1",
               "\u2d30\u2d3d\u2d55\u2d30\u2d39\u2d62\u2d53\u2d54 2",
               "\u2d30\u2d3d\u2d55\u2d30\u2d39\u2d62\u2d53\u2d54 3",
               "\u2d30\u2d3d\u2d55\u2d30\u2d39\u2d62\u2d53\u2d54 4",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "\u2d30\u2d3d 1",
               "\u2d30\u2d3d 2",
               "\u2d30\u2d3d 3",
               "\u2d30\u2d3d 4",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u2d5c\u2d49\u2d3c\u2d30\u2d61\u2d5c",
               "\u2d5c\u2d30\u2d37\u2d33\u2d33\u2d6f\u2d30\u2d5c",
            };
        final String[] metaValue_Eras = new String[] {
               "\u2d37\u2d30\u2d44",
               "\u2d37\u2d3c\u2d44",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE d MMMM y G",
               "d MMMM y G",
               "d MMM, y G",
               "d/M/y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE d MMMM y GGGG",
               "d MMMM y GGGG",
               "d MMM, y GGGG",
               "d/M/y G",
            };
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u2d30\u2d59\u2d33\u2d33\u2d6f\u2d30\u2d59" },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "field.zone", "\u2d30\u2d3d\u2d53\u2d37 \u2d4f \u2d53\u2d33\u2d4e\u2d4e\u2d30\u2d39" },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "narrow.Eras", metaValue_Eras },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "roc.DayNames", metaValue_DayNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "long.Eras",
                new String[] {
                    "\u2d37\u2d30\u2d5c \u2d4f \u2d44\u2d49\u2d59\u2d30",
                    "\u2d37\u2d3c\u2d3c\u2d49\u2d54 \u2d4f \u2d44\u2d49\u2d59\u2d30",
                }
            },
            { "islamic.DayNames", metaValue_DayNames },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "field.weekday", "\u2d30\u2d59\u2d59 \u2d33 \u2d49\u2d4e\u2d30\u2d4d\u2d30\u2d59\u2d59" },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    "\u00a0",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u2d5c\u2d53\u2d59\u2d37\u2d49\u2d37\u2d5c" },
            { "field.era", "\u2d5c\u2d30\u2d59\u2d53\u2d5c" },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u2d5c\u2d49\u2d63\u2d49 \u2d33 \u2d61\u2d30\u2d59\u2d59: \u2d5c\u2d49\u2d3c\u2d30\u2d61\u2d5c/\u2d5c\u2d30\u2d37\u2d33\u2d33\u2d6f\u2d30\u2d5c" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "field.month", "\u2d30\u2d62\u2d62\u2d53\u2d54" },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "field.second", "\u2d5c\u2d30\u2d59\u2d49\u2d4f\u2d5c" },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\u2d49\u2d4e\u2d30\u2d4d\u2d30\u2d59\u2d59" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a4",
                    "#,##0%",
                }
            },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "DatePatterns",
                new String[] {
                    "EEEE d MMMM y",
                    "d MMMM y",
                    "d MMM, y",
                    "d/M/y",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "field.hour", "\u2d5c\u2d30\u2d59\u2d54\u2d30\u2d33\u2d5c" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "roc.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "QuarterNames", metaValue_QuarterNames },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
        };
        return data;
    }
}
