/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WidgetUtils {
    public static int getIndex(Control control) {
        int index = 0;
        Composite parent = null;
        do {
            parent = control.getParent();
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c.equals(control)) {
                    return index;
                }
                if (c.getClass().equals(control.getClass())) {
                    ++index;
                }
                ++n2;
            }
        } while (!(parent instanceof Shell));
        throw new RuntimeException("Could not determine index for widget " + control);
    }

    public static String getGroup(Control control) {
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent instanceof Group) {
                return ((Group)parent).getText();
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Shell getShell(Control widget) {
        while (widget != null) {
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            widget = widget.getParent();
        }
        return null;
    }

    public static String getLabel(Control widget) {
        Control[] controls = widget.getParent().getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Label && controls[i + 1].equals(widget)) {
                return ((Label)controls[i]).getText();
            }
            ++i;
        }
        return null;
    }

    public static String cleanText(String text) {
        if (text != null) {
            return text.replaceAll("&", "").split("\t")[0];
        }
        return null;
    }

    private static Control getPreviousControl(Control control) {
        int i = Arrays.asList(control.getParent().getChildren()).indexOf(control);
        if (i == 0) {
            return null;
        }
        return control.getParent().getChildren()[i - 1];
    }

    public static String widgetLocator(Widget widget) {
        if (widget instanceof Text) {
            return WidgetUtils.widgetLocator((Text)widget);
        }
        if (widget instanceof StyledText) {
            return WidgetUtils.widgetLocator((StyledText)widget);
        }
        if (widget instanceof MenuItem) {
            return WidgetUtils.widgetLocator((MenuItem)widget);
        }
        return "Widget not supported: " + widget.getClass().getSimpleName();
    }

    public static String widgetLocator(Text text) {
        StringBuilder res = new StringBuilder("bot.");
        Control previous = WidgetUtils.getPreviousControl((Control)text);
        if (previous instanceof Label && !((Label)previous).getText().isEmpty()) {
            res.append("textWithLabel(\"");
            res.append(((Label)previous).getText());
            res.append("\")");
        } else {
            res.append("text(");
            int index = WidgetUtils.getIndex((Control)text);
            if (index != 0) {
                res.append(index);
            }
            res.append(")");
        }
        return res.toString();
    }

    public static String widgetLocator(StyledText text) {
        StringBuilder res = new StringBuilder("bot.");
        Control previous = WidgetUtils.getPreviousControl((Control)text);
        if (previous instanceof Label && !((Label)previous).getText().isEmpty()) {
            res.append("styledTextWithLabel(\"");
            res.append(((Label)previous).getText());
            res.append("\")");
        } else {
            res.append("styledText(");
            int index = WidgetUtils.getIndex((Control)text);
            if (index != 0) {
                res.append(index);
            }
            res.append(")");
        }
        return res.toString();
    }

    public static String widgetLocator(MenuItem menuItem) {
        StringBuilder res = new StringBuilder("bot");
        ArrayList<String> path = new ArrayList<String>();
        MenuItem currentItem = menuItem;
        Menu parent = null;
        while (currentItem != null && currentItem.getParent() != null) {
            path.add(WidgetUtils.cleanText(currentItem.getText()));
            parent = currentItem.getParent();
            currentItem = parent.getParentItem();
        }
        Collections.reverse(path);
        boolean isPopup = (parent.getStyle() & 8) != 0;
        boolean isFirst = true;
        for (String text : path) {
            if (isFirst && isPopup) {
                isFirst = false;
                res.append(".contextMenu(\"");
            } else {
                res.append(".menu(\"");
            }
            res.append(WidgetUtils.cleanText(text));
            res.append("\")");
        }
        return res.toString();
    }
}

