/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.IQueuedElement;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousActiveQueue<Data extends IQueuedElement<Data>> {
    protected final String name;
    protected final LinkedList<Data> queue;
    protected final IRecordHandler<Data> handler;
    protected final boolean system;
    static final boolean DEBUG = SVNTeamPlugin.instance().isDebugging();

    public AsynchronousActiveQueue(String queueName, IRecordHandler<Data> handler, boolean system) {
        this.name = queueName;
        this.queue = new LinkedList();
        this.handler = handler;
        this.system = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Data data) {
        LinkedList<Data> linkedList = this.queue;
        synchronized (linkedList) {
            IQueuedElement old;
            int i;
            if (!this.queue.isEmpty() && data.canSkip()) {
                i = this.queue.size() - 1;
                while (i >= 0) {
                    old = (IQueuedElement)this.queue.get(i);
                    if (old.equals(data)) {
                        if (DEBUG) {
                            this.logDebug("skipped: " + data);
                        }
                        return;
                    }
                    --i;
                }
            }
            if (this.queue.size() > 1) {
                i = this.queue.size() - 1;
                while (i > 0) {
                    old = (IQueuedElement)this.queue.get(i);
                    if (old.canMerge(data)) {
                        this.queue.set(i, old.merge(data));
                        if (DEBUG) {
                            this.logDebug("merged " + old + " with " + data);
                        }
                        return;
                    }
                    --i;
                }
            }
            this.queue.add(data);
            if (DEBUG) {
                this.logDebug("added " + data);
            }
            if (this.queue.size() == 1) {
                ProgressMonitorUtility.doTaskScheduledDefault(new QueuedOperation(this.name), this.system);
            }
        }
    }

    private void logDebug(String message) {
        if (DEBUG) {
            System.out.println("[" + this.name + "] size: " + this.queue.size() + ", " + message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRecordHandler<Data extends IQueuedElement<Data>> {
        public void process(IProgressMonitor var1, IActionOperation var2, Data var3);
    }

    private final class QueuedOperation
    extends AbstractActionOperation {
        private QueuedOperation(String operationName) {
            super(operationName, SVNMessages.class);
        }

        public ISchedulingRule getSchedulingRule() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runImpl(IProgressMonitor monitor) throws Exception {
            while (true) {
                IQueuedElement record;
                LinkedList linkedList = AsynchronousActiveQueue.this.queue;
                synchronized (linkedList) {
                    if (monitor.isCanceled() || AsynchronousActiveQueue.this.queue.isEmpty()) {
                        AsynchronousActiveQueue.this.queue.clear();
                        break;
                    }
                    record = (IQueuedElement)AsynchronousActiveQueue.this.queue.get(0);
                }
                AsynchronousActiveQueue.this.handler.process(monitor, this, record);
                if (DEBUG) {
                    AsynchronousActiveQueue.this.logDebug("processed " + record);
                }
                linkedList = AsynchronousActiveQueue.this.queue;
                synchronized (linkedList) {
                    AsynchronousActiveQueue.this.queue.remove(0);
                    if (AsynchronousActiveQueue.this.queue.isEmpty()) {
                        break;
                    }
                }
            }
        }
    }
}

