/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.svn.core.operation.local.GetAllResourcesOperation;
import org.eclipse.team.svn.core.synchronize.IRemoteStatusCache;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class PersistentRemoteStatusCache
extends PersistantResourceVariantByteStore
implements IRemoteStatusCache {
    public PersistentRemoteStatusCache(QualifiedName qualifiedName) {
        super(qualifiedName);
    }

    public boolean containsData() throws TeamException {
        IResource[] roots;
        boolean containsData = false;
        IResource[] iResourceArray = roots = this.roots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (this.getBytes(root) != null) {
                containsData = true;
                break;
            }
            ++n2;
        }
        return containsData;
    }

    public void clearAll() throws TeamException {
        IResource[] resources;
        IResource[] iResourceArray = resources = this.roots();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.flushBytes(resource, 2);
            ++n2;
        }
    }

    public IResource[] allMembers(IResource resource) throws TeamException {
        if (!(resource instanceof IContainer)) {
            return FileUtility.NO_CHILDREN;
        }
        IResource[] known = this.members(resource);
        ArrayList<Object> members = known.length == 0 ? new ArrayList() : new ArrayList<IResource>(Arrays.asList(known));
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.svn.core.svnnature") != null) {
            IContainer container = (IContainer)resource;
            GetAllResourcesOperation op = new GetAllResourcesOperation(container);
            ProgressMonitorUtility.doTaskExternal(op, (IProgressMonitor)new NullProgressMonitor());
            IResource[] children = op.getChildren();
            if (children.length > 0) {
                members.addAll(Arrays.asList(children));
            }
        }
        return members.toArray(new IResource[members.size()]);
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (this.getBytes(resource) == null) {
            return new IResource[0];
        }
        return super.members(resource);
    }

    public boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
        IContainer parent;
        if (!resource.isAccessible() && bytes != null && (parent = resource.getParent()) != null && !parent.isAccessible()) {
            this.setBytes((IResource)parent, new byte[0]);
        }
        return super.setBytes(resource, bytes);
    }

    public byte[] getBytes(IResource resource) throws TeamException {
        return super.getBytes(resource);
    }

    public boolean flushBytes(IResource resource, int depth) throws TeamException {
        return resource.isAccessible() ? super.flushBytes(resource, depth) : false;
    }

    public boolean deleteBytes(IResource resource) throws TeamException {
        return super.deleteBytes(resource);
    }

    public void traverse(IResource[] resources, int depth, IRemoteStatusCache.ICacheVisitor visitor) throws TeamException {
        int i = 0;
        while (i < resources.length) {
            this.traverse(resources[i], depth, visitor);
            ++i;
        }
    }

    protected void traverse(IResource resource, int depth, IRemoteStatusCache.ICacheVisitor visitor) throws TeamException {
        IPath base = resource.getFullPath();
        this.traverseImpl(base, resource, depth, visitor);
    }

    protected void traverseImpl(IPath base, IResource resource, int depth, IRemoteStatusCache.ICacheVisitor visitor) throws TeamException {
        byte[] data = this.getBytes(resource);
        if (data != null && this.isChildOf(base, resource.getFullPath(), depth)) {
            visitor.visit(resource.getFullPath(), data);
        }
        if (depth != 0) {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.members(resource);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                this.traverseImpl(base, res, depth == 1 ? 0 : 2, visitor);
                ++n2;
            }
        }
    }

    protected boolean isChildOf(IPath base, IPath current, int depth) {
        int matchingSegmentsCount;
        int cachedSegmentsCount;
        int difference;
        return base.isPrefixOf(current) && ((difference = (cachedSegmentsCount = current.segmentCount()) - (matchingSegmentsCount = base.matchingFirstSegments(current))) >= 0 && depth == 2 || depth >= difference);
    }

    protected IResource[] roots() {
        return UpdateSubscriber.instance().roots();
    }
}

