/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.change;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.local.change.FileChange;
import org.eclipse.team.svn.core.operation.local.change.FolderChange;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.resource.ILocalFile;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.utility.FileUtility;

public abstract class ResourceChange {
    protected ILocalResource local;
    protected File tmp;
    protected SVNProperty[] properties;

    public ResourceChange(ResourceChange parent, ILocalResource local, boolean needsTemporary) {
        this.local = local;
        if (needsTemporary) {
            this.tmp = SVNTeamPlugin.instance().getTemporaryFile(parent == null ? null : parent.getTemporary(), local.getName());
        }
        this.properties = null;
    }

    public ILocalResource getLocal() {
        return this.local;
    }

    public SVNProperty[] getProperties() {
        return this.properties;
    }

    public void setProperties(SVNProperty[] properties) {
        this.properties = properties;
    }

    public File getTemporary() {
        return this.tmp;
    }

    public void disposeChangeModel(IProgressMonitor monitor) throws Exception {
        if (this.tmp != null) {
            FileUtility.deleteRecursive(this.tmp, monitor);
        }
    }

    public void traverse(IResourceChangeVisitor visitor, int depth, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        this.preTraverse(visitor, depth, processor, monitor);
        this.postTraverse(visitor, depth, processor, monitor);
    }

    protected abstract void preTraverse(IResourceChangeVisitor var1, int var2, IActionOperationProcessor var3, IProgressMonitor var4) throws Exception;

    protected abstract void postTraverse(IResourceChangeVisitor var1, int var2, IActionOperationProcessor var3, IProgressMonitor var4) throws Exception;

    public static ResourceChange wrapLocalResource(ResourceChange parent, ILocalResource local, boolean needsTemporary) {
        if (local == null) {
            return null;
        }
        return local instanceof ILocalFile ? new FileChange(parent, (ILocalFile)local, needsTemporary) : new FolderChange(parent, (ILocalFolder)local, needsTemporary);
    }
}

