/*******************************************************************************
 * Copyright (c) 2005-2008 Polarion Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Alexander Gurov (Polarion Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.team.svn.core.extension.options;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/**
 * Allows to define dynamically resource ignore rules
 * 
 * @author Alexander Gurov
 */
public interface IIgnoreRecommendations {
	/**
	 * Tells if the given resource can be processed by recommendation provider
	 * @param resource resource to be processed
	 * @return true if and only if the given resource can be processed by recommendation provider
	 * @throws CoreException
	 */
	public boolean isAcceptableNature(IResource resource) throws CoreException;
	/**
	 * Tells if ignore is recommended for the given resource
	 * @param resource resource to be processed
	 * @return true if and only if ignore is recommended for the given resource
	 * @throws CoreException
	 */
	public boolean isIgnoreRecommended(IResource resource) throws CoreException;
	/**
	 * Tells if resource is autogenerated output
	 * @param resource resource to be processed
	 * @return true if and only if resource is autogenerated output
	 * @throws CoreException
	 */
	public boolean isOutput(IResource resource) throws CoreException;
}
