/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.properties;

import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IAConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IConfigureOption;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.AutotoolsUIPluginImages;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.ToolListElement;
import org.eclipse.swt.graphics.Image;

public class ToolListLabelProvider
extends LabelProvider {
    private final Image IMG_TOOL = AutotoolsUIPluginImages.get("org.eclipse.linuxtools.cdt.autotools.ui.config_tool.gif");
    private final Image IMG_CAT = AutotoolsUIPluginImages.get("org.eclipse.linuxtools.cdt.autotools.ui.config_category.gif");
    private static final String ERROR_UNKNOWN_ELEMENT = "ConfigurePropertyPage.error.Unknown_tree_element";
    private ImageDescriptor descriptor = null;
    private ResourceManager manager = null;
    private IAConfiguration cfg = null;

    public ToolListLabelProvider(IAConfiguration cfg) {
        this.cfg = cfg;
    }

    public IAConfiguration getCfg() {
        return this.cfg;
    }

    public void setCfg(IAConfiguration cfg) {
        this.cfg = cfg;
    }

    public Image getImage(Object element) {
        if (!(element instanceof ToolListElement)) {
            throw this.unknownElement(element);
        }
        Image defaultImage = this.IMG_CAT;
        ToolListElement toolListElement = (ToolListElement)element;
        IConfigureOption cat = this.cfg.getOption(toolListElement.getName());
        if (cat == null) {
            defaultImage = this.IMG_TOOL;
        }
        return defaultImage;
    }

    public String getText(Object element) {
        if (!(element instanceof ToolListElement)) {
            throw this.unknownElement(element);
        }
        ToolListElement toolListElement = (ToolListElement)element;
        IConfigureOption cat = this.cfg.getOption(toolListElement.getName());
        if (cat == null) {
            return toolListElement.getName();
        }
        return cat.getDescription();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException(UIMessages.getFormattedString((String)ERROR_UNKNOWN_ELEMENT, (String)element.getClass().getName()));
    }

    public void dispose() {
        if (this.descriptor != null && this.manager != null) {
            this.manager.destroyImage(this.descriptor);
        }
    }
}

