/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.properties.ToolListElement;

public class ToolListContentProvider
implements ITreeContentProvider {
    private ToolListElement[] elements;

    private ToolListElement[] createElements() {
        ArrayList<ToolListElement> toolList = new ArrayList<ToolListElement>();
        AutotoolsConfiguration.Option[] options = AutotoolsConfiguration.getTools();
        int i = 0;
        while (i < options.length) {
            AutotoolsConfiguration.Option opt = options[i];
            String optName = opt.getName();
            ToolListElement tool = new ToolListElement(optName, 5);
            toolList.add(tool);
            AutotoolsConfiguration.Option[] categories = AutotoolsConfiguration.getChildOptions((String)optName);
            int j = 0;
            while (j < categories.length) {
                String catName = categories[j].getName();
                ToolListElement newItem = new ToolListElement(catName, 0);
                tool.addChild(newItem);
                ++j;
            }
            ++i;
        }
        return toolList.toArray(new ToolListElement[toolList.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AutotoolsConfiguration) {
            return (Object[])this.elements.clone();
        }
        return ((ToolListElement)parentElement).getChildren();
    }

    public Object getParent(Object element) {
        return ((ToolListElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((ToolListElement)element).hasChildren();
    }

    public Object[] getElements(Object inputElement) {
        if (this.elements != null) {
            return (Object[])this.elements.clone();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.elements = this.createElements();
    }
}

