/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config;

public class TraceChannel
implements Cloneable {
    public static final int UNKNOWN_VALUE = -1;
    public static final String UNKNOWN_STRING = "?";
    public static final String UST_TRACE_CHANNEL_NAME = "AUTO";
    private String fName = "";
    private boolean fIsEnabled = true;
    private boolean fIsEnabledStatusKnown = false;
    private boolean fIsChannelOverride = false;
    private boolean fIsChannelOverrideStatusKnown = false;
    private long fSubbufNum = 0L;
    private long fSubbufSize = 0L;
    private long fTimer = 0L;

    public TraceChannel(String name, long subbufNum, long subbufSize, long timer) {
        this.fName = name;
        this.fIsEnabled = false;
        this.fIsEnabledStatusKnown = false;
        this.fIsChannelOverride = false;
        this.fIsChannelOverrideStatusKnown = false;
        this.fSubbufNum = subbufNum;
        this.fSubbufSize = subbufSize;
        this.fTimer = timer;
    }

    public TraceChannel(String name, boolean isEnabled, boolean issChannelOverride, long subbufNum, long subbufSize, long timer) {
        this.fName = name;
        this.fIsEnabled = isEnabled;
        this.fIsEnabledStatusKnown = true;
        this.fIsChannelOverride = issChannelOverride;
        this.fIsChannelOverrideStatusKnown = true;
        this.fSubbufNum = subbufNum;
        this.fSubbufSize = subbufSize;
        this.fTimer = timer;
    }

    public TraceChannel(String name) {
        this(name, -1L, -1L, -1L);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.fIsEnabled = isEnabled;
        this.fIsEnabledStatusKnown = true;
    }

    public boolean isEnabledStatusKnown() {
        return this.fIsEnabledStatusKnown;
    }

    public void setIsEnabledStatusKnown(boolean isKnown) {
        this.fIsEnabledStatusKnown = isKnown;
    }

    public boolean isChannelOverride() {
        return this.fIsChannelOverride;
    }

    public void setIsChannelOverride(boolean isChannelOverride) {
        this.fIsChannelOverride = isChannelOverride;
        this.fIsChannelOverrideStatusKnown = true;
    }

    public boolean isChannelOverrideStatusKnown() {
        return this.fIsChannelOverrideStatusKnown;
    }

    public void setIsChannelOverrideStatusKnown(boolean isKnown) {
        this.fIsChannelOverrideStatusKnown = isKnown;
    }

    public long getSubbufNum() {
        return this.fSubbufNum;
    }

    public void setSubbufNum(long subbufNum) {
        this.fSubbufNum = subbufNum;
    }

    public long getSubbufSize() {
        return this.fSubbufSize;
    }

    public void setSubbufSize(long subbufSize) {
        this.fSubbufSize = subbufSize;
    }

    public long getTimer() {
        return this.fTimer;
    }

    public void setTimer(long timer) {
        this.fTimer = timer;
    }

    public TraceChannel clone() {
        TraceChannel clone = null;
        try {
            clone = (TraceChannel)super.clone();
            clone.fName = this.fName;
            clone.fIsEnabled = this.fIsEnabled;
            clone.fIsEnabledStatusKnown = this.fIsEnabledStatusKnown;
            clone.fIsChannelOverride = this.fIsChannelOverride;
            clone.fIsChannelOverrideStatusKnown = this.fIsChannelOverrideStatusKnown;
            clone.fSubbufNum = this.fSubbufNum;
            clone.fSubbufSize = this.fSubbufSize;
            clone.fTimer = this.fTimer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TraceChannel)) {
            return false;
        }
        TraceChannel otherChannel = (TraceChannel)other;
        if (!otherChannel.fName.equals(this.fName)) {
            return false;
        }
        if (otherChannel.fIsEnabled != this.fIsEnabled) {
            return false;
        }
        if (otherChannel.fIsEnabledStatusKnown != this.fIsEnabledStatusKnown) {
            return false;
        }
        if (otherChannel.fIsChannelOverride != this.fIsChannelOverride) {
            return false;
        }
        if (otherChannel.fIsChannelOverrideStatusKnown != this.fIsChannelOverrideStatusKnown) {
            return false;
        }
        if (otherChannel.fSubbufNum != this.fSubbufNum) {
            return false;
        }
        if (otherChannel.fSubbufSize != this.fSubbufSize) {
            return false;
        }
        return otherChannel.fTimer == this.fTimer;
    }

    public int hashCode() {
        StringBuffer builder = new StringBuffer(this.fName);
        builder.append(this.fIsEnabled);
        builder.append(this.fIsEnabledStatusKnown);
        builder.append(this.fIsChannelOverride);
        builder.append(this.fIsChannelOverrideStatusKnown);
        builder.append(this.fSubbufNum);
        builder.append(this.fSubbufSize);
        builder.append(this.fTimer);
        return builder.toString().hashCode();
    }

    public String toString() {
        return "[TraceChannel (" + this.fName + ")]";
    }
}

