/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.event;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventContent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventType;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class LttngEvent
extends TmfEvent {
    private JniEvent jniEventReference = null;

    public LttngEvent() {
        super.setType((ITmfEventType)LttngEventType.DEFAULT_EVENT_TYPE);
    }

    public LttngEvent(TmfTrace<LttngEvent> parent, LttngTimestamp timestamp, String source, LttngEventType type, LttngEventContent content, String reference, JniEvent lttEvent) {
        super(parent, (ITmfTimestamp)timestamp, source, (ITmfEventType)type, (ITmfEventField)content, reference);
        this.jniEventReference = lttEvent;
        super.setTrace(parent);
    }

    public LttngEvent(LttngEvent oldEvent) {
        this((TmfTrace<LttngEvent>)((TmfTrace)oldEvent.getTrace()), (LttngTimestamp)oldEvent.getTimestamp(), oldEvent.getSource(), oldEvent.getType(), oldEvent.getContent(), oldEvent.getReference(), oldEvent.jniEventReference);
    }

    public void setParentTrace(TmfTrace<LttngEvent> parentTrace) {
        super.setTrace(parentTrace);
    }

    public String getChannelName() {
        return this.getType().getTracefileName();
    }

    public long getCpuId() {
        return this.getType().getCpuId();
    }

    public String getMarkerName() {
        return this.getType().getMarkerName();
    }

    public int getMarkerId() {
        return this.getType().getMarkerId();
    }

    public LttngEventContent getContent() {
        return (LttngEventContent)super.getContent();
    }

    public void setContent(LttngEventContent newContent) {
        super.setContent((ITmfEventField)newContent);
    }

    public void setReference(String reference) {
        super.setReference(reference);
    }

    public LttngEventType getType() {
        return (LttngEventType)super.getType();
    }

    public void setType(LttngEventType newType) {
        super.setType((ITmfEventType)newType);
    }

    public synchronized void updateJniEventReference(JniEvent newJniEventReference) {
        this.jniEventReference = newJniEventReference;
    }

    public synchronized JniEvent convertEventTmfToJni() {
        JniEvent tmpEvent = null;
        if (this.jniEventReference.getParentTracefile().getParentTrace().getCurrentEventTimestamp().getTime() == this.getTimestamp().getValue()) {
            tmpEvent = this.jniEventReference;
        } else {
            System.out.println("convertEventTmfToJni() failed: Unsynced Timestamp > TMF:" + this.getTimestamp().getValue() + " <--> JNI:" + this.jniEventReference.getParentTracefile().getParentTrace().getCurrentEventTimestamp().getTime());
        }
        return tmpEvent;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[LttngEvent(");
        result.append("Timestamp:" + this.getTimestamp().getValue());
        result.append(",Channel:" + this.getChannelName());
        result.append(",CPU:" + this.getCpuId());
        result.append(",Marker:" + this.getMarkerName());
        result.append(",Content:" + (Object)((Object)this.getContent()) + ")]");
        return result.toString();
    }

    public LttngEvent clone() {
        LttngEvent clone = (LttngEvent)super.clone();
        clone.getContent().setEvent(clone);
        clone.jniEventReference = this.jniEventReference;
        return clone;
    }

    public synchronized int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.jniEventReference == null ? 0 : this.jniEventReference.hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LttngEvent)) {
            return false;
        }
        LttngEvent other = (LttngEvent)((Object)obj);
        return !(this.jniEventReference == null ? other.jniEventReference != null : !this.jniEventReference.equals((Object)other.jniEventReference));
    }
}

