/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.util.HashMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.listeners.STColumnSizeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;

public class STDataViewersHideShowManager {
    public static final int STATE_SHOWN = 1;
    public static final int STATE_HIDDEN = 0;
    private int[] defaultColumnsWidth;
    private int[] columnsWidth;
    private int[] columnsState;
    private Item[] columns;
    private AbstractSTViewer stViewer;
    private HashMap<Item, STColumnSizeListener> columnsSizeListener = new HashMap();

    public STDataViewersHideShowManager(AbstractSTViewer stViewer) {
        this.stViewer = stViewer;
        this.columns = stViewer.getColumns();
        int[] widths = new int[this.columns.length];
        int[] states = new int[this.columns.length];
        int i = 0;
        while (i < this.columns.length) {
            widths[i] = stViewer.getColumnWidth(this.columns[i]);
            states[i] = 1;
            ++i;
        }
        this.columnsWidth = widths;
        this.columnsState = states;
        this.defaultColumnsWidth = new int[this.columns.length];
        i = this.columns.length;
        while (i-- > 0) {
            ISTDataViewersField field = (ISTDataViewersField)this.columns[i].getData();
            this.defaultColumnsWidth[i] = field.getPreferredWidth();
            STColumnSizeListener l = new STColumnSizeListener(this);
            this.columnsSizeListener.put(this.columns[i], l);
            this.columns[i].addListener(11, (Listener)l);
            this.columns[i].addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Item column = (Item)e.widget;
                    column.removeListener(11, (Listener)STDataViewersHideShowManager.this.columnsSizeListener.get(column));
                }
            });
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        IDialogSettings settings = dialogSettings.addNewSection("hide_show_section");
        int i = 0;
        while (i < this.columnsWidth.length) {
            settings.put("column_width_" + i, this.columnsWidth[i]);
            ++i;
        }
        i = 0;
        while (i < this.columnsState.length) {
            settings.put("column_state_" + i, this.columnsState[i]);
            ++i;
        }
    }

    public void restoreState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            this.resetState();
            return;
        }
        IDialogSettings settings = dialogSettings.getSection("hide_show_section");
        if (settings == null) {
            this.resetState();
            return;
        }
        try {
            int i = 0;
            while (i < this.columnsWidth.length) {
                String width = settings.get("column_width_" + i);
                if (width == null) {
                    this.resetState();
                    return;
                }
                this.columnsWidth[i] = Integer.parseInt(width);
                ++i;
            }
            i = 0;
            while (i < this.columnsState.length) {
                String state = settings.get("column_state_" + i);
                if (state == null) {
                    this.resetState();
                    return;
                }
                this.columnsState[i] = Integer.parseInt(state);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.resetState();
            return;
        }
    }

    private void resetState() {
        this.columnsWidth = this.defaultColumnsWidth;
        int i = 0;
        while (i < this.columnsState.length) {
            this.columnsState[i] = 1;
            ++i;
        }
    }

    public void setWidth(int index, int width) {
        if (this.columnsState[index] != 0) {
            this.columnsWidth[index] = width;
        }
    }

    public void setState(int index, int state) {
        this.columnsState[index] = state;
    }

    public int getWidth(int index) {
        return this.columnsWidth[index];
    }

    public int getState(int index) {
        return this.columnsState[index];
    }

    public int[] getColumnsWidth() {
        return this.columnsWidth;
    }

    public int[] getColumnsState() {
        return this.columnsState;
    }

    public void updateColumns(Item[] columns) {
        int i = columns.length;
        while (i-- > 0) {
            Item column = columns[i];
            if (this.getState(i) == 0) {
                this.stViewer.setColumnWidth(column, 0);
                this.stViewer.setColumnResizable(column, false);
                continue;
            }
            this.stViewer.setColumnWidth(column, this.getWidth(i));
            this.stViewer.setColumnResizable(column, true);
        }
    }

    public AbstractSTViewer getSTViewer() {
        return this.stViewer;
    }
}

