/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.callgraph.AggregateLayoutAlgorithm;
import org.eclipse.linuxtools.internal.callgraph.CallgraphView;
import org.eclipse.linuxtools.internal.callgraph.Messages;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.linuxtools.internal.callgraph.StapNode;
import org.eclipse.linuxtools.internal.callgraph.core.MP;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.Projectionist;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.StapGraphKeyListener;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.StapGraphMouseListener;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.StapGraphMouseWheelListener;
import org.eclipse.linuxtools.internal.callgraph.treeviewer.StapTreeContentProvider;
import org.eclipse.linuxtools.internal.callgraph.treeviewer.StapTreeDoubleClickListener;
import org.eclipse.linuxtools.internal.callgraph.treeviewer.StapTreeLabelProvider;
import org.eclipse.linuxtools.internal.callgraph.treeviewer.StapTreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class StapGraph
extends Graph {
    public static final String CONSTANT_TOP_NODE_NAME = Messages.getString("StapGraph.StartNode");
    public static final int CONSTANT_HORIZONTAL_SPACING = 50;
    public static final int CONSTANT_DRAWMODE_LEVEL = 0;
    public static final int CONSTANT_DRAWMODE_RADIAL = 1;
    public static final int CONSTANT_DRAWMODE_TREE = 2;
    public static final int CONSTANT_DRAWMODE_AGGREGATE = 3;
    public static final int CONSTANT_ANIMATION_SLOW = 1;
    public static final int CONSTANT_ANIMATION_FASTER = 2;
    public static final int CONSTANT_ANIMATION_FASTEST = 3;
    public static final int CONSTANT_MAX_NUMBER_OF_SIBLINGS = 3;
    public static final int CONSTANT_MAX_NUMBER_OF_RADIAL_SIBLINGS = 15;
    public static final int CONSTANT_VERTICAL_INCREMENT = 50;
    public static final int CONSTANT_HORIZONTAL_SPACING_FOR_LEVEL = 150;
    public static final Color CONSTANT_HAS_PARENT = new Color((Device)Display.getCurrent(), 240, 200, 200);
    public static final Color CONSTANT_HAS_CHILDREN = new Color((Device)Display.getCurrent(), 200, 250, 200);
    public static final Color CONSTANT_MARKED = new Color((Device)Display.getCurrent(), 210, 112, 214);
    private int ANIMATION_TIME = 500;
    private int topLevelToDraw;
    private int bottomLevelToDraw;
    private int topLevelOnScreen;
    public int levelBuffer = 30;
    private int maxNodes = 150;
    private Projectionist proj;
    private int lowestLevelOfNodesAdded;
    public HashMap<Integer, List<Integer>> levels;
    private int idOfLastNode;
    private int idOfLastCollapsedNode;
    public HashMap<Integer, StapNode> nodeMap;
    public HashMap<Integer, StapData> nodeDataMap;
    public List<GraphNode> aggregateNodes;
    public HashMap<String, Long> aggregateTime;
    public HashMap<String, Integer> aggregateCount;
    private HashMap<Integer, Integer> collapsedLevelSize;
    public List<Integer> markedNodes;
    public List<Integer> markedCollapsedNodes;
    private boolean collapse_mode;
    private int draw_mode;
    private int animation_mode;
    private long totalTime;
    private long endTime;
    private long startTime;
    private int rootVisibleNodeNumber;
    private boolean killInvalidFunctions;
    private static TreeViewer treeViewer;
    private Composite treeComp;
    private static IDoubleClickListener treeDoubleListener;
    public HashMap<Integer, Integer> currentPositionInLevel;
    private int nextMarkedNode;
    public double scale;
    private ArrayList<Integer> callOrderList;
    private int lastFunctionCalled;
    private int treeLevelFromRoot;
    private Canvas thumbCanvas;
    private ICProject project;
    private boolean threaded;
    private int counter;
    private StapGraphMouseListener mListener;
    private StapGraphMouseWheelListener mwListener;
    private StapGraphKeyListener kListener;
    private CallgraphView callgraphView;
    public static final Comparator<Map.Entry<String, Long>> VALUE_ORDER;

    static {
        VALUE_ORDER = new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> a, Map.Entry<String, Long> b) {
                return a.getValue().compareTo(b.getValue());
            }
        };
    }

    public StapGraphMouseListener getMouseListener() {
        return this.mListener;
    }

    public StapGraphMouseWheelListener getMouseWheelListener() {
        return this.mwListener;
    }

    public StapGraphKeyListener getKeyListener() {
        return this.kListener;
    }

    public StapGraph(Composite parent, int style, Composite treeComp, Canvas tCanvas, CallgraphView callgraphView) {
        super(parent, style);
        this.thumbCanvas = tCanvas;
        this.nodeMap = new HashMap();
        this.levels = new HashMap();
        this.nodeDataMap = new HashMap();
        this.aggregateTime = new HashMap();
        this.aggregateCount = new HashMap();
        this.currentPositionInLevel = new HashMap();
        this.collapsedLevelSize = new HashMap();
        this.markedNodes = new ArrayList<Integer>();
        this.markedCollapsedNodes = new ArrayList<Integer>();
        this.animation_mode = 1;
        this.idOfLastNode = 0;
        this.rootVisibleNodeNumber = 0;
        this.totalTime = 0L;
        this.collapse_mode = false;
        this.killInvalidFunctions = true;
        this.nextMarkedNode = -1;
        this.scale = 1.0;
        this.treeLevelFromRoot = 0;
        this.idOfLastCollapsedNode = 0;
        this.callgraphView = callgraphView;
        this.treeComp = treeComp;
        if (treeViewer == null || treeViewer.getControl().isDisposed()) {
            treeViewer = new TreeViewer(this.treeComp);
            StapTreeListener stl = new StapTreeListener(treeViewer.getTree().getHorizontalBar());
            treeViewer.addTreeListener((ITreeViewerListener)stl);
        }
        this.mListener = new StapGraphMouseListener(this);
        this.kListener = new StapGraphKeyListener(this);
        this.mwListener = new StapGraphMouseWheelListener(this);
        this.addMouseListener(this.mListener);
        this.addKeyListener(this.kListener);
        this.addMouseWheelListener(this.mwListener);
    }

    public void initializeTree() {
        if (treeViewer.getContentProvider() != null) {
            ((StapTreeContentProvider)treeViewer.getContentProvider()).setGraph(this);
            treeViewer.refresh();
            return;
        }
        StapTreeContentProvider scp = new StapTreeContentProvider();
        treeViewer.setContentProvider((IContentProvider)scp);
        ((StapTreeContentProvider)treeViewer.getContentProvider()).setGraph(this);
        if (treeViewer.getLabelProvider() != null) {
            treeViewer.getLabelProvider().dispose();
        }
        StapTreeLabelProvider prov = new StapTreeLabelProvider();
        treeViewer.setLabelProvider((IBaseLabelProvider)prov);
        if (treeDoubleListener != null) {
            treeViewer.removeDoubleClickListener(treeDoubleListener);
        }
        treeDoubleListener = new StapTreeDoubleClickListener(treeViewer, this);
        treeViewer.addDoubleClickListener(treeDoubleListener);
        treeViewer.setInput((Object)this.getNodeData(this.getTopNode()));
        treeViewer.refresh();
    }

    public int loadData(int style, int id, String txt, long time, int called, int caller, boolean isMarked, String message) {
        if (id < 10 && this.killInvalidFunctions) {
            if (txt.contains(")")) {
                return -1;
            }
            if (txt.contains(".")) {
                return -1;
            }
            if (txt.contains("\"")) {
                return -1;
            }
        }
        StapData n = new StapData(this, style, txt, time, called, id, caller, isMarked);
        if (isMarked) {
            n.setMessage(message);
            this.markedNodes.add(id);
        }
        this.nodeDataMap.put(id, n);
        if (id > this.idOfLastNode) {
            this.idOfLastNode = id;
        }
        return id;
    }

    public void insertMessage(int id, String message) {
        StapData temp = this.nodeDataMap.get(id);
        if (temp == null) {
            return;
        }
        temp.insertMessage(message);
        this.nodeDataMap.put(id, temp);
    }

    public void drawRadial(int centerNode) {
        int radius = Math.max(50, Math.min(this.getBounds().width, this.getBounds().height) / 2 - 100);
        this.rootVisibleNodeNumber = centerNode;
        StapData nodeData = this.getNodeData(centerNode);
        int collapsed = nodeData.getPartOfCollapsedNode();
        if (!nodeData.isCollapsed && collapsed != -10) {
            nodeData = this.getNodeData(collapsed);
        }
        treeViewer.expandToLevel((Object)nodeData, 0);
        treeViewer.setSelection((ISelection)new StructuredSelection((Object)nodeData));
        if (this.nodeMap.get(centerNode) == null) {
            this.nodeMap.put(centerNode, this.getNodeData(centerNode).makeNode(this));
        }
        StapNode n = this.nodeMap.get(centerNode);
        int x = this.getBounds().width / 2 - n.getSize().width / 2;
        int y = this.getBounds().height / 2;
        n.setLocation(x, y);
        if (this.getNodeData(centerNode).isMarked()) {
            this.nodeMap.get(centerNode).setBackgroundColor(CONSTANT_MARKED);
        }
        this.radialHelper(centerNode, x, y, radius, 0);
    }

    public void preDrawRadial(int centerNode) {
        StapNode n;
        this.rootVisibleNodeNumber = centerNode;
        if (this.nodeMap.get(centerNode) == null) {
            this.nodeMap.put(centerNode, this.getNodeData(centerNode).makeNode(this));
            n = this.nodeMap.get(centerNode);
            n.setLocation(this.getBounds().width / 2, this.getShell().getSize().y / 2);
        }
        n = this.nodeMap.get(centerNode);
        int x = n.getLocation().x;
        int y = n.getLocation().y;
        this.radialHelper(centerNode, x, y, 0, 0);
    }

    public void radialHelper(int id, int x, int y, int radius, int startFromChild) {
        int callerID = this.nodeDataMap.get((Object)Integer.valueOf((int)id)).parent;
        if (callerID != -1) {
            if (this.getNode(callerID) == null) {
                this.nodeMap.put(callerID, this.getNodeData(callerID).makeNode(this));
            }
            this.getNode(callerID).setBackgroundColor(CONSTANT_HAS_PARENT);
            this.getNode(callerID).setLocation(x + radius / 5, y - radius / 5);
            if (this.getNode((int)id).connection == null) {
                this.getNode(id).makeConnection(0, this.getNode(callerID), this.getNodeData((int)id).timesCalled);
            }
            if (this.getNodeData(callerID).isMarked()) {
                this.nodeMap.get(callerID).setBackgroundColor(CONSTANT_MARKED);
            }
        }
        List<Integer> nodeList = !this.collapse_mode ? this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children : this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren;
        int numberOfNodes = nodeList.size() >= 15 ? 15 : nodeList.size();
        double angle = numberOfNodes > 5 ? Math.PI * 2 / (double)numberOfNodes : 0.41887902047863906;
        int i = 0;
        i = 0;
        while (i < numberOfNodes) {
            StapData d;
            int subID = nodeList.get(i);
            int yOffset = 0;
            int xOffset = 0;
            if (this.nodeMap.get(subID) == null) {
                this.nodeMap.put(subID, this.getNodeData(subID).makeNode(this));
            }
            StapNode subN = this.nodeMap.get(subID);
            if (radius != 0) {
                yOffset = (int)((double)radius * Math.cos((float)angle * (float)i));
                xOffset = (int)((double)radius * Math.sin((float)angle * (float)i)) - subN.getSize().width / 2 + this.getNode((int)id).getSize().width / 2;
            }
            if (this.hasChildren(subID)) {
                subN.setBackgroundColor(CONSTANT_HAS_CHILDREN);
            }
            subN.setLocation(x + xOffset, y + yOffset);
            if (subN.connection == null) {
                subN.makeConnection(0, this.nodeMap.get(id), this.nodeDataMap.get((Object)Integer.valueOf((int)subID)).timesCalled);
            }
            if ((d = this.getNodeData(subID)).isMarked()) {
                subN.setBackgroundColor(CONSTANT_MARKED);
            }
            ++i;
        }
    }

    private void drawAggregateView() {
        if (this.aggregateNodes == null) {
            this.aggregateNodes = new ArrayList<GraphNode>();
        } else {
            this.aggregateNodes.clear();
        }
        int maxTimesCalled = 0;
        NumberFormat num = NumberFormat.getInstance(Locale.CANADA);
        num.setMinimumFractionDigits(2);
        num.setMaximumFractionDigits(2);
        for (int val : this.aggregateCount.values()) {
            if (val <= maxTimesCalled) continue;
            maxTimesCalled = val;
        }
        TreeSet<Map.Entry<String, Long>> sortedValues = new TreeSet<Map.Entry<String, Long>>(VALUE_ORDER);
        HashMap<String, Long> tempMap = new HashMap<String, Long>();
        tempMap.putAll(this.aggregateTime);
        for (String string : tempMap.keySet()) {
            long time = this.aggregateTime.get(string);
            while (time < 0L) {
                time += this.endTime;
            }
            tempMap.put(string, time);
        }
        sortedValues.addAll(tempMap.entrySet());
        for (Map.Entry entry : sortedValues) {
            String key = (String)entry.getKey();
            GraphNode n = new GraphNode((IContainer)this.getGraphModel(), 0);
            this.aggregateNodes.add(n);
            float percentage_count = (float)this.aggregateCount.get(key).intValue() / (float)maxTimesCalled;
            float percentage_time = (float)((Long)entry.getValue()).longValue() / (float)this.getTotalTime() * 100.0f;
            n.setText(String.valueOf(key) + "\n" + num.format(percentage_time) + "%" + "\n" + this.aggregateCount.get(key) + "\n");
            n.setData("AGGREGATE_NAME", (Object)key);
            int primary = (int)(percentage_count * 15.0f * 12.0f);
            int secondary = 180 - (int)(percentage_count * 15.0f * 12.0f);
            primary = Math.max(0, primary);
            secondary = Math.max(0, secondary);
            primary = Math.min(primary, 255);
            secondary = Math.min(secondary, 255);
            Color c = new Color((Device)this.getDisplay(), primary, 0, secondary);
            n.setBackgroundColor(c);
            n.setHighlightColor(c);
            n.setForegroundColor(new Color((Device)this.getDisplay(), 255, 255, 255));
            n.setTooltip((IFigure)new Label(String.valueOf(Messages.getString("StapGraph.Func")) + key + "\n" + Messages.getString("StapGraph.Time") + num.format(percentage_time) + "%" + "\n" + Messages.getString("StapGraph.NumOfCalls") + this.aggregateCount.get(key)));
            n.setBorderWidth(2);
        }
        this.setLayoutAlgorithm((LayoutAlgorithm)new AggregateLayoutAlgorithm(0, sortedValues, this.getTotalTime(), this.getBounds().width), true);
    }

    private void drawTree(int id, int x, int y) {
        if (this.nodeMap.get(id) == null) {
            this.nodeMap.put(id, this.getNodeData(id).makeNode(this));
        }
        StapNode n = this.getNode(id);
        n.setLocation(x, y);
        n.setSize((double)n.getSize().width / this.scale, (double)n.getSize().height / this.scale);
        if (this.getLevelOfNode(id) == this.bottomLevelToDraw && this.getNodeData((int)id).children.size() > 0) {
            n.setBackgroundColor(CONSTANT_HAS_CHILDREN);
        }
        if (this.getNodeData(id).isMarked()) {
            n.setBackgroundColor(CONSTANT_MARKED);
        }
        List<Integer> callees = null;
        int usefulSize = 0;
        callees = !this.collapse_mode ? this.getNodeData((int)id).children : this.getNodeData((int)id).collapsedChildren;
        if (callees == null) {
            return;
        }
        int cLevel = this.getLevelOfNode(id) + 1;
        if (!this.collapse_mode) {
            if (this.levels.get(cLevel) != null) {
                usefulSize = this.levels.get(cLevel).size() - this.collapsedLevelSize.get(cLevel);
            }
        } else if (this.collapsedLevelSize.get(cLevel) != null) {
            usefulSize = this.collapsedLevelSize.get(cLevel);
        }
        int i = 0;
        while (i < callees.size()) {
            int childID = callees.get(i);
            int childLevel = this.getLevelOfNode(childID);
            if (this.currentPositionInLevel.get(this.getLevelOfNode(childID)) == null) {
                int tmp = (int)((double)(50 * (usefulSize - 1) * -1) / this.scale);
                this.currentPositionInLevel.put(childLevel, this.getNode((int)this.rootVisibleNodeNumber).getLocation().x + tmp);
            }
            if (childLevel <= this.bottomLevelToDraw && childLevel <= this.lowestLevelOfNodesAdded) {
                this.drawTree(callees.get(i), this.currentPositionInLevel.get(childLevel), y + (int)(50.0 / this.scale));
                int newSize = this.currentPositionInLevel.get(this.getLevelOfNode(childID)) + this.getNode((int)childID).getSize().width;
                if (i == callees.size() - 1) {
                    newSize += 16;
                }
                this.currentPositionInLevel.put(this.getLevelOfNode(childID), newSize);
            }
            ++i;
        }
    }

    public void extendTree() {
        if (this.bottomLevelToDraw >= this.lowestLevelOfNodesAdded) {
            return;
        }
        StapData data = this.getNodeData(this.rootVisibleNodeNumber);
        if (data.children != null && data.children.size() < 1) {
            return;
        }
        List<Integer> list = data.children;
        if (this.isCollapseMode()) {
            list = data.collapsedChildren;
        }
        if (list.size() == 1) {
            int aMode = this.animation_mode;
            this.draw(2, 3, list.get(0));
            this.setAnimationMode(aMode);
            return;
        }
        List<Integer> bottomList = this.levels.get(this.bottomLevelToDraw);
        ++this.bottomLevelToDraw;
        for (int i : bottomList) {
            if (this.getNode(i) == null) continue;
            this.getNode(i).setBackgroundColor(this.DEFAULT_NODE_COLOR);
            this.getParentNode(i).setBackgroundColor(this.DEFAULT_NODE_COLOR);
            this.drawTree(i, this.getNode((int)i).getLocation().x, this.getNode((int)i).getLocation().y);
        }
        ++this.treeLevelFromRoot;
    }

    public void shrinkTree() {
        if (this.treeLevelFromRoot < 1) {
            return;
        }
        --this.bottomLevelToDraw;
        this.deleteAll(this.rootVisibleNodeNumber);
        int i = this.rootVisibleNodeNumber;
        this.currentPositionInLevel.clear();
        this.drawTree(i, this.getNode((int)i).getLocation().x, this.getNode((int)i).getLocation().y);
        --this.treeLevelFromRoot;
    }

    public void drawNextNode() {
        int toDraw;
        if (this.isCollapseMode()) {
            this.setCollapseMode(false);
        }
        if ((toDraw = this.getNextCalledNode(this.getRootVisibleNodeNumber())) != -1) {
            this.draw(toDraw);
        } else {
            this.proj.pause();
        }
    }

    public void moveAllNodesTo(int x, int y) {
        for (int i : this.nodeMap.keySet()) {
            this.nodeMap.get(i).setLocation(x, y);
        }
    }

    public void drawBox(int id, int x, int y) {
        this.setLevelLimits(id);
        int MaxLevelPixelWidth = 1;
        int currPixelWidth = 1;
        int i = this.topLevelToDraw;
        while (i <= this.bottomLevelToDraw) {
            int count = 0;
            this.levels.get(i).add(0, count);
            int size = this.levels.get(i).size();
            int j = 1;
            while (j < size) {
                int val = this.levels.get(i).get(j);
                StapData data = this.nodeDataMap.get(val);
                if (!(!data.isOnlyChildWithThisName() && (this.collapse_mode && data.isPartOfCollapsedNode() || !this.collapse_mode && data.isCollapsed))) {
                    if (MaxLevelPixelWidth < (currPixelWidth += data.name.length() * 10 + 150)) {
                        MaxLevelPixelWidth = currPixelWidth;
                    }
                    this.levels.get(i).remove(0);
                    this.levels.get(i).add(0, ++count);
                }
                ++j;
            }
            currPixelWidth = 1;
            ++i;
        }
        MaxLevelPixelWidth = (int)((double)MaxLevelPixelWidth / this.scale);
        this.counter = 0;
        if (id == this.getFirstUsefulNode()) {
            this.nodeMap.get(id).setLocation(150 + MaxLevelPixelWidth / 2, y);
        }
        this.drawFromBottomToTop(this.bottomLevelToDraw, y + (this.bottomLevelToDraw - this.topLevelToDraw) * 3 * (int)(50.0 / this.scale), MaxLevelPixelWidth);
        if (id == this.getFirstUsefulNode()) {
            this.nodeMap.get(id).setLocation(150 + MaxLevelPixelWidth / 2, y);
        }
    }

    public void drawFromBottomToTop(int level, int height, int MaxLevelPixelWidth) {
        if (level == 0 || level < this.topLevelToDraw) {
            return;
        }
        int total = this.levels.get(level).remove(0);
        int count = 1;
        int i = 0;
        while (i < this.levels.get(level).size()) {
            int id = this.levels.get(level).get(i);
            StapData data = this.nodeDataMap.get(id);
            if (!(!data.isOnlyChildWithThisName() && (this.collapse_mode && data.isPartOfCollapsedNode() || !this.collapse_mode && this.nodeDataMap.get((Object)Integer.valueOf((int)id)).isCollapsed))) {
                if (this.nodeMap.get(id) == null) {
                    this.nodeMap.put(id, this.getNodeData(id).makeNode(this));
                }
                StapNode n = this.nodeMap.get(id);
                n.setVisible(true);
                n.setSize((double)n.getSize().width / this.scale, (double)n.getSize().height / this.scale);
                if (this.getAnimationMode() == 1) {
                    if (this.counter <= this.ANIMATION_TIME) {
                        Animation.markBegin();
                    }
                    n.setLocation(150 + this.nodeMap.get((Object)Integer.valueOf((int)this.getRootVisibleNodeNumber())).getLocation().x, this.nodeMap.get((Object)Integer.valueOf((int)this.getRootVisibleNodeNumber())).getLocation().y);
                    n.setLocation(150 + MaxLevelPixelWidth / (total + 1) * count, height);
                    if (this.counter <= this.ANIMATION_TIME) {
                        Animation.run((int)(this.ANIMATION_TIME / this.nodeMap.size() / 3));
                        this.counter += this.ANIMATION_TIME / this.nodeMap.size();
                    }
                } else {
                    n.setLocation(150 + MaxLevelPixelWidth / (total + 1) * count, height);
                }
                if (level == this.bottomLevelToDraw && this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children.size() != 0) {
                    n.setBackgroundColor(CONSTANT_HAS_CHILDREN);
                }
                if (this.getNodeData(n.id).isMarked()) {
                    n.setBackgroundColor(CONSTANT_MARKED);
                }
                List<Integer> setOfCallees = null;
                setOfCallees = this.collapse_mode ? this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren : this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children;
                for (int val : setOfCallees) {
                    if (this.nodeMap.get(val) == null) continue;
                    this.nodeMap.get(val).makeConnection(0, n, this.nodeDataMap.get((Object)Integer.valueOf((int)val)).timesCalled);
                }
                ++count;
            }
            ++i;
        }
        this.drawFromBottomToTop(level - 1, height - 3 * (int)(50.0 / this.scale), MaxLevelPixelWidth);
    }

    public void deleteAll(int exception) {
        if (this.aggregateNodes != null) {
            for (GraphNode n : this.aggregateNodes) {
                n.dispose();
            }
            this.aggregateNodes.clear();
        }
        int x = -1;
        int y = -1;
        if (exception != -1 && this.nodeMap.get(exception) != null) {
            x = this.nodeMap.get((Object)Integer.valueOf((int)exception)).getLocation().x;
            y = this.nodeMap.get((Object)Integer.valueOf((int)exception)).getLocation().y;
        }
        for (int i : this.nodeMap.keySet()) {
            StapNode node = this.nodeMap.get(i);
            if (node == null) continue;
            node.unhighlight();
            node.dispose();
        }
        this.nodeMap.clear();
        if (x != -1 && y != -1) {
            StapNode n = this.getNodeData(exception).makeNode(this);
            n.setLocation(x, y);
            n.highlight();
            this.nodeMap.put(exception, n);
        }
    }

    private void deleteLevelsFromTop(int numberOfLevelsToDelete) {
        if (numberOfLevelsToDelete <= 0) {
            return;
        }
        int i = 0;
        while (i < numberOfLevelsToDelete) {
            List<Integer> level = this.levels.get(this.topLevelToDraw);
            int j = 0;
            while (j < level.size()) {
                if (this.nodeMap.get(level.get(j)) != null) {
                    this.nodeMap.remove(level.get(j)).dispose();
                }
                ++j;
            }
            ++this.topLevelToDraw;
            ++i;
        }
    }

    private void deleteLevelsFromBottom(int numberOfLevelsToDelete) {
        if (numberOfLevelsToDelete <= 0) {
            return;
        }
        int i = 0;
        while (i < numberOfLevelsToDelete) {
            List<Integer> level = this.levels.get(this.getBottomLevelToDraw());
            int j = 0;
            while (j < level.size()) {
                if (this.nodeMap.get(level.get(j)) != null) {
                    this.nodeMap.remove(level.get(j)).dispose();
                }
                ++j;
            }
            --this.bottomLevelToDraw;
            ++i;
        }
    }

    public void setLevelLimits(int id) {
        this.setTopLevelTo(this.getLevelOfNode(id));
    }

    public void setTopLevelTo(int new_topLevelToDraw) {
        this.changeLevelLimits(new_topLevelToDraw);
        int new_bottomLevelToDraw = new_topLevelToDraw + this.levelBuffer;
        if (new_bottomLevelToDraw > this.lowestLevelOfNodesAdded) {
            new_bottomLevelToDraw = this.lowestLevelOfNodesAdded;
        }
        this.deleteLevelsFromTop(new_topLevelToDraw - this.topLevelToDraw);
        this.deleteLevelsFromBottom(this.getBottomLevelToDraw() - new_bottomLevelToDraw);
        this.topLevelToDraw = new_topLevelToDraw;
        this.bottomLevelToDraw = new_bottomLevelToDraw;
    }

    public boolean changeLevelLimits(int lvl) {
        int numberOfNodes = 0;
        int maxLevel = this.min(lvl + this.levelBuffer, this.lowestLevelOfNodesAdded);
        int level = lvl;
        while (level < maxLevel) {
            for (int id : this.levels.get(level)) {
                List<Integer> list = this.isCollapseMode() ? this.getNodeData((int)id).collapsedChildren : this.getNodeData((int)id).children;
                if ((numberOfNodes += list.size()) <= this.maxNodes) continue;
                this.levelBuffer = this.max(0, level - 1);
                return true;
            }
            ++level;
        }
        return false;
    }

    public void draw() {
        this.draw(this.getRootVisibleNodeNumber());
    }

    public void draw(int id) {
        this.draw(this.draw_mode, this.animation_mode, id);
    }

    public void draw(int animation, int id) {
        this.draw(this.draw_mode, animation, id);
    }

    public void draw(int drawMode, int animationMode, int id) {
        GridData gd;
        this.setDrawMode(drawMode);
        this.setAnimationMode(animationMode);
        if (this.nodeDataMap.get(id) == null) {
            return;
        }
        this.clearSelection();
        this.treeLevelFromRoot = 0;
        this.currentPositionInLevel.clear();
        this.setRedraw(false);
        if (this.draw_mode == 1) {
            gd = (GridData)this.thumbCanvas.getLayoutData();
            gd.exclude = true;
            this.thumbCanvas.setLayoutData((Object)gd);
            this.thumbCanvas.setVisible(false);
            this.callgraphView.layout();
            gd = (GridData)this.treeComp.getLayoutData();
            gd.exclude = false;
            this.treeComp.setLayoutData((Object)gd);
            this.treeComp.setVisible(true);
            treeViewer.collapseToLevel((Object)this.getNodeData(id), 1);
            treeViewer.expandToLevel((Object)this.getNodeData(id), 1);
        } else if (this.draw_mode == 3) {
            gd = (GridData)this.treeComp.getLayoutData();
            gd.exclude = true;
            this.treeComp.setLayoutData((Object)gd);
            this.treeComp.setVisible(false);
            this.callgraphView.layout();
            gd = (GridData)this.thumbCanvas.getLayoutData();
            gd.exclude = true;
            this.thumbCanvas.setLayoutData((Object)gd);
            this.thumbCanvas.setVisible(false);
        } else {
            gd = (GridData)this.treeComp.getLayoutData();
            gd.exclude = true;
            this.treeComp.setLayoutData((Object)gd);
            this.treeComp.setVisible(false);
            this.callgraphView.layout();
            gd = (GridData)this.thumbCanvas.getLayoutData();
            gd.exclude = true;
            this.thumbCanvas.setLayoutData((Object)gd);
            this.thumbCanvas.setVisible(true);
            this.thumbCanvas.setBackground(this.getBackground());
        }
        this.callgraphView.layout();
        this.setRedraw(true);
        if (this.draw_mode == 2) {
            if (this.animation_mode == 1) {
                if (this.nodeMap.get(id) == null) {
                    this.nodeMap.put(id, this.getNodeData(id).makeNode(this));
                }
                int tempX = this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().x;
                int tempY = this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().y;
                Animation.markBegin();
                this.moveAllNodesTo(tempX, tempY);
                Animation.run((int)this.ANIMATION_TIME);
                this.deleteAll(id);
                this.setLevelLimits(id);
                this.rootVisibleNodeNumber = id;
                this.drawTree(id, this.getBounds().width / 2, 20);
                this.currentPositionInLevel.clear();
                this.update();
                Animation.markBegin();
                this.drawTree(id, this.getBounds().width / 2, 20);
                Animation.run((int)this.ANIMATION_TIME);
                this.getNode(id).unhighlight();
            } else {
                this.deleteAll(id);
                this.setLevelLimits(id);
                this.rootVisibleNodeNumber = id;
                this.drawTree(id, this.getBounds().width / 2, 20);
                this.getNode(id).unhighlight();
            }
        } else if (this.draw_mode == 1) {
            if (this.animation_mode == 1) {
                this.rootVisibleNodeNumber = id;
                this.deleteAll(id);
                this.preDrawRadial(id);
                this.redraw();
                this.getLightweightSystem().getUpdateManager().performUpdate();
                Animation.markBegin();
                this.nodeMap.get(id).setLocation(this.getBounds().width / 2, this.getBounds().height / 2);
                this.drawRadial(id);
                Animation.run((int)this.ANIMATION_TIME);
                this.callgraphView.maximizeOrRefresh(false);
            } else {
                this.deleteAll(id);
                this.drawRadial(id);
            }
        } else if (this.draw_mode == 0) {
            this.rootVisibleNodeNumber = id;
            if (this.animation_mode == 1) {
                if (this.nodeMap.get(id) == null) {
                    this.nodeMap.put(id, this.getNodeData(id).makeNode(this));
                }
                Animation.markBegin();
                this.moveAllNodesTo(this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().x, this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().y);
                Animation.run((int)this.ANIMATION_TIME);
                this.deleteAll(id);
                this.drawBox(id, 0, 0);
            } else {
                if (this.nodeMap.get(id) == null) {
                    this.nodeMap.put(id, this.getNodeData(id).makeNode(this));
                }
                this.deleteAll(id);
                this.drawBox(id, 0, 0);
            }
        } else if (this.draw_mode == 3) {
            this.rootVisibleNodeNumber = this.getFirstUsefulNode();
            this.deleteAll(-1);
            this.drawAggregateView();
        }
        if (this.getNode(id) != null) {
            this.getNode(id).unhighlight();
        }
        this.clearSelection();
        this.setLayoutData(new GridData(4, 4, true, true));
    }

    public void clearSelection() {
        List list = this.getSelection();
        for (GraphNode n : list) {
            if (n == null) continue;
            n.unhighlight();
        }
        this.setSelection(null);
    }

    public void moveRecursive(int id, int xTarget, int yTarget) {
        if (this.nodeMap.get(id) == null) {
            return;
        }
        int x = this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().x;
        int y = this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().y;
        this.nodeMap.get(id).setLocation(x + xTarget, y + yTarget);
        List<Integer> list = null;
        list = this.collapse_mode ? this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren : this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children;
        int i = 0;
        while (i < list.size()) {
            this.moveRecursive(list.get(i), xTarget, yTarget);
            ++i;
        }
    }

    public void moveAllNodesBy(int xDiff, int yDiff) {
        for (int id : this.nodeMap.keySet()) {
            if (this.nodeMap.get(id) == null) continue;
            int x = this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().x;
            int y = this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().y;
            this.getNode(id).setLocation(x + xDiff, y + yDiff);
        }
    }

    public boolean recursivelyCollapseAllChildrenOfNode(int id) {
        this.setCollapseMode(true);
        if (this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children.size() == 0) {
            return true;
        }
        this.nodeDataMap.get((Object)Integer.valueOf((int)id)).hasCollapsedChildren = true;
        HashMap<String, Integer> newNodeMap = new HashMap<String, Integer>();
        for (int collapsedID : this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren) {
            newNodeMap.put(this.getNodeData((int)collapsedID).name, collapsedID);
        }
        HashMap<Integer, Integer> collapsedNodesWithOnlyOneNodeInThem = new HashMap<Integer, Integer>();
        int size = this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children.size();
        int i = 0;
        while (i < size) {
            int childID = this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children.get(i);
            if (!this.getNodeData(childID).isPartOfCollapsedNode()) {
                String nodeName;
                int childLevel = this.getLevelOfNode(childID);
                if (this.collapsedLevelSize.get(childLevel) == null) {
                    this.collapsedLevelSize.put(childLevel, 0);
                }
                if (newNodeMap.get(nodeName = this.nodeDataMap.get((Object)Integer.valueOf((int)childID)).name) != null) {
                    int aggregateID = (Integer)newNodeMap.get(nodeName);
                    if (collapsedNodesWithOnlyOneNodeInThem.get(aggregateID) != null) {
                        this.loadData(0, aggregateID, nodeName, this.nodeDataMap.get(childID).getTime(), this.nodeDataMap.get((Object)Integer.valueOf((int)childID)).timesCalled, id, this.nodeDataMap.get(childID).isMarked(), "");
                        if (this.getNodeData(aggregateID).isMarked()) {
                            this.markedCollapsedNodes.add(aggregateID);
                            this.markedNodes.remove((Object)aggregateID);
                        }
                        this.nodeDataMap.get((Object)Integer.valueOf((int)id)).children.remove((Object)aggregateID);
                        this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren.add(aggregateID);
                        this.nodeDataMap.get(childID).setPartOfCollapsedNode(aggregateID);
                        this.nodeDataMap.get((Object)Integer.valueOf((int)aggregateID)).collapsedParent = id;
                        int otherChildID = (Integer)collapsedNodesWithOnlyOneNodeInThem.get(aggregateID);
                        this.aggregateData(this.nodeDataMap.get(aggregateID), this.nodeDataMap.get(otherChildID));
                        collapsedNodesWithOnlyOneNodeInThem.remove(aggregateID);
                        this.nodeDataMap.get((Object)Integer.valueOf((int)aggregateID)).children.addAll(this.nodeDataMap.get((Object)Integer.valueOf((int)otherChildID)).children);
                        this.nodeDataMap.get(aggregateID).setPartOfCollapsedNode(-10);
                        this.nodeDataMap.get(otherChildID).setPartOfCollapsedNode(aggregateID);
                        this.nodeDataMap.get((Object)Integer.valueOf((int)aggregateID)).uncollapsedPiece = otherChildID;
                    } else {
                        this.aggregateData(this.nodeDataMap.get(aggregateID), this.nodeDataMap.get(childID));
                    }
                    this.nodeDataMap.get((Object)Integer.valueOf((int)aggregateID)).children.addAll(this.nodeDataMap.get((Object)Integer.valueOf((int)childID)).children);
                    this.nodeDataMap.get((Object)Integer.valueOf((int)aggregateID)).isCollapsed = true;
                    if (this.nodeMap.get(childID) != null) {
                        this.nodeMap.get(childID).setLocation(this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().x - this.nodeMap.get((Object)Integer.valueOf((int)id)).getSize().width, this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().y);
                    }
                    this.nodeDataMap.get(childID).setPartOfCollapsedNode(aggregateID);
                } else {
                    --this.idOfLastCollapsedNode;
                    newNodeMap.put(nodeName, this.idOfLastCollapsedNode);
                    collapsedNodesWithOnlyOneNodeInThem.put(this.idOfLastCollapsedNode, childID);
                    if (this.nodeMap.get(childID) != null) {
                        this.nodeMap.get(childID).setLocation(this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().x, this.nodeMap.get((Object)Integer.valueOf((int)id)).getLocation().y);
                    }
                    int tmp = this.collapsedLevelSize.get(childLevel) + 1;
                    this.collapsedLevelSize.put(childLevel, tmp);
                }
            }
            ++i;
        }
        Iterator<Object> iterator = collapsedNodesWithOnlyOneNodeInThem.keySet().iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            int childID = (Integer)collapsedNodesWithOnlyOneNodeInThem.get(i);
            this.nodeDataMap.get((Object)Integer.valueOf((int)childID)).onlyChildWithThisName = true;
            this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren.add(childID);
            newNodeMap.remove(this.nodeDataMap.get((Object)Integer.valueOf((int)childID)).name);
            this.nodeDataMap.get((Object)Integer.valueOf((int)childID)).collapsedParent = id;
            this.nodeDataMap.get(childID).setPartOfCollapsedNode(childID);
            if (!this.getNodeData(childID).isMarked()) continue;
            this.markedCollapsedNodes.add(childID);
        }
        iterator = this.nodeDataMap.get((Object)Integer.valueOf((int)id)).collapsedChildren.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            this.recursivelyCollapseAllChildrenOfNode(i);
        }
        collapsedNodesWithOnlyOneNodeInThem.clear();
        newNodeMap.clear();
        this.nodeDataMap.get((Object)Integer.valueOf((int)id)).hasCollapsedChildren = true;
        return true;
    }

    public void aggregateData(StapData target, StapData victim) {
        target.setTime(target.getTime() + victim.getTime());
        target.timesCalled += victim.timesCalled;
        if (victim.isMarked() || target.isMarked()) {
            target.setMarked();
            this.markedCollapsedNodes.add(target.id);
        }
    }

    public void printContents(int level) {
        if (this.levels.get(level) != null) {
            return;
        }
        MP.println((String)("Contents of level " + level + ":\n"));
        int i = 0;
        while (i < this.levels.get(level).size()) {
            MP.println((String)this.nodeDataMap.get((Object)this.levels.get((Object)Integer.valueOf((int)level)).get((int)i)).name);
            ++i;
        }
        MP.println((String)"---------------------------");
    }

    public StapNode getNode(int id) {
        return this.nodeMap.get(id);
    }

    public StapData getNodeData(int id) {
        return this.nodeDataMap.get(id);
    }

    public int getTopNode() {
        return this.levels.get(this.topLevelToDraw).get(0);
    }

    public int getFirstUsefulNode() {
        if (this.threaded) {
            return 0;
        }
        int id = 0;
        if (this.nodeDataMap.get((Object)Integer.valueOf((int)id)).name == CONSTANT_TOP_NODE_NAME) {
            ++id;
        }
        while (this.nodeDataMap.get(id) == null && id < this.idOfLastNode) {
            ++id;
        }
        return id;
    }

    public int getTopLevel() {
        return this.topLevelToDraw;
    }

    public int getLevelOfNode(int nodeID) {
        return this.nodeDataMap.get((Object)Integer.valueOf((int)nodeID)).levelOfRecursion;
    }

    public boolean hasChildren(int nodeID) {
        return this.nodeDataMap.get((Object)Integer.valueOf((int)nodeID)).children.size() > 0;
    }

    public void setDimensions(int width, int height) {
        this.getBounds().width = width;
        this.getBounds().height = height;
    }

    public void setAnimationMode(int mode) {
        this.animation_mode = mode;
        if (mode == 1) {
            this.callgraphView.getAnimation_slow().setChecked(true);
            this.callgraphView.getAnimation_fast().setChecked(false);
        } else if (mode == 3) {
            this.callgraphView.getAnimation_slow().setChecked(false);
            this.callgraphView.getAnimation_fast().setChecked(true);
        }
    }

    public void setCollapseMode(boolean value) {
        if (this.collapse_mode == value || this.draw_mode == 3) {
            return;
        }
        if (this.draw_mode != 0) {
            int temp;
            if (this.collapse_mode) {
                if (!this.getRootData().isOnlyChildWithThisName()) {
                    this.rootVisibleNodeNumber = this.getRootData().uncollapsedPiece;
                }
            } else if (!this.getRootData().isOnlyChildWithThisName() && (temp = this.getRootData().getPartOfCollapsedNode()) != -10) {
                this.rootVisibleNodeNumber = temp;
            }
        }
        this.collapse_mode = value;
        this.callgraphView.getMode_collapsednodes().setChecked(value);
        this.nextMarkedNode = -1;
    }

    public StapData getRootData() {
        return this.getNodeData(this.getRootVisibleNodeNumber());
    }

    public int getRootVisibleNodeNumber() {
        return this.rootVisibleNodeNumber;
    }

    public void setRootVisibleNodeNumber(int id) {
        this.rootVisibleNodeNumber = id;
    }

    public long getTotalTime() {
        if (this.totalTime == 0L || this.totalTime > 1200000000000000000L) {
            return this.endTime - this.startTime;
        }
        return this.totalTime;
    }

    public void setTotalTime(long val) {
        this.totalTime = val;
    }

    public int getLowestLevelOfNodesAdded() {
        return this.lowestLevelOfNodesAdded;
    }

    public void setLowestLevelOfNodesAdded(int lowestLevelOfNodesAdded) {
        this.lowestLevelOfNodesAdded = lowestLevelOfNodesAdded;
    }

    public int getDrawMode() {
        return this.draw_mode;
    }

    public void setDrawMode(int draw_mode) {
        this.draw_mode = draw_mode;
    }

    public void reset() {
        this.setSelection(null);
        this.draw(this.draw_mode, this.animation_mode, this.getFirstUsefulNode());
        if (this.draw_mode != 3) {
            this.getNode(this.getFirstUsefulNode()).unhighlight();
        }
        if (treeViewer != null) {
            treeViewer.collapseAll();
            treeViewer.expandToLevel(2);
        }
        this.scale = 1.0;
        this.nextMarkedNode = -1;
    }

    public boolean isCollapseMode() {
        return this.collapse_mode;
    }

    public void setBottomLevelToDraw(int bottomLevelToDraw) {
        this.bottomLevelToDraw = bottomLevelToDraw;
    }

    public int getBottomLevelToDraw() {
        return this.bottomLevelToDraw;
    }

    public void setTopLevelOnScreen(int topLevelOnScreen) {
        this.topLevelOnScreen = topLevelOnScreen;
    }

    public int getTopLevelOnScreen() {
        return this.topLevelOnScreen;
    }

    public List<Integer> getLevel(int level) {
        if (level < 0 || level > this.lowestLevelOfNodesAdded) {
            return null;
        }
        return this.levels.get(level);
    }

    public TreeViewer getTreeViewer() {
        return treeViewer;
    }

    public StapNode getParentNode(int id) {
        return this.nodeMap.get(this.nodeDataMap.get((Object)Integer.valueOf((int)id)).parent);
    }

    public StapData getParentData(int id) {
        return this.nodeDataMap.get(this.nodeDataMap.get((Object)Integer.valueOf((int)id)).parent);
    }

    public int getNextCalledNode(int id) {
        int returnID = -1;
        if (this.isCollapseMode()) {
            this.setCollapseMode(false);
            this.draw();
        }
        int count = this.callOrderList.indexOf(id) + 1;
        while (count < this.callOrderList.size()) {
            int next = this.callOrderList.get(count);
            if (this.getNodeData(id) != null && (!this.getNodeData((int)next).isCollapsed || this.getNodeData(next).isOnlyChildWithThisName())) {
                return next;
            }
            ++count;
        }
        return returnID;
    }

    public int getPreviousCalledNode(int id) {
        int returnID = -1;
        int count = this.callOrderList.indexOf(id) - 1;
        while (count > -1) {
            if (this.getNodeData(id) != null && (!this.getNodeData((int)id).isCollapsed || this.getNodeData(id).isOnlyChildWithThisName())) {
                returnID = this.callOrderList.get(count);
                return returnID;
            }
            --count;
        }
        return returnID;
    }

    public int getNextMarkedNode() {
        List<Integer> list = this.markedNodes;
        if (this.collapse_mode) {
            list = this.markedCollapsedNodes;
        }
        if (list.size() == 0) {
            return -1;
        }
        ++this.nextMarkedNode;
        if (this.nextMarkedNode >= list.size()) {
            this.nextMarkedNode = 0;
        }
        return list.get(this.nextMarkedNode);
    }

    public int getPreviousMarkedNode() {
        List<Integer> list = this.markedNodes;
        if (this.collapse_mode) {
            list = this.markedCollapsedNodes;
        }
        if (list.size() == 0) {
            return -1;
        }
        --this.nextMarkedNode;
        if (this.nextMarkedNode < 0) {
            this.nextMarkedNode = list.size() - 1;
        }
        return list.get(this.nextMarkedNode);
    }

    public void play() {
        if (this.proj == null || this.proj.getResult() == Status.OK_STATUS) {
            this.proj = new Projectionist("Projectionist", this, 2000);
            this.proj.schedule();
        } else {
            this.proj.pause();
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo(this.getHorizontalBar().getSelection() + x, this.getVerticalBar().getSelection() + y);
    }

    public void scrollSmoothBy(int x, int y) {
        this.scrollSmoothTo(this.getHorizontalBar().getSelection() + x, this.getVerticalBar().getSelection() + y);
    }

    public int getNodeDataMapSize() {
        return this.nodeDataMap.size();
    }

    public int getAnimationMode() {
        return this.animation_mode;
    }

    public int getLevelBuffer() {
        return this.levelBuffer;
    }

    public void setLevelBuffer(int val) {
        this.levelBuffer = val;
    }

    public int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int val) {
        this.maxNodes = val;
    }

    public ArrayList<Integer> getCallOrderList() {
        return this.callOrderList;
    }

    public void setCallOrderList(ArrayList<Integer> callOrderList) {
        this.callOrderList = callOrderList;
    }

    public int getLastFunctionCalled() {
        return this.lastFunctionCalled;
    }

    public void setLastFunctionCalled(int lastFunctionCalled) {
        this.lastFunctionCalled = lastFunctionCalled;
    }

    public ICProject getProject() {
        return this.project;
    }

    public Projectionist getProjectionist() {
        return this.proj;
    }

    public void setProject(ICProject myProject) {
        this.project = myProject;
    }

    public CallgraphView getCallgraphView() {
        return this.callgraphView;
    }

    public void setEndTime(long val) {
        this.endTime = val;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setStartTime(long val) {
        this.startTime = val;
    }

    public void setThreaded() {
        this.threaded = true;
    }

    public boolean getCollapseMode() {
        return this.collapse_mode;
    }

    public void addCalled(int idChild) {
        ++this.getNodeData((int)idChild).timesCalled;
    }
}

