/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.ide.ResourceUtil;

public class GitHistorySelectionTracker
implements ISelectionListener,
IPartListener,
IPartListener2,
IPageChangedListener {
    protected IStructuredSelection selection;

    public void partActivated(IWorkbenchPartReference partRef) {
        this.partActivated(partRef.getPart(false));
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.partBroughtToTop(partRef.getPart(false));
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.partClosed(partRef.getPart(false));
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        this.partDeactivated(partRef.getPart(false));
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.partOpened(partRef.getPart(false));
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorActivated((IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() instanceof IEditorPart) {
            this.editorActivated((IEditorPart)event.getSelectedPage());
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection newSelection) {
        if (newSelection == null || part instanceof GenericHistoryView) {
            return;
        }
        IStructuredSelection structuredSelection = SelectionUtils.getStructuredSelection(newSelection);
        if (structuredSelection.isEmpty()) {
            return;
        }
        this.setSelection(structuredSelection);
    }

    protected void editorActivated(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
        if (resource != null) {
            this.setSelection((IStructuredSelection)new StructuredSelection((Object)resource));
        }
    }

    public void attach(IWorkbenchPage page) {
        if (page != null) {
            page.addPartListener((IPartListener2)this);
            page.addSelectionListener((ISelectionListener)this);
        }
    }

    public void detach(IWorkbenchPage page) {
        if (page != null) {
            page.removePartListener((IPartListener2)this);
            page.removeSelectionListener((ISelectionListener)this);
        }
    }

    private void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void clearSelection() {
        this.setSelection(null);
    }
}

