/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ResolverConfigurationComponent
extends ExpandableComposite {
    private static final String[] DEFAULT_NAME_TEMPLATES = new String[]{"[artifactId]", "[artifactId]-TRUNK", "[artifactId]-[version]", "[groupId].[artifactId]", "[groupId].[artifactId]-[version]", "[name]"};
    protected final ResolverConfiguration resolverConfiguration;
    private final ProjectImportConfiguration projectImportConfiguration;
    private ModifyListener modifyListener;
    Button resolveWorkspaceProjects;
    Text profiles;
    Combo template;

    public ResolverConfigurationComponent(final Composite parent, ProjectImportConfiguration propectImportConfiguration, boolean enableProjectNameTemplate) {
        super(parent, 98);
        this.projectImportConfiguration = propectImportConfiguration;
        this.resolverConfiguration = propectImportConfiguration.getResolverConfiguration();
        this.setText(Messages.resolverConfigurationAdvanced);
        Composite advancedComposite = new Composite((Composite)this, 0);
        this.setClient((Control)advancedComposite);
        this.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Shell shell = parent.getShell();
                Point minSize = shell.getMinimumSize();
                shell.setMinimumSize(shell.getSize().x, minSize.y);
                shell.pack();
                parent.layout();
                shell.setMinimumSize(minSize);
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 11;
        gridLayout.numColumns = 2;
        advancedComposite.setLayout((Layout)gridLayout);
        this.resolveWorkspaceProjects = new Button(advancedComposite, 32);
        this.resolveWorkspaceProjects.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.resolveWorkspaceProjects.setText(Messages.resolverConfigurationResolveWorkspaceProjects);
        this.resolveWorkspaceProjects.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.resolverConfiguration.setResolveWorkspaceProjects(this.resolveWorkspaceProjects.getSelection())));
        Label profilesLabel = new Label(advancedComposite, 0);
        profilesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        profilesLabel.setText(Messages.resolverConfigurationProfiles);
        this.profiles = new Text(advancedComposite, 2048);
        this.profiles.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profiles.addModifyListener(e -> this.resolverConfiguration.setSelectedProfiles(this.profiles.getText()));
        if (enableProjectNameTemplate) {
            Label templateLabel = new Label(advancedComposite, 0);
            templateLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            templateLabel.setText(Messages.resolverConfigurationTemplate);
            this.template = new Combo(advancedComposite, 2048);
            this.template.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.template.setToolTipText(Messages.resolverConfigurationTemplateDescription);
            this.template.setItems(DEFAULT_NAME_TEMPLATES);
            this.template.addModifyListener(e -> propectImportConfiguration.setProjectNameTemplate(this.template.getText()));
        }
        this.loadData();
    }

    public void loadData() {
        this.resolveWorkspaceProjects.setSelection(this.resolverConfiguration.isResolveWorkspaceProjects());
        this.profiles.setText(this.resolverConfiguration.getSelectedProfiles());
        if (this.template != null) {
            this.template.setText(this.projectImportConfiguration.getProjectNameTemplate());
        }
    }

    public IProjectConfiguration getResolverConfiguration() {
        return this.resolverConfiguration;
    }

    public void setModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
        if (this.template != null) {
            this.template.addModifyListener(modifyListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.modifyListener != null) {
            this.template.removeModifyListener(this.modifyListener);
        }
    }
}

