/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectoutlineview;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.projectoutlineview.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.util.NamespaceNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public enum ProjectOutlineGroups {
    GROUP_CLASSES(PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage(), PHPUIMessages.PHPProjectOutline_nodes_classes),
    GROUP_NAMESPACES(PHPPluginImages.DESC_OBJ_PHP_NAMESPACES_GROUP.createImage(), PHPUIMessages.PHPProjectOutline_nodes_namespaces),
    GROUP_CONSTANTS(PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage(), PHPUIMessages.PHPProjectOutline_nodes_constants),
    GROUP_FUNCTIONS(PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage(), PHPUIMessages.PHPProjectOutline_nodes_functions);

    private final Image image;
    private final String text;
    protected static final Object[] NO_CHILDREN;

    static {
        NO_CHILDREN = new Object[0];
    }

    private ProjectOutlineGroups(Image image, String text) {
        this.image = image;
        this.text = text;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    protected Object[] getChildren() {
        if (ProjectOutlineContentProvider.scripProject != null) {
            IProject project = ProjectOutlineContentProvider.scripProject.getProject();
            try {
                if (!project.isAccessible() || !project.hasNature("org.eclipse.php.core.PHPNature")) {
                    return NO_CHILDREN;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)ProjectOutlineContentProvider.scripProject, (int)1);
            TreeSet<IModelElement> childrenList = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement o1, IModelElement o2) {
                    int res = o1.getElementName().compareTo(o2.getElementName());
                    if (res == 0) {
                        String label1 = ScriptElementLabels.getDefault().getElementLabel(o1, 262144L);
                        String label2 = ScriptElementLabels.getDefault().getElementLabel(o2, 262144L);
                        return label1.compareTo(label2);
                    }
                    return res;
                }
            });
            switch (this) {
                case GROUP_NAMESPACES: {
                    IType[] namespaces = PHPModelAccess.getDefault().findNamespaces(null, null, ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
                    HashMap<String, LinkedList<IType>> nsByName = new HashMap<String, LinkedList<IType>>();
                    if (namespaces != null) {
                        IType[] iTypeArray = namespaces;
                        int n = namespaces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType namespace = iTypeArray[n2];
                            String namespaceName = namespace.getElementName();
                            LinkedList<IType> nsList = (LinkedList<IType>)nsByName.get(namespaceName);
                            if (nsList == null) {
                                nsList = new LinkedList<IType>();
                                nsByName.put(namespaceName, nsList);
                            }
                            nsList.add(namespace);
                            ++n2;
                        }
                    }
                    for (Map.Entry entry : nsByName.entrySet()) {
                        childrenList.add((IModelElement)new NamespaceNode((IModelElement)ProjectOutlineContentProvider.scripProject, (String)entry.getKey()));
                    }
                    break;
                }
                case GROUP_CLASSES: {
                    IType[] findTypes = PHPModelAccess.getDefault().findTypes(null, ISearchEngine.MatchRule.PREFIX, 0, 2048, scope, null);
                    if (findTypes == null) break;
                    childrenList.addAll(Arrays.asList(findTypes));
                    break;
                }
                case GROUP_FUNCTIONS: {
                    IMethod[] findMethods = PHPModelAccess.getDefault().findFunctions(null, ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, null);
                    if (findMethods == null) break;
                    childrenList.addAll(Arrays.asList(findMethods));
                    break;
                }
                case GROUP_CONSTANTS: {
                    IField[] findFields = PHPModelAccess.getDefault().findFields(null, ISearchEngine.MatchRule.PREFIX, 2, 0, scope, null);
                    if (findFields == null) break;
                    IField[] iFieldArray = findFields;
                    int n = findFields.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IField field = iFieldArray[n3];
                        try {
                            IField element = field;
                            if (field.getParent() instanceof ISourceModule) {
                                element = ((ISourceModule)field.getParent()).getElementAt(field.getNameRange().getOffset());
                            }
                            if (element != null && element.getParent() instanceof ISourceModule) {
                                childrenList.add((IModelElement)element);
                            }
                        }
                        catch (ModelException modelException) {
                            // empty catch block
                        }
                        ++n3;
                    }
                    break;
                }
            }
            return childrenList.toArray();
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren() {
        Object[] children = this.getChildren();
        return children != null && children.length != 0;
    }
}

