/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.uriresolver.CacheResourceException;

public class CacheResourceDownloadingException
extends CacheResourceException {
    private static final long serialVersionUID = 1L;
    private final CompletableFuture<Path> future;
    private final CacheResourceDownloadingError errorCode;

    public CacheResourceDownloadingException(String resourceURI, Path resourceCachePath, CacheResourceDownloadingError errorCode, CompletableFuture<Path> future, Throwable e) {
        super(resourceURI, errorCode.getMessage(resourceURI, resourceCachePath), e);
        this.errorCode = errorCode;
        this.future = future;
    }

    public CacheResourceDownloadingError getErrorCode() {
        return this.errorCode;
    }

    public CompletableFuture<Path> getFuture() {
        return this.future;
    }

    public static enum CacheResourceDownloadingError {
        DOWNLOAD_DISABLED("Downloading external resources is disabled."),
        RESOURCE_LOADING("The resource ''{0}'' is downloading in the cache path ''{1}''."),
        RESOURCE_NOT_IN_DEPLOYED_PATH("The resource ''{0}'' cannot be downloaded in the cache path ''{1}''.");

        private final String rawMessage;

        private CacheResourceDownloadingError(String rawMessage) {
            this.rawMessage = rawMessage;
        }

        public String getMessage(Object ... arguments) {
            return MessageFormat.format(this.rawMessage, arguments);
        }
    }
}

