/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class TaskPatternsProvider {
    @NonNull
    private static final TaskPatternsProvider instance = new TaskPatternsProvider();
    private boolean isInitialized = false;
    private TaskTagsProvider provider = TaskTagsProvider.getInstance();
    private Pattern[] workspacePatterns;
    private HashMap<IProject, Pattern[]> projectsPatterns = new HashMap();
    private HashMap<IProject, ITaskTagsListener> projectToListener = new HashMap();

    private TaskPatternsProvider() {
    }

    @NonNull
    public static TaskPatternsProvider getInstance() {
        return instance;
    }

    @NonNull
    public synchronized Pattern[] getPatternsForProject(IProject project) {
        TaskPatternsProvider.registerProject(project);
        Pattern[] patterns = this.projectsPatterns.get(project);
        if (patterns != null) {
            return patterns;
        }
        return this.workspacePatterns;
    }

    private void initPatternsDB() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.workspacePatterns = TaskPatternsProvider.createPatterns(this.provider.getWorkspaceTaskTags(), this.provider.isWorkspaceTagsCaseSensitive());
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null) {
            return;
        }
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            TaskPatternsProvider.registerProject(project);
            ++i;
        }
    }

    @NonNull
    public synchronized Pattern[] getPatternsForWorkspace() {
        this.initPatternsDB();
        return this.workspacePatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProject(IProject project) {
        TaskPatternsProvider taskPatternsProvider = instance;
        synchronized (taskPatternsProvider) {
            if (project == null) {
                return;
            }
            instance.initPatternsDB();
            if (!TaskPatternsProvider.instance.projectToListener.containsKey(project)) {
                TaskTag[] tags = TaskPatternsProvider.instance.provider.getProjectTaskTags(project);
                boolean caseSensitive = TaskPatternsProvider.instance.provider.getProjectTagsCaseSensitive(project);
                if (tags != null) {
                    Pattern[] patterns = TaskPatternsProvider.createPatterns(tags, caseSensitive);
                    TaskPatternsProvider.instance.projectsPatterns.put(project, patterns);
                }
                TaskTagsListener tagsListener = new TaskTagsListener();
                TaskPatternsProvider.instance.projectToListener.put(project, tagsListener);
                TaskPatternsProvider.instance.provider.addTaskTagsListener(tagsListener, project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterProject(IProject project) {
        TaskPatternsProvider taskPatternsProvider = instance;
        synchronized (taskPatternsProvider) {
            if (!TaskPatternsProvider.instance.isInitialized || project == null) {
                return;
            }
            TaskPatternsProvider.instance.provider.removeTaskTagsListener(project);
            TaskPatternsProvider.instance.projectsPatterns.remove(project);
            TaskPatternsProvider.instance.projectToListener.remove(project);
        }
    }

    private static Pattern[] createPatterns(TaskTag[] workspaceTaskTags, boolean caseSensitive) {
        Pattern[] patterns = new Pattern[workspaceTaskTags.length];
        int i = 0;
        while (i < workspaceTaskTags.length) {
            TaskTag tag = workspaceTaskTags[i];
            String tagString = tag.getTag();
            patterns[i] = caseSensitive ? Pattern.compile("(?<![a-zA-Z-])" + Pattern.quote(tagString) + "(?![a-zA-Z-])") : Pattern.compile("(?<![a-zA-Z-])" + Pattern.quote(tagString) + "(?![a-zA-Z-])", 2);
            ++i;
        }
        return patterns;
    }

    private synchronized void taskTagsChanged(IProject project, TaskTag[] tags, boolean caseSensitive) {
        if (project == null) {
            this.workspacePatterns = TaskPatternsProvider.createPatterns(tags, caseSensitive);
            return;
        }
        Pattern[] patterns = TaskPatternsProvider.createPatterns(tags, caseSensitive);
        this.projectsPatterns.put(project, patterns);
    }

    private static class TaskTagsListener
    implements ITaskTagsListener {
        private TaskTagsListener() {
        }

        @Override
        public void taskTagsChanged(TaskTagsEvent event) {
            instance.taskTagsChanged(event.getProject(), event.getTaskTags(), event.isCaseSensitive());
        }

        @Override
        public void taskPrioritiesChanged(TaskTagsEvent event) {
        }

        @Override
        public void taskCaseChanged(TaskTagsEvent event) {
            instance.taskTagsChanged(event.getProject(), event.getTaskTags(), event.isCaseSensitive());
        }
    }
}

