/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.editor;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.communication.RemoteFileStorage;
import org.eclipse.php.internal.debug.ui.editor.RemoteFileStorageEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class OpenRemoteFileContentRequestor
implements IRemoteFileContentRequestor {
    public void fileContentReceived(final byte[] content, String serverAddress, final String originalURL, final String fileName, final int lineNumber) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenRemoteFileContentRequestor.this.openInEditor(content, originalURL, fileName, lineNumber);
            }
        });
    }

    private void openInEditor(byte[] content, String originalURL, String fileName, int lineNumber) {
        try {
            IEditorPart editorPart;
            RemoteFileStorageEditorInput editorInput = new RemoteFileStorageEditorInput(new RemoteFileStorage(content, fileName, originalURL));
            IWorkbenchPage p = DLTKUIPlugin.getActivePage();
            if (p != null && (editorPart = p.openEditor((IEditorInput)editorInput, EditorUtility.getEditorID((IEditorInput)editorInput, null), true)) != null) {
                IRegion region;
                if (lineNumber > 0 && editorPart instanceof StructuredTextEditor && (region = ((StructuredTextEditor)editorPart).getTextViewer().getDocument().getLineInformation(lineNumber - 1)) != null) {
                    EditorUtility.revealInEditor((IEditorPart)editorPart, (int)region.getOffset(), (int)region.getLength());
                }
                if (editorPart.getSite() != null) {
                    editorPart.getSite().getShell().forceActive();
                }
            }
        }
        catch (PartInitException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (BadLocationException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    public void requestCompleted(Exception e) {
    }
}

