/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.xpath.matcher;

import java.util.Collection;
import org.eclipse.lemminx.xpath.matcher.AbstractXPathNodeMatcher;
import org.eclipse.lemminx.xpath.matcher.IXPathNodeMatcher;
import org.eclipse.lemminx.xpath.matcher.XPathMatcher;
import org.w3c.dom.Node;

public class XPathAttributeNameMatcher
extends AbstractXPathNodeMatcher {
    public static final String ANY_ELEMENT_NAME = "*";
    private final String prefix;
    private final String localName;
    private final boolean anyAttributeName;

    public XPathAttributeNameMatcher(String prefix, String localName, XPathMatcher matcher) {
        super(matcher);
        this.prefix = prefix;
        this.localName = localName;
        this.anyAttributeName = ANY_ELEMENT_NAME.equals(localName);
    }

    @Override
    public IXPathNodeMatcher.MatcherType getType() {
        return IXPathNodeMatcher.MatcherType.ATTRIBUTE;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean match(Node testNode, Collection<String> wildcardValues) {
        if (testNode.getNodeType() != 2) {
            return false;
        }
        if (this.anyAttributeName) {
            return true;
        }
        return this.localName.equals(testNode.getLocalName());
    }

    @Override
    public boolean isAny() {
        return false;
    }
}

