/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.MapsIdDerivedIdentityStrategy2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaDerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaSingleRelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsIdAnnotation2_0;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationArgumentMessages;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaMapsIdDerivedIdentityStrategy2_0
extends AbstractJavaContextModel<JavaDerivedIdentity2_0>
implements MapsIdDerivedIdentityStrategy2_0 {
    protected String specifiedIdAttributeName = this.buildSpecifiedIdAttributeName();
    protected String defaultIdAttributeName;

    public GenericJavaMapsIdDerivedIdentityStrategy2_0(JavaDerivedIdentity2_0 parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedIdAttributeName_(this.buildSpecifiedIdAttributeName());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultIdAttributeName(this.buildDefaultIdAttributeName());
    }

    @Override
    public String getIdAttributeName() {
        return this.specifiedIdAttributeName != null ? this.specifiedIdAttributeName : this.defaultIdAttributeName;
    }

    @Override
    public String getSpecifiedIdAttributeName() {
        return this.specifiedIdAttributeName;
    }

    @Override
    public void setSpecifiedIdAttributeName(String idAttributeName) {
        if (ObjectTools.notEquals((Object)idAttributeName, (Object)this.specifiedIdAttributeName)) {
            this.getAnnotation().setValue(idAttributeName);
            this.setSpecifiedIdAttributeName_(idAttributeName);
        }
    }

    protected void setSpecifiedIdAttributeName_(String idAttributeName) {
        String old = this.specifiedIdAttributeName;
        this.specifiedIdAttributeName = idAttributeName;
        this.firePropertyChanged("specifiedIdAttributeName", old, idAttributeName);
    }

    protected String buildSpecifiedIdAttributeName() {
        return this.getAnnotation().getValue();
    }

    @Override
    public String getDefaultIdAttributeName() {
        return this.defaultIdAttributeName;
    }

    protected void setDefaultIdAttributeName(String idAttributeName) {
        String old = this.defaultIdAttributeName;
        this.defaultIdAttributeName = idAttributeName;
        this.firePropertyChanged("defaultIdAttributeName", old, idAttributeName);
    }

    protected String buildDefaultIdAttributeName() {
        AttributeMapping mapping = this.getPersistentAttribute().getDeclaringTypeMapping().getIdAttributeMapping();
        if (mapping == null) {
            return null;
        }
        if (ObjectTools.equals((Object)"embeddedId", (Object)mapping.getKey())) {
            EmbeddedIdMapping embeddedId = (EmbeddedIdMapping)mapping;
            Entity targetEntity = this.getMapping().getResolvedTargetEntity();
            if (targetEntity != null && ObjectTools.equals((Object)embeddedId.getTargetEmbeddableName(), (Object)targetEntity.getPrimaryKeyClassName())) {
                return embeddedId.getName();
            }
            return this.getMapping().getName();
        }
        if (ObjectTools.equals((Object)"id", (Object)mapping.getKey())) {
            return mapping.getName();
        }
        return null;
    }

    @Override
    public boolean defaultIdAttributeNameIsPossible() {
        return true;
    }

    protected MapsIdAnnotation2_0 getAnnotation() {
        return (MapsIdAnnotation2_0)this.getResourceAttribute().getNonNullAnnotation(this.getAnnotationName());
    }

    protected MapsIdAnnotation2_0 getAnnotationOrNull() {
        return (MapsIdAnnotation2_0)this.getResourceAttribute().getAnnotation(this.getAnnotationName());
    }

    protected void addAnnotation() {
        this.getResourceAttribute().addAnnotation(this.getAnnotationName());
    }

    protected void removeAnnotation() {
        this.getResourceAttribute().removeAnnotation(this.getAnnotationName());
    }

    protected String getAnnotationName() {
        return MapsIdAnnotation2_0.ANNOTATION_NAME;
    }

    protected JavaDerivedIdentity2_0 getDerivedIdentity() {
        return (JavaDerivedIdentity2_0)this.parent;
    }

    protected JavaSingleRelationshipMapping2_0 getMapping() {
        return this.getDerivedIdentity().getMapping();
    }

    protected JavaSpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getMapping().getPersistentAttribute();
    }

    protected JavaResourceAttribute getResourceAttribute() {
        return this.getPersistentAttribute().getResourceAttribute();
    }

    protected Iterable<AttributeMapping> getAllAttributeMappings() {
        return this.getPersistentAttribute().getDeclaringTypeMapping().getAllAttributeMappings();
    }

    @Override
    public Iterable<String> getSortedCandidateIdAttributeNames() {
        return IterableTools.sort(this.getAllAttributeMappingChoiceNames());
    }

    protected Iterable<String> getAllAttributeMappingChoiceNames() {
        return IterableTools.transform(this.getAllAttributeMappingChoices(), AttributeMapping.NAME_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getAllAttributeMappingChoices() {
        return this.buildAttributeMappingChoices(this.getAllAttributeMappings());
    }

    protected Iterable<AttributeMapping> buildAttributeMappingChoices(Iterable<AttributeMapping> attributeMappings) {
        return IterableTools.children(attributeMappings, (Transformer)new AttributeMappingTransformer());
    }

    protected Iterable<AttributeMapping> getEmbeddedIdMappingChoiceIterable(EmbeddedIdMapping mapping) {
        Embeddable embeddable = mapping.getTargetEmbeddable();
        if (embeddable == null) {
            return new SingleElementIterable((Object)mapping);
        }
        return IterableTools.insert((Object)mapping, embeddable.getAllAttributeMappings());
    }

    @Override
    public AttributeMapping getDerivedIdAttributeMapping() {
        String idAttributeName = this.getIdAttributeName();
        if (idAttributeName != null) {
            for (AttributeMapping mapping : this.getAllAttributeMappingChoices()) {
                if (!idAttributeName.equals(mapping.getName())) continue;
                return mapping;
            }
        }
        return null;
    }

    @Override
    public boolean isSpecified() {
        return this.getAnnotationOrNull() != null;
    }

    @Override
    public void addStrategy() {
        if (this.getAnnotationOrNull() == null) {
            this.addAnnotation();
        }
    }

    @Override
    public void removeStrategy() {
        if (this.getAnnotationOrNull() != null) {
            this.removeAnnotation();
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.getAnnotation().valueTouches(pos)) {
            result = this.getSortedJavaValueChoices();
        }
        return result;
    }

    protected Iterable<String> getSortedJavaValueChoices() {
        return new TransformationIterable(this.getSortedCandidateIdAttributeNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMapsId(messages);
    }

    protected void validateMapsId(List<IMessage> messages) {
        if (this.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy()) {
            this.validateMapsId_(messages);
        }
    }

    protected void validateMapsId_(List<IMessage> messages) {
        AttributeMapping attributeMapping = this.getDerivedIdAttributeMapping();
        if (attributeMapping == null) {
            if (this.specifiedIdAttributeName == null) {
                messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPS_ID_VALUE_NOT_SPECIFIED, new Object[0]));
            } else {
                messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPS_ID_VALUE_NOT_RESOLVED, this.getIdAttributeName()));
            }
        } else if (!IterableTools.contains(this.getValidAttributeMappingChoices(), (Object)attributeMapping)) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPS_ID_VALUE_INVALID, this.getIdAttributeName()));
        }
    }

    protected Iterable<AttributeMapping> getValidAttributeMappingChoices() {
        return this.buildAttributeMappingChoices(this.getPersistentAttribute().getDeclaringTypeMapping().getIdAttributeMappings());
    }

    protected IMessage buildMessage(ValidationMessage msg, Object ... args) {
        JavaSpecifiedPersistentAttribute attribute = this.getPersistentAttribute();
        String attributeDescription = attribute.isVirtual() ? JptJpaCoreValidationArgumentMessages.VIRTUAL_ATTRIBUTE_DESC : JptJpaCoreValidationArgumentMessages.ATTRIBUTE_DESC;
        attributeDescription = NLS.bind((String)attributeDescription, (Object)attribute.getName());
        args = ArrayTools.add((Object[])args, (int)0, (Object)attributeDescription);
        TextRange textRange = attribute.isVirtual() ? attribute.getValidationTextRange() : this.getValidationTextRange();
        return this.buildValidationMessage(textRange, msg, args);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getDerivedIdentity().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        return this.getAnnotation().getTextRange();
    }

    public class AttributeMappingTransformer
    extends TransformerAdapter<AttributeMapping, Iterable<AttributeMapping>> {
        public Iterable<AttributeMapping> transform(AttributeMapping mapping) {
            return ObjectTools.equals((Object)mapping.getKey(), (Object)"embeddedId") ? GenericJavaMapsIdDerivedIdentityStrategy2_0.this.getEmbeddedIdMappingChoiceIterable((EmbeddedIdMapping)mapping) : new SingleElementIterable((Object)mapping);
        }
    }
}

