/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FilterResourceParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class AddMappedOutputFoldersParticipant
extends AbstractFlattenParticipant
implements VirtualComponentFlattenUtility.ShouldIncludeUtilityCallback {
    private List<IFlatResource> list;
    private String[] filteredSuffixes = new String[0];

    public AddMappedOutputFoldersParticipant() {
    }

    public AddMappedOutputFoldersParticipant(String[] filtered) {
        this.filteredSuffixes = filtered;
    }

    public boolean shouldAddComponentFile(IVirtualComponent component, IFlatFile file) {
        IFlattenParticipant[] delegates = this.getDelegateParticipants();
        int i = 0;
        while (i < delegates.length) {
            if (!delegates[i].shouldAddExportableFile(null, component, null, file)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IFlattenParticipant[] getDelegateParticipants() {
        return new IFlattenParticipant[]{FilterResourceParticipant.createSuffixFilterParticipant((String[])this.filteredSuffixes)};
    }

    public void finalize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
        this.list = resources;
        this.list.getClass();
        if (!this.isApprovedComponent(component)) {
            return;
        }
        HashMap<IContainer, IPath> mapped = AddMappedOutputFoldersParticipant.getMappedJavaOutputContainers(component.getProject());
        for (IContainer next : mapped.keySet()) {
            try {
                new VirtualComponentFlattenUtility(this.list, (VirtualComponentFlattenUtility.ShouldIncludeUtilityCallback)this).addContainer(next, mapped.get(next).makeRelative());
            }
            catch (CoreException coreException) {}
        }
    }

    protected boolean isApprovedComponent(IVirtualComponent vc) {
        return true;
    }

    public static final HashMap<IContainer, IPath> getMappedJavaOutputContainers(IProject project) {
        ComponentResourceProxy[] proxies = AddMappedOutputFoldersParticipant.findAllMappingProxies(project);
        IJavaProjectLite javaProjectLite = JavaCoreLite.create(project);
        HashMap<IContainer, IPath> map = new HashMap<IContainer, IPath>();
        IFile classpathFile = project.getFile(".classpath");
        if (javaProjectLite.exists() && classpathFile.exists()) {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProjectLite.readRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPath cpePath = entry.getPath();
                    int i = 0;
                    while (i < proxies.length) {
                        IContainer outputContainer;
                        if (cpePath.equals((Object)new Path(project.getName()).append(proxies[i].source).makeAbsolute()) && !map.containsKey(outputContainer = JavaLiteUtilities.getJavaOutputContainer(javaProjectLite, entry))) {
                            map.put(outputContainer, proxies[i].runtimePath);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return map;
    }

    public static ComponentResourceProxy[] findAllMappingProxies(IProject project) {
        ComponentResource[] allMappings = AddMappedOutputFoldersParticipant.findAllMappings(project);
        ComponentResourceProxy[] proxies = new ComponentResourceProxy[allMappings.length];
        int i = 0;
        while (i < allMappings.length) {
            proxies[i] = new ComponentResourceProxy(allMappings[i].getSourcePath(), allMappings[i].getRuntimePath());
            ++i;
        }
        return proxies;
    }

    protected static ComponentResource[] findAllMappings(IProject project) {
        StructureEdit structureEdit = null;
        try {
            structureEdit = StructureEdit.getStructureEditForRead((IProject)project);
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            ComponentResource[] result = new ComponentResource[arr.length];
            int i = 0;
            while (i < arr.length) {
                result[i] = (ComponentResource)arr[i];
                ++i;
            }
            ComponentResource[] componentResourceArray = result;
            return componentResourceArray;
        }
        catch (Exception exception) {
        }
        finally {
            if (structureEdit != null) {
                structureEdit.dispose();
            }
        }
        return new ComponentResource[0];
    }

    public static class ComponentResourceProxy {
        public IPath source;
        public IPath runtimePath;

        public ComponentResourceProxy(IPath source, IPath runtimePath) {
            this.source = source;
            this.runtimePath = runtimePath;
        }
    }
}

