/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ecore;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ecore.EcoreImporterPlugin;

public class EcoreImporter
extends ModelImporter {
    public String getID() {
        return "org.eclipse.emf.importer.ecore";
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        List locationURIs = this.getModelLocationURIs();
        if (locationURIs.isEmpty()) {
            diagnostic = new BasicDiagnostic(4, EcoreImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, EcoreImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidCoreModel_message"), null);
        } else {
            monitor.beginTask("", 2);
            monitor.subTask(EcoreImporterPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{locationURIs}));
            ResourceSet ecoreResourceSet = this.createResourceSet();
            for (URI ecoreModelLocation : locationURIs) {
                ecoreResourceSet.getResource(ecoreModelLocation, true);
            }
            EcoreUtil.resolveAll((ResourceSet)ecoreResourceSet);
            List ePackages = this.getEPackages();
            for (Resource resource : ecoreResourceSet.getResources()) {
                ePackages.addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE));
            }
            final List<Object> excludedAncestors = Arrays.asList(ecoreResourceSet, EcorePackage.eINSTANCE, XMLTypePackage.eINSTANCE, XMLNamespacePackage.eINSTANCE);
            Map<EObject, Collection<EStructuralFeature.Setting>> externalCrossReferences = new EcoreUtil.ExternalCrossReferencer(ecoreResourceSet){
                private static final long serialVersionUID = 1L;

                protected void handleCrossReference(EObject eObject) {
                    if (eObject.eClass().getEPackage() == EcorePackage.eINSTANCE) {
                        super.handleCrossReference(eObject);
                    }
                }

                protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                    return eReference == EcorePackage.Literals.EGENERIC_TYPE__ECLASSIFIER && !EcoreUtil.isAncestor((Collection)excludedAncestors, (EObject)crossReferencedEObject);
                }

                public Map<EObject, Collection<EStructuralFeature.Setting>> findExternalCrossReferences() {
                    return super.findExternalCrossReferences();
                }
            }.findExternalCrossReferences();
            if (!externalCrossReferences.isEmpty()) {
                Map ePackageNsURIToGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
                for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry : externalCrossReferences.entrySet()) {
                    EPackage externalEPackage;
                    URI genModelLocation;
                    Resource genModelResource;
                    GenModel genModel;
                    GenPackage genPackage;
                    EObject eObject = entry.getKey();
                    EObject rootEObject = EcoreUtil.getRootContainer((EObject)eObject);
                    if (!(rootEObject instanceof EPackage) || (genPackage = (genModel = (GenModel)EcoreUtil.getObjectByType((Collection)(genModelResource = ecoreResourceSet.getResource(genModelLocation = (URI)ePackageNsURIToGenModelLocationMap.get((externalEPackage = (EPackage)rootEObject).getNsURI()), true)).getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL)).findGenPackage(externalEPackage)) == null) continue;
                    EPackage ecorePackage = genPackage.getEcorePackage();
                    String relativeURIFragmentPath = EcoreUtil.getRelativeURIFragmentPath((EObject)externalEPackage, (EObject)eObject);
                    EObject resolvedEObject = EcoreUtil.getEObject((EObject)ecorePackage, (String)relativeURIFragmentPath);
                    if (!eObject.eClass().isInstance((Object)resolvedEObject)) continue;
                    ePackages.add(ecorePackage);
                    for (EStructuralFeature.Setting setting : entry.getValue()) {
                        EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)eObject, (Object)resolvedEObject);
                    }
                }
            }
            Iterator i = ePackages.iterator();
            while (i.hasNext()) {
                if (!"xcore.lang".equals(((EPackage)i.next()).getNsURI())) continue;
                i.remove();
            }
            BasicDiagnostic diagnosticChain = new BasicDiagnostic("org.eclipse.emf.converter", 1, EcoreImporterPlugin.INSTANCE.getString("_UI_ErrorsWereDetectedEcore_message"), null);
            for (EPackage ePackage : ePackages) {
                Diagnostician.INSTANCE.validate((EObject)ePackage, (DiagnosticChain)diagnosticChain);
            }
            if (diagnosticChain.getSeverity() != 0) {
                diagnostic = diagnosticChain;
            }
        }
        return diagnostic;
    }

    public void addToResource(EPackage ePackage, ResourceSet resourceSet) {
        if (ePackage.eResource() != null && this.getGenModel().eResource() != null) {
            URI ePackageURI = ePackage.eResource().getURI();
            URI genModelURI = this.getGenModel().eResource().getURI();
            if (!ePackageURI.trimSegments(1).equals(genModelURI.trimSegments(1))) {
                ePackage.eResource().getContents().remove((Object)ePackage);
            }
        }
        super.addToResource(ePackage, resourceSet);
    }

    protected void adjustGenModel(Monitor monitor) {
        super.adjustGenModel(monitor);
        URI genModelURI = this.createFileURI(this.getGenModelPath().toString());
        for (URI uri : this.getModelLocationURIs()) {
            this.getGenModel().getForeignModel().add((Object)this.makeRelative(uri, genModelURI).toString());
        }
    }

    protected void handleOriginalGenModel() throws DiagnosticException {
        URI genModelURI = this.getOriginalGenModel().eResource().getURI();
        StringBuffer text = new StringBuffer();
        for (String value : this.getOriginalGenModel().getForeignModel()) {
            if (!value.endsWith(".ecore") && !value.endsWith(".emof")) continue;
            text.append(this.makeAbsolute(URI.createURI((String)value), genModelURI).toString());
            text.append(" ");
        }
        if (text.length() == 0) {
            UniqueEList locations = new UniqueEList();
            for (GenPackage genPackage : this.getOriginalGenModel().getGenPackages()) {
                URI ecoreURI = genPackage.getEcorePackage().eResource().getURI();
                if (!locations.add(ecoreURI)) continue;
                text.append(this.makeAbsolute(URI.createURI((String)ecoreURI.toString()), genModelURI).toString());
                text.append(" ");
            }
        }
        this.setModelLocation(text.toString().trim());
    }
}

