/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.osgi.framework.Bundle;

final class SPIMapping {
    private final Class<?> serviceClass;
    private final Bundle bundle;
    private final Set<String> classes;
    private final Collection<URL> urls;

    SPIMapping(Class<?> serviceClass, Bundle bundle, Collection<URL> urls) {
        this.serviceClass = serviceClass;
        this.bundle = bundle;
        this.urls = urls;
        this.classes = SPIMapping.readClasses(urls);
    }

    private static Set<String> readClasses(Collection<URL> urls) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (URL url : urls) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    reader.lines().forEach(result::add);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    boolean isCompatible(Bundle other) {
        try {
            return other.loadClass(this.serviceClass.getName()) == this.serviceClass;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    Collection<URL> getUrls() {
        return this.urls;
    }

    boolean hasService(String implementation) {
        return this.classes != null && this.classes.contains(implementation);
    }

    Class<?> loadImplementation(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }
}

